/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.rcp.speech.views;

import mbrola.MbrolaPlugin;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.ui.part.ViewPart;
import org.jpn.xucker.speech.VoiceControler;
import org.jpn.xucker.speech.multi.USVoiceControlPlayer;

public class VoiceSettingView
extends ViewPart {
    public static final String VIEW_ID;
    private Scale durationStretchScale;
    private Scale pitchShiftScale;
    private Scale rateScale;
    private Scale pitchScale;
    private Scale pitchRangeScale;
    private Label stretchLabel;
    private Label pitchShiftLabel;
    private Label pitchLabel;
    private Label pitchRangeLabel;
    private CCombo voiceList;
    private USVoiceControlPlayer usPlayer;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jpn.xucker.rcp.speech.views.VoiceSettingView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        VIEW_ID = clazz.getName();
    }

    public USVoiceControlPlayer getUsPlayer() {
        return this.usPlayer;
    }

    public void setUsPlayer(USVoiceControlPlayer usPlayer) {
        this.usPlayer = usPlayer;
    }

    public float getDurationStrech() {
        return (float)this.durationStretchScale.getSelection() / 10.0f;
    }

    public float getPitchShift() {
        return (float)this.pitchShiftScale.getSelection() / 10.0f;
    }

    public float getRate() {
        return this.rateScale.getSelection();
    }

    public float getPitch() {
        return this.pitchScale.getSelection();
    }

    public float getPitchRange() {
        return this.pitchRangeScale.getSelection();
    }

    public void setDefaultValue() {
        float pitch = VoiceControler.getInstance().getDefaultPitch();
        float duration = VoiceControler.getInstance().getDefaultDurationStretch();
        float pitchShift = VoiceControler.getInstance().getDefaultPitchShift();
        float pitchRange = VoiceControler.getInstance().getDefaultPitchRange();
        this.updateValues(pitch, duration, pitchShift, pitchRange);
        this.updateLabels(pitch, duration, pitchShift, pitchRange);
        this.updateScale(pitch, duration, pitchShift, pitchRange);
        this.usPlayer.setVoice(VoiceControler.getInstance().getVoice());
    }

    public void createPartControl(Composite master) {
        String[] optionVoices = new String[]{};
        try {
            optionVoices = this.getOptionVoices();
        }
        catch (NoClassDefFoundError e) {
            System.out.println("class not found:" + e.getMessage());
        }
        if (optionVoices.length > 0) {
            VoiceControler.getInstance().setAvaileMbrola(true);
        }
        master.setLayout((Layout)new GridLayout(2, false));
        Composite info = new Composite(master, 0);
        GridData d1 = new GridData();
        d1.horizontalSpan = 2;
        info.setLayoutData((Object)d1);
        info.setLayout((Layout)new FillLayout());
        this.voiceList = new CCombo(info, 8);
        this.voiceList.add("kevin16");
        int i = 0;
        while (i < optionVoices.length) {
            this.voiceList.add("mbrola_" + optionVoices[i]);
            ++i;
        }
        this.voiceList.addSelectionListener((SelectionListener)new VoiceChanger());
        this.voiceList.select(0);
        ValueChangeMonitor monitor = new ValueChangeMonitor();
        Composite gp = new Composite(master, 0);
        Label tmp1 = new Label(gp, 0);
        tmp1.setText("stretch");
        this.toGridLayout(tmp1, 40);
        gp.setLayout((Layout)new GridLayout(3, false));
        this.stretchLabel = new Label(gp, 0x1000000);
        this.toGridLayout(this.stretchLabel, 30);
        gp.setLayoutData((Object)new GridData(768));
        this.durationStretchScale = new Scale(gp, 256);
        this.durationStretchScale.setMinimum(1);
        this.durationStretchScale.setMaximum(40);
        this.durationStretchScale.setSelection(10);
        this.durationStretchScale.addSelectionListener((SelectionListener)monitor);
        this.durationStretchScale.setLayoutData((Object)new GridData(1808));
        Composite gp2 = new Composite(master, 0);
        Label tmp2 = new Label(gp2, 0);
        tmp2.setText("pitch shift");
        this.toGridLayout(tmp2, 40);
        gp2.setLayout((Layout)new GridLayout(3, false));
        gp2.setLayoutData((Object)new GridData(768));
        this.pitchShiftLabel = new Label(gp2, 0x1000000);
        this.toGridLayout(this.pitchShiftLabel, 30);
        this.pitchShiftScale = new Scale(gp2, 256);
        this.pitchShiftScale.setMinimum(1);
        this.pitchShiftScale.setMaximum(60);
        this.pitchShiftScale.setSelection(10);
        this.pitchShiftScale.addSelectionListener((SelectionListener)monitor);
        this.pitchShiftScale.setLayoutData((Object)new GridData(1808));
        Composite gp3 = new Composite(master, 0);
        Label tmp3 = new Label(gp3, 0);
        tmp3.setText("pitch");
        this.toGridLayout(tmp3, 40);
        gp3.setLayout((Layout)new GridLayout(3, false));
        gp3.setLayoutData((Object)new GridData(768));
        this.pitchLabel = new Label(gp3, 0x1000000);
        this.toGridLayout(this.pitchLabel, 30);
        this.pitchScale = new Scale(gp3, 256);
        this.pitchScale.setMinimum(1);
        this.pitchScale.setMaximum(600);
        this.pitchScale.setSelection(180);
        this.pitchScale.addSelectionListener((SelectionListener)monitor);
        this.pitchScale.setLayoutData((Object)new GridData(1808));
        Composite gp4 = new Composite(master, 0);
        Label tmp4 = new Label(gp4, 0);
        tmp4.setText("pitch range");
        this.toGridLayout(tmp4, 40);
        gp4.setLayout((Layout)new GridLayout(3, false));
        gp4.setLayoutData((Object)new GridData(768));
        this.pitchRangeLabel = new Label(gp4, 0x1000000);
        this.toGridLayout(this.pitchRangeLabel, 30);
        this.pitchRangeScale = new Scale(gp4, 256);
        this.pitchRangeScale.setMinimum(1);
        this.pitchRangeScale.setMaximum(200);
        this.pitchRangeScale.setSelection(22);
        this.pitchRangeScale.addSelectionListener((SelectionListener)monitor);
        this.pitchRangeScale.setLayoutData((Object)new GridData(1808));
        this.usPlayer = new USVoiceControlPlayer();
        this.setDefaultValue();
    }

    private String[] getOptionVoices() {
        String[] result = new String[]{};
        try {
            result = MbrolaPlugin.getDefault().getMboraDataNames();
            if (result.length > 0) {
                System.setProperty("mbrola.base", MbrolaPlugin.getDefault().getMboraDirectory().getAbsolutePath());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private void toGridLayout(Label label, int width) {
        GridData data = new GridData(768);
        data.widthHint = width;
        label.setLayoutData((Object)data);
    }

    public void updateScale(float pitch, float duration, float pitchShift, float pitchRange) {
        this.pitchScale.setSelection((int)pitch);
        this.pitchRangeScale.setSelection((int)pitchRange);
        this.pitchShiftScale.setSelection((int)pitchShift * 10);
        this.durationStretchScale.setSelection((int)duration * 10);
    }

    public void updateValues(float pitch, float duration, float pitchShift, float pitchRange) {
        VoiceControler.getInstance().getVoice().setPitch(pitch);
        VoiceControler.getInstance().getVoice().setDurationStretch(duration);
        VoiceControler.getInstance().getVoice().setPitchShift(pitchShift);
        VoiceControler.getInstance().getVoice().setPitchRange(pitchRange);
    }

    public void updateLabels(float pitch, float duration, float pitchShift, float pitchRange) {
        this.pitchLabel.setText("" + pitch);
        this.stretchLabel.setText("" + duration);
        this.pitchShiftLabel.setText("" + pitchShift);
        this.pitchRangeLabel.setText("" + pitchRange);
    }

    public void setFocus() {
        this.durationStretchScale.setFocus();
    }

    public CCombo getVoiceList() {
        return this.voiceList;
    }

    public class VoiceChanger
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            String label = VoiceSettingView.this.voiceList.getItem(VoiceSettingView.this.voiceList.getSelectionIndex());
            VoiceControler.getInstance().changeVoice(label);
            VoiceSettingView.this.setDefaultValue();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    public class ValueChangeMonitor
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            float pitch = VoiceSettingView.this.getPitch();
            float duration = VoiceSettingView.this.getDurationStrech();
            float pitchShift = VoiceSettingView.this.getPitchShift();
            float pitchRange = VoiceSettingView.this.getPitchRange();
            VoiceSettingView.this.updateValues(pitch, duration, pitchShift, pitchRange);
            VoiceSettingView.this.updateLabels(pitch, duration, pitchShift, pitchRange);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

