/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.audio;

import com.sun.speech.freetts.audio.AudioPlayer;
import com.sun.speech.freetts.util.Utilities;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.SequenceInputStream;
import java.util.Vector;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public class SingleFileAudioPlayer
implements AudioPlayer {
    private boolean debug = false;
    private AudioFormat currentFormat = null;
    private String baseName;
    private byte[] outputData;
    private int curIndex = 0;
    private int totBytes = 0;
    private AudioFileFormat.Type outputType;
    private Vector outputList;

    public SingleFileAudioPlayer(String baseName, AudioFileFormat.Type type) {
        this.baseName = baseName + "." + type.getExtension();
        this.outputType = type;
        this.debug = Utilities.getBoolean("com.sun.speech.freetts.audio.AudioPlayer.debug");
        this.outputList = new Vector();
    }

    public SingleFileAudioPlayer() {
        this(Utilities.getProperty("com.sun.speech.freetts.AudioPlayer.baseName", "freetts"), AudioFileFormat.Type.WAVE);
    }

    public synchronized void setAudioFormat(AudioFormat format) {
        this.currentFormat = format;
    }

    public AudioFormat getAudioFormat() {
        return this.currentFormat;
    }

    public void pause() {
    }

    public synchronized void resume() {
    }

    public synchronized void cancel() {
    }

    public synchronized void reset() {
    }

    public void startFirstSampleTimer() {
    }

    public synchronized void close() {
        try {
            File file = new File(this.baseName);
            SequenceInputStream is = new SequenceInputStream(this.outputList.elements());
            AudioInputStream ais = new AudioInputStream(is, this.currentFormat, this.totBytes / this.currentFormat.getFrameSize());
            System.out.println("Wrote synthesized speech to " + this.baseName);
            AudioSystem.write(ais, this.outputType, file);
        }
        catch (IOException ioe) {
            System.err.println("Can't write audio to " + this.baseName);
        }
        catch (IllegalArgumentException iae) {
            System.err.println("Can't write audio type " + this.outputType);
        }
    }

    public float getVolume() {
        return 1.0f;
    }

    public void setVolume(float volume) {
    }

    public void begin(int size) {
        this.outputData = new byte[size];
        this.curIndex = 0;
    }

    public boolean end() {
        this.outputList.add(new ByteArrayInputStream(this.outputData));
        this.totBytes += this.outputData.length;
        return true;
    }

    public boolean drain() {
        return true;
    }

    public synchronized long getTime() {
        return -1L;
    }

    public synchronized void resetTime() {
    }

    public boolean write(byte[] audioData) {
        return this.write(audioData, 0, audioData.length);
    }

    public boolean write(byte[] bytes, int offset, int size) {
        System.arraycopy(bytes, offset, this.outputData, this.curIndex, size);
        this.curIndex += size;
        return true;
    }

    private synchronized boolean waitResume() {
        return true;
    }

    public String toString() {
        return "FileAudioPlayer";
    }

    private void debugPrint(String msg) {
        if (this.debug) {
            System.out.println(this.toString() + ": " + msg);
        }
    }

    public void showMetrics() {
    }
}

