/* Copyright (c) 2000-2003                  */
/*   Yamashita Lab., Ritsumeikan University */
/*   All rights reserved                    */

/*--------------------------------------------------------------------------*/

#ifndef _ACCENT_H_
#define _ACCENT_H_

/* iID */

#define H_MEISHI                      100
#define H_MEISHI_FUTSUU               110
#define H_MEISHI_FUTSUU_IPPAN         111
#define H_MEISHI_FUTSUU_SAHEN         112
#define H_MEISHI_FUTSUU_KEIJOU        113
#define H_MEISHI_FUTSUU_FUKUSHI       114
#define H_MEISHI_KOYUU                120
#define H_MEISHI_KOYUU_IPPAN          121
#define H_MEISHI_KOYUU_JINMEI         122
#define H_MEISHI_KOYUU_CHIMEI         123
#define H_MEISHI_KOYUU_SOSHIKI        124
#define H_MEISHI_KAZU                 130
#define H_DAIMEISHI                   200
#define H_KEIJOUSHI                   300
#define H_RENTAISHI                   400
#define H_FUKUSHI                     500
#define H_SETSUZOKUSHI                600
#define H_KANDOUSHI                   700
#define H_KANDOUSHI_IPPAN             710
#define H_KANDOUSHI_FILLER            720

#define H_DOUSHI                      800
#define H_DOUSHI_IPPAN                810
#define H_DOUSHI_HIJIRITSU            820
#define H_KEIYOUSHI                   900
#define H_KEIYOUSHI_IPPAN             910
#define H_KEIYOUSHI_HIJIRITSU         920
#define H_JODOUSHI                   1000
#define H_JOSHI                      1100
#define H_JOSHI_KAKUJOSHI            1110
#define H_JOSHI_FUKUJOSHI            1120
#define H_JOSHI_KAKARIJOSHI          1130
#define H_JOSHI_SETSUZOKUJOSHI       1140
#define H_JOSHI_SHUUJOSHI            1150
#define H_JOSHI_JUNTAIJOSHI          1160
#define H_SETTOUJI                   1200
#define H_SETSUBIJI                  1300

#define H_KIGOU                      1400
#define H_SONOTA                     1500
#define H_KUTEN                      1540
#define H_TOUTEN                     1550
#define H_KAKKO_HIRAKU               1560
#define H_KAKKO_TOJIRU               1570

#define H_MICHIGO                    1600

#define	IS_MEISHI(h)	   ( ((h)>=H_MEISHI && (h)<=H_DAIMEISHI) )
#define	IS_KOYUU_MEISHI(h) ( ((h)>=H_KOYUU && (h)<H_KAZU) )
#define	IS_DAIMEISHI(h)	   ( ((h)==H_DAIMEISHI) )
#define IS_KEIJOUSHI(h)    ( ((h)==H_KEIJOUSHI) )
#define IS_RENTAISHI(h)    ( ((h)==H_RENTAISHI) )
#define IS_FUKUSHI(h)      ( ((h)==H_FUKUSHI) )
#define IS_SETSUZOKUSHI(h) ( ((h)==H_SETSUZOKUSHI) )
#define IS_KANDOUSHI(h)    ( ((h)>=H_KANDOUSHI && (h)<H_DOUSHI) )
#define IS_FILLER(h)       ( ((h)==H_FILLER) )
#define	IS_DOUSHI(h)	   ( ((h)>=H_DOUSHI && (h)<H_KEIYOUSHI) )
#define	IS_KEIYOUSHI(h)	   ( ((h)>=H_KEIYOUSHI && (h)<H_JODOUSHI) )
#define	IS_JODOUSHI(h)	   ( ((h)==H_JODOUSHI) )
#define	IS_JOSHI(h)	       ( ((h)>=H_JOSHI && (h)<H_SETTOUJI) )
#define IS_SETTOUJI(h)     ( ((h)==H_SETTOUJI) )
#define IS_SETSUBIJI(h)    ( ((h)==H_SETSUBIJI) )
#define IS_KIGOU(h)        ( ((h)>=J_KIGOU) )

#define	IS_FUZOKUGO(h)	( IS_JODOUSHI(h) || IS_JOSHI(h) )
#define	IS_JIRITSUGO(h)	( ! IS_FUZOKUGO(h) )
#define	IS_KUTOUTEN(h)	( ((h)==H_KUTEN || (h)==H_TOUTEN) )

/* p^ID */

#define	KATA_ICHIDAN	1

/* p`ID */

#define	KEI_RENYOU	1
#define	KEI_MIZEN	2


/* ANZglID */

#define	AF_NULL	0
#define	AF_F1	1
#define	AF_F2	2
#define	AF_F3	3
#define	AF_F4	4
#define	AF_F5	5
#define	AF_F6	6
#define	AF_F7	7
#define	AF_F8	8
#define	AF_F9	9

#define	AF_C1	11
#define	AF_C2	12
#define	AF_C3	13
#define	AF_C4	14
#define	AF_C5	15
#define	AF_C6	16
#define	AF_C7	17
#define	AF_C8	18
#define	AF_C9	19
#define	AF_C10	20
#define	AF_C11	21
#define	AF_C12	22

#define	AF_P1	31
#define	AF_P2	32
#define	AF_P3	33
#define	AF_P4	34
#define	AF_P5	35
#define	AF_P6	36
#define	AF_P7	37
#define	AF_P8	38
#define	AF_P9	39
#define	AF_P10	40
#define	AF_P11	41
#define	AF_P12	42
#define	AF_P13	43
#define	AF_P14	44
#define	AF_P15	45

#define AF_OTHER 99


#define	IS_FUZOKU_KETSUGOU(af)	( (af)>=AF_F1 && (af)<AF_C1 )
#define	IS_POST_KETSUGOU(af)	( (af)>=AF_C1 && (af)<AF_P1 )
#define	IS_PRE_KETSUGOU(af) 	( (af)>=AF_P1 && (af)<AF_OTHER )


/* ⣉͌ʂ̌`ԑfID */

#define W_PRON    0
#define W_POS     1
#define W_CTYPE   2
#define W_CFORM   3
#define W_INFO    4
#define W_FORM    5
#define W_ORTH    6

#define W_ACCENT       7
#define W_INDEX_FORM   8
#define W_INDEX_ORTH   9
#define W_A_TYPE      10
#define W_A_CON_TYPE  11
#define W_C_TYPE      12
#define W_C_FORM      13
#define W_LEX         14

#endif

