/* Copyright (c) 2000-2003                  */
/*   Yamashita Lab., Ritsumeikan University */
/*   Studio ARC, ASTEM RI/Kyoto             */
/*   All rights reserved                    */

#include	<stdio.h>
#include	<stdlib.h>

#ifndef WIN32
#include	<unistd.h>
#endif

#include	"confpara.h"

#ifdef WIN32
#include <windows.h>
#include "chaone.h"
#endif

/*
#define CHASEN "/usr/local/bin/chasen"
#define CHASENRC "chasenrc"
*/

typedef struct _pipe_chain {
	char *command[20];
	int last;	/* Ō̃vZX̂ 1 ɂB 0 ɁB*/
} PIPE_CHAIN;

PIPE_CHAIN pchain[3];
char chasen_rc_option[] = "-r";

/*
PIPE_CHAIN pchain[] = {
	{ { CHASEN, "-r", CHASENRC, (char *)0 }, 0 },
	{ { CHAONE, (char *)0 }, 0 },
	{ { POSTP, (char *)0 }, 1 }
};
*/

int TmpMsg(char *,...);
int ErrMsg(char *,...);
int make_pipe_child(PIPE_CHAIN *,int *);

int chasen_process = 0;

#ifndef WIN32
void set_command( char *str, char *command[] )
{
	int i;
	char *c;

	command[0] = str;
	i = 1;  c = str+1;
	while( *c != '\0' )  {
		if( *c == ' ' || *c == '\t' )  *c = '\0';
		if( *(c-1) == '\0' && *c != ' ' && *c != '\t' )  {
			command[i] = c;
			++i;
		}
		++c;
	}
	command[i] = '\0';
}
#endif

#ifdef WIN32
// Load Library functions
typedef int  (__cdecl *chasen_getopt )( char*[], FILE * );
typedef char*  (__cdecl *chasen_sparse )( char* );
#endif

/**
 * Analysis to ChasenDLL
 * in     char* pszText : ͑Ώە
 * return char*         : ͌
 */
char* make_chasen_process( char* pszText )
{
	HINSTANCE hLib;
	// set libchasen.dll
	chasen_getopt chasen_getopt_func;
	// get libchasen.dll
	chasen_sparse chasen_sparse_func;
	// installation place of Chasen (C:\Program Files\chasen\\etc\chasenrc)
	//char *opt[] = { NULL , "-r","C:\\Program Files\\chasen\\etc\\chasenrc", NULL };
	char *opt[] = { NULL, chasen_rc_option, chasen_rc, NULL };
	// libchasen load
	if( ( hLib = LoadLibrary( chasen_dll ) ) != 0 )
	{
		if( ( chasen_getopt_func = ( chasen_getopt )GetProcAddress( hLib, "chasen_getopt_argv" ) ) != 0 )
		{
			( *chasen_getopt_func )( opt, stdout );
		}

		if( ( chasen_sparse_func = ( chasen_sparse )GetProcAddress( hLib, "chasen_sparse_tostr" ) ) != 0 )
		{
			char* str = NULL;
			str = ( *chasen_sparse_func )( pszText );
			return make_chaone_process( str );
			//return str;
		}
	}
	return NULL;
}

#ifndef WIN32
int make_chasen_process( int *fd_in, int *fd_out )
{
	int to_parent[2];

	if( chasen_process != 0 )  return 0;

	pchain[0].command[0] = chasen_bin;
	pchain[0].command[1] = chasen_rc_option;
	pchain[0].command[2] = chasen_rc;
	pchain[0].command[3] = '\0';

	if( chaone_bin[0] == '\0' )  {
		pchain[0].last = 1;		/* set 1 if this process is the last */
	} else {
		pchain[0].last = 0;
		set_command( chaone_bin, pchain[1].command );
		pchain[1].last = 1;	
	}

	/* to_parent ́uŌ̎q -> evŎgB*/
	if( pipe(to_parent) < 0 )  {
		ErrMsg( "pipe error in init_text_analysis\n" );
		return -1;
	}

	/* efd͂̃[`̒Ō܂B*/
	*fd_out = make_pipe_child( pchain, to_parent );
	if( *fd_out < 0 )  return -1;

	*fd_in = to_parent[0];		/* e͂ǂݏoB*/
	close( to_parent[1] );		/* e͂ւ͏ȂB*/
	chasen_process = 1;
#ifdef PRINTDATA
	TmpMsg( "* chasen start.\n" );
#endif
	return 0;
}
#endif

/* q֏ނƂfdԂB */
int make_pipe_child( PIPE_CHAIN *pc, int *to_parent )
{
#ifndef WIN32
	pid_t pid;
	int to_child[2], out;

	/* to_child ́ue -> qvŎgB*/
	if( pipe(to_child) < 0 )  {
		ErrMsg( "pipe error in init_text_analysis\n" );
		return -1;
	}

	switch( (pid=fork()) ) {
	case 0:					/* child */
		/* q͂ւ͏ȂB*/
		close( to_child[1] );

		/* ǂݍݐW͂ */
		if( to_child[0] != 0 )  {
			dup2( to_child[0], 0 );
			close( to_child[0] );
		}

		/* ݐ̐ݒ */
		if( pc->last )  {
		  /* Ō̎q */
			close( to_parent[0] );	/* q͂ǂ܂Ȃ */
			/* Ō̎q͐e֏ށB*/
			if( to_parent[1] != 1 )  {
				dup2( to_parent[1], 1 );
				close( to_parent[1] );
			}
		} else {
		  /* r̎q */
			/* fd͂̃[`̒Ō܂B*/
			out = make_pipe_child( (pc+1), to_parent );
			/* ݐWo͂ */
			if( out != 1 )  {
				dup2( out, 1 );
				close( out );
			}
			close( to_parent[0] );	/* r̎qvZXł͎gȂB */
			close( to_parent[1] );	
		}

		if( execv( pc->command[0], pc->command ) < 0 )  {
			ErrMsg( "execv error in init_text_analysis\n" );
			exit(1);
		}
		break;

	case -1:				/* error */
		ErrMsg( "fork error\n" );
		return -1;

	default:				/* parant */
		close( to_child[0] );	/* e͂ǂ܂ȂB*/
		return to_child[1];		/* e͂֏ށB*/
	}
#endif
	return 0;
}
