/* Copyright (c) 2000-2003                  */
/*   Yamashita Lab., Ritsumeikan University */
/*   Studio ARC, ASTEM RI/Kyoto             */
/*   All rights reserved                    */

#ifndef _CONFPARA_H_
#define _CONFPARA_H_

/* fZbg */
extern FILE *logfp;

extern char *phlist_file;

#ifdef LINUX
#define DEF_PHLIST_FILE "mono.lst"
#else if WIN32
#define DEF_PHLIST_FILE "mono.lst"
#endif

/*  */

extern char *chasen_bin;
extern char *chasen_dll;
extern char *chasen_rc;
extern char *chaone_bin;

#ifdef LINUX
#define DEF_CHASEN_BIN "/usr/local/bin/chasen"
#define DEF_CHASEN_RC  "chasenrc"
#else if WIN32
#define DEF_CHASEN_RC  "chasenrc"
#define DEF_CHASEN_DLL "libchasen.dll"
#define CONF_FILE	   "ssm.conf"
#endif

/* p */

extern char *read_number;
extern char *read_alphabet;
extern char *read_date;
extern char *read_time;

#define DEF_READ_NUMBER "DECIMAL"
#define DEF_READ_ALPHABET "WORD"
#define DEF_READ_DATE "YMD"
#define DEF_READ_TIME "hms"

/* Chaone */
#ifdef WIN32
#define DEF_XSLT_FILE "chaone_t_ms.xsl"
extern char *chaone_xsl;
#endif

#define DEF_CHAONE_BIN "java chaone"

/* b */

typedef enum {MALE,FEMALE,UNKNOWN} GENDER;

typedef struct _speaker {
	char *code;
	GENDER	gender;
	char *dur_tree_file;
	char *pit_tree_file;
	char *mcep_tree_file;
	char *dur_model_file;
	char *pit_model_file;
	char *mcep_model_file;
	double alpha;		/* MEL ̎g[sOWBʏ 0.42 */
	double alpha_saved;	/* W̕ۑ */
} SPEAKER;

#define MAX_SPEAKER 20
extern SPEAKER speaker[MAX_SPEAKER];

extern int n_speaker;	/* o^ꂽbҐ */
extern int spid;	/* ݂̘bID */

#define DEF_ALPHA 0.42
#define DEF_SP_CODE "male01"
#define DEF_SP_GENDER MALE

#ifdef LINUX

#define DEF_DUR_TREE_FILE "tree-dur.inf"
#define DEF_PIT_TREE_FILE "tree-lf0.inf"
#define DEF_MCEP_TREE_FILE "tree-mcep.inf"

#define DEF_DUR_MODEL_FILE "duration.pdf"
#define DEF_PIT_MODEL_FILE "lf0.pdf"
#define DEF_MCEP_MODEL_FILE "mcep.pdf"

#else if WIN32

#define DEF_DUR_TREE_FILE "speakers\\male01\\tree-dur.inf"
#define DEF_PIT_TREE_FILE "speakers\\male01\\tree-lf0.inf"
#define DEF_MCEP_TREE_FILE "speakers\\male01\\tree-mcep.inf"

#define DEF_DUR_MODEL_FILE "speakers\\male01\\duration.pdf"
#define DEF_PIT_MODEL_FILE "speakers\\male01\\lf0.pdf"
#define DEF_MCEP_MODEL_FILE "speakers\\male01\\mcep.pdf"

#endif



#endif
