/* Copyright (c) 2000-2003                  */
/*   Yamashita Lab., Ritsumeikan University */
/*   All rights reserved                    */

#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	"synthesis.h"
#include	"accent.h"

int TmpMsg(char *,...);
int LogMsg(char *,...);
int ErrMsg(char *,...);
void restart(int);
void print_aphrase_kanji(APHRASE *);
void print_aphrase_yomi(APHRASE *);
void print_morph_yomi(MORPH *);



/* ŏɈx */
void init_aphrase()
{
	ahead = atail = NULL;
}

/* ͕Ƃ */
/* gĂANZg̃Z̊J */
void refresh_aphrase()
{
	APHRASE *aphrase, *next;

	aphrase = ahead;
	while( aphrase )  {
		next = aphrase->next;
		free( aphrase );
		aphrase = next;
	}
	ahead = atail = NULL;
}

/* [ mora ꔏłΔOԂ */
int is_TOKUSHUHAKU( MORA *mora )
{
	if( mora == NULL )  return(0);		/* uvȂǁB*/

	if( strcmp("",mora->yomi)==0 )  return(1);
	if( strcmp("[",mora->yomi)==0 )  return(1);
	if( strcmp("b",mora->yomi)==0 )  return(1);
	return(0);
}

/* `ԑf m ̃ANZg^^^łΔOԂ */
int no_nucleus( MORPH *morph )
{
	int 	at, len;

	at = morph->accentType;
	if( at == 0 )  return(1);

	len = morph->nmora;
	if( at == len  )  return(1);
	if( at < len-1 )  return(0);

/* ^ǂ͉ߒPʂŔfB
   uv 3 ^AŏI߁uQvɊj邽߁A^ƂB
   ܂Aat == len-1 ōŏI[ꔑłΔ^B*/
	if( is_TOKUSHUHAKU(morph->mrtail) )  return(1);

	return(0);
}

/* iɊÂĉԖڂ̃ANZggԂ */
int select_aform_pos( MORPH *morph, int hinshiID )
{
	int i;
	char pre_posID;

	if( morph->n_accent <= 0 )  return(-1);

	/* ANZg̐擪`ԑf̕i */
	switch( hinshiID )  {
	case H_DOUSHI:
		pre_posID = 'V';	/*  */
		break;
	case H_KEIYOUSHI:
		pre_posID = 'A';	/* `e */
		break;
	default:
		pre_posID = 'N';	/*  */
	}

	for( i=0; i<morph->n_accent; ++i )  {
		if( morph->accent[i].prepos == pre_posID )  return(i);
	}
	for( i=0; i<morph->n_accent; ++i )  {
		if( morph->accent[i].prepos == '*' )  return(i);
	}
	/* }b`iȂ΁A1Ԗڂ̃f[^g */
	return(0);
}

/* ANZg a Ɍ`ԑf morph 㑱̑Ŝ̃ANZg^߂ */
int accentKetsugou( MORPH *morph, APHRASE *a )
{
	int 	p1, p2, af1, at1, len1, af2, at2, cm2, cm22, len2, at;

	if( morph->nmora == 0 )  return 0;	/* v Ȃ */

	/* sANZg傪ړȂ鎞̂߂ */
	/* l㑱`ԑf̕iŌ߂ */
	at1 = a->accentType;
	p1 = select_aform_pos( a->mptail, morph->hinshiID );
	if( p1 < 0 )  {
		af1 = -1;
	} else {
		af1 = a->mptail->accent[p1].form;
	}
	len1 = a->nmora;

	/* 㑱`ԑf̌lANZg喖̌`ԑf̕iŌ߂ */
	at2 = morph->accentType;
	p2 = select_aform_pos( morph, a->mphead->hinshiID );
	if( p2 < 0 )  {
		af2 = AF_C4;	/* ^  (cm2, cm22 ͕sv) */
	} else {
		af2 = morph->accent[p2].form;
		cm2 = morph->accent[p2].ctype;	/* ANZg */
		if( cm2 < 0 )  cm2 = at2;	/* `ł΃ANZg^̒lg */
		cm22 = morph->accent[p2].ctype2;  /* F6, F9 ł́AQB*/
	}
	len2 = morph->nmora;

/* Oړ̎ */
	if( IS_PRE_KETSUGOU(af1) )  {
		switch( af1 )  {
		case AF_P1:	/* ̉^ */
			at = ( no_nucleus(morph) ) ? 0 : (len1+at2);
			break;
		case AF_P2:	/* ꌋ^ */
			at = ( no_nucleus(morph) ) ? (len1+1) : (len1+at2);
			break;
		case AF_P3:	/* ^ */
			/* ^͓ƗANZg^ɂ */
			/* s邱Ƃ͂Ȃ͂B */
			at = at1;
			break;
		case AF_P4:	/* ^ */
			at = ( no_nucleus(morph) ) ? (len1+1) : (at1);
			break;
		case AF_P5: /* ^`eڑ^ */
			at = len1+len2-1;
			/* 납ڂ̃[ꔑȂO */
			if( is_TOKUSHUHAKU(morph->mrtail->prev) )  {
				--at;
			}
			break;
		case AF_P6:
			at = 0;
			break;
		case AF_P7:
			at = ( no_nucleus(morph) ) ? 0 : (at1);
			break;
		case AF_P8:
			at = ( no_nucleus(morph) ) ? (len1+1) : 0;
			break;
		case AF_P9:
			at = ( no_nucleus(morph) ) ? (len1+1) : (at1);
			break;
		case AF_P10:
			at = ( no_nucleus(morph) ) ? (len1+1) : (at1);
			break;
		case AF_P11:
			at = ( no_nucleus(morph) ) ? (len1) : (len1+at2);
			break;
		case AF_P12:
			at = ( no_nucleus(morph) ) ? (len1) : (at1);
			break;
		case AF_P13:
			at = at1;
			break;
		case AF_P14:
			at = ( no_nucleus(morph) ) ? (at1) : (len1 + at2);
			break;
		case AF_P15:
			at = ( no_nucleus(morph) ) ? (at1) : 1;
			break;
		default: /* px̂ P2 ftH[g */
			/* s邱Ƃ͂Ȃ͂ł邪AÔ߁B */
			at = ( no_nucleus(morph) ) ? (len1+1) : (len1+at2);
			break;
		}
#ifdef KETSUGO_DEBUG
		TmpMsg( "%s %d ړ %o\n", morph->kanji, at, af2 );
#endif
			
/* tꂪ㑱鎞 */
	} else if( IS_FUZOKU_KETSUGOU(af2) )  {
		switch( af2 )  {
		case AF_F1:	/* ]^ */
			at = at1;
			break;
		case AF_F2: /* sSxz^ */
			at = ( at1 == 0 ) ? (len1+cm2) : at1;
			break;
		case AF_F3:	/* Z^ */
			at = ( at1 == 0 ) ? at1 : (len1+cm2);
			break;
		case AF_F4:	/* xz^1 */
			at = (len1+cm2);
			break;
		case AF_F5:	/* xz^2 */
			at = 0;
			break;
		case AF_F6:
			if( cm22 < 0 )  {
				ErrMsg( "'%s' is F6 type. But it does not have two accent conjugation metrics\n", morph->kanji );
				cm22 = cm2;
			}
			at = ( at1 == 0 ) ? (len1+cm2) : (len1+cm22);
			break;
		case AF_F7:
			at = ( at1 == 0 ) ? 0 : (len1+cm2);
			break;
		case AF_F8:
			at = (len1+cm2);
			break;
		case AF_F9:
			if( cm22 < 0 )  {
				ErrMsg( "'%s' is F6 type. But it does not have two accent conjugation metrics\n", morph->kanji );
				cm22 = cm2;
			}
			at = ( at1 == 0 ) ? (len1+cm2) : (len1+cm22);
			break;
		default: /* px̂ F1 ftH[g */
			/* s邱Ƃ͂Ȃ͂ł邪AÔ߁B */
			at = at1;
			break;
		}
#ifdef KETSUGO_DEBUG
		TmpMsg( "%s %d t %o\n", morph->kanji, at, af2 );
#endif

/* ڔZ(Q[ȉ)ꂪ㑱鎞AA̎ */
	} else if( IS_POST_KETSUGOU(af2) )  {
		switch( af2 )  {
		case AF_C1:	/* ꌋ ۑ^ */
			at = len1+at2;
			break;
		case AF_C2:	/* ꌋ N^ */
			at = len1+1;
			break;
		case AF_C3:	/* ڎ W^ */
			/* ANZg̍ŏI[𒲂ׂ */
			/* ꔏȂO */
			at = (is_TOKUSHUHAKU(a->mptail->mrtail)) ? (len1-1) : len1;
			break;
		case AF_C4:	/* ڎ ^ */
			at = 0;
			break;
		case AF_C5:
			at = at1;
			break;
		case AF_C6:
			at = 1;
			break;
		case AF_C7:
			at = len1+cm2;
			break;
		case AF_C8:
			at = len1+at2;
			break;
		case AF_C9:
			at = 0;
			break;
		case AF_C10:
			at = len1+at2;	/* or at = at1; */
			break;
		case AF_C11:
			at = len1+cm2;	/* or at = at1; */
			break;
		case AF_C12:
			at = len1+cm2;	/* or at = len1; */
			break;
		default: /* px̂ C4 ftH[g */
			/* s邱Ƃ͂Ȃ͂ł邪AÔ߁B */
			at = 0;
			break;
		}
#ifdef KETSUGO_DEBUG
		TmpMsg( "%s %d ڔ %o\n", morph->kanji, at, af2 );
#endif

/* ̑̌ */
	} else {
		at = ( no_nucleus(morph) ) ? (len1+1) : (len1+at2);
#ifdef KETSUGO_DEBUG
		TmpMsg( "%s %d ̑ %o\n", morph->kanji, at, af2 );
#endif
	}
	return( at );
}

/* `ԑf morph ANZg a ɒǉ */
void add_to_aphrase( MORPH *morph, APHRASE *a )
{
	if( a->mphead == NULL )  {
		/* ߂̎q */
		a->mphead = a->mptail = morph;
		a->accentType = morph->accentType;
	} else {
		/* Ō̎q */
		a->accentType = accentKetsugou( morph, a );
		a->mptail = morph;
	}
	a->nmora += morph->nmora;
	morph->parent = a;
}

APHRASE *new_aphrase()
{
	APHRASE	*aphrase;

	aphrase = (APHRASE *) malloc( sizeof(APHRASE) );
	if( ! aphrase )  {
		ErrMsg( "* malloc error for 'aphrase'\n" );
		restart(1);
	}
/* ANZgZ`F[̒ɓ */
	if( ahead == NULL )  {
		/* ߂̃Z */
		ahead = atail = aphrase;
		aphrase->prev = aphrase->next = NULL;
	} else {
		/* tail ̌ɒǉ */
		atail->next = aphrase;
		aphrase->prev = atail;
		aphrase->next = NULL;
		atail = aphrase;
	}
	aphrase->parent = NULL;

	aphrase->nmora = 0;
	aphrase->accentType = -1;
	aphrase->position = -1;
	aphrase->silence = NON;
	aphrase->interrogative = NO;
	aphrase->mphead = aphrase->mptail = NULL;

	return aphrase;
}

/* ANZg傪܂ŁA[Ƃ̃ANZgƂāA
       mora.position: ANZg咆ł̃[ʒu
       mora.acdist: ANZg咆ł̃ANZgj̑Έʒu
   ߂B*/
void make_accent_on_mora()
{
	APHRASE	*aphrase;
	MORA	*mora, *last=NULL;
	int 	i, accent;
	
	for( aphrase=ahead; aphrase; aphrase=aphrase->next )  {
		if( aphrase->nmora == 0 )  continue;	/* uvȂǁB*/

		accent = aphrase->accentType;
		mora = aphrase->mphead->mrhead;
		for( i=0; i<aphrase->nmora; ++i, mora=mora->next )  {
			mora->position = i+1;
			mora->acdist = (i+1) - accent;
			last = mora;
		}
		/* Ô */
		if( aphrase->mptail->mrtail != last )  {
			ErrMsg( "* ERROR: make_accent_on_mora \n" );
			restart(1);
		}
	}
}

void make_aphrase()
{
	int 	pre_hinshi, hinshi, pre_ketsugou, ketsugou;
	MORPH	*morph;
	APHRASE	*aphrase=NULL;
	SILENCE pre_silence;

	pre_hinshi = pre_ketsugou = 0;
	pre_silence = NON;
	for( morph=mphead; morph; morph=morph->next )  {
		hinshi = morph->hinshiID;
		ketsugou = morph->accent[0].form;

		if( strcmp(morph->kanji,"H")==0 ) {
			/* 'H' ̑O͕ʂ̃ANZg */
			aphrase = new_aphrase();
			/* ÕANZg^╶ */
			if( aphrase->prev )  aphrase->prev->interrogative = YES;

		} else if( morph->silence != NON) {
			/* ͈̃ANZg */
			aphrase = new_aphrase();

		} else if(pre_silence != NON) {
			/* ͕̌ʂ̃ANZg */
			aphrase = new_aphrase();

		} else if( IS_KUTOUTEN(pre_hinshi) || IS_KUTOUTEN(hinshi) ) {
			/* Ǔ_͒PƂ̃ANZg */
			aphrase = new_aphrase();

		} else if( hinshi == H_KAKKO_HIRAKU ||
				pre_hinshi == H_KAKKO_HIRAKU )  {
			/* L-ʊJ (uȂ) ͒PƂ̃ANZg */
			aphrase = new_aphrase();

		} else if( hinshi == H_KAKKO_TOJIRU ||
				pre_hinshi == H_KAKKO_TOJIRU )  {
			/* L-ʕ (vȂ) ͒PƂ̃ANZg */
			aphrase = new_aphrase();

		} else if( hinshi == H_DOUSHI_HIJIRITSU )  {
			/* -񎩗 (AȂ) ͑Oɂ */

		} else if( hinshi == H_KEIYOUSHI_HIJIRITSU )  {
			/* `e-񎩗 ͑Oɂ */

		} else if( IS_SETSUBIJI(pre_hinshi) && IS_MEISHI(hinshi) )  {
			/* ڔ̖͈̌̃ANZg */

		} else if( IS_FUZOKUGO(pre_hinshi) && IS_JIRITSUGO(hinshi) )  {
			/* ť͕̎ʂ̃ANZg */
			aphrase = new_aphrase();

		} else if( IS_FUZOKUGO(hinshi) )  {
			/* t͑Oɂ */

		} else if( pre_hinshi == H_MEISHI_FUTSUU_FUKUSHI )  {
			/* -ʖ-\ (ׂāAȂ) ͒PƂ̃ANZg */
			aphrase = new_aphrase();

		} else if( pre_hinshi == H_FUKUSHI || hinshi == H_FUKUSHI )  {
			/* ͒PƂ̃ANZg */
			aphrase = new_aphrase();

		} else if( pre_hinshi == H_SETSUZOKUSHI || hinshi == H_SETSUZOKUSHI )  {
			/* ڑ͒PƂ̃ANZg */
			aphrase = new_aphrase();

		} else if( pre_hinshi == H_RENTAISHI )  {
			/* A̎͒PƂ̃ANZg */
			aphrase = new_aphrase();

		} else if( pre_hinshi == H_DOUSHI && IS_MEISHI(hinshi) )  {
			/* ̌ɖʂ̃ANZg */
			aphrase = new_aphrase();

		} else if( pre_hinshi == H_DOUSHI && 
				   ( hinshi == H_KEIYOUSHI || hinshi == H_KEIJOUSHI ) )  {
			/* ̌Ɍ`eA`󎌂ʂ̃ANZg */
			aphrase = new_aphrase();

		} else if( (pre_hinshi == H_KEIYOUSHI || pre_hinshi == H_KEIJOUSHI ) 
				   && IS_MEISHI(hinshi)	) {
			/* `eA`󎌂̌ɖʂ̃ANZg */
			aphrase = new_aphrase();

		} else if( IS_MEISHI(pre_hinshi) && IS_MEISHI(hinshi) )  {
			/* ̘A͂ */

		} else if( pre_ketsugou == AF_P3 )  {
			/* ^ (eAAOAȂ) ͒PƂ̃ANZg */
			aphrase = new_aphrase();

		}
		aphrase->silence = morph->silence;
		add_to_aphrase( morph, aphrase );
		pre_hinshi = hinshi;
		pre_ketsugou = ketsugou;
		pre_silence = morph->silence;
	}

	make_accent_on_mora();
}

void print_aphrase()
{
	int 	n;
	APHRASE	*a;

	LogMsg( "* aphrase data\n" );
	LogMsg( "(orth\tpron\t[accent]\tmora\tposition\tDEC/INT)\n" );
	n = 0;
	for( a=ahead; a; a=a->next )  {
		print_aphrase_kanji( a );
		LogMsg( "\t" );
		print_aphrase_yomi( a );
		LogMsg( "\t[%d]\t%d\t%d\t", a->accentType, a->nmora, a->position );
		if( a->interrogative == YES ) {
		  LogMsg( "INT" );
		} else {
		  LogMsg( "DEC" );
		}
		LogMsg( "\n" );
		++n;
	}
	LogMsg( "- n_aphrase: %d\n", n );
}

void print_aphrase_kanji( APHRASE *a )
{
	MORPH	*morph;

	for( morph=a->mphead; morph && morph->parent==a; morph=morph->next )  {
			LogMsg( "%s", morph->kanji );
	}
}

void print_aphrase_yomi( APHRASE *a )
{
	MORPH	*morph;

	for( morph=a->mphead; morph && morph->parent==a; morph=morph->next )  {
		print_morph_yomi( morph );
	}
}

