/* Copyright (c) 2000-2003                  */
/*   Yamashita Lab., Ritsumeikan University */
/*   All rights reserved                    */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string>
#include "confpara.h"

void restart(int);
//*******for server mode *******
bool SendMsg( const char* lpszMsg );
//******************************

/* to report messages to Control Unit */

extern bool s_mode;

int RepMsg(char *fmt, ...)
{
	va_list ap;
	int error;

	//*******for server mode *******
	char *chrMsg;
	//******************************

	va_start( ap, fmt );
	error = vfprintf( stdout, fmt, ap );
	fflush( stdout );
	va_end( ap );

	//*******for server mode *******
	if (s_mode) {
	  if(error>0)
	    {
	      chrMsg = (char*)malloc(error * sizeof(char*));
	      va_start( ap, fmt );
	      error = vsprintf(chrMsg,fmt,ap);
	      va_end( ap );
	      std::string strMsg = chrMsg;
	      free(chrMsg);
	      
	      strMsg.append("./\n");
	      if(error>0)
		SendMsg(strMsg.c_str());
	    }
	}
	//******************************

	return( error );
}

/* to print messages to debug */

int TmpMsg(char *fmt, ...)
{
	va_list ap;
	int error;

	va_start( ap, fmt );
	error = vfprintf( stderr, fmt, ap );
	fflush( stderr );
	va_end( ap );
	return( error );
}

/* to log messages to debug */

int LogMsg(char *fmt, ...)
{
	va_list ap;
	int error;

	va_start( ap, fmt );
	error = vfprintf( logfp, fmt, ap );
	fflush( stderr );
	va_end( ap );
	return( error );
}

/* to log error messages */

FILE *fp_err;

int ErrMsg(char *fmt, ...)
{
	va_list ap;
	int error;

	va_start( ap, fmt );
	error = vfprintf( fp_err, fmt, ap );
	fflush( fp_err );
	va_end( ap );
	return( error );
}

char* malloc_char( char* str, char *str_name )
{
	char *p;

	p = (char *) malloc( sizeof(char) * (strlen(str)+1) );
	if( ! p )  {
		ErrMsg( "* malloc error for '%s'\n", str_name );
		restart(1);
	}
	strcpy( p, str );
	return p;
}

