/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source;

import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.IChangeRulerColumn;
import org.eclipse.jface.text.source.ILineDiffInfo;
import org.eclipse.jface.text.source.ILineDiffer;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.text.source.IVerticalRulerInfoExtension;
import org.eclipse.jface.text.source.IVerticalRulerListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public final class ChangeRulerColumn
implements IVerticalRulerColumn,
IVerticalRulerInfo,
IVerticalRulerInfoExtension,
IChangeRulerColumn {
    private CompositeRuler fParentRuler;
    private ITextViewer fCachedTextViewer;
    private StyledText fCachedTextWidget;
    private Canvas fCanvas;
    private int fScrollPos;
    private Image fBuffer;
    private InternalListener fInternalListener = new InternalListener();
    private boolean fSensitiveToTextChanges = false;
    private Color fForeground;
    private Color fBackground;
    private Color fAddedColor;
    private Color fChangedColor;
    private Color fDeletedColor;
    private IAnnotationModel fAnnotationModel;
    private IAnnotationHover fHover;
    private AnnotationListener fAnnotationListener = new AnnotationListener();
    private int fWidth = 5;

    protected Color getBackground(Display display) {
        if (this.fBackground == null) {
            return display.getSystemColor(25);
        }
        return this.fBackground;
    }

    public Control createControl(CompositeRuler parentRuler, Composite parentControl) {
        this.fParentRuler = parentRuler;
        this.fCachedTextViewer = parentRuler.getTextViewer();
        this.fCachedTextWidget = this.fCachedTextViewer.getTextWidget();
        this.fCanvas = new Canvas(parentControl, 0);
        this.fCanvas.setBackground(this.getBackground(this.fCanvas.getDisplay()));
        this.fCanvas.setForeground(this.fForeground);
        this.fCanvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                if (ChangeRulerColumn.this.fCachedTextViewer != null) {
                    ChangeRulerColumn.this.doubleBufferPaint(event.gc);
                }
            }
        });
        this.fCanvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ChangeRulerColumn.this.handleDispose();
                ChangeRulerColumn.this.fCachedTextViewer = null;
                ChangeRulerColumn.this.fCachedTextWidget = null;
            }
        });
        MouseHandler mouseHandler = new MouseHandler();
        this.fCanvas.addMouseListener((MouseListener)mouseHandler);
        this.fCanvas.addMouseMoveListener((MouseMoveListener)mouseHandler);
        if (this.fCachedTextViewer != null) {
            this.fCachedTextViewer.addViewportListener(this.fInternalListener);
            this.fCachedTextViewer.addTextListener(this.fInternalListener);
        }
        return this.fCanvas;
    }

    protected void handleDispose() {
        if (this.fAnnotationModel != null) {
            this.fAnnotationModel.removeAnnotationModelListener((IAnnotationModelListener)this.fAnnotationListener);
            this.fAnnotationModel = null;
        }
        if (this.fCachedTextViewer != null) {
            this.fCachedTextViewer.removeViewportListener(this.fInternalListener);
            this.fCachedTextViewer.removeTextListener(this.fInternalListener);
        }
        if (this.fBuffer != null) {
            this.fBuffer.dispose();
            this.fBuffer = null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doubleBufferPaint(GC dest) {
        Point size = this.fCanvas.getSize();
        if (size.x <= 0 || size.y <= 0) {
            return;
        }
        if (this.fBuffer != null) {
            Rectangle r = this.fBuffer.getBounds();
            if (r.width != size.x || r.height != size.y) {
                this.fBuffer.dispose();
                this.fBuffer = null;
            }
        }
        if (this.fBuffer == null) {
            this.fBuffer = new Image((Device)this.fCanvas.getDisplay(), size.x, size.y);
        }
        GC gc = new GC((Drawable)this.fBuffer);
        gc.setFont(this.fCanvas.getFont());
        if (this.fForeground != null) {
            gc.setForeground(this.fForeground);
        }
        try {
            gc.setBackground(this.getBackground(this.fCanvas.getDisplay()));
            gc.fillRectangle(0, 0, size.x, size.y);
            if (this.fCachedTextViewer instanceof ITextViewerExtension5) {
                this.doPaint1(gc);
            } else {
                this.doPaint(gc);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            gc.dispose();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        gc.dispose();
        dest.drawImage(this.fBuffer, 0, 0);
    }

    protected int getVisibleLinesInViewport() {
        Rectangle clArea = this.fCachedTextWidget.getClientArea();
        if (!clArea.isEmpty()) {
            return clArea.height / this.fCachedTextWidget.getLineHeight();
        }
        return -1;
    }

    private void doPaint(GC gc) {
        if (this.fCachedTextViewer == null) {
            return;
        }
        if (this.fCachedTextWidget == null) {
            return;
        }
        int firstLine = 0;
        int topLine = this.fCachedTextViewer.getTopIndex() - 1;
        int bottomLine = this.fCachedTextViewer.getBottomIndex() + 1;
        try {
            int lastLine;
            IRegion region = this.fCachedTextViewer.getVisibleRegion();
            IDocument doc = this.fCachedTextViewer.getDocument();
            if (doc == null) {
                return;
            }
            firstLine = doc.getLineOfOffset(region.getOffset());
            if (firstLine > topLine) {
                topLine = firstLine;
            }
            if ((lastLine = doc.getLineOfOffset(region.getOffset() + region.getLength())) < bottomLine) {
                bottomLine = lastLine;
            }
        }
        catch (BadLocationException badLocationException) {
            return;
        }
        this.fSensitiveToTextChanges = bottomLine - topLine < this.getVisibleLinesInViewport();
        int lineheight = this.fCachedTextWidget.getLineHeight();
        this.fScrollPos = this.fCachedTextWidget.getTopPixel();
        int canvasheight = this.fCanvas.getSize().y;
        int y = (topLine - firstLine) * lineheight - this.fScrollPos + this.fCachedTextViewer.getTopInset();
        int line = topLine;
        while (line <= bottomLine) {
            if (y >= canvasheight) break;
            this.paintLine(line, y, lineheight, gc, this.fCachedTextWidget.getDisplay());
            ++line;
            y += lineheight;
        }
    }

    private void doPaint1(GC gc) {
        if (this.fCachedTextViewer == null) {
            return;
        }
        ITextViewerExtension5 extension = (ITextViewerExtension5)((Object)this.fCachedTextViewer);
        int firstLine = 0;
        int widgetTopLine = this.fCachedTextWidget.getTopIndex();
        if (widgetTopLine > 0) {
            --widgetTopLine;
        }
        int topLine = extension.widgetLine2ModelLine(widgetTopLine);
        int bottomLine = this.fCachedTextViewer.getBottomIndex();
        if (bottomLine >= 0) {
            ++bottomLine;
        }
        try {
            int lastLine;
            IRegion region = extension.getModelCoverage();
            IDocument doc = this.fCachedTextViewer.getDocument();
            if (doc == null) {
                return;
            }
            firstLine = doc.getLineOfOffset(region.getOffset());
            if (firstLine > topLine || topLine == -1) {
                topLine = firstLine;
            }
            if ((lastLine = doc.getLineOfOffset(region.getOffset() + region.getLength())) < bottomLine || bottomLine == -1) {
                bottomLine = lastLine;
            }
        }
        catch (BadLocationException badLocationException) {
            return;
        }
        this.fSensitiveToTextChanges = bottomLine - topLine < this.getVisibleLinesInViewport();
        int lineheight = this.fCachedTextWidget.getLineHeight();
        this.fScrollPos = this.fCachedTextWidget.getTopPixel();
        int canvasheight = this.fCanvas.getSize().y;
        int y = widgetTopLine * lineheight - this.fScrollPos + this.fCachedTextViewer.getTopInset();
        int modelLine = topLine;
        while (modelLine <= bottomLine) {
            if (y >= canvasheight) break;
            int widgetLine = extension.modelLine2WidgetLine(modelLine);
            if (widgetLine != -1) {
                this.paintLine(modelLine, y, lineheight, gc, this.fCachedTextWidget.getDisplay());
                y += lineheight;
            }
            ++modelLine;
        }
    }

    public void redraw() {
        if (this.fCanvas != null && !this.fCanvas.isDisposed()) {
            GC gc = new GC((Drawable)this.fCanvas);
            this.doubleBufferPaint(gc);
            gc.dispose();
        }
    }

    public void setFont(Font font) {
    }

    protected CompositeRuler getParentRuler() {
        return this.fParentRuler;
    }

    protected void paintLine(int line, int y, int lineheight, GC gc, Display display) {
        ILineDiffInfo info = this.getDiffInfo(line);
        if (info != null) {
            int width = this.getWidth();
            if (this.hasSpecialColor(info)) {
                gc.setBackground(this.getColor(info, display));
                gc.fillRectangle(0, y, width, lineheight);
            }
            int delBefore = info.getRemovedLinesAbove();
            int delBelow = info.getRemovedLinesBelow();
            if (delBefore > 0 || delBelow > 0) {
                Color deletionColor = this.getDeletionColor(display);
                gc.setForeground(deletionColor);
                if (delBefore > 0) {
                    gc.drawLine(0, y, width, y);
                }
                if (delBelow > 0) {
                    gc.drawLine(0, y + lineheight - 1, width, y + lineheight - 1);
                }
            }
        }
    }

    private boolean hasSpecialColor(ILineDiffInfo info) {
        return info.getChangeType() == 1 || info.getChangeType() == 2;
    }

    private ILineDiffInfo getDiffInfo(int line) {
        if (this.fAnnotationModel == null) {
            return null;
        }
        if (this.fAnnotationModel instanceof ILineDiffer) {
            ILineDiffer differ = (ILineDiffer)this.fAnnotationModel;
            return differ.getLineInfo(line);
        }
        return null;
    }

    private Color getDeletionColor(Display display) {
        return this.fDeletedColor == null ? this.getBackground(display) : this.fDeletedColor;
    }

    private Color getColor(ILineDiffInfo info, Display display) {
        Assert.isTrue((info != null && info.getChangeType() != 0 ? 1 : 0) != 0);
        Color ret = null;
        switch (info.getChangeType()) {
            case 2: {
                ret = this.fChangedColor;
                break;
            }
            case 1: {
                ret = this.fAddedColor;
            }
        }
        return ret == null ? this.getBackground(display) : ret;
    }

    public int getLineOfLastMouseButtonActivity() {
        return this.getParentRuler().getLineOfLastMouseButtonActivity();
    }

    public int toDocumentLineNumber(int y_coordinate) {
        return this.getParentRuler().toDocumentLineNumber(y_coordinate);
    }

    public IAnnotationHover getHover() {
        return this.fHover;
    }

    public void setHover(IAnnotationHover hover) {
        this.fHover = hover;
    }

    public void setModel(IAnnotationModel model) {
        IAnnotationModel newModel = model instanceof IAnnotationModelExtension ? ((IAnnotationModelExtension)model).getAnnotationModel((Object)"diff") : model;
        if (this.fAnnotationModel != newModel) {
            if (this.fAnnotationModel != null) {
                this.fAnnotationModel.removeAnnotationModelListener((IAnnotationModelListener)this.fAnnotationListener);
            }
            this.fAnnotationModel = newModel;
            if (this.fAnnotationModel != null) {
                this.fAnnotationModel.addAnnotationModelListener((IAnnotationModelListener)this.fAnnotationListener);
            }
            this.redraw();
        }
    }

    public void setBackground(Color background) {
        this.fBackground = background;
        if (this.fCanvas != null && !this.fCanvas.isDisposed()) {
            this.fCanvas.setBackground(this.getBackground(this.fCanvas.getDisplay()));
        }
    }

    public void setAddedColor(Color addedColor) {
        this.fAddedColor = addedColor;
    }

    public void setChangedColor(Color changedColor) {
        this.fChangedColor = changedColor;
    }

    public void setDeletedColor(Color deletedColor) {
        this.fDeletedColor = deletedColor;
    }

    public IAnnotationModel getModel() {
        return this.fAnnotationModel;
    }

    public Control getControl() {
        return this.fCanvas;
    }

    public int getWidth() {
        return this.fWidth;
    }

    protected final void postRedraw() {
        Display d;
        if (this.fCanvas != null && !this.fCanvas.isDisposed() && (d = this.fCanvas.getDisplay()) != null) {
            d.asyncExec(new Runnable(){

                public void run() {
                    ChangeRulerColumn.this.redraw();
                }
            });
        }
    }

    public void addVerticalRulerListener(IVerticalRulerListener listener) {
        throw new UnsupportedOperationException();
    }

    public void removeVerticalRulerListener(IVerticalRulerListener listener) {
        throw new UnsupportedOperationException();
    }

    class MouseHandler
    implements MouseListener,
    MouseMoveListener {
        MouseHandler() {
        }

        public void mouseUp(MouseEvent event) {
        }

        public void mouseDown(MouseEvent event) {
            ChangeRulerColumn.this.fParentRuler.setLocationOfLastMouseButtonActivity(event.x, event.y);
        }

        public void mouseDoubleClick(MouseEvent event) {
            ChangeRulerColumn.this.fParentRuler.setLocationOfLastMouseButtonActivity(event.x, event.y);
        }

        public void mouseMove(MouseEvent e) {
        }
    }

    class InternalListener
    implements IViewportListener,
    ITextListener {
        InternalListener() {
        }

        public void viewportChanged(int verticalPosition) {
            if (verticalPosition != ChangeRulerColumn.this.fScrollPos) {
                ChangeRulerColumn.this.redraw();
            }
        }

        public void textChanged(TextEvent event) {
            if (!event.getViewerRedrawState()) {
                return;
            }
            if (ChangeRulerColumn.this.fSensitiveToTextChanges || event.getDocumentEvent() == null) {
                ChangeRulerColumn.this.postRedraw();
            }
        }
    }

    class AnnotationListener
    implements IAnnotationModelListener {
        AnnotationListener() {
        }

        public void modelChanged(IAnnotationModel model) {
            ChangeRulerColumn.this.postRedraw();
        }
    }
}

