/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.adaptor.core;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Dictionary;
import java.util.Properties;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.BundleWatcher;
import org.eclipse.osgi.framework.adaptor.EventPublisher;
import org.eclipse.osgi.framework.adaptor.FrameworkAdaptor;
import org.eclipse.osgi.framework.adaptor.ServiceRegistry;
import org.eclipse.osgi.framework.adaptor.core.AdaptorElementFactory;
import org.eclipse.osgi.framework.adaptor.core.AdaptorMsg;
import org.eclipse.osgi.framework.adaptor.core.BundleFile;
import org.eclipse.osgi.framework.adaptor.core.BundleResourceHandler;
import org.eclipse.osgi.framework.adaptor.core.ServiceRegistryImpl;
import org.eclipse.osgi.framework.adaptor.core.SystemBundleData;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.util.Headers;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public abstract class AbstractFrameworkAdaptor
implements FrameworkAdaptor {
    public static final String PROP_PARENT_CLASSLOADER = "osgi.parentClassloader";
    public static final String PARENT_CLASSLOADER_APP = "app";
    public static final String PARENT_CLASSLOADER_EXT = "ext";
    public static final String PARENT_CLASSLOADER_BOOT = "boot";
    public static final String PARENT_CLASSLOADER_FWK = "fwk";
    protected final String ADAPTOR_MANIFEST = "ADAPTOR.MF";
    protected EventPublisher eventPublisher;
    protected ServiceRegistryImpl serviceRegistry;
    protected Properties properties;
    protected BundleContext context;
    protected int initialBundleStartLevel = 1;
    protected Headers manifest = null;
    protected boolean stopping = false;
    protected static ClassLoader bundleClassLoaderParent;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        ClassLoader appCL;
        String type = System.getProperty(PROP_PARENT_CLASSLOADER, PARENT_CLASSLOADER_BOOT);
        if (PARENT_CLASSLOADER_FWK.equalsIgnoreCase(type)) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.osgi.framework.adaptor.FrameworkAdaptor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            bundleClassLoaderParent = clazz.getClassLoader();
        } else if (PARENT_CLASSLOADER_APP.equalsIgnoreCase(type)) {
            bundleClassLoaderParent = ClassLoader.getSystemClassLoader();
        } else if (PARENT_CLASSLOADER_EXT.equalsIgnoreCase(type) && (appCL = ClassLoader.getSystemClassLoader()) != null) {
            bundleClassLoaderParent = appCL.getParent();
        }
        if (bundleClassLoaderParent == null) {
            bundleClassLoaderParent = new ParentClassLoader();
        }
    }

    public void initialize(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
        this.serviceRegistry = new ServiceRegistryImpl();
        this.serviceRegistry.initialize();
        this.loadProperties();
        this.readAdaptorManifest();
    }

    public Properties getProperties() {
        return this.properties;
    }

    public URLConnection mapLocationToURLConnection(String location) throws BundleException {
        try {
            return new URL(location).openConnection();
        }
        catch (IOException e) {
            throw new BundleException(AdaptorMsg.formatter.getString("ADAPTOR_URL_CREATE_EXCEPTION", (Object)location), (Throwable)e);
        }
    }

    public long getTotalFreeSpace() throws IOException {
        return -1L;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    public void frameworkStart(BundleContext context) throws BundleException {
        this.stopping = false;
        this.context = context;
        BundleResourceHandler.setContext(context);
    }

    public void frameworkStop(BundleContext context) throws BundleException {
        this.context = null;
        BundleResourceHandler.setContext(null);
    }

    public void frameworkStopping(BundleContext context) {
        this.stopping = true;
    }

    public String getExportPackages() {
        if (this.manifest == null) {
            return null;
        }
        return (String)this.manifest.get((Object)"Export-Package");
    }

    public String getExportServices() {
        if (this.manifest == null) {
            return null;
        }
        return (String)this.manifest.get((Object)"Export-Service");
    }

    public String getProvidePackages() {
        if (this.manifest == null) {
            return null;
        }
        return (String)this.manifest.get((Object)"Provide-Package");
    }

    public EventPublisher getEventPublisher() {
        return this.eventPublisher;
    }

    public boolean isStopping() {
        return this.stopping;
    }

    public int getInitialBundleStartLevel() {
        return this.initialBundleStartLevel;
    }

    public void setInitialBundleStartLevel(int value) {
        this.initialBundleStartLevel = value;
    }

    public BundleWatcher getBundleWatcher() {
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadProperties() {
        this.properties = new Properties();
        String resource = System.getProperty("osgi.framework.properties", "osgi.properties");
        try {
            InputStream in = null;
            File file = new File(resource);
            if (file.exists()) {
                in = new FileInputStream(file);
            }
            if (in == null) {
                in = this.getClass().getResourceAsStream(resource);
            }
            if (in == null) {
                if (!Debug.DEBUG_GENERAL) return;
                Debug.println((String)("Skipping osgi.properties: " + resource));
                return;
            }
            try {
                this.properties.load(new BufferedInputStream(in));
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var4_7 = null;
                try {}
                catch (IOException iOException) {
                    return;
                }
                in.close();
                return;
            }
        }
        catch (IOException e) {
            if (!Debug.DEBUG_GENERAL) return;
            Debug.println((String)("Unable to load osgi.properties: " + e.getMessage()));
        }
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void readAdaptorManifest() {
        Class<?> clazz;
        InputStream in = null;
        Class<?> adaptorClazz = this.getClass();
        boolean bl = true;
        do {
            if (!bl || (bl = false) || !true) {
                in = adaptorClazz.getResourceAsStream("ADAPTOR.MF");
                adaptorClazz = adaptorClazz.getSuperclass();
            }
            if (in != null) break;
            clazz = class$1;
            if (clazz != null) continue;
            try {
                clazz = Class.forName("org.eclipse.osgi.framework.adaptor.core.AbstractFrameworkAdaptor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        } while (clazz.isAssignableFrom(adaptorClazz));
        if (in == null) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println((String)"Unable to find adaptor bundle manifest ADAPTOR.MF");
            }
            this.manifest = new Headers((Dictionary)new Properties());
            return;
        }
        try {
            this.manifest = Headers.parseManifest(in);
            return;
        }
        catch (BundleException bundleException) {
            Debug.println((String)"Unable to read adaptor bundle manifest ADAPTOR.MF");
        }
    }

    public BundleData createSystemBundleData() throws BundleException {
        return new SystemBundleData(this);
    }

    public abstract AdaptorElementFactory getElementFactory();

    public static void copyDir(File inDir, File outDir) throws IOException {
        String[] files = inDir.list();
        if (files != null && files.length > 0) {
            outDir.mkdir();
            int i = 0;
            while (i < files.length) {
                File inFile = new File(inDir, files[i]);
                File outFile = new File(outDir, files[i]);
                if (inFile.isDirectory()) {
                    AbstractFrameworkAdaptor.copyDir(inFile, outFile);
                } else {
                    FileInputStream in = new FileInputStream(inFile);
                    AbstractFrameworkAdaptor.readFile(in, outFile);
                }
                ++i;
            }
        }
    }

    public static void readFile(InputStream in, File file) throws IOException {
        FileOutputStream fos = null;
        try {
            int count;
            fos = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            while ((count = in.read(buffer, 0, buffer.length)) > 0) {
                fos.write(buffer, 0, count);
            }
            fos.close();
            fos = null;
            in.close();
            in = null;
        }
        catch (IOException e) {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (Debug.DEBUG_GENERAL) {
                Debug.println((String)"Unable to read file");
                Debug.printStackTrace((Throwable)e);
            }
            throw e;
        }
    }

    public ClassLoader getBundleClassLoaderParent() {
        return bundleClassLoaderParent;
    }

    public void handleRuntimeError(Throwable error) {
    }

    public BundleFile createBundleFile(File basefile, BundleData bundledata) throws IOException {
        if (basefile.isDirectory()) {
            return new BundleFile.DirBundleFile(basefile);
        }
        return new BundleFile.ZipBundleFile(basefile, bundledata);
    }

    protected static class ParentClassLoader
    extends ClassLoader {
        protected ParentClassLoader() {
            super(null);
        }
    }
}

