/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.model.ITocElement;
import org.eclipse.help.internal.toc.TocManager;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.internal.webapp.servlet.XMLGenerator;

public class TocServlet
extends HttpServlet {
    private String locale;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.locale = UrlUtil.getLocale(req, resp);
        req.setCharacterEncoding("UTF-8");
        resp.setContentType("application/xml; charset=UTF-8");
        resp.setHeader("Cache-Control", "max-age=10000");
        if ("/".equals(req.getPathInfo())) {
            if (req.getParameter("topic") == null) {
                this.serializeTocs(resp);
            } else {
                this.serializeTocs(this.findTocContainingTopic(req.getParameter("topic")), resp);
            }
        } else {
            this.serializeToc(req.getPathInfo(), resp);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    private void serializeToc(String tocID, HttpServletResponse resp) throws ServletException, IOException {
        ITocElement toc = HelpPlugin.getTocManager().getToc(tocID, this.locale);
        this.serializeToc((IToc)toc, resp);
    }

    private void serializeToc(IToc toc, HttpServletResponse resp) throws ServletException, IOException {
        if (toc == null) {
            throw new ServletException();
        }
        TocWriter tocWriter = new TocWriter(resp.getWriter());
        tocWriter.generate(toc, true);
        tocWriter.close();
    }

    private void serializeTocs(HttpServletResponse resp) throws ServletException, IOException {
        TocManager tocManager = HelpPlugin.getTocManager();
        ITocElement[] tocs = tocManager.getTocs(this.locale);
        TocWriter gen = new TocWriter(resp.getWriter());
        gen.println("<tocs>");
        ++gen.pad;
        int i = 0;
        while (i < tocs.length) {
            gen.printPad();
            gen.generate((IToc)tocs[i], false);
            ++i;
        }
        --gen.pad;
        gen.println("</tocs>");
        gen.close();
    }

    private void serializeTocs(IToc toc, HttpServletResponse resp) throws ServletException, IOException {
        if (toc == null) {
            throw new ServletException();
        }
        TocWriter gen = new TocWriter(resp.getWriter());
        gen.println("<tocs>");
        ++gen.pad;
        gen.printPad();
        gen.generate(toc, false);
        --gen.pad;
        gen.println("</tocs>");
        gen.close();
    }

    private IToc findTocContainingTopic(String topic) {
        if (topic == null || topic.equals("")) {
            return null;
        }
        int index = topic.indexOf("/topic/");
        if (index != -1) {
            topic = topic.substring(index + 6);
        }
        if ((index = topic.indexOf(63)) != -1) {
            topic = topic.substring(0, index);
        }
        if (topic == null || topic.equals("")) {
            return null;
        }
        ITocElement[] tocs = HelpPlugin.getTocManager().getTocs(this.locale);
        int i = 0;
        while (i < tocs.length) {
            if (tocs[i].getTopic(topic) != null) {
                return tocs[i];
            }
            ++i;
        }
        return null;
    }

    private static class TocWriter
    extends XMLGenerator {
        public TocWriter(Writer writer) {
            super(writer);
        }

        public void generate(IToc toc, boolean genTopics) {
            String topicDescription = "";
            ITopic topic = toc.getTopic(null);
            if (topic != null) {
                topicDescription = topic.getHref();
            }
            this.println("<toc label=\"" + XMLGenerator.xmlEscape(toc.getLabel()) + "\" href=\"" + TocWriter.reduceURL(toc.getHref()) + "\" topic=\"" + TocWriter.reduceURL(topicDescription) + "\">");
            if (genTopics) {
                ITopic[] topics = toc.getTopics();
                int i = 0;
                while (i < topics.length) {
                    this.generate(topics[i]);
                    ++i;
                }
            }
            this.println("</toc>");
        }

        protected void generate(ITopic topic) {
            ++this.pad;
            this.printPad();
            String href = topic.getHref();
            this.print("<topic label=\"" + XMLGenerator.xmlEscape(topic.getLabel()) + "\"" + (href != null ? " href=\"" + TocWriter.reduceURL(href) + "\"" : ""));
            ITopic[] subtopics = topic.getSubtopics();
            if (subtopics.length > 0) {
                this.println(">");
                int i = 0;
                while (i < subtopics.length) {
                    this.generate(subtopics[i]);
                    ++i;
                }
                this.printPad();
                this.println("</topic>");
            } else {
                this.println(" />");
            }
            --this.pad;
        }

        protected static String reduceURL(String url) {
            int index;
            if (url == null) {
                return url;
            }
            while ((index = url.indexOf("/..", 1)) > 0) {
                String part1 = url.substring(0, index);
                String part2 = url.substring(index + "/..".length());
                index = part1.lastIndexOf("/");
                if (index >= 0) {
                    url = String.valueOf(part1.substring(0, index)) + part2;
                    continue;
                }
                url = part2;
            }
            return url;
        }
    }
}

