/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.model.PerspectiveLabelProvider;

public class ProjectPerspectiveChoiceDialog
extends Dialog {
    private static final int MIN_DIALOG_WIDTH = 200;
    private static final int MIN_DIALOG_HEIGHT = 250;
    private IWorkbenchWindow window;
    private ArrayList persps;
    private IPerspectiveDescriptor chosenPersp;
    private boolean sameWindow = true;
    private TableViewer list;
    private Comparator comparator = new Comparator(){
        private Collator collator = Collator.getInstance();

        public int compare(Object ob1, Object ob2) {
            IPerspectiveDescriptor d1 = (IPerspectiveDescriptor)ob1;
            IPerspectiveDescriptor d2 = (IPerspectiveDescriptor)ob2;
            return this.collator.compare(d1.getLabel(), d2.getLabel());
        }
    };

    public ProjectPerspectiveChoiceDialog(IWorkbenchWindow window, String[] perspIds) {
        super(window.getShell());
        this.window = window;
        IWorkbenchPage page = window.getActivePage();
        if (page != null) {
            this.chosenPersp = page.getPerspective();
        }
        IPerspectiveRegistry reg = window.getWorkbench().getPerspectiveRegistry();
        this.persps = new ArrayList(perspIds.length);
        int i = 0;
        while (i < perspIds.length) {
            IPerspectiveDescriptor desc = reg.findPerspectiveWithId(perspIds[i]);
            if (desc != null && desc != this.chosenPersp) {
                this.persps.add(desc);
            }
            ++i;
        }
        Collections.sort(this.persps, this.comparator);
        if (this.chosenPersp != null) {
            this.persps.add(0, this.chosenPersp);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(IDEWorkbenchMessages.getString("ProjectPerspectiveChoiceDialog.title"));
        WorkbenchHelp.setHelp((Control)shell, (String)"org.eclipse.ui.ide.show_project_perspective_dialog_context");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout());
        GridData data = new GridData(1808);
        data.widthHint = 200;
        data.heightHint = 250;
        composite.setLayoutData((Object)data);
        this.createPerspectiveGroup(composite);
        this.createOptionGroup(composite);
        if (this.chosenPersp != null) {
            this.list.setSelection((ISelection)new StructuredSelection((Object)this.chosenPersp));
        }
        return composite;
    }

    private void createPerspectiveGroup(Composite parent) {
        Font font = parent.getFont();
        Label label = new Label(parent, 0);
        label.setFont(font);
        label.setText(IDEWorkbenchMessages.getString("ProjectPerspectiveChoiceDialog.choosePerspective"));
        this.list = new TableViewer(parent, 2816);
        this.list.setLabelProvider((IBaseLabelProvider)new PerspectiveLabelProvider(false));
        this.list.setContentProvider((IContentProvider)new PerspectiveContentProvider());
        this.list.setInput((Object)this.persps);
        this.list.addSelectionChangedListener((ISelectionChangedListener)new SelectionListener());
        this.list.getTable().setLayoutData((Object)new GridData(1808));
        this.list.getTable().setFont(font);
    }

    private void createOptionGroup(Composite parent) {
        Font font = parent.getFont();
        Group optionGroup = new Group(parent, 16384);
        GridLayout layout = new GridLayout();
        optionGroup.setLayout((Layout)layout);
        GridData data = new GridData(768);
        optionGroup.setLayoutData((Object)data);
        optionGroup.setFont(font);
        optionGroup.setText(IDEWorkbenchMessages.getString("ProjectPerspectiveChoiceDialog.options"));
        Button button = new Button((Composite)optionGroup, 16400);
        button.setText(IDEWorkbenchMessages.getString("ProjectPerspectiveChoiceDialog.sameWindow"));
        data = new GridData();
        button.setLayoutData((Object)data);
        button.setFont(font);
        button.setSelection(this.sameWindow);
        button.addSelectionListener((org.eclipse.swt.events.SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPerspectiveChoiceDialog.this.sameWindow = true;
            }
        });
        button = new Button((Composite)optionGroup, 16400);
        button.setText(IDEWorkbenchMessages.getString("ProjectPerspectiveChoiceDialog.newWindow"));
        data = new GridData();
        button.setLayoutData((Object)data);
        button.setFont(font);
        button.setSelection(!this.sameWindow);
        button.addSelectionListener((org.eclipse.swt.events.SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPerspectiveChoiceDialog.this.sameWindow = false;
            }
        });
    }

    public IWorkbenchWindow showChosenPerspective() {
        if (this.chosenPersp == null) {
            return this.window;
        }
        final IWorkbenchWindow[] results = new IWorkbenchWindow[1];
        final WorkbenchException[] errors = new WorkbenchException[1];
        BusyIndicator.showWhile((Display)this.window.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                if (ProjectPerspectiveChoiceDialog.this.sameWindow) {
                    results[0] = ProjectPerspectiveChoiceDialog.this.window;
                    IWorkbenchPage page = ProjectPerspectiveChoiceDialog.this.window.getActivePage();
                    if (page != null) {
                        page.setPerspective(ProjectPerspectiveChoiceDialog.this.chosenPersp);
                    }
                } else {
                    try {
                        results[0] = ProjectPerspectiveChoiceDialog.this.window.getWorkbench().openWorkbenchWindow(ProjectPerspectiveChoiceDialog.this.chosenPersp.getId(), (IAdaptable)ResourcesPlugin.getWorkspace().getRoot());
                    }
                    catch (WorkbenchException e) {
                        errors[0] = e;
                    }
                }
            }
        });
        IWorkbenchWindow result = results[0];
        results[0] = null;
        if (errors[0] != null) {
            ErrorDialog.openError((Shell)this.window.getShell(), (String)IDEWorkbenchMessages.getString("ProjectPerspectiveChoiceDialog.errorTitle"), (String)IDEWorkbenchMessages.getString("ProjectPerspectiveChoiceDialog.errorMessage"), (IStatus)errors[0].getStatus());
            errors[0] = null;
            return this.window;
        }
        return result;
    }

    class PerspectiveContentProvider
    implements IStructuredContentProvider {
        public void dispose() {
        }

        public Object[] getElements(Object element) {
            if (element instanceof ArrayList) {
                return ((ArrayList)element).toArray();
            }
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public boolean isDeleted(Object element) {
            return false;
        }
    }

    class SelectionListener
    implements ISelectionChangedListener {
        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (selection != null) {
                ProjectPerspectiveChoiceDialog.this.chosenPersp = (IPerspectiveDescriptor)selection.getFirstElement();
            }
        }
    }
}

