/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNatureDescriptor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.ide.Category;
import org.eclipse.ui.internal.ide.registry.Capability;
import org.eclipse.ui.internal.ide.registry.CapabilityRegistryReader;
import org.eclipse.ui.model.WorkbenchAdapter;

public class CapabilityRegistry
extends WorkbenchAdapter
implements IAdaptable {
    private static final String[] EMPTY_ID_LIST = new String[0];
    private static final Capability[] EMPTY_CAP_LIST = new Capability[0];
    private HashMap natureToCapability;
    private ArrayList capabilities = new ArrayList(30);
    private ArrayList categories = new ArrayList(15);
    private Category miscCategory;
    static /* synthetic */ Class class$0;

    boolean addCapability(Capability capability) {
        return this.capabilities.add(capability);
    }

    boolean addCategory(Category category) {
        return this.categories.add(category);
    }

    public Capability findCapability(String id) {
        Iterator iterator = this.capabilities.iterator();
        while (iterator.hasNext()) {
            Capability cap = (Capability)((Object)iterator.next());
            if (!id.equals(cap.getId())) continue;
            return cap;
        }
        return null;
    }

    public Category findCategory(String id) {
        Iterator iterator = this.categories.iterator();
        while (iterator.hasNext()) {
            Category cat = (Category)((Object)iterator.next());
            if (!id.equals(cat.getRootPath())) continue;
            return cat;
        }
        return null;
    }

    public Capability[] findCapabilities(String[] ids) {
        int count = this.capabilities.size();
        Capability[] results = new Capability[ids.length];
        int i = 0;
        while (i < ids.length) {
            String id = ids[i];
            int j = 0;
            while (j < count) {
                Capability cap = (Capability)((Object)this.capabilities.get(j));
                if (cap.getId().equals(id)) {
                    results[i] = cap;
                    break;
                }
                ++j;
            }
            ++i;
        }
        return results;
    }

    public Category[] findCategories(String[] ids) {
        int count = this.categories.size();
        Category[] results = new Category[ids.length];
        int i = 0;
        while (i < ids.length) {
            String id = ids[i];
            int j = 0;
            while (j < count) {
                Category cat = (Category)((Object)this.categories.get(j));
                if (cat.getId().equals(id)) {
                    results[i] = cat;
                    break;
                }
                ++j;
            }
            ++i;
        }
        return results;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this;
        }
        return null;
    }

    public ArrayList getUsedCategories() {
        ArrayList<Category> results = new ArrayList<Category>(this.categories.size());
        Iterator iterator = this.categories.iterator();
        while (iterator.hasNext()) {
            Category cat = (Category)((Object)iterator.next());
            if (!cat.hasElements()) continue;
            results.add(cat);
        }
        return results;
    }

    public Capability getCapabilityForNature(String natureId) {
        return (Capability)((Object)this.natureToCapability.get(natureId));
    }

    public ArrayList getCapabilities() {
        return this.capabilities;
    }

    public Object[] getChildren(Object o) {
        return this.capabilities.toArray();
    }

    public String[] getMembershipSetIds(Capability capability) {
        IProjectNatureDescriptor desc = capability.getNatureDescriptor();
        if (desc == null) {
            return EMPTY_ID_LIST;
        }
        return desc.getNatureSetIds();
    }

    public Category getMiscCategory() {
        return this.miscCategory;
    }

    public String[] getPrerequisiteIds(Capability capability) {
        IProjectNatureDescriptor desc = capability.getNatureDescriptor();
        if (desc == null) {
            return EMPTY_ID_LIST;
        }
        String[] natureIds = desc.getRequiredNatureIds();
        if (natureIds.length == 0) {
            return EMPTY_ID_LIST;
        }
        ArrayList<String> results = new ArrayList<String>(natureIds.length);
        int i = 0;
        while (i < natureIds.length) {
            Capability cap = (Capability)((Object)this.natureToCapability.get(natureIds[i]));
            if (cap != null) {
                results.add(cap.getId());
            }
            ++i;
        }
        if (results.size() == 0) {
            return EMPTY_ID_LIST;
        }
        String[] ids = new String[results.size()];
        results.toArray(ids);
        return ids;
    }

    public Capability[] getProjectCapabilities(IProject project) {
        try {
            String[] natureIds = project.getDescription().getNatureIds();
            ArrayList<Capability> results = new ArrayList<Capability>(natureIds.length);
            int i = 0;
            while (i < natureIds.length) {
                Capability cap = (Capability)((Object)this.natureToCapability.get(natureIds[i]));
                if (cap == null) {
                    cap = new Capability(natureIds[i]);
                    this.mapCapability(cap);
                }
                results.add(cap);
                ++i;
            }
            if (results.size() == 0) {
                return EMPTY_CAP_LIST;
            }
            Capability[] caps = new Capability[results.size()];
            results.toArray(caps);
            return caps;
        }
        catch (CoreException coreException) {
            return EMPTY_CAP_LIST;
        }
    }

    public Capability[] getProjectDisabledCapabilities(IProject project) {
        try {
            String[] natureIds = project.getDescription().getNatureIds();
            ArrayList<Capability> results = new ArrayList<Capability>(natureIds.length);
            int i = 0;
            while (i < natureIds.length) {
                if (!project.isNatureEnabled(natureIds[i])) {
                    Capability cap = (Capability)((Object)this.natureToCapability.get(natureIds[i]));
                    if (cap == null) {
                        cap = new Capability(natureIds[i]);
                        this.mapCapability(cap);
                    }
                    results.add(cap);
                }
                ++i;
            }
            if (results.size() == 0) {
                return EMPTY_CAP_LIST;
            }
            Capability[] caps = new Capability[results.size()];
            results.toArray(caps);
            return caps;
        }
        catch (CoreException coreException) {
            return EMPTY_CAP_LIST;
        }
    }

    public boolean hasCapabilities() {
        return !this.capabilities.isEmpty();
    }

    public boolean hasPrerequisites(Capability capability) {
        return this.getPrerequisiteIds(capability).length > 0;
    }

    public void load() {
        CapabilityRegistryReader reader = new CapabilityRegistryReader();
        reader.read(Platform.getPluginRegistry(), this);
        this.mapCapabilities();
    }

    void mapCapabilities() {
        this.natureToCapability = new HashMap();
        Iterator iterator = this.capabilities.iterator();
        while (iterator.hasNext()) {
            this.mapCapability((Capability)((Object)iterator.next()));
        }
    }

    private void mapCapability(Capability cap) {
        if (!cap.isValid()) {
            if (this.miscCategory == null) {
                this.miscCategory = new Category();
            }
            this.miscCategory.addElement((Object)cap);
        } else {
            Category cat = null;
            String catPath = cap.getCategoryPath();
            if (catPath != null) {
                cat = this.findCategory(catPath);
            }
            if (cat != null) {
                cat.addElement((Object)cap);
            } else {
                if (this.miscCategory == null) {
                    this.miscCategory = new Category();
                }
                this.miscCategory.addElement((Object)cap);
            }
        }
        this.natureToCapability.put(cap.getNatureId(), cap);
    }

    public Capability[] pruneCapabilities(Capability[] capabilities) {
        ArrayList<String> ids = new ArrayList<String>(capabilities.length);
        int i = 0;
        while (i < capabilities.length) {
            ids.add(capabilities[i].getId());
            ++i;
        }
        i = 0;
        while (i < capabilities.length) {
            ArrayList handleIds = capabilities[i].getHandleUIs();
            if (handleIds != null) {
                ids.removeAll(handleIds);
            }
            ++i;
        }
        String[] results = new String[ids.size()];
        ids.toArray(results);
        return this.findCapabilities(results);
    }

    public IStatus validateCapabilities(Capability[] capabilities) {
        String[] natures = new String[capabilities.length];
        int i = 0;
        while (i < capabilities.length) {
            natures[i] = capabilities[i].getNatureId();
            ++i;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus status = workspace.validateNatureSet(natures);
        if (status.isOK()) {
            natures = workspace.sortNatureSet(natures);
            int i2 = 0;
            while (i2 < natures.length) {
                capabilities[i2] = (Capability)((Object)this.natureToCapability.get(natures[i2]));
                ++i2;
            }
        }
        return status;
    }
}

