/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.commons.io;

import java.io.IOException;
import java.io.InputStream;
import org.jpn.xucker.commons.io.LineSeparatorCountInputStream;

public class WordCountInputStream
extends LineSeparatorCountInputStream {
    private int word;

    public int getCountWord() {
        return this.word;
    }

    public int getCountLineSeparator() {
        return this.getR() + this.getN() + this.getRn();
    }

    public WordCountInputStream(InputStream input) {
        super(input);
    }

    public int read() throws IOException {
        int ret = -1;
        if (this.datas != null) {
            ret = this.datas.charAt(0);
            this.datas = this.datas.substring(1);
            if (this.datas.length() == 0) {
                this.datas = null;
            }
        } else {
            this.datas = this.lineRead();
            this.countWord(this.datas);
            if (this.datas != null) {
                return this.read();
            }
        }
        return ret;
    }

    private void countWord(String line) {
        int start = 0;
        int end = 0;
        if (line != null) {
            int i = 0;
            while (i < line.length()) {
                if (this.isWord(line.charAt(i))) {
                    end = i + 1;
                } else {
                    if (end - start > 0) {
                        this.parseWord(line.substring(start, end));
                    }
                    this.parseNotWord(line.charAt(i));
                    start = i;
                    end = i;
                }
                ++i;
            }
            if (start != end) {
                this.parseWord(line.substring(start, end));
            }
        }
    }

    private void parseNotWord(char c) {
    }

    private void parseWord(String string) {
        ++this.word;
    }

    private boolean isWord(char c) {
        return Character.isDigit(c) || this.isAZ(c) || c == '-' || c == '_';
    }

    private boolean isAZ(char c) {
        char num = c;
        return num >= 'A' && num <= 'Z' || num >= 'a' && num <= 'z';
    }
}

