/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.util.List;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;

public class Polyline
extends Shape {
    PointList points = new PointList();
    private static final int TOLERANCE = 2;
    private static final Rectangle LINEBOUNDS = Rectangle.SINGLETON;

    public Polyline() {
        this.bounds = null;
    }

    public void addPoint(Point pt) {
        this.points.addPoint(pt);
        this.bounds = null;
        this.repaint();
    }

    public boolean containsPoint(int x, int y) {
        int tolerance = this.lineWidth / 2 + 2;
        LINEBOUNDS.setBounds(this.getBounds());
        LINEBOUNDS.expand(tolerance, tolerance);
        if (!LINEBOUNDS.contains(x, y)) {
            return false;
        }
        int[] ints = this.points.toIntArray();
        int index = 0;
        while (index < ints.length - 3) {
            if (this.lineContainsPoint(ints[index], ints[index + 1], ints[index + 2], ints[index + 3], x, y, tolerance)) {
                return true;
            }
            index += 2;
        }
        List children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            if (((IFigure)children.get(i)).containsPoint(x, y)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean lineContainsPoint(int x1, int y1, int x2, int y2, int px, int py, int tolerance) {
        LINEBOUNDS.setSize(0, 0);
        LINEBOUNDS.setLocation(x1, y1);
        LINEBOUNDS.union(x2, y2);
        LINEBOUNDS.expand(tolerance, tolerance);
        if (!LINEBOUNDS.contains(px, py)) {
            return false;
        }
        int result = 0;
        if (x1 != x2 && y1 != y2) {
            int v1x = x2 - x1;
            int v1y = y2 - y1;
            int v2x = px - x1;
            int v2y = py - y1;
            int numerator = v2x * v1y - v1x * v2y;
            int denominator = v1x * v1x + v1y * v1y;
            result = (int)((long)numerator * (long)numerator / (long)denominator);
        }
        return result <= tolerance * tolerance;
    }

    protected void fillShape(Graphics g) {
    }

    public Rectangle getBounds() {
        if (this.bounds == null) {
            this.bounds = this.getPoints().getBounds().getExpanded(this.lineWidth / 2, this.lineWidth / 2);
        }
        return this.bounds;
    }

    public Point getEnd() {
        return this.points.getLastPoint();
    }

    public PointList getPoints() {
        return this.points;
    }

    public Point getStart() {
        return this.points.getFirstPoint();
    }

    public void insertPoint(Point pt, int index) {
        this.bounds = null;
        this.points.insertPoint(pt, index);
        this.repaint();
    }

    public boolean isOpaque() {
        return false;
    }

    protected void outlineShape(Graphics g) {
        g.drawPolyline(this.points);
    }

    public void primTranslate(int x, int y) {
    }

    public void removeAllPoints() {
        this.erase();
        this.bounds = null;
        this.points.removeAllPoints();
    }

    public void removePoint(int index) {
        this.erase();
        this.bounds = null;
        this.points.removePoint(index);
    }

    public void setEnd(Point end) {
        if (this.points.size() < 2) {
            this.addPoint(end);
        } else {
            this.setPoint(end, this.points.size() - 1);
        }
    }

    public void setEndpoints(Point start, Point end) {
        this.setStart(start);
        this.setEnd(end);
    }

    public void setLineWidth(int w) {
        if (this.lineWidth == w) {
            return;
        }
        if (w < this.lineWidth) {
            this.erase();
        }
        this.bounds = null;
        super.setLineWidth(w);
    }

    public void setPoint(Point pt, int index) {
        this.erase();
        this.points.setPoint(pt, index);
        this.bounds = null;
        this.repaint();
    }

    public void setPoints(PointList points) {
        this.erase();
        this.points = points;
        this.bounds = null;
        this.firePropertyChange("points", null, points);
        this.repaint();
    }

    public void setStart(Point start) {
        if (this.points.size() == 0) {
            this.addPoint(start);
        } else {
            this.setPoint(start, 0);
        }
    }

    protected boolean useLocalCoordinates() {
        return false;
    }
}

