/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.PerspectiveDescriptor;
import org.eclipse.ui.internal.registry.PerspectiveRegistryReader;
import org.eclipse.ui.internal.registry.RegistryManager;
import org.eclipse.ui.internal.util.PrefUtil;

public class PerspectiveRegistry
extends RegistryManager
implements IPerspectiveRegistry,
IRegistryChangeListener {
    private String defaultPerspID;
    private static final String EXT = "_persp.xml";
    private static final String ID_DEF_PERSP = "PerspectiveRegistry.DEFAULT_PERSP";
    private static final String PERSP = "_persp";
    private static final String TAG_LAYOUT = "perspective";
    protected static final String TAG_DESCRIPTION = "description";
    private static final char SPACE_DELIMITER = ' ';
    private ArrayList perspToRemove = new ArrayList(5);

    public PerspectiveRegistry() {
        super(WorkbenchPlugin.PI_WORKBENCH, "perspectives");
        Platform.getExtensionRegistry().addRegistryChangeListener((IRegistryChangeListener)this);
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        store.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().endsWith(PerspectiveRegistry.PERSP)) {
                    this.mergePerspectives(event);
                } else if (event.getProperty().equals("perspectives")) {
                    this.updatePreferenceList((IPreferenceStore)event.getSource());
                }
            }

            private void mergePerspectives(PropertyChangeEvent event) {
                String id;
                IPreferenceStore store = (IPreferenceStore)event.getSource();
                if (event.getNewValue() == null) {
                    IPerspectiveDescriptor[] perspectiveList = PerspectiveRegistry.this.getPerspectives();
                    int i = 0;
                    while (i < perspectiveList.length) {
                        String id2 = perspectiveList[i].getId();
                        if (event.getProperty().startsWith(id2)) {
                            if (!PerspectiveRegistry.this.perspToRemove.contains(id2)) {
                                store.setValue(String.valueOf(id2) + PerspectiveRegistry.PERSP, (String)event.getOldValue());
                            } else {
                                PerspectiveRegistry.this.perspToRemove.remove(id2);
                            }
                        }
                        ++i;
                    }
                } else if ((event.getOldValue() == null || event.getOldValue().equals("")) && PerspectiveRegistry.this.findPerspectiveWithId(id = event.getProperty().substring(0, event.getProperty().lastIndexOf(PerspectiveRegistry.PERSP))) == null) {
                    PerspectiveDescriptor desc = new PerspectiveDescriptor(null, null, null);
                    StringReader reader = new StringReader((String)event.getNewValue());
                    try {
                        XMLMemento memento = XMLMemento.createReadRoot(reader);
                        desc.restoreState(memento);
                        PerspectiveRegistry.this.add(desc, desc.getPluginId());
                    }
                    catch (WorkbenchException e) {
                        PerspectiveRegistry.this.unableToLoadPerspective(e.getStatus());
                    }
                }
                this.updatePreferenceList(store);
            }

            private void updatePreferenceList(IPreferenceStore store) {
                IPerspectiveDescriptor[] perspectiveList = PerspectiveRegistry.this.getPerspectives();
                StringBuffer perspBuffer = new StringBuffer();
                int i = 0;
                while (i < perspectiveList.length) {
                    PerspectiveDescriptor desc = (PerspectiveDescriptor)perspectiveList[i];
                    if (PerspectiveRegistry.this.hasCustomDefinition(desc)) {
                        perspBuffer.append(desc.getId()).append(' ');
                    }
                    ++i;
                }
                String newList = perspBuffer.toString().trim();
                store.setValue("perspectives", newList);
            }
        });
    }

    public void addPerspective(PerspectiveDescriptor desc) {
        if (desc == null) {
            return;
        }
        this.add(desc, desc.getPluginId());
    }

    public PerspectiveDescriptor createPerspective(String label, PerspectiveDescriptor originalDescriptor) {
        if (!this.validateLabel(label)) {
            return null;
        }
        String id = label.replace(' ', '_');
        id = id.trim();
        PerspectiveDescriptor desc = new PerspectiveDescriptor(id, label, originalDescriptor);
        this.add(desc, desc.getPluginId());
        return desc;
    }

    public void revertPerspectives(ArrayList perspToRevert) {
        int i = 0;
        while (i < perspToRevert.size()) {
            PerspectiveDescriptor desc = (PerspectiveDescriptor)perspToRevert.get(i);
            this.perspToRemove.add(desc.getId());
            desc.revertToPredefined();
            ++i;
        }
    }

    public void deletePerspectives(ArrayList perspToDelete) {
        int i = 0;
        while (i < perspToDelete.size()) {
            this.deletePerspective((IPerspectiveDescriptor)perspToDelete.get(i));
            ++i;
        }
    }

    public void deletePerspective(IPerspectiveDescriptor in) {
        PerspectiveDescriptor desc = (PerspectiveDescriptor)in;
        if (!desc.isPredefined()) {
            this.perspToRemove.add(desc.getId());
            this.remove(desc.getPluginId(), desc);
            desc.deleteCustomDefinition();
            this.verifyDefaultPerspective();
            this.cleanRegistry();
        }
    }

    void deleteCustomDefinition(PerspectiveDescriptor desc) {
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        store.setToDefault(String.valueOf(desc.getId()) + PERSP);
    }

    boolean hasCustomDefinition(PerspectiveDescriptor desc) {
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        return store.contains(String.valueOf(desc.getId()) + PERSP);
    }

    public IPerspectiveDescriptor findPerspectiveWithId(String id) {
        Object[] allDescriptors = this.getRegistryObjects();
        if (allDescriptors == null) {
            return null;
        }
        int i = 0;
        while (i < allDescriptors.length) {
            IPerspectiveDescriptor desc = (IPerspectiveDescriptor)allDescriptors[i];
            if (desc.getId().equals(id)) {
                return desc;
            }
            ++i;
        }
        return null;
    }

    public IPerspectiveDescriptor findPerspectiveWithLabel(String label) {
        Object[] allDescriptors = this.getRegistryObjects();
        if (allDescriptors == null) {
            return null;
        }
        int i = 0;
        while (i < allDescriptors.length) {
            IPerspectiveDescriptor desc = (IPerspectiveDescriptor)allDescriptors[i];
            if (desc.getLabel().equals(label)) {
                return desc;
            }
            ++i;
        }
        return null;
    }

    public String getDefaultPerspective() {
        return this.defaultPerspID;
    }

    public IPerspectiveDescriptor[] getPerspectives() {
        Object[] midArray = this.getRegistryObjects();
        if (midArray == null || midArray.length == 0) {
            return null;
        }
        IPerspectiveDescriptor[] retArray = new IPerspectiveDescriptor[midArray.length];
        int i = 0;
        while (i < midArray.length) {
            retArray[i] = (IPerspectiveDescriptor)midArray[i];
            ++i;
        }
        return retArray;
    }

    public void load() {
        this.loadPredefined();
        this.loadCustom();
        IDialogSettings dialogSettings = WorkbenchPlugin.getDefault().getDialogSettings();
        String str = dialogSettings.get(ID_DEF_PERSP);
        if (str != null && str.length() > 0) {
            this.setDefaultPerspective(str);
            dialogSettings.put(ID_DEF_PERSP, "");
        } else {
            this.defaultPerspID = PrefUtil.getAPIPreferenceStore().getString("defaultPerspectiveId");
        }
        this.verifyDefaultPerspective();
    }

    private void loadCustom() {
        Reader reader = null;
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        String customPerspectives = store.getString("perspectives");
        String[] perspectivesList = StringConverter.asArray((String)customPerspectives);
        int i = 0;
        while (i < perspectivesList.length) {
            try {
                String xmlString = store.getString(String.valueOf(perspectivesList[i]) + PERSP);
                if (xmlString != null && xmlString.length() != 0) {
                    reader = new StringReader(xmlString);
                }
                XMLMemento memento = XMLMemento.createReadRoot(reader);
                PerspectiveDescriptor newPersp = new PerspectiveDescriptor(null, null, null);
                newPersp.restoreState(memento);
                String id = newPersp.getId();
                IPerspectiveDescriptor oldPersp = this.findPerspectiveWithId(id);
                if (oldPersp == null) {
                    this.add(newPersp, newPersp.getPluginId());
                }
                reader.close();
            }
            catch (IOException iOException) {
                this.unableToLoadPerspective(null);
            }
            catch (WorkbenchException e) {
                this.unableToLoadPerspective(e.getStatus());
            }
            ++i;
        }
        IPath path = WorkbenchPlugin.getDefault().getStateLocation();
        File folder = path.toFile();
        if (folder.isDirectory()) {
            File[] fileList = folder.listFiles();
            int nSize = fileList.length;
            int nX = 0;
            while (nX < nSize) {
                File file = fileList[nX];
                if (file.getName().endsWith(EXT)) {
                    FileInputStream stream = null;
                    try {
                        stream = new FileInputStream(file);
                        reader = new BufferedReader(new InputStreamReader((InputStream)stream, "utf-8"));
                        XMLMemento memento = XMLMemento.createReadRoot(reader);
                        PerspectiveDescriptor newPersp = new PerspectiveDescriptor(null, null, null);
                        newPersp.restoreState(memento);
                        IPerspectiveDescriptor oldPersp = this.findPerspectiveWithId(newPersp.getId());
                        if (oldPersp == null) {
                            this.add(newPersp, newPersp.getPluginId());
                        }
                        this.saveCustomPersp(newPersp, memento);
                        file.delete();
                        reader.close();
                        ((InputStream)stream).close();
                    }
                    catch (IOException iOException) {
                        this.unableToLoadPerspective(null);
                    }
                    catch (WorkbenchException e) {
                        this.unableToLoadPerspective(e.getStatus());
                    }
                }
                ++nX;
            }
        }
    }

    private void unableToLoadPerspective(IStatus status) {
        String title = WorkbenchMessages.getString("Perspective.problemLoadingTitle");
        String msg = WorkbenchMessages.getString("Perspective.errorLoadingState");
        if (status == null) {
            MessageDialog.openError(null, (String)title, (String)msg);
        } else {
            ErrorDialog.openError(null, (String)title, (String)msg, (IStatus)status);
        }
    }

    public void saveCustomPersp(PerspectiveDescriptor realDesc, XMLMemento memento) throws IOException {
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        StringWriter writer = new StringWriter();
        memento.save(writer);
        ((Writer)writer).close();
        store.setValue(String.valueOf(realDesc.getId()) + PERSP, ((Object)writer).toString());
    }

    public IMemento getCustomPersp(String id) throws WorkbenchException, IOException {
        Reader reader = null;
        IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
        String xmlString = store.getString(String.valueOf(id) + PERSP);
        if (xmlString != null && xmlString.length() != 0) {
            reader = new StringReader(xmlString);
        }
        XMLMemento memento = XMLMemento.createReadRoot(reader);
        reader.close();
        return memento;
    }

    private void loadPredefined() {
        PerspectiveRegistryReader reader = new PerspectiveRegistryReader();
        reader.readPerspectives(Platform.getExtensionRegistry(), this);
    }

    public void setDefaultPerspective(String id) {
        IPerspectiveDescriptor desc = this.findPerspectiveWithId(id);
        if (desc != null) {
            this.defaultPerspID = id;
            PrefUtil.getAPIPreferenceStore().setValue("defaultPerspectiveId", id);
        }
    }

    public boolean validateLabel(String label) {
        return (label = label.trim()).length() > 0;
    }

    private void verifyDefaultPerspective() {
        IPerspectiveDescriptor desc = null;
        if (this.defaultPerspID != null) {
            desc = this.findPerspectiveWithId(this.defaultPerspID);
        }
        if (desc != null) {
            return;
        }
        this.defaultPerspID = PrefUtil.getAPIPreferenceStore().getString("defaultPerspectiveId");
        if (this.defaultPerspID != null) {
            desc = this.findPerspectiveWithId(this.defaultPerspID);
        }
        if (desc != null) {
            return;
        }
        this.defaultPerspID = Workbench.getInstance().getDefaultPerspectiveId();
    }

    public IPerspectiveDescriptor clonePerspective(String id, String label, IPerspectiveDescriptor originalDescriptor) {
        if (label == null || label.trim().length() <= 0) {
            throw new IllegalArgumentException();
        }
        IPerspectiveDescriptor desc = this.findPerspectiveWithId(id);
        if (desc != null) {
            throw new IllegalArgumentException();
        }
        desc = new PerspectiveDescriptor(id, label, (PerspectiveDescriptor)originalDescriptor);
        this.add(desc, ((PerspectiveDescriptor)desc).getPluginId());
        return desc;
    }

    public void revertPerspective(IPerspectiveDescriptor perspToRevert) {
        PerspectiveDescriptor desc = (PerspectiveDescriptor)perspToRevert;
        this.perspToRemove.add(desc.getId());
        desc.revertToPredefined();
    }

    public Object buildNewCacheObject(IExtensionDelta delta) {
        IExtension extension = delta.getExtension();
        if (extension == null) {
            return null;
        }
        IConfigurationElement[] elements = extension.getConfigurationElements();
        IPerspectiveDescriptor desc = null;
        int i = 0;
        while (i < elements.length) {
            String id = elements[i].getAttribute("id");
            if (id != null && (desc = this.findPerspectiveWithId(id)) == null && elements[i].getName().equals(TAG_LAYOUT)) {
                try {
                    IConfigurationElement[] children = elements[i].getChildren(TAG_DESCRIPTION);
                    String descText = children.length >= 1 ? children[0].getValue() : "";
                    desc = new PerspectiveDescriptor(elements[i], descText);
                }
                catch (CoreException e) {
                    WorkbenchPlugin.log("Unable to create layout descriptor.", e.getStatus());
                }
            }
            ++i;
        }
        return desc;
    }

    public void postChangeProcessing() {
    }

    public void dispose() {
        Platform.getExtensionRegistry().removeRegistryChangeListener((IRegistryChangeListener)this);
    }
}

