/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.views;

import java.util.ArrayList;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.cheatsheets.AbstractItemExtensionElement;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.cheatsheets.CheatSheetPlugin;
import org.eclipse.ui.internal.cheatsheets.CheatSheetStopWatch;
import org.eclipse.ui.internal.cheatsheets.data.Item;
import org.eclipse.ui.internal.cheatsheets.views.CheatSheetViewer;

public abstract class ViewItem {
    public static final byte VIEWITEM_ADVANCE = 0;
    public static final byte VIEWITEM_DONOT_ADVANCE = 1;
    private Composite bodyComp;
    protected FormText bodyText;
    protected Composite bodyWrapperComposite;
    protected Composite buttonComposite;
    private boolean buttonExpanded = true;
    private Label checkDoneLabel;
    private boolean completed = false;
    protected Item item;
    protected final RGB activeRGB = new RGB(232, 242, 254);
    protected Color activeColor;
    protected final RGB alternateRGB = new RGB(244, 244, 244);
    protected Color alternateColor;
    protected Color itemColor;
    protected Color white;
    private boolean isSkipped = false;
    private ExpandableComposite mainItemComposite;
    private Composite parent;
    protected CheatSheetViewer viewer;
    private Composite titleComposite;
    protected FormToolkit toolkit;
    protected ScrolledForm form;
    private boolean bold = true;
    private Font boldFont;
    private Font regularFont;
    private boolean initialized = false;

    public ViewItem(FormToolkit toolkit, ScrolledForm form, Item item, Color itemColor, CheatSheetViewer viewer) {
        this.toolkit = toolkit;
        this.form = form;
        this.parent = form.getBody();
        this.item = item;
        this.itemColor = itemColor;
        this.viewer = viewer;
        this.activeColor = new Color((Device)this.parent.getDisplay(), this.activeRGB);
        this.alternateColor = new Color((Device)this.parent.getDisplay(), this.alternateRGB);
        this.addItem();
    }

    private void addItem() {
        Color bg;
        CheatSheetStopWatch.startStopWatch("ViewItem.addItem()");
        Display display = this.parent.getDisplay();
        this.white = bg = JFaceColors.getBannerBackground((Display)display);
        CheatSheetStopWatch.printLapTime("ViewItem.addItem()", "Time in addItem() after getBannerBackground: ");
        this.checkDoneLabel = this.toolkit.createLabel(this.parent, " ");
        this.checkDoneLabel.setBackground(this.white);
        CheatSheetStopWatch.printLapTime("ViewItem.addItem()", "Time in addItem() after create checkDoneLabel: ");
        this.mainItemComposite = this.toolkit.createExpandableComposite(this.parent, 4);
        this.mainItemComposite.setBackground(this.itemColor);
        this.mainItemComposite.setLayoutData((Object)new TableWrapData(256));
        String title = this.item.getTitle();
        if (title != null) {
            this.mainItemComposite.setText(title);
        }
        CheatSheetStopWatch.printLapTime("ViewItem.addItem()", "Time in addItem() after create mainItemComposite: ");
        this.mainItemComposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                ViewItem.this.form.reflow(true);
            }
        });
        CheatSheetStopWatch.printLapTime("ViewItem.addItem()", "Time in addItem() after addExpansionListener: ");
        int number = 0;
        ArrayList itemExts = this.item.getItemExtensions();
        if (itemExts != null && itemExts.size() > 0 || this.item.getContextId() != null || this.item.getHref() != null) {
            this.titleComposite = this.toolkit.createComposite((Composite)this.mainItemComposite);
            this.titleComposite.setBackground(this.itemColor);
        }
        if (itemExts != null) {
            int g = 0;
            while (g < itemExts.size()) {
                AbstractItemExtensionElement[] eea = (AbstractItemExtensionElement[])itemExts.get(g);
                number += eea.length;
                int x = 0;
                while (x < eea.length) {
                    eea[x].createControl(this.titleComposite);
                    ++x;
                }
                ++g;
            }
        }
        CheatSheetStopWatch.printLapTime("ViewItem.addItem()", "Time in addItem() after create item extensions: ");
        if (this.item.getContextId() != null || this.item.getHref() != null) {
            ++number;
            ImageHyperlink helpButton = this.createButton(this.titleComposite, CheatSheetPlugin.getPlugin().getImage("CHEATSHEET_ITEM_HELP"), this, this.itemColor, CheatSheetPlugin.getResourceString("%HELP_BUTTON_TOOLTIP"));
            this.toolkit.adapt((Control)helpButton, true, true);
            helpButton.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    if (ViewItem.this.item.getContextId() != null) {
                        ViewItem.this.openInfopop(e.widget);
                    } else {
                        ViewItem.this.openHelpTopic();
                    }
                }
            });
        }
        CheatSheetStopWatch.printLapTime("ViewItem.addItem()", "Time in addItem() after create help button: ");
        if (number > 0) {
            this.mainItemComposite.setTextClient((Control)this.titleComposite);
            GridLayout layout = new GridLayout(number, false);
            GridData data = new GridData(1808);
            this.titleComposite.setLayout((Layout)layout);
            this.titleComposite.setLayoutData((Object)data);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.verticalSpacing = 0;
        }
        CheatSheetStopWatch.printLapTime("ViewItem.addItem()", "Time in addItem() after setTextClient: ");
        this.bodyWrapperComposite = this.toolkit.createComposite((Composite)this.mainItemComposite);
        this.mainItemComposite.setClient((Control)this.bodyWrapperComposite);
        TableWrapLayout wrapperLayout = new TableWrapLayout();
        this.bodyWrapperComposite.setLayout((Layout)wrapperLayout);
        this.bodyWrapperComposite.setBackground(this.itemColor);
        CheatSheetStopWatch.printLapTime("ViewItem.addItem()", "Time in addItem() after create bodyWrapperComposite: ");
        this.bodyText = this.toolkit.createFormText(this.bodyWrapperComposite, false);
        this.bodyText.setText(this.item.getDescription(), this.item.getDescription().startsWith("<form><p>"), false);
        this.bodyText.setBackground(this.itemColor);
        this.bodyText.setLayoutData((Object)new TableWrapData(256));
        CheatSheetStopWatch.printLapTime("ViewItem.addItem()", "Time in addItem() after create FormText: ");
        if (!this.item.isDynamic()) {
            this.handleButtons();
        }
        CheatSheetStopWatch.printLapTime("ViewItem.addItem()", "Time in addItem() after handleButtons(): ");
        this.setButtonsCollapsed();
        this.setCollapsed();
        CheatSheetStopWatch.printLapTime("ViewItem.addItem()", "Time in addItem() after setting buttons and item collapsed: ");
        this.boldFont = this.mainItemComposite.getFont();
        FontData[] fontDatas = this.boldFont.getFontData();
        int i = 0;
        while (i < fontDatas.length) {
            fontDatas[i].setStyle(fontDatas[i].getStyle() ^ 1);
            ++i;
        }
        this.regularFont = new Font((Device)this.mainItemComposite.getDisplay(), fontDatas);
        CheatSheetStopWatch.printLapTime("ViewItem.addItem()", "Time in addItem() after font initlization: ");
        this.setBold(false);
        CheatSheetStopWatch.printLapTime("ViewItem.addItem()", "Time in addItem() after setBold: ");
    }

    protected ImageHyperlink createButton(Composite parent, Image image, ViewItem item, Color color, String toolTipText) {
        ImageHyperlink button = new ImageHyperlink(parent, 0);
        this.toolkit.adapt((Control)button, true, true);
        button.setImage(image);
        button.setData((Object)item);
        button.setBackground(color);
        button.setToolTipText(toolTipText);
        return button;
    }

    public void dispose() {
        ArrayList itemExts;
        if (this.alternateColor != null) {
            this.alternateColor.dispose();
        }
        if (this.activeColor != null) {
            this.activeColor.dispose();
        }
        if (this.checkDoneLabel != null) {
            this.checkDoneLabel.dispose();
        }
        if (this.bodyText != null) {
            this.bodyText.dispose();
        }
        if (this.buttonComposite != null) {
            this.buttonComposite.dispose();
        }
        if (this.bodyComp != null) {
            this.bodyComp.dispose();
        }
        if (this.bodyWrapperComposite != null) {
            this.bodyWrapperComposite.dispose();
        }
        if (this.mainItemComposite != null) {
            this.mainItemComposite.dispose();
        }
        if (this.white != null) {
            this.white.dispose();
        }
        if (this.titleComposite != null) {
            this.titleComposite.dispose();
        }
        if (this.regularFont != null) {
            this.regularFont.dispose();
        }
        if ((itemExts = this.item.getItemExtensions()) != null) {
            int g = 0;
            while (g < itemExts.size()) {
                AbstractItemExtensionElement[] eea = (AbstractItemExtensionElement[])itemExts.get(g);
                int x = 0;
                while (x < eea.length) {
                    eea[x].dispose();
                    ++x;
                }
                ++g;
            }
        }
    }

    Image getCompleteImage() {
        return CheatSheetPlugin.getPlugin().getImage("CHEATSHEET_ITEM_COMPLETE");
    }

    public Item getItem() {
        return this.item;
    }

    Composite getMainItemComposite() {
        return this.mainItemComposite;
    }

    Image getSkipImage() {
        return CheatSheetPlugin.getPlugin().getImage("CHEATSHEET_ITEM_SKIP");
    }

    abstract void handleButtons();

    boolean isBold() {
        return this.bold;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public boolean isExpanded() {
        return this.mainItemComposite.isExpanded();
    }

    boolean isSkipped() {
        return this.isSkipped;
    }

    private void openHelpTopic() {
        if (this.item == null || this.item.getHref() == null) {
            return;
        }
        WorkbenchHelp.displayHelpResource((String)this.item.getHref());
    }

    private void openInfopop(Widget widget) {
        if (this.item == null || this.item.getContextId() == null) {
            return;
        }
        IContext context = HelpSystem.getContext((String)this.item.getContextId());
        if (context != null) {
            Point point = widget.getDisplay().getCursorLocation();
            point = new Point(point.x + 15, point.y);
            WorkbenchHelp.displayContext((IContext)context, (int)point.x, (int)point.y);
        }
    }

    void setAsCurrentActiveItem() {
        this.setColorAsCurrent(true);
        if (!this.buttonExpanded) {
            this.setButtonsExpanded();
        }
        this.setExpanded();
        this.setBold(true);
        this.mainItemComposite.setFocus();
    }

    void setAsNormalCollapsed() {
        this.setBold(false);
        this.setColorAsCurrent(false);
        if (this.mainItemComposite.isExpanded()) {
            this.setCollapsed();
        }
    }

    void setAsNormalNonCollapsed() {
        this.setColorAsCurrent(false);
        this.setBold(false);
    }

    private void setBodyColor(Color color) {
        this.mainItemComposite.setBackground(color);
        this.bodyWrapperComposite.setBackground(color);
        if (this.buttonComposite != null) {
            this.buttonComposite.setBackground(color);
        }
        Control[] bodyChildren = this.bodyWrapperComposite.getChildren();
        int i = 0;
        while (i < bodyChildren.length) {
            bodyChildren[i].setBackground(color);
            ++i;
        }
        if (this.buttonComposite != null) {
            this.buttonComposite.setBackground(color);
            bodyChildren = this.buttonComposite.getChildren();
            i = 0;
            while (i < bodyChildren.length) {
                bodyChildren[i].setBackground(color);
                ++i;
            }
        }
    }

    void setBold(boolean value) {
        if (value) {
            this.mainItemComposite.setFont(this.boldFont);
            if (this.initialized) {
                this.mainItemComposite.layout();
            }
        } else {
            this.mainItemComposite.setFont(this.regularFont);
            if (this.initialized) {
                this.mainItemComposite.layout();
            }
        }
        this.bold = value;
    }

    void setButtonsCollapsed() {
        if (this.buttonComposite != null && this.buttonExpanded) {
            this.buttonComposite.setVisible(false);
            this.buttonExpanded = false;
        }
    }

    void setButtonsExpanded() {
        if (!this.buttonExpanded) {
            this.buttonComposite.setVisible(true);
            this.buttonExpanded = true;
            if (this.initialized) {
                FormToolkit.ensureVisible((Control)this.getMainItemComposite());
            }
        }
    }

    void setCollapsed() {
        if (this.mainItemComposite.isExpanded()) {
            this.mainItemComposite.setExpanded(false);
            if (this.initialized) {
                this.form.reflow(true);
                FormToolkit.ensureVisible((Control)this.getMainItemComposite());
            }
        }
    }

    private void setColorAsCurrent(boolean active) {
        if (active) {
            this.setTitleColor(this.activeColor);
            this.setBodyColor(this.activeColor);
        } else {
            this.setTitleColor(this.itemColor);
            this.setBodyColor(this.itemColor);
        }
    }

    void setComplete() {
        this.completed = true;
        this.checkDoneLabel.setImage(this.getCompleteImage());
        if (this.initialized) {
            this.checkDoneLabel.getParent().layout();
        }
    }

    void setExpanded() {
        if (!this.mainItemComposite.isExpanded()) {
            this.mainItemComposite.setExpanded(true);
            if (this.initialized) {
                this.form.reflow(true);
                FormToolkit.ensureVisible((Control)this.getMainItemComposite());
            }
        }
    }

    void setIncomplete() {
        this.checkDoneLabel.setImage(null);
        this.completed = false;
        this.setStartImage();
    }

    void setItemColor(Color itemColor) {
        this.itemColor = itemColor;
    }

    void setOriginalColor() {
        this.setTitleColor(this.itemColor);
        this.setBodyColor(this.itemColor);
        this.setBold(false);
    }

    abstract void setRestartImage();

    void setSkipped() {
        this.isSkipped = true;
        this.checkDoneLabel.setImage(this.getSkipImage());
        if (this.initialized) {
            this.checkDoneLabel.getParent().layout();
        }
    }

    abstract void setStartImage();

    private void setTitleColor(Color color) {
        if (this.titleComposite != null) {
            this.titleComposite.setBackground(color);
            Control[] titlechildren = this.titleComposite.getChildren();
            int i = 0;
            while (i < titlechildren.length) {
                titlechildren[i].setBackground(color);
                ++i;
            }
        }
    }

    public void initialized() {
        this.initialized = true;
    }
}

