/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.snack;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jpn.xucker.rcp.ui.ProgressMonitor;
import org.jpn.xucker.snack.Formant;
import org.jpn.xucker.snack.FormantParser;
import org.jpn.xucker.snack.Spectrogram;
import org.jpn.xucker.snack.SpectrogramGifConverter;
import org.jpn.xucker.snack.SpectrogramListener;
import org.jpn.xucker.snack.SpectrogramParser;

public class SnackExecuter {
    public static final int ALL_RANGE = 0;
    private String pysnackExecuterDir;
    private Process process;
    public static Log log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.jpn.xucker.snack.SnackExecuter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public SnackExecuter(String dir) {
        this.pysnackExecuterDir = dir;
    }

    public static int getDefaultValue() {
        return -138;
    }

    public void cancel() {
        if (this.process != null) {
            this.process.destroy();
            this.process = null;
        }
    }

    public void createSpectrogramImage(File[] audioFile, String outputDir, int samplerate, int height, double persample, int start, int end, ProgressMonitor monitor, SpectrogramListener listener) throws IOException {
        SpectrogramGifConverter parser = new SpectrogramGifConverter(samplerate, height, persample);
        parser.setProgressMonitor(monitor);
        parser.setSpectrogramListener(listener);
        parser.setExportPath(outputDir);
        int i = 0;
        while (i < audioFile.length) {
            String[] argv = new String[]{this.getExecutePath("spectram.exe"), audioFile[i].getAbsolutePath(), "" + height, "" + persample, "" + start, "" + end};
            log.trace((Object)"start:getSpectoram");
            this.process = Runtime.getRuntime().exec(argv);
            log.trace((Object)"end:getSpectoram");
            if (this.process != null) {
                InputStream input = null;
                if (this.process != null && (input = this.process.getInputStream()) != null) {
                    long starttime = System.currentTimeMillis();
                    log.trace((Object)"start-parse-spectrogram:");
                    parser.parse(input);
                    log.trace((Object)("end-parse-spectrogram:" + (System.currentTimeMillis() - starttime) + "ms"));
                }
            }
            ++i;
        }
    }

    private String getExecutePath(String executeName) {
        String pyPath = this.pysnackExecuterDir;
        if (!pyPath.endsWith(File.separator)) {
            pyPath = String.valueOf(this.pysnackExecuterDir) + File.separator;
        }
        pyPath = String.valueOf(pyPath) + executeName;
        return pyPath;
    }

    public Formant[] getFormants(String path) throws IOException {
        return this.getFormants(path, 0, 0);
    }

    public Formant[] getFormants(String path, int start, int end) throws IOException {
        String[] argv = new String[]{this.getExecutePath("formant.exe"), path, "" + start, "" + end};
        log.trace((Object)("runtime:formant:" + argv[0] + " " + argv[1] + " " + argv[2] + " " + argv[3]));
        this.process = Runtime.getRuntime().exec(argv);
        log.trace((Object)"runtime:formant");
        if (this.process != null) {
            InputStream stream = null;
            SnackExecuter snackExecuter = this;
            synchronized (snackExecuter) {
                if (this.process != null) {
                    stream = this.process.getInputStream();
                }
            }
            if (stream != null) {
                FormantParser parser = new FormantParser();
                return (Formant[])parser.parse(this.process.getInputStream());
            }
        }
        return null;
    }

    public Spectrogram getSpectram(String path, int samplerate, int height, int persample, int start, int end) throws IOException {
        return this.getSpectram(path, samplerate, height, persample, start, end, null);
    }

    public Spectrogram getSpectram(String path, int samplerate, int height, int persample, int start, int end, ProgressMonitor monitor) throws IOException {
        Spectrogram spectrogram = null;
        String pyPath = this.pysnackExecuterDir;
        if (!pyPath.endsWith(File.separator)) {
            pyPath = String.valueOf(this.pysnackExecuterDir) + File.separator;
        }
        pyPath = String.valueOf(pyPath) + "spectram.exe";
        String[] argv = new String[]{pyPath, path, "" + height, "" + persample, "" + start, "" + end};
        log.trace((Object)"start:getSpectoram");
        this.process = Runtime.getRuntime().exec(argv);
        log.trace((Object)"end:getSpectoram");
        if (this.process != null) {
            InputStream input = null;
            SnackExecuter snackExecuter = this;
            synchronized (snackExecuter) {
                if (this.process != null && (input = this.process.getInputStream()) != null) {
                    long starttime = System.currentTimeMillis();
                    log.trace((Object)"start-parse-spectrogram:");
                    SpectrogramParser parser = new SpectrogramParser(samplerate, height, persample);
                    parser.setProgressMonitor(monitor);
                    spectrogram = (Spectrogram)parser.parse(input);
                    log.trace((Object)("end-parse-spectrogram:" + (System.currentTimeMillis() - starttime) + "ms"));
                }
            }
        }
        return spectrogram;
    }
}

