/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.BITMAP;
import org.eclipse.swt.internal.win32.DRAWITEMSTRUCT;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Button
extends Control {
    Image image;
    static final int ButtonProc;
    static final TCHAR ButtonClass;
    static final int CheckWidth;
    static final int CheckHeight;

    static {
        ButtonClass = new TCHAR(0, "BUTTON", true);
        int hBitmap = OS.LoadBitmap(0, 32759);
        if (hBitmap == 0) {
            CheckWidth = OS.GetSystemMetrics(OS.IsWinCE ? 49 : 2);
            CheckHeight = OS.GetSystemMetrics(OS.IsWinCE ? 50 : 20);
        } else {
            BITMAP bitmap = new BITMAP();
            OS.GetObject(hBitmap, 24, bitmap);
            OS.DeleteObject(hBitmap);
            CheckWidth = bitmap.bmWidth / 4;
            CheckHeight = bitmap.bmHeight / 3;
        }
        WNDCLASS lpWndClass = new WNDCLASS();
        OS.GetClassInfo(0, ButtonClass, lpWndClass);
        ButtonProc = lpWndClass.lpfnWndProc;
    }

    public Button(Composite parent, int style) {
        super(parent, Button.checkStyle(style));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    int callWindowProc(int msg, int wParam, int lParam) {
        if (this.handle == 0) {
            return 0;
        }
        return OS.CallWindowProc(ButtonProc, this.handle, msg, wParam, lParam);
    }

    static int checkStyle(int style) {
        if (((style = Widget.checkBits(style, 8, 4, 32, 16, 2, 0)) & 0xA) != 0) {
            return Widget.checkBits(style, 0x1000000, 16384, 131072, 0, 0, 0);
        }
        if ((style & 0x30) != 0) {
            return Widget.checkBits(style, 16384, 131072, 0x1000000, 0, 0, 0);
        }
        if ((style & 4) != 0) {
            return Widget.checkBits(style |= 0x80000, 128, 1024, 16384, 131072, 0, 0);
        }
        return style;
    }

    void click() {
        OS.SendMessage(this.handle, 245, 0, 0);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int border = this.getBorderWidth();
        int width = 0;
        int height = 0;
        if ((this.style & 4) != 0) {
            if ((this.style & 0x480) != 0) {
                width += OS.GetSystemMetrics(2);
                height += OS.GetSystemMetrics(20);
            } else {
                width += OS.GetSystemMetrics(21);
                height += OS.GetSystemMetrics(3);
            }
            if (wHint != -1) {
                width = wHint;
            }
            if (hHint != -1) {
                height = hHint;
            }
            return new Point(width += border * 2, height += border * 2);
        }
        int extra = 0;
        int bits = OS.GetWindowLong(this.handle, -16);
        if ((bits & 0xC0) == 0) {
            int oldFont = 0;
            int hDC = OS.GetDC(this.handle);
            int newFont = OS.SendMessage(this.handle, 49, 0, 0);
            if (newFont != 0) {
                oldFont = OS.SelectObject(hDC, newFont);
            }
            TEXTMETRIC lptm = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
            OS.GetTextMetrics(hDC, lptm);
            int length = OS.GetWindowTextLength(this.handle);
            if (length == 0) {
                height += lptm.tmHeight;
            } else {
                extra = Math.max(8, lptm.tmAveCharWidth);
                TCHAR buffer = new TCHAR(this.getCodePage(), length + 1);
                OS.GetWindowText(this.handle, buffer, length + 1);
                RECT rect = new RECT();
                int flags = 1056;
                OS.DrawText(hDC, buffer, length, rect, flags);
                width += rect.right - rect.left;
                height += rect.bottom - rect.top;
            }
            if (newFont != 0) {
                OS.SelectObject(hDC, oldFont);
            }
            OS.ReleaseDC(this.handle, hDC);
        } else if (this.image != null) {
            Rectangle rect = this.image.getBounds();
            width = rect.width;
            height = rect.height;
            extra = 8;
        }
        if ((this.style & 0x30) != 0) {
            width += CheckWidth + extra;
            height = Math.max(height, CheckHeight + 3);
        }
        if ((this.style & 0xA) != 0) {
            width += 12;
            height += 10;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width += border * 2, height += border * 2);
    }

    int defaultBackground() {
        if ((this.style & 0xA) != 0) {
            return OS.GetSysColor(OS.COLOR_BTNFACE);
        }
        return super.defaultBackground();
    }

    int defaultForeground() {
        return OS.GetSysColor(OS.COLOR_BTNTEXT);
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            if ((this.style & 0x80) != 0) {
                return 128;
            }
            if ((this.style & 0x400) != 0) {
                return 1024;
            }
            if ((this.style & 0x4000) != 0) {
                return 16384;
            }
            if ((this.style & 0x20000) != 0) {
                return 131072;
            }
            return 128;
        }
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    boolean getDefault() {
        if ((this.style & 8) == 0) {
            return false;
        }
        int bits = OS.GetWindowLong(this.handle, -16);
        return (bits & 1) != 0;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    String getNameText() {
        return this.getText();
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return false;
        }
        int state = OS.SendMessage(this.handle, 240, 0, 0);
        return (state & 1) != 0;
    }

    public String getText() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return "";
        }
        int length = OS.GetWindowTextLength(this.handle);
        if (length == 0) {
            return "";
        }
        TCHAR buffer = new TCHAR(this.getCodePage(), length + 1);
        OS.GetWindowText(this.handle, buffer, length + 1);
        return buffer.toString(0, length);
    }

    boolean isTabItem() {
        return super.isTabItem();
    }

    boolean mnemonicHit(char ch) {
        if (!this.setFocus()) {
            return false;
        }
        if ((this.style & 0x10) == 0) {
            this.click();
        }
        return true;
    }

    boolean mnemonicMatch(char key) {
        char mnemonic = this.findMnemonic(this.getText());
        if (mnemonic == '\u0000') {
            return false;
        }
        return Character.toUpperCase(key) == Character.toUpperCase(mnemonic);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.image = null;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void selectRadio() {
        Control[] children = this.parent._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (this != child) {
                child.setRadioSelection(false);
            }
            ++i;
        }
        this.setSelection(true);
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            if ((this.style & 0x24480) == 0) {
                return;
            }
            this.style &= 0xFFFDBB7F;
            this.style |= alignment & 0x24480;
            OS.InvalidateRect(this.handle, null, true);
            return;
        }
        if ((alignment & 0x1024000) == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= alignment & 0x1024000;
        int bits = OS.GetWindowLong(this.handle, -16);
        bits &= 0xFFFFFCFF;
        if ((this.style & 0x4000) != 0) {
            bits |= 0x100;
        }
        if ((this.style & 0x1000000) != 0) {
            bits |= 0x300;
        }
        if ((this.style & 0x20000) != 0) {
            bits |= 0x200;
        }
        OS.SetWindowLong(this.handle, -16, bits);
        OS.InvalidateRect(this.handle, null, true);
    }

    void setDefault(boolean value) {
        if ((this.style & 8) == 0) {
            return;
        }
        int hwndShell = this.menuShell().handle;
        int bits = OS.GetWindowLong(this.handle, -16);
        if (value) {
            bits |= 1;
            OS.SendMessage(hwndShell, 1025, this.handle, 0);
        } else {
            bits &= 0xFFFFFFFE;
            OS.SendMessage(hwndShell, 1025, 0, 0);
        }
        OS.SendMessage(this.handle, 244, bits, 1);
    }

    public void setImage(Image image) {
        int newBits;
        this.checkWidget();
        int hImage = 0;
        int imageBits = 0;
        int fImageType = 0;
        if (image != null) {
            if (image.isDisposed()) {
                this.error(5);
            }
            hImage = image.handle;
            switch (image.type) {
                case 0: {
                    imageBits = 128;
                    fImageType = 0;
                    break;
                }
                case 1: {
                    imageBits = 64;
                    fImageType = 1;
                    break;
                }
                default: {
                    return;
                }
            }
        }
        this.image = image;
        int oldBits = newBits = OS.GetWindowLong(this.handle, -16);
        newBits &= 0xFFFFFF3F;
        if ((newBits |= imageBits) != oldBits) {
            OS.SetWindowLong(this.handle, -16, newBits);
        }
        OS.SendMessage(this.handle, 247, fImageType, hImage);
    }

    boolean setRadioFocus() {
        if ((this.style & 0x10) == 0 || !this.getSelection()) {
            return false;
        }
        return this.setFocus();
    }

    boolean setRadioSelection(boolean value) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != value) {
            this.setSelection(value);
            this.postEvent(13);
        }
        return true;
    }

    boolean setSavedFocus() {
        if ((this.style & 0x10) != 0 && !this.getSelection()) {
            return false;
        }
        return super.setSavedFocus();
    }

    public void setSelection(boolean selected) {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return;
        }
        int flags = selected ? 1 : 0;
        int bits = OS.GetWindowLong(this.handle, -16);
        OS.SendMessage(this.handle, 241, flags, 0);
        OS.SetWindowLong(this.handle, -16, bits);
    }

    public void setText(String string) {
        int newBits;
        int oldBits;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 4) != 0) {
            return;
        }
        if ((newBits &= 0xFFFFFF3F) != (oldBits = (newBits = OS.GetWindowLong(this.handle, -16)))) {
            OS.SetWindowLong(this.handle, -16, newBits);
        }
        TCHAR buffer = new TCHAR(this.getCodePage(), string, true);
        OS.SetWindowText(this.handle, buffer);
    }

    int widgetStyle() {
        int bits = super.widgetStyle();
        if ((this.style & 0x800000) != 0) {
            bits |= 0x8000;
        }
        if ((this.style & 4) != 0) {
            return bits | 0xB;
        }
        if ((this.style & 0x4000) != 0) {
            bits |= 0x100;
        }
        if ((this.style & 0x1000000) != 0) {
            bits |= 0x300;
        }
        if ((this.style & 0x20000) != 0) {
            bits |= 0x200;
        }
        if ((this.style & 8) != 0) {
            return bits | 0x10000;
        }
        if ((this.style & 0x20) != 0) {
            return bits | 2 | 0x10000;
        }
        if ((this.style & 0x10) != 0) {
            return bits | 4;
        }
        if ((this.style & 2) != 0) {
            return bits | 0x1000 | 2;
        }
        return bits | 0x10000;
    }

    TCHAR windowClass() {
        return ButtonClass;
    }

    int windowProc() {
        return ButtonProc;
    }

    LRESULT WM_GETDLGCODE(int wParam, int lParam) {
        LRESULT result = super.WM_GETDLGCODE(wParam, lParam);
        if (result != null) {
            return result;
        }
        if ((this.style & 4) != 0) {
            return new LRESULT(256);
        }
        return result;
    }

    LRESULT WM_KILLFOCUS(int wParam, int lParam) {
        LRESULT result = super.WM_KILLFOCUS(wParam, lParam);
        if ((this.style & 8) != 0 && this.getDefault()) {
            this.menuShell().setDefaultButton(null, false);
        }
        return result;
    }

    LRESULT WM_SETFOCUS(int wParam, int lParam) {
        int bits = 0;
        if ((this.style & 0x10) != 0) {
            bits = OS.GetWindowLong(this.handle, -16);
        }
        LRESULT result = super.WM_SETFOCUS(wParam, lParam);
        if ((this.style & 0x10) != 0) {
            OS.SetWindowLong(this.handle, -16, bits);
        }
        if ((this.style & 8) != 0) {
            this.menuShell().setDefaultButton(this, false);
        }
        return result;
    }

    LRESULT wmCommandChild(int wParam, int lParam) {
        int code = wParam >> 16;
        switch (code) {
            case 0: 
            case 5: {
                if ((this.style & 0x22) != 0) {
                    this.setSelection(!this.getSelection());
                } else if ((this.style & 0x10) != 0) {
                    if ((this.parent.getStyle() & 0x400000) != 0) {
                        this.setSelection(!this.getSelection());
                    } else {
                        this.selectRadio();
                    }
                }
                this.postEvent(13);
            }
        }
        return super.wmCommandChild(wParam, lParam);
    }

    LRESULT wmDrawChild(int wParam, int lParam) {
        if ((this.style & 4) == 0) {
            return super.wmDrawChild(wParam, lParam);
        }
        DRAWITEMSTRUCT struct = new DRAWITEMSTRUCT();
        OS.MoveMemory(struct, lParam, 48);
        int uState = 2;
        switch (this.style & 0x24480) {
            case 128: {
                uState = 0;
                break;
            }
            case 1024: {
                uState = 1;
                break;
            }
            case 16384: {
                uState = 2;
                break;
            }
            case 131072: {
                uState = 3;
            }
        }
        if (!this.getEnabled()) {
            uState |= 0x100;
        }
        if ((this.style & 0x800000) == 0x800000) {
            uState |= 0x4000;
        }
        if ((struct.itemState & 1) != 0) {
            uState |= 0x200;
        }
        RECT rect = new RECT();
        OS.SetRect(rect, struct.left, struct.top, struct.right, struct.bottom);
        OS.DrawFrameControl(struct.hDC, rect, 3, uState);
        return null;
    }
}

