/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.quickdiff;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.IStorageDocumentProvider;
import org.eclipse.ui.internal.editors.quickdiff.QuickDiffMessages;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IElementStateListener;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.quickdiff.IQuickDiffReferenceProvider;

public class LastSaveReferenceProvider
implements IQuickDiffReferenceProvider,
IElementStateListener {
    private boolean fDocumentRead = false;
    private IDocument fReference = null;
    private String fId;
    private IDocumentProvider fDocumentProvider;
    private IEditorInput fEditorInput;
    private final Object fLock = new Object();
    private IProgressMonitor fProgressMonitor;
    private ITextEditor fEditor;

    public IDocument getReference(IProgressMonitor monitor) {
        if (!this.fDocumentRead) {
            this.readDocument(monitor, true);
        }
        return this.fReference;
    }

    public void dispose() {
        IProgressMonitor monitor = this.fProgressMonitor;
        if (monitor != null) {
            monitor.setCanceled(true);
        }
        IDocumentProvider provider = this.fDocumentProvider;
        Object object = this.fLock;
        synchronized (object) {
            if (provider != null) {
                provider.removeElementStateListener((IElementStateListener)this);
            }
            this.fEditorInput = null;
            this.fDocumentProvider = null;
            this.fReference = null;
            this.fDocumentRead = false;
            this.fProgressMonitor = null;
            this.fEditor = null;
        }
    }

    public String getId() {
        return this.fId;
    }

    public void setActiveEditor(ITextEditor targetEditor) {
        IDocumentProvider provider = null;
        IEditorInput input = null;
        if (targetEditor != null) {
            provider = targetEditor.getDocumentProvider();
            input = targetEditor.getEditorInput();
        }
        if (provider != this.fDocumentProvider || input != this.fEditorInput) {
            this.dispose();
            Object object = this.fLock;
            synchronized (object) {
                this.fEditor = targetEditor;
                this.fDocumentProvider = provider;
                this.fEditorInput = input;
            }
        }
    }

    public boolean isEnabled() {
        return this.fEditorInput != null && this.fDocumentProvider != null;
    }

    public void setId(String id) {
        this.fId = id;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readDocument(IProgressMonitor monitor, boolean force) {
        IFile file;
        IJobManager jobMgr;
        IStorageDocumentProvider provider;
        IFileEditorInput input;
        ITextEditor editor;
        IDocument doc;
        IDocumentProvider prov;
        block16: {
            block15: {
                block14: {
                    prov = this.fDocumentProvider;
                    IEditorInput inp = this.fEditorInput;
                    doc = this.fReference;
                    editor = this.fEditor;
                    if (!(prov instanceof IStorageDocumentProvider)) return;
                    if (!(inp instanceof IFileEditorInput)) return;
                    input = (IFileEditorInput)inp;
                    provider = (IStorageDocumentProvider)prov;
                    if (doc == null) {
                        if (!force) {
                            if (!this.fDocumentRead) return;
                        }
                        doc = new Document();
                    }
                    jobMgr = Platform.getJobManager();
                    file = input.getFile();
                    try {
                        try {
                            this.fProgressMonitor = monitor;
                            jobMgr.beginRule((ISchedulingRule)file, monitor);
                            InputStream stream = LastSaveReferenceProvider.getFileContents(file);
                            if (stream == null) {
                                Object var14_12 = null;
                                break block14;
                            }
                            String encoding = file.getCharset();
                            if (encoding == null) {
                                break block15;
                            }
                            boolean skipUTF8BOM = LastSaveReferenceProvider.isUTF8BOM(encoding, file);
                            LastSaveReferenceProvider.setDocumentContent(doc, stream, encoding, monitor, skipUTF8BOM);
                            break block16;
                        }
                        catch (IOException iOException) {
                            Object var14_14 = null;
                            jobMgr.endRule((ISchedulingRule)file);
                            this.fProgressMonitor = null;
                            return;
                        }
                        catch (CoreException coreException) {
                            Object var14_15 = null;
                            jobMgr.endRule((ISchedulingRule)file);
                            this.fProgressMonitor = null;
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var14_16 = null;
                        jobMgr.endRule((ISchedulingRule)file);
                        this.fProgressMonitor = null;
                        throw throwable;
                    }
                }
                jobMgr.endRule((ISchedulingRule)file);
                this.fProgressMonitor = null;
                return;
            }
            Object var14_13 = null;
            jobMgr.endRule((ISchedulingRule)file);
            this.fProgressMonitor = null;
            return;
        }
        Object var14_17 = null;
        jobMgr.endRule((ISchedulingRule)file);
        this.fProgressMonitor = null;
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        Object object = this.fLock;
        synchronized (object) {
            if (this.fDocumentProvider != provider) return;
            if (this.fEditorInput != input) return;
            this.fReference = doc;
            this.fDocumentRead = true;
            this.addElementStateListener(editor, prov);
            return;
        }
    }

    private void addElementStateListener(ITextEditor editor, IDocumentProvider provider) {
        provider.addElementStateListener((IElementStateListener)this);
    }

    private static InputStream getFileContents(IFile file) {
        InputStream stream = null;
        try {
            if (file != null) {
                stream = file.getContents();
            }
        }
        catch (CoreException coreException) {}
        return stream;
    }

    /*
     * Exception decompiling
     */
    private static void setDocumentContent(IDocument document, InputStream contentStream, String encoding, IProgressMonitor monitor, boolean skipUTF8BOM) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 178->182)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean isUTF8BOM(String encoding, IFile file) throws CoreException {
        byte[] bom;
        IContentDescription description;
        if ("UTF-8".equals(encoding) && (description = file.getContentDescription()) != null && (bom = (byte[])description.getProperty(IContentDescription.BYTE_ORDER_MARK)) != null) {
            if (bom != IContentDescription.BOM_UTF_8) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.editors", 0, QuickDiffMessages.getString("LastSaveReferenceProvider.LastSaveReferenceProvider.error.wrongByteOrderMark"), null));
            }
            return true;
        }
        return false;
    }

    public void elementDirtyStateChanged(Object element, boolean isDirty) {
        if (!isDirty && element == this.fEditorInput) {
            new ReadJob().schedule();
        }
    }

    public void elementContentAboutToBeReplaced(Object element) {
    }

    public void elementContentReplaced(Object element) {
        if (element == this.fEditorInput) {
            new ReadJob().schedule();
        }
    }

    public void elementDeleted(Object element) {
    }

    public void elementMoved(Object originalElement, Object movedElement) {
    }

    private final class ReadJob
    extends Job {
        public ReadJob() {
            super(QuickDiffMessages.getString("LastSaveReferenceProvider.LastSaveReferenceProvider.readJob.label"));
            this.setSystem(true);
            this.setPriority(20);
        }

        protected IStatus run(IProgressMonitor monitor) {
            LastSaveReferenceProvider.this.readDocument(monitor, false);
            return Status.OK_STATUS;
        }
    }
}

