/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.text;

import java.text.BreakIterator;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.text.TextFragmentBox;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;

class FlowUtilities
extends FigureUtilities {
    private static Dimension ELLIPSIS_SIZE = new Dimension();

    FlowUtilities() {
    }

    public static int getTextForSpace(TextFragmentBox frag, String string, Font font, int availableWidth, float avg, int wrapping) {
        int result;
        frag.truncated = false;
        if (string.length() == 0) {
            frag.length = 0;
            FlowUtilities.setupFragment(frag, font, string);
            return 0;
        }
        FontMetrics metrics = FigureUtilities.getFontMetrics(font);
        BreakIterator breakItr = BreakIterator.getLineInstance();
        breakItr.setText(string);
        int min = wrapping == 0 ? breakItr.next() : 1;
        int MIN = min;
        int max = string.length() + 1;
        if ((double)avg == 0.0) {
            avg = metrics.getAverageCharWidth();
        }
        int winNL = string.indexOf("\r\n");
        int macNL = string.indexOf(13);
        int unixNL = string.indexOf(10);
        if (macNL == winNL) {
            macNL = -1;
        }
        if (winNL != -1) {
            max = Math.min(max, (winNL += 2) + 1);
        }
        if (unixNL != -1) {
            max = Math.min(max, ++unixNL + 1);
        }
        if (macNL != -1) {
            max = Math.min(max, ++macNL + 1);
        }
        int guess = 0;
        int guessSize = 0;
        while (max - min > 1) {
            if ((guess += Math.round((float)(availableWidth - guessSize) / avg)) >= max) {
                guess = max - 1;
            }
            if (guess <= min) {
                guess = min + 1;
            }
            if ((guessSize = FigureUtilities.getStringExtents((String)string.substring((int)0, (int)guess), (Font)font).width) <= availableWidth) {
                min = guess;
                continue;
            }
            max = guess;
        }
        while (max <= string.length() && Character.isWhitespace(string.charAt(max - 1)) && min != winNL && min != macNL && min != unixNL) {
            ++max;
            ++min;
        }
        string = new String(string);
        boolean needToSetLength = true;
        if (min == string.length() || min == winNL || min == unixNL || min == macNL || breakItr.isBoundary(max - 1)) {
            result = min;
        } else {
            result = breakItr.preceding(max - 1);
            if (result == 0) {
                switch (wrapping) {
                    case 0: {
                        result = MIN;
                        break;
                    }
                    case 1: {
                        result = min;
                        break;
                    }
                    case 2: {
                        ELLIPSIS_SIZE = FigureUtilities.getStringExtents("...", font).shrink(1, 0);
                        FlowUtilities.getTextForSpace(frag, string, font, availableWidth - FlowUtilities.ELLIPSIS_SIZE.width, avg, 1);
                        needToSetLength = false;
                        frag.truncated = true;
                        result = breakItr.following(max - 1);
                        if (result != -1) break;
                        result = string.length();
                    }
                }
            }
        }
        if (needToSetLength) {
            frag.length = result;
        }
        FlowUtilities.setupFragment(frag, font, string);
        return result;
    }

    static void setupFragment(TextFragmentBox frag, Font f, String s) {
        while (frag.length > 0 && Character.isWhitespace(s.charAt(frag.length - 1))) {
            --frag.length;
        }
        Dimension d = FigureUtilities.getStringExtents(s.substring(0, frag.length), f);
        FontMetrics fm = FigureUtilities.getFontMetrics(f);
        frag.setHeight(fm.getHeight() + fm.getLeading());
        frag.setAscent(fm.getAscent() + fm.getLeading());
        if (frag.truncated) {
            d.width += FlowUtilities.ELLIPSIS_SIZE.width;
        }
        frag.setWidth(d.width);
    }
}

