/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal.merge;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.compare.IStreamMerger;
import org.eclipse.compare.internal.merge.LineComparator;
import org.eclipse.compare.internal.merge.MergeMessages;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class TextStreamMerger
implements IStreamMerger {
    public IStatus merge(OutputStream output, String outputEncoding, InputStream ancestor, String ancestorEncoding, InputStream target, String targetEncoding, InputStream other, String otherEncoding, IProgressMonitor monitor) {
        LineComparator o;
        LineComparator t;
        LineComparator a;
        try {
            a = new LineComparator(ancestor, ancestorEncoding);
            t = new LineComparator(target, targetEncoding);
            o = new LineComparator(other, otherEncoding);
        }
        catch (UnsupportedEncodingException e) {
            return new Status(4, "org.eclipse.compare", 1, MergeMessages.getString("TextAutoMerge.inputEncodingError"), (Throwable)e);
        }
        try {
            int lineSeparator = 10;
            RangeDifference[] diffs = RangeDifferencer.findRanges(monitor, a, t, o);
            int i = 0;
            while (i < diffs.length) {
                RangeDifference rd = diffs[i];
                switch (rd.kind()) {
                    case 0: 
                    case 2: 
                    case 4: {
                        String s;
                        int j = rd.rightStart();
                        while (j < rd.rightEnd()) {
                            s = o.getLine(j);
                            output.write(s.getBytes(outputEncoding));
                            output.write(lineSeparator);
                            ++j;
                        }
                        break;
                    }
                    case 3: {
                        String s;
                        int j = rd.leftStart();
                        while (j < rd.leftEnd()) {
                            s = t.getLine(j);
                            output.write(s.getBytes(outputEncoding));
                            output.write(lineSeparator);
                            ++j;
                        }
                        break;
                    }
                    case 1: {
                        return new Status(4, "org.eclipse.compare", 1, MergeMessages.getString("TextAutoMerge.conflict"), null);
                    }
                }
                ++i;
            }
        }
        catch (UnsupportedEncodingException e) {
            return new Status(4, "org.eclipse.compare", 1, MergeMessages.getString("TextAutoMerge.outputEncodingError"), (Throwable)e);
        }
        catch (IOException e) {
            return new Status(4, "org.eclipse.compare", 1, MergeMessages.getString("TextAutoMerge.outputIOError"), (Throwable)e);
        }
        return Status.OK_STATUS;
    }
}

