/*
 * Decompiled with CFR 0.152.
 */
package org.jpn.xucker.rcp.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class FileDialogBuilder {
    private Map categoryMap = new HashMap();
    private List fileFilterList = new ArrayList();
    private boolean createAll = true;
    private boolean createAny;
    public static final String ALL = "ALL";
    public static final String ANY = "ANY";

    public Map getCategoryMap() {
        return this.categoryMap;
    }

    public void setCategoryMap(Map categoryMap) {
        this.categoryMap = categoryMap;
    }

    public boolean isCreateAll() {
        return this.createAll;
    }

    public void setCreateAll(boolean createAll) {
        this.createAll = createAll;
    }

    public boolean isCreateAny() {
        return this.createAny;
    }

    public void setCreateAny(boolean createAny) {
        this.createAny = createAny;
    }

    public List getFileFilterList() {
        return this.fileFilterList;
    }

    public void setFileFilterList(List fileFilterList) {
        this.fileFilterList = fileFilterList;
    }

    public FileDialog createFileDialog(Shell shell, int style, String filterName) {
        FileDialog dialog = new FileDialog(shell, style);
        dialog.setFilterExtensions(this.getFilterExtentions(filterName));
        dialog.setFilterNames(this.getFilterNames(filterName));
        return dialog;
    }

    public void registCategory(String categoryName, FileFilter fileFilter) {
        ArrayList<FileFilter> list = (ArrayList<FileFilter>)this.categoryMap.get(categoryName);
        if (list == null) {
            list = new ArrayList<FileFilter>();
            this.categoryMap.put(categoryName, list);
        }
        list.add(fileFilter);
    }

    public void add(String category, String filterName, String[] filterExtension) {
        FileFilter filter = new FileFilter(filterName, filterExtension);
        this.fileFilterList.add(filter);
        this.registCategory(category, filter);
    }

    public void add(String filterName, String[] filterExtension) {
        this.fileFilterList.add(new FileFilter(filterName, filterExtension));
    }

    public String getCategoryFilterExtensions(String categoryName) {
        List list = (List)this.categoryMap.get(categoryName);
        if (list == null) {
            return "";
        }
        FileFilter[] fileFilters = list.toArray(new FileFilter[list.size()]);
        String all = "";
        int i = 0;
        while (i < fileFilters.length) {
            String label = "";
            String[] ext = fileFilters[i].getFilterExtension();
            int j = 0;
            while (j < ext.length) {
                String tmpLabel = "*." + ext[j] + ";";
                label = String.valueOf(label) + tmpLabel;
                all = String.valueOf(all) + tmpLabel;
                ++j;
            }
            ++i;
        }
        return all.substring(0, all.length() - 1);
    }

    public String[] getFilterNames(String filterName) {
        ArrayList<String> exList = new ArrayList<String>();
        String first = null;
        String all = "";
        String[] categories = this.categoryMap.keySet().toArray(new String[this.categoryMap.size()]);
        int i = 0;
        while (i < categories.length) {
            String value = this.getCategoryFilterExtensions(categories[i]);
            if (ObjectUtils.equals((Object)categories[i], (Object)filterName)) {
                first = categories[i];
            } else {
                exList.add(categories[i]);
            }
            ++i;
        }
        FileFilter[] fileFilters = this.fileFilterList.toArray(new FileFilter[this.fileFilterList.size()]);
        int i2 = 0;
        while (i2 < fileFilters.length) {
            if (ObjectUtils.equals((Object)filterName, (Object)fileFilters[i2].getFilterName())) {
                first = fileFilters[i2].getFilterName();
            } else {
                exList.add(fileFilters[i2].getFilterName());
            }
            ++i2;
        }
        if (this.createAll) {
            if (ObjectUtils.equals((Object)filterName, (Object)ALL)) {
                first = "All Supported Types";
            } else {
                exList.add("All Supported Types");
            }
        }
        if (this.createAny) {
            if (ObjectUtils.equals((Object)filterName, (Object)ANY)) {
                first = "All Files";
            } else {
                exList.add("All Files");
            }
        }
        if (first != null) {
            exList.add(0, first);
        }
        String[] extensions = this.getFilterExtentions(filterName);
        String[] filterNames = exList.toArray(new String[exList.size()]);
        int i3 = 0;
        while (i3 < filterNames.length) {
            filterNames[i3] = String.valueOf(filterNames[i3]) + " (" + extensions[i3].replaceAll(";", ",") + ")";
            ++i3;
        }
        return filterNames;
    }

    public String[] getFilterExtentions(String filterName) {
        ArrayList<String> exList = new ArrayList<String>();
        String first = null;
        String all = "";
        String[] categories = this.categoryMap.keySet().toArray(new String[this.categoryMap.size()]);
        int i = 0;
        while (i < categories.length) {
            String value = this.getCategoryFilterExtensions(categories[i]);
            if (ObjectUtils.equals((Object)categories[i], (Object)filterName)) {
                first = value;
            } else {
                exList.add(value);
            }
            ++i;
        }
        FileFilter[] fileFilters = this.fileFilterList.toArray(new FileFilter[this.fileFilterList.size()]);
        int i2 = 0;
        while (i2 < fileFilters.length) {
            String label = "";
            String[] ext = fileFilters[i2].getFilterExtension();
            int j = 0;
            while (j < ext.length) {
                String tmpLabel = "*." + ext[j] + ";";
                label = String.valueOf(label) + tmpLabel;
                all = String.valueOf(all) + tmpLabel;
                ++j;
            }
            if (ObjectUtils.equals((Object)filterName, (Object)fileFilters[i2].getFilterName())) {
                first = label.substring(0, label.length() - 1);
            } else {
                exList.add(label.substring(0, label.length() - 1));
            }
            ++i2;
        }
        if (this.createAll) {
            if (ObjectUtils.equals((Object)filterName, (Object)ALL)) {
                first = all.substring(0, all.length() - 1);
            } else {
                exList.add(all.substring(0, all.length() - 1));
            }
        }
        if (this.createAny) {
            if (ObjectUtils.equals((Object)filterName, (Object)ANY)) {
                first = "*,*";
            } else {
                exList.add("*,*");
            }
        }
        if (first != null) {
            exList.add(0, first);
        }
        return exList.toArray(new String[exList.size()]);
    }

    public class FileFilter {
        private String filterName;
        private String[] filterExtension;

        public FileFilter(String filterName, String[] filterExtension) {
            this.filterName = filterName;
            this.filterExtension = filterExtension;
        }

        public String[] getFilterExtension() {
            return this.filterExtension;
        }

        public void setFilterExtension(String[] filterExtension) {
            this.filterExtension = filterExtension;
        }

        public String getFilterName() {
            return this.filterName;
        }

        public void setFilterName(String filterName) {
            this.filterName = filterName;
        }
    }
}

