package org.jpn.xucker.rcp.subplayer;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.plugin.AbstractUIPlugin;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.jpn.xucker.rcp.subplayer.preferences.SubViewPage;
import org.osgi.framework.BundleContext;

import java.io.File;

/**
 * The main plugin class to be used in the desktop.
 */
public class SubplayerPlugin extends AbstractUIPlugin {
	//The shared instance.
	private static SubplayerPlugin plugin;
	//Resource bundle.
	private ResourceBundle resourceBundle;
	
	/**
	 * The constructor.
	 */
	public SubplayerPlugin() {
		super();
		plugin = this;
		try {
			resourceBundle = ResourceBundle.getBundle("org.jpn.xucker.rci.subplayer.SubplayerPluginResources");
		} catch (MissingResourceException x) {
			resourceBundle = null;
		}
	}

	/**
	 * This method is called upon plug-in activation
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
		
		
		//FontData fontData=new FontData("MS UI Gothic",28,SWT.NONE);
		
		//PreferenceConverter.setDefault(getPreferenceStore(),SubViewPage.LAYER1_FONT,fontData);
		//PreferenceConverter.setDefault(getPreferenceStore(),"ab",fontData);
		
		/*
		PreferenceConverter.setDefault(getPreferenceStore(),SubViewPage.LAYER1_BGCOLOR,new RGB(0,0,0));
		
		
		
		
		PreferenceConverter.setDefault(getPreferenceStore(),SubViewPage.LAYER1_BGCOLOR,ColorConstants.black.getRGB());
		PreferenceConverter.setDefault(getPreferenceStore(),SubViewPage.LAYER1_FGCOLOR,ColorConstants.white.getRGB());
		*/
	}

	/**
	 * This method is called when the plug-in is stopped
	 */
	public void stop(BundleContext context) throws Exception {
		super.stop(context);
	}

	/**
	 * Returns the shared instance.
	 */
	public static SubplayerPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns the string from the plugin's resource bundle,
	 * or 'key' if not found.
	 */
	public static String getResourceString(String key) {
		ResourceBundle bundle = SubplayerPlugin.getDefault().getResourceBundle();
		try {
			return (bundle != null) ? bundle.getString(key) : key;
		} catch (MissingResourceException e) {
			return key;
		}
	}

	/**
	 * Returns the plugin's resource bundle,
	 */
	public ResourceBundle getResourceBundle() {
		return resourceBundle;
	}
	
	 public static  File toPluginDir(AbstractUIPlugin plugin){
		 	return new File(Platform.getInstallLocation().getURL().getPath(),
		 	"plugins/"
		 	+plugin.getBundle().getSymbolicName()
		 	+"_"
		 	+plugin.getBundle().getHeaders().get("Bundle-Version"));
		 	}
}
