/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.dvdstyler;

import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jp.sourceforge.akjrcp.akj_betas.wizards.DVDStylerExportWizard;
import jp.sourceforge.akjrcp.dvdstyler.DVDStylerMenu;
import jp.sourceforge.akjrcp.dvdstyler.DVDStylerTitle;
import jp.sourceforge.akjrcp.dvdstyler.DVDStylerTitleset;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class DVDStylerData {
    public static final String ASPECT_RATIO_4x3 = "4:3";
    public static final String ASPECT_RATIO_16x9 = "16:9";
    private DVDStylerMenu menu = new DVDStylerMenu();
    private List<DVDStylerTitleset> titlesets = new ArrayList<DVDStylerTitleset>();
    public static final int VERSION_1 = 1;
    public static final int VERSION_2 = 2;
    private int format = 2;
    private String aspectRatio = "4:3";

    public static String createJumpTitle(int index) {
        return "jump title " + index + ";";
    }

    public static String createJumpTitle(int titleset, int index) {
        return "jump titleset " + titleset + " title " + index + ";";
    }

    public static String createJumpVmgmMenu(int index) {
        return "call vmgm menu " + index + ";";
    }

    public static String createJumpMenu(int index) {
        return "call menu " + index + ";";
    }

    public DVDStylerData() {
        this.addTitleset();
    }

    public void addTitleset() {
        this.titlesets.add(new DVDStylerTitleset());
    }

    public Element toTitleElement(Document document, DVDStylerTitle title) {
        Element pgc = document.createElement("pgc");
        Element vob = document.createElement("vob");
        vob.setAttribute("file", title.getPath());
        vob.setAttribute("chapters", title.getChapters());
        pgc.appendChild(vob);
        String postAction = title.getPostAction();
        if (postAction.length() > 0) {
            Element post = document.createElement("post");
            post.appendChild(document.createTextNode(postAction));
            pgc.appendChild(post);
        }
        return pgc;
    }

    public Document toVersion1Document() {
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
            document = builder.newDocument();
            Element root = document.createElement("dvdstyler");
            root.setAttribute("jumppad", "1");
            root.setAttribute("emptymenu", "1");
            DVDStylerExportWizard.log.info((Object)root);
            Element vmgm = document.createElement("vmgm");
            Element menus = document.createElement("menus");
            root.appendChild(vmgm);
            vmgm.appendChild(menus);
            DVDStylerTitleset[] sets = this.titlesets.toArray(new DVDStylerTitleset[this.titlesets.size()]);
            int i = 0;
            while (i < sets.length) {
                Element titleset = document.createElement("titleset");
                root.appendChild(titleset);
                Element menus2 = document.createElement("menus");
                titleset.appendChild(menus2);
                Element pgc = document.createElement("pgc");
                menus2.appendChild(pgc);
                Element spumux = document.createElement("spumux");
                pgc.appendChild(spumux);
                Element menu = document.createElement("menu");
                spumux.appendChild(menu);
                menu.setAttribute("videoFormat", "NTSC");
                menu.setAttribute("bgColour", "#000000");
                Element vob = document.createElement("vob");
                pgc.appendChild(vob);
                vob.setAttribute("file", "");
                vob.setAttribute("pause", "inf");
                Element pre = document.createElement("pre");
                pgc.appendChild(pre);
                Text text = document.createTextNode(this.menu.getPreAction());
                pre.appendChild(text);
                Element titles = document.createElement("titles");
                titleset.appendChild(titles);
                DVDStylerTitle[] stylerTitles = sets[i].getTitles();
                int j = 0;
                while (j < stylerTitles.length) {
                    titles.appendChild(this.toTitleElement(document, stylerTitles[j]));
                    ++j;
                }
                ++i;
            }
            document.appendChild(root);
        }
        catch (ParserConfigurationException e) {
            DVDStylerExportWizard.log.warn((Object)e.getMessage());
        }
        return document;
    }

    public Document toVersion2Document() {
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
            document = builder.newDocument();
            Element root = document.createElement("dvdstyler");
            root.setAttribute("jumppad", "1");
            root.setAttribute("emptyMenu", "1");
            root.setAttribute("name", "dvd");
            root.setAttribute("format", "2");
            DVDStylerExportWizard.log.info((Object)root);
            Element vmgm = document.createElement("vmgm");
            Element menus = document.createElement("menus");
            root.appendChild(vmgm);
            vmgm.appendChild(menus);
            DVDStylerTitleset[] sets = this.titlesets.toArray(new DVDStylerTitleset[this.titlesets.size()]);
            int i = 0;
            while (i < sets.length) {
                Element titleset = document.createElement("titleset");
                root.appendChild(titleset);
                Element menus2 = document.createElement("menus");
                titleset.appendChild(menus2);
                Element video = document.createElement("video");
                video.setAttribute("aspect", ASPECT_RATIO_4x3);
                menus2.appendChild(video);
                Element pgc = document.createElement("pgc");
                menus2.appendChild(pgc);
                Element menu = document.createElement("menu");
                menu.setAttribute("videoFormat", "NTSC");
                menu.setAttribute("bgColour", "#000000");
                Element vob = document.createElement("vob");
                pgc.appendChild(vob);
                vob.setAttribute("pause", "inf");
                vob.appendChild(menu);
                Element svg = document.createElement("svg");
                svg.setAttribute("width", "720");
                svg.setAttribute("height", "480");
                menu.appendChild(svg);
                Element rect = document.createElement("rect");
                rect.setAttribute("width", "720");
                rect.setAttribute("height", "480");
                rect.setAttribute("id", "background");
                rect.setAttribute("style", "fill:#000000;");
                svg.appendChild(rect);
                Element defs = document.createElement("defs");
                defs.setAttribute("id", "defs");
                svg.appendChild(defs);
                Element objects = document.createElement("g");
                objects.setAttribute("id", "objects");
                svg.appendChild(objects);
                Element buttons = document.createElement("g");
                buttons.setAttribute("id", "buttons");
                svg.appendChild(buttons);
                Element pre = document.createElement("pre");
                pgc.appendChild(pre);
                Text text = document.createTextNode(this.menu.getPreAction());
                pre.appendChild(text);
                Element titles = document.createElement("titles");
                titleset.appendChild(titles);
                DVDStylerTitle[] stylerTitles = sets[i].getTitles();
                int j = 0;
                while (j < stylerTitles.length) {
                    titles.appendChild(this.toTitleElement(document, stylerTitles[j]));
                    ++j;
                }
                ++i;
            }
            document.appendChild(root);
        }
        catch (ParserConfigurationException e) {
            DVDStylerExportWizard.log.warn((Object)e.getMessage());
        }
        return document;
    }

    public Document toDocument() {
        if (this.format == 1) {
            return this.toVersion1Document();
        }
        if (this.format == 2) {
            return this.toVersion2Document();
        }
        return null;
    }

    public void addTitle(DVDStylerTitle title) {
        this.titlesets.get(this.titlesets.size() - 1).addTitle(title);
    }

    public String getAspectRatio() {
        return this.aspectRatio;
    }

    public void setAspectRatio(String aspectRatio) {
        this.aspectRatio = aspectRatio;
    }

    public int getFormat() {
        return this.format;
    }

    public void setFormat(int format) {
        this.format = format;
    }
}

