/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ffmpeg;

import java.util.ArrayList;

public class FFMpegCommandUtil {
    public static String[] makeInputPipeCommand(String ffmpeg, boolean overwrite, String[] inputOptions, String[] others) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(ffmpeg);
        if (overwrite) {
            list.add("-y");
        }
        list.add("-f");
        list.add("image2pipe");
        list.add("-vcodec");
        list.add("mjpeg");
        int i = 0;
        while (i < inputOptions.length) {
            list.add(inputOptions[i]);
            ++i;
        }
        list.add("-i");
        list.add("-");
        i = 0;
        while (i < others.length) {
            list.add(others[i]);
            ++i;
        }
        return list.toArray(new String[0]);
    }

    public static String[] makeInputPipeCommand(String ffmpeg, boolean overwrite) {
        return FFMpegCommandUtil.makeInputPipeCommand(ffmpeg, overwrite, new String[0], new String[0]);
    }

    public static String[] makeJpegOutputPipeCommand(String ffmpeg, String input, String[] options) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(ffmpeg);
        list.add("-i");
        list.add(input);
        list.add("-f");
        list.add("image2pipe");
        list.add("-vcodec");
        list.add("mjpeg");
        list.add("-sameq");
        list.add("-an");
        int i = 0;
        while (i < options.length) {
            list.add(options[i]);
            ++i;
        }
        list.add("-");
        return list.toArray(new String[0]);
    }

    public static String[] makeJpegOutputPipeCommand(String ffmpeg, String input) {
        return FFMpegCommandUtil.makeJpegOutputPipeCommand(ffmpeg, input, new String[0]);
    }

    public static String[] makeWaveOutputPipeCommand(String ffmpeg, String input) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(ffmpeg);
        list.add("-i");
        list.add(input);
        list.add("-f");
        list.add("wav");
        list.add("-");
        return list.toArray(new String[0]);
    }

    public static String[] copyAudioCommand(String ffmpeg, String input, String output) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(ffmpeg);
        list.add("-i");
        list.add(input);
        list.add("-vn");
        list.add("-acodec");
        list.add("copy");
        list.add(output);
        return list.toArray(new String[0]);
    }

    public static String toDigits(int value, int digit) {
        String result = "" + value;
        while (result.length() < digit) {
            result = "0" + result;
        }
        return result;
    }
}

