/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.flvtools.explorer;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import jp.sourceforge.akjrcp.akj_betas.Akj_betasPlugin;
import jp.sourceforge.akjrcp.akj_betas.FilePlayer;
import jp.sourceforge.akjrcp.akj_betas.Messages;
import jp.sourceforge.akjrcp.flvtools.basic.OpenDirectable;
import jp.sourceforge.akjrcp.flvtools.basic.SimpleView;
import jp.sourceforge.akjrcp.flvtools.explorer.ConvertingMonitorDialog;
import jp.sourceforge.akjrcp.flvtools.explorer.FFMpegExecutable;
import jp.sourceforge.akjrcp.flvtools.explorer.FFMpegExplorerExecuter;
import jp.sourceforge.akjrcp.flvtools.explorer.FlowPlayerShell;
import jp.sourceforge.akjrcp.flvtools.explorer.MonitorCancelable;
import jp.sourceforge.akjrcp.flvtools.explorer.RenameDialog;
import jp.sourceforge.akjrcp.flvtools.explorer.ThumbnailManager;
import jp.sourceforge.akjrcp.ui.DirectoryList;
import jp.sourceforge.akjrcp.util.DropFileListener;
import jp.sourceforge.akjrcp.util.DropFileMonitor;
import jp.sourceforge.akjrcp.util.FLVChecker;
import jp.sourceforge.akjrcp.util.FileNameUtils;
import jp.sourceforge.akjrcp.util.image.ImageUtils;
import jp.sourceforge.akjrcp.youtubedl.YoutubeDLListener;
import jp.sourceforge.akjrcp.youtubedl.YoutubeDLView;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.part.ViewPart;

public class ExplorerView
extends ViewPart
implements OpenDirectable,
FFMpegExecutable,
MonitorCancelable {
    public static Log log = LogFactory.getLog(ExplorerView.class);
    public static final String ID = ExplorerView.class.getName();
    public static final String SORT_TYPE = "explorer.sorttype";
    private String currentDir;
    private String[] assistantNames;
    private CCombo directoryPaths;
    private ExplorerPathChange explorerPathChange;
    protected static Image noFFMpegImage;
    protected static Image noSupportImage;
    protected static Image loadingImage;
    protected static Image moveUpPrevImage;
    protected static Image folderImage;
    private File currentFile = null;
    private boolean firstPaint = true;
    ConvertingMonitorDialog convertingDialog;
    private FFMpegExplorerExecuter ffmpegExecuter;
    private int sortType;
    public static final int SORT_A_Z = 0;
    public static final int SORT_Z_A = 1;
    public static final int SORT_NEW = 2;
    public static final int SORT_OLD = 3;
    public static final int SORT_BIG = 4;
    public static final int SORT_SMALL = 5;
    private FLVChecker flvChecker = new FLVChecker();
    private String oldPath;
    ExplorerView self;
    private MenuItem moveDirs;
    Menu canvasPopup;
    private long MIN_FLV_SIZE = 1024L;
    private String[] folders;
    ArrayList actionValueList = new ArrayList();
    private FigureCanvas canvas;
    private Figure rootFigure;
    private FlowPlayerShell flowPlayerShell;
    private MenuItem convert;
    private int executingIndex;
    private Explorer explorerFigure;
    private MenuItem enableseek;
    private MenuItem renameFile;
    private MenuItem movePaths;
    private Menu moveDirMenu;
    private Menu movePathMenu;
    private MenuItem pspMenuItem;
    private MenuItem mpegMenuItem;
    private MenuItem wmvMenuItem;
    private MenuItem aviMenuItem;
    private MenuItem mp3MenuItem;
    private MenuItem wavMenuItem;

    static {
        System.out.println(Messages.getString("explorer.no_support"));
        noFFMpegImage = new Image((Device)Display.getCurrent(), DirectoryList.class.getClassLoader().getResourceAsStream("jp/sourceforge/akjrcp/flvtools/resource/" + Messages.getString("explorer.no_ffmpeg")));
        noSupportImage = new Image((Device)Display.getCurrent(), DirectoryList.class.getClassLoader().getResourceAsStream("jp/sourceforge/akjrcp/flvtools/resource/" + Messages.getString("explorer.no_support")));
        loadingImage = new Image((Device)Display.getCurrent(), DirectoryList.class.getClassLoader().getResourceAsStream("jp/sourceforge/akjrcp/flvtools/resource/loading.png"));
        moveUpPrevImage = new Image((Device)Display.getCurrent(), DirectoryList.class.getClassLoader().getResourceAsStream("jp/sourceforge/akjrcp/flvtools/resource/moveup_prev.png"));
        folderImage = new Image((Device)Display.getCurrent(), DirectoryList.class.getClassLoader().getResourceAsStream("jp/sourceforge/akjrcp/flvtools/resource/folder_large.png"));
    }

    public void initAssistantName(File file) {
        String[] list = file.list();
        if (list == null) {
            log.info((Object)("secyrity problem:" + file.getAbsolutePath()));
            this.assistantNames = new String[0];
            return;
        }
        FLVFilter filter = new FLVFilter();
        ArrayList<String> tmpNames = new ArrayList<String>();
        if (list != null) {
            int i = 0;
            while (i < list.length) {
                File tmp = new File(file, list[i]);
                if (tmp.isDirectory()) {
                    String[] flvList = tmp.list(filter);
                    int j = 0;
                    while (j < flvList.length) {
                        String flvKey = this.trimNumberName(flvList[j].substring(0, flvList[j].length() - ".flv".length()));
                        tmpNames.remove(flvKey);
                        tmpNames.add(flvKey);
                        ++j;
                    }
                }
                ++i;
            }
        }
        this.assistantNames = tmpNames.toArray(new String[0]);
    }

    private String trimNumberName(String name) {
        int x;
        String newName = name;
        if (name.endsWith(")") && (x = name.lastIndexOf("(")) != -1) {
            String digi = name.substring(x + 1, name.length() - 1);
            boolean isDigit = true;
            int i = 0;
            while (i < digi.length()) {
                if (!Character.isDigit(digi.charAt(i))) {
                    isDigit = false;
                    break;
                }
                ++i;
            }
            if (isDigit) {
                newName = name.substring(0, x);
            }
        }
        return newName;
    }

    private void updateExplorerPaths() {
        String paths = Akj_betasPlugin.getDefault().getPreferenceStore().getString("explorer.paths");
        String[] path = paths.split(";");
        this.directoryPaths.removeAll();
        int i = 0;
        while (i < path.length) {
            this.directoryPaths.add(path[i]);
            ++i;
        }
        this.directoryPaths.removeSelectionListener((SelectionListener)this.explorerPathChange);
        if (this.currentDir == null) {
            this.directoryPaths.select(0);
        } else {
            boolean find = false;
            int i2 = 0;
            while (i2 < path.length) {
                if (path[i2].equals(this.currentDir)) {
                    this.directoryPaths.select(i2);
                    find = true;
                    break;
                }
                ++i2;
            }
            if (!find) {
                this.directoryPaths.add(this.currentDir);
                this.directoryPaths.select(this.directoryPaths.getItemCount() - 1);
            }
        }
        this.directoryPaths.addSelectionListener((SelectionListener)this.explorerPathChange);
        this.updateMovePathsMenus();
    }

    public void ffmpegEnableChanged(String ffmpeg, String pureffmpeg) {
        if (ffmpeg == null && pureffmpeg == null) {
            this.convert.setEnabled(false);
        } else {
            this.convert.setEnabled(true);
            if (ffmpeg == null) {
                this.pspMenuItem.setEnabled(false);
                this.mp3MenuItem.setEnabled(false);
                this.aviMenuItem.setEnabled(FFMpegExplorerExecuter.canPureFFMpeg("avi"));
                this.mpegMenuItem.setEnabled(FFMpegExplorerExecuter.canPureFFMpeg("mpg"));
                this.wmvMenuItem.setEnabled(FFMpegExplorerExecuter.canPureFFMpeg("wmv"));
            } else {
                this.pspMenuItem.setEnabled(true);
                this.wmvMenuItem.setEnabled(true);
                this.mp3MenuItem.setEnabled(true);
                this.aviMenuItem.setEnabled(true);
                this.mpegMenuItem.setEnabled(true);
            }
        }
    }

    public static File getEmptyFileName(File file) {
        String fileName;
        if (!file.exists()) {
            return file;
        }
        String head = fileName = file.getName();
        int e = fileName.lastIndexOf(".");
        String ext = "";
        if (e != -1) {
            ext = fileName.substring(e);
            head = fileName.substring(0, e);
        }
        int index = 1;
        File newFile = null;
        while (newFile == null || newFile.exists()) {
            String newName = String.valueOf(head) + "(" + index + ")" + ext;
            newFile = new File(file.getParentFile(), newName);
            ++index;
        }
        return newFile;
    }

    public ExplorerView() {
        this.self = this;
    }

    public String findBaseDir() {
        String baseDir = SimpleView.findBaseDir();
        return baseDir;
    }

    public void createPartControl(Composite root) {
        ThumbnailManager.clearThumbnails();
        root.setLayout((Layout)new GridLayout(1, false));
        Composite controler = new Composite(root, 0);
        controler.setLayoutData((Object)new GridData(768));
        controler.setLayout((Layout)new GridLayout(3, false));
        Button reloadButton = new Button(controler, 0);
        reloadButton.setText(Messages.getString("reload"));
        reloadButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExplorerView.this.reload();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.directoryPaths = new CCombo(controler, 8);
        this.explorerPathChange = new ExplorerPathChange();
        GridData datax = new GridData(768);
        this.directoryPaths.setLayoutData((Object)datax);
        CCombo st = new CCombo(controler, 8);
        st.add(Messages.getString("sort.az"));
        st.add(Messages.getString("sort.za"));
        st.add(Messages.getString("sort.new"));
        st.add(Messages.getString("sort.old"));
        st.add(Messages.getString("sort.big"));
        st.add(Messages.getString("sort.small"));
        this.sortType = Akj_betasPlugin.getDefault().getPreferenceStore().getInt(SORT_TYPE);
        st.select(this.sortType);
        st.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ExplorerView.this.sortType = ((CCombo)e.getSource()).getSelectionIndex();
                Akj_betasPlugin.getDefault().getPreferenceStore().setValue(ExplorerView.SORT_TYPE, ExplorerView.this.sortType);
                ExplorerView.this.reload();
            }
        });
        this.canvas = new FigureCanvas(root);
        this.canvas.setLayoutData((Object)new GridData(1808));
        this.rootFigure = new Figure();
        this.canvas.setContents((IFigure)this.rootFigure);
        this.canvas.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                System.out.println(e);
                if (e.stateMask == 262144 && e.keyCode == 97) {
                    ExplorerView.this.selectAllThumbnail();
                }
            }
        });
        this.rootFigure.setLayoutManager((LayoutManager)new StackLayout());
        this.canvas.addControlListener((ControlListener)new ResizeMonitor(this.rootFigure));
        this.canvasPopup = new Menu((Control)this.canvas);
        this.canvas.setMenu(this.canvasPopup);
        MenuItem player = new MenuItem(this.canvasPopup, 64);
        player.setText(Messages.getString("explorer.play"));
        Menu playMenu = new Menu(player);
        player.setMenu(playMenu);
        MenuItem systemPlayItem = new MenuItem(playMenu, 8);
        systemPlayItem.setText(Messages.getString("explorer.System-Player"));
        systemPlayItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ExplorerView.this.currentFile != null && ExplorerView.this.currentFile.isFile()) {
                    FilePlayer.play(ExplorerView.this.currentFile, "flv");
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        MenuItem flowPlayItem = new MenuItem(playMenu, 8);
        flowPlayItem.setText(Messages.getString("explorer.flowPlayer"));
        flowPlayItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExplorerView.this.playFlowPlayer(ExplorerView.this.currentFile);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.convert = new MenuItem(this.canvasPopup, 64);
        this.convert.setText(Messages.getString("explorer.convert"));
        Menu convertMenu = new Menu(this.convert);
        this.convert.setMenu(convertMenu);
        MenuItem movie = new MenuItem(convertMenu, 64);
        movie.setText(Messages.getString("explorer.movie"));
        Menu movieMenu = new Menu(movie);
        movie.setMenu(movieMenu);
        this.pspMenuItem = new MenuItem(movieMenu, 8);
        this.pspMenuItem.setText(Messages.getString("explorer.psp"));
        this.pspMenuItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExplorerView.this.ffmpegExecuter = new FFMpegExplorerExecuter(ExplorerView.this.self);
                ExplorerView.this.ffmpegExecuter.setExtension("psp");
                ExplorerView.this.setExportBaseDir(ExplorerView.this.ffmpegExecuter);
                ExplorerView.this.ffmpegExecuter.setConvertingFile(ExplorerView.this.toSelectionFiles());
                ExplorerView.this.ffmpegExecuter.startExecute();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.mpegMenuItem = new MenuItem(movieMenu, 8);
        this.mpegMenuItem.setText(Messages.getString("explorer.mpeg"));
        this.mpegMenuItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExplorerView.this.ffmpegExecuter = new FFMpegExplorerExecuter(ExplorerView.this.self);
                ExplorerView.this.ffmpegExecuter.setExtension("mpg");
                ExplorerView.this.setExportBaseDir(ExplorerView.this.ffmpegExecuter);
                ExplorerView.this.ffmpegExecuter.setConvertingFile(ExplorerView.this.toSelectionFiles());
                ExplorerView.this.ffmpegExecuter.startExecute();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.wmvMenuItem = new MenuItem(movieMenu, 8);
        this.wmvMenuItem.setText(Messages.getString("explorer.wmv"));
        this.wmvMenuItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExplorerView.this.ffmpegExecuter = new FFMpegExplorerExecuter(ExplorerView.this.self);
                ExplorerView.this.ffmpegExecuter.setExtension("wmv");
                ExplorerView.this.setExportBaseDir(ExplorerView.this.ffmpegExecuter);
                ExplorerView.this.ffmpegExecuter.setConvertingFile(ExplorerView.this.toSelectionFiles());
                ExplorerView.this.ffmpegExecuter.startExecute();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.aviMenuItem = new MenuItem(movieMenu, 8);
        this.aviMenuItem.setText(Messages.getString("explorer.avi"));
        this.aviMenuItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExplorerView.this.ffmpegExecuter = new FFMpegExplorerExecuter(ExplorerView.this.self);
                ExplorerView.this.ffmpegExecuter.setExtension("avi");
                ExplorerView.this.setExportBaseDir(ExplorerView.this.ffmpegExecuter);
                ExplorerView.this.ffmpegExecuter.setConvertingFile(ExplorerView.this.toSelectionFiles());
                ExplorerView.this.ffmpegExecuter.startExecute();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        MenuItem audio = new MenuItem(convertMenu, 64);
        audio.setText(Messages.getString("explorer.audio"));
        Menu audioMenu = new Menu(audio);
        audio.setMenu(audioMenu);
        this.mp3MenuItem = new MenuItem(audioMenu, 8);
        this.mp3MenuItem.setText(Messages.getString("explorer.mp3"));
        this.mp3MenuItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExplorerView.this.ffmpegExecuter = new FFMpegExplorerExecuter(ExplorerView.this.self);
                ExplorerView.this.ffmpegExecuter.setExtension("mp3");
                ExplorerView.this.setExportBaseDir(ExplorerView.this.ffmpegExecuter);
                ExplorerView.this.ffmpegExecuter.setConvertingFile(ExplorerView.this.toSelectionFiles());
                ExplorerView.this.ffmpegExecuter.startExecute();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.wavMenuItem = new MenuItem(audioMenu, 8);
        this.wavMenuItem.setText(Messages.getString("explorer.wav"));
        this.wavMenuItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExplorerView.this.ffmpegExecuter = new FFMpegExplorerExecuter(ExplorerView.this.self);
                ExplorerView.this.ffmpegExecuter.setExtension("wav");
                ExplorerView.this.setExportBaseDir(ExplorerView.this.ffmpegExecuter);
                ExplorerView.this.ffmpegExecuter.setConvertingFile(ExplorerView.this.toSelectionFiles());
                ExplorerView.this.ffmpegExecuter.startExecute();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        MenuItem image = new MenuItem(convertMenu, 64);
        image.setText(Messages.getString("explorer.image"));
        Menu imageMenu = new Menu(image);
        image.setMenu(imageMenu);
        MenuItem jpeg = new MenuItem(imageMenu, 8);
        jpeg.setText(Messages.getString("explorer.jpeg"));
        jpeg.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExplorerView.this.ffmpegExecuter = new FFMpegExplorerExecuter(ExplorerView.this.self);
                ExplorerView.this.ffmpegExecuter.setExtension("jpg");
                ExplorerView.this.setExportBaseDir(ExplorerView.this.ffmpegExecuter);
                ExplorerView.this.ffmpegExecuter.setConvertingFile(ExplorerView.this.toSelectionFiles());
                ExplorerView.this.ffmpegExecuter.startExecute();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        MenuItem png = new MenuItem(imageMenu, 8);
        png.setText(Messages.getString("explorer.png"));
        png.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExplorerView.this.ffmpegExecuter = new FFMpegExplorerExecuter(ExplorerView.this.self);
                ExplorerView.this.ffmpegExecuter.setExtension("png");
                ExplorerView.this.setExportBaseDir(ExplorerView.this.ffmpegExecuter);
                ExplorerView.this.ffmpegExecuter.setConvertingFile(ExplorerView.this.toSelectionFiles());
                ExplorerView.this.ffmpegExecuter.startExecute();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.ffmpegEnableChanged(Akj_betasPlugin.getDefault().getFFmpeg(), Akj_betasPlugin.getDefault().getPureFFmpeg());
        new MenuItem(this.canvasPopup, 2);
        this.moveDirs = new MenuItem(this.canvasPopup, 64);
        this.movePaths = new MenuItem(this.canvasPopup, 64);
        this.updateMovePathsMenus();
        this.updateMoveDirsMenus(new String[0]);
        new MenuItem(this.canvasPopup, 2);
        this.enableseek = new MenuItem(this.canvasPopup, 8);
        this.enableseek.setText(Messages.getString("enable_seek"));
        this.enableseek.setEnabled(this.isEnableFLVTool2());
        this.enableseek.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExplorerView.this.callFLVTool2();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.renameFile = new MenuItem(this.canvasPopup, 8);
        this.renameFile.setText(Messages.getString("explorer.rename_file"));
        this.renameFile.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExplorerView.this.renameFile();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        new MenuItem(this.canvasPopup, 2);
        MenuItem selectAll = new MenuItem(this.canvasPopup, 8);
        selectAll.setText(Messages.getString("explorer.select_all"));
        selectAll.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExplorerView.this.selectAllThumbnail();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        new MenuItem(this.canvasPopup, 2);
        MenuItem openDir = new MenuItem(this.canvasPopup, 8);
        openDir.setText(Messages.getString("explorer.open_dir"));
        openDir.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ExplorerView.this.openFolder();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        root.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (ExplorerView.this.firstPaint) {
                    ExplorerView.this.firstPaint = false;
                    ExplorerView.this.openDirectory(ExplorerView.this.findBaseDir());
                }
            }
        });
        new DropFileMonitor((Control)this.canvas, new DropOpen());
        Akj_betasPlugin.getDefault().getPluginPreferences().addPropertyChangeListener((Preferences.IPropertyChangeListener)new SettingMonitor());
        try {
            YoutubeDLView.youtubeDLListeners.add(new YoutubeDownloaded());
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
    }

    public void openFolder() {
        if (this.currentFile == null) {
            return;
        }
        File dir = this.currentFile.isDirectory() ? this.currentFile : this.currentFile.getParentFile();
        Runtime r = Runtime.getRuntime();
        try {
            r.exec(new String[]{"explorer", dir.getAbsolutePath()});
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void updateMoveDirsMenus(String[] dirs) {
        if (this.moveDirMenu != null) {
            this.moveDirMenu.dispose();
        }
        this.moveDirMenu = new Menu(this.movePaths);
        this.moveDirs.setMenu(this.moveDirMenu);
        this.moveDirs.setText(Messages.getString("explorer.move_dirs"));
        int i = 0;
        while (i < dirs.length) {
            MenuItem movePath = new MenuItem(this.moveDirMenu, 8);
            movePath.setText(dirs[i]);
            movePath.addSelectionListener((SelectionListener)new MoveFLVToDir(String.valueOf(this.currentDir) + "\\" + dirs[i]));
            ++i;
        }
    }

    public void updateMovePathsMenus() {
        if (this.movePathMenu != null) {
            this.movePathMenu.dispose();
        }
        this.movePathMenu = new Menu(this.movePaths);
        this.movePaths.setMenu(this.movePathMenu);
        this.movePaths.setText(Messages.getString("explorer.move_paths"));
        String paths = Akj_betasPlugin.getDefault().getPreferenceStore().getString("explorer.paths");
        String[] path = paths.split(";");
        int i = 0;
        while (i < path.length) {
            MenuItem movePath = new MenuItem(this.movePathMenu, 8);
            movePath.setText(new File(path[i]).getName());
            movePath.addSelectionListener((SelectionListener)new MoveFLVToDir(path[i]));
            ++i;
        }
    }

    public void moveDirectory(String path) {
        File[] selectFile = this.toSelectionFiles();
        int i = 0;
        while (i < selectFile.length) {
            File newFile = new File(String.valueOf(path) + "\\" + selectFile[i].getName());
            String renameFile = FileNameUtils.getChangedExtensionName(newFile, "flv");
            boolean result = selectFile[i].renameTo(new File(renameFile));
            if (!result) {
                log.warn((Object)("move faild: from " + selectFile[i] + " to " + renameFile));
            }
            ++i;
        }
        this.reload();
    }

    public void reload() {
        log.info((Object)("reload:" + this.currentDir));
        this.openDirectory(this.currentDir);
        this.canvas.forceFocus();
    }

    public void renameFile() {
        RenameDialog dialog = new RenameDialog((IWorkbenchSite)this.self.getSite());
        dialog.setFiles(this.toSelectionFiles());
        dialog.open();
        int returncode = dialog.getReturnCode();
        if (returncode == 0) {
            this.reload();
        }
    }

    private File[] toSelectionFiles() {
        ThumbnailFigure[] figures = this.explorerFigure.getSelectionThumbnails();
        File[] file = new File[figures.length];
        int i = 0;
        while (i < file.length) {
            file[i] = figures[i].toFile();
            ++i;
        }
        return file;
    }

    private boolean isEnableFLVTool2() {
        File exe;
        String path = Akj_betasPlugin.getDefault().getPreferenceStore().getString("flvtool2_path");
        return path.endsWith("flvtool2.exe") && (exe = new File(path)).exists();
    }

    public void callFLVTool2() {
        File file;
        Runtime runtime = Runtime.getRuntime();
        String path = Akj_betasPlugin.getDefault().getPreferenceStore().getString("flvtool2_path");
        if (path.endsWith("flvtool2.exe") && (file = new File(path)).exists()) {
            String[] args = path.indexOf("akj_friends") != -1 ? new String[]{path, "-U", this.currentFile.getAbsolutePath()} : new String[]{path, "u", this.currentFile.getAbsolutePath()};
            try {
                WorkbenchWindow workbenchWindow = (WorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IProgressMonitor convertMonitor = workbenchWindow.getStatusLineManager().getProgressMonitor();
                Process p = runtime.exec(args);
                try {
                    p.waitFor();
                    convertMonitor.done();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void setExportBaseDir(FFMpegExplorerExecuter executer) {
        boolean isSame = Akj_betasPlugin.getDefault().getPreferenceStore().getBoolean("explorer.export_same_directory");
        String path = Akj_betasPlugin.getDefault().getPreferenceStore().getString("explorer.export_directory");
        if (!isSame && path.length() > 0) {
            executer.setExportBaseDir(new File(path));
        }
    }

    public void selectAllThumbnail() {
        Figure[] figures = this.explorerFigure.getChildren().toArray(new Figure[0]);
        int i = 0;
        while (i < figures.length) {
            if (figures[i] instanceof ThumbnailFigure) {
                ((ThumbnailFigure)figures[i]).setSelection(true);
            }
            ++i;
        }
    }

    public void selectBetween(File file1, File file2) {
        log.info((Object)("between:" + file1 + "," + file2));
        if (file1.getAbsolutePath().equals(file2.getAbsolutePath())) {
            return;
        }
        List list = this.explorerFigure.getChildren();
        int f1 = -1;
        int f2 = -1;
        int i = 0;
        while (i < list.size()) {
            if (list.get(i) instanceof ThumbnailFigure) {
                ThumbnailFigure th = (ThumbnailFigure)((Object)list.get(i));
                if (file1.getAbsolutePath().equals(th.toFile().getAbsolutePath())) {
                    f1 = i;
                } else if (file2.getAbsolutePath().equals(th.toFile().getAbsolutePath())) {
                    f2 = i;
                }
            }
            ++i;
        }
        if (f1 < 0 || f2 < 0) {
            log.warn((Object)"faild select");
        } else {
            log.info((Object)("f1=" + f1 + ",f2=" + f2));
        }
        if (f1 < f2) {
            i = f1 + 1;
            while (i <= f2) {
                ((ThumbnailFigure)((Object)list.get(i))).turnSelection();
                ++i;
            }
        } else {
            i = f1 - 1;
            while (i >= f2) {
                ((ThumbnailFigure)((Object)list.get(i))).turnSelection();
                --i;
            }
        }
    }

    public void playFile(File file) {
        log.info((Object)("playFile:" + file));
        boolean primaryFlowPlayer = Akj_betasPlugin.getDefault().getPreferenceStore().getBoolean("primary_flowplayer");
        if (primaryFlowPlayer) {
            this.playFlowPlayer(file);
        } else if (!FilePlayer.play(file)) {
            this.playFlowPlayer(file);
        }
    }

    public void playFlowPlayer(File file) {
        if (this.isFLVExtension(file)) {
            if (this.flowPlayerShell == null || this.flowPlayerShell.getShell().isDisposed()) {
                this.flowPlayerShell = new FlowPlayerShell(this.getSite().getShell());
            }
            this.flowPlayerShell.openFLVFile(file);
        }
    }

    public boolean isFLVExtension(File file) {
        return file.getName().toLowerCase().endsWith(".flv");
    }

    public void showConvertingStatus() {
        this.convertingDialog = new ConvertingMonitorDialog((IWorkbenchSite)this.self.getSite());
        this.convertingDialog.setCancelable(this);
        if (this.ffmpegExecuter != null) {
            log.info((Object)("" + this.executingIndex));
            this.convertingDialog.setFileList(this.ffmpegExecuter.getFileList());
            this.convertingDialog.selectFile(this.executingIndex);
        }
        this.convertingDialog.open();
    }

    public void openPrev() {
        if (this.oldPath != null) {
            this.openDirectory(this.oldPath);
        }
    }

    public void openDirectory(String path) {
        if (this.oldPath == null) {
            this.oldPath = this.currentDir;
        } else if (!this.currentDir.equals(this.oldPath)) {
            this.oldPath = this.currentDir;
        }
        this.clearList();
        if (path.endsWith("res")) {
            return;
        }
        long debug = System.currentTimeMillis();
        log.info((Object)("path:" + path));
        this.currentDir = path;
        this.updateExplorerPaths();
        File file = new File(path);
        this.initAssistantName(file);
        this.initFolder(file);
        this.initList(file);
        long listTime = (System.currentTimeMillis() - debug) / 1000L;
        System.out.println("init:" + listTime);
        this.updatePopupMenu(file);
        String flvaddmode = Akj_betasPlugin.getDefault().getPreferenceStore().getString("explorer.addextension");
        if (!this.isEveryFLVOK(file) && !flvaddmode.equals("add_never")) {
            int dialog_button = 0;
            if (flvaddmode.equals("add_dialog")) {
                MessageDialog dialog = new MessageDialog(this.getSite().getShell(), Messages.getString("confirm_rename"), null, Messages.getString("confirm_rename_message"), 2, new String[]{"OK", "Cancell"}, 0);
                dialog_button = dialog.open();
            }
            log.info((Object)("dialog:" + dialog_button));
            if (dialog_button == 0) {
                String[] flvs = this.getFLVFiles(file);
                int i = 0;
                while (i < flvs.length) {
                    if (!flvs[i].toLowerCase().endsWith(".flv")) {
                        File flv = new File(flvs[i]);
                        File newFile = new File(FileNameUtils.getChangedExtensionName(flv, "flv"));
                        boolean result = flv.renameTo(newFile);
                        log.info((Object)("result:" + result + " " + newFile));
                    }
                    ++i;
                }
                this.initList(file);
            }
        }
        FolderChecker checker = new FolderChecker(this.currentDir);
        checker.start();
    }

    public void updatePopupMenu(File file) {
    }

    public boolean isEveryFLVOK(File file) {
        String[] files = this.getFLVFiles(file);
        int i = 0;
        while (i < files.length) {
            if (!files[i].toLowerCase().endsWith(".flv")) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isFLVFile(File file) {
        if (file.isDirectory()) {
            return false;
        }
        if (file.length() < this.MIN_FLV_SIZE) {
            return false;
        }
        if (file.getName().toLowerCase().endsWith(".flv")) {
            return true;
        }
        if (file.getName().indexOf(".") != -1) {
            return false;
        }
        boolean b = this.flvChecker.checkFLV(file);
        if (b) {
            System.out.println(file.getAbsolutePath());
        }
        return b;
    }

    public String[] getFLVFiles(File baseDir) {
        String[] list = baseDir.list();
        ArrayList<File> array = new ArrayList<File>();
        int i = 0;
        while (i < list.length) {
            File file2 = new File(baseDir, list[i]);
            if (this.isFLVFile(file2)) {
                array.add(file2);
            }
            ++i;
        }
        File[] files = array.toArray(new File[0]);
        FLVListComparator comparator = new FLVListComparator();
        Arrays.sort(files, comparator);
        String[] paths = new String[files.length];
        int i2 = 0;
        while (i2 < paths.length) {
            paths[i2] = files[i2].getAbsolutePath();
            ++i2;
        }
        return paths;
    }

    public void clearList() {
        this.actionValueList.removeAll(this.actionValueList);
        this.rootFigure.removeAll();
        this.rootFigure.repaint();
    }

    public void initList(File file) {
        String[] flvfiles = this.getFLVFiles(file);
        this.explorerFigure = new Explorer();
        this.explorerFigure.setBackgroundColor(ColorConstants.white);
        this.explorerFigure.add((IFigure)new MoveUpPrevNextFigure("", moveUpPrevImage));
        this.explorerFigure.setLayoutManager(new CustomLayout(this.rootFigure));
        ImageLoader imageLoader = new ImageLoader();
        int i = 0;
        while (i < flvfiles.length) {
            File f = new File(flvfiles[i]);
            String name = this.trimExtension(f.getName());
            ThumbnailFigure th = new ThumbnailFigure(name, loadingImage);
            if (!f.getName().toLowerCase().endsWith(".flv")) {
                log.info((Object)"no extension");
                th.setHasExtension(false);
            }
            this.explorerFigure.add((IFigure)th);
            imageLoader.add(th, f);
            ++i;
        }
        String[] list = file.list();
        int i2 = 0;
        while (i2 < list.length) {
            if (new File(file, list[i2]).isDirectory()) {
                FolderFigure folder = new FolderFigure(list[i2], folderImage);
                this.explorerFigure.add((IFigure)folder);
            }
            ++i2;
        }
        this.rootFigure.add((IFigure)this.explorerFigure);
        Thread t = new Thread(imageLoader);
        t.start();
    }

    private String trimExtension(String name) {
        int e = name.toLowerCase().lastIndexOf(".flv");
        if (e != -1) {
            return name.substring(0, e);
        }
        return name;
    }

    private void initFolder(File file) {
        String[] list = file.list();
        ArrayList<String> array = new ArrayList<String>();
        int i = 0;
        while (i < list.length) {
            if (new File(file, list[i]).isDirectory()) {
                array.add(list[i]);
            }
            ++i;
        }
        this.folders = array.toArray(new String[0]);
    }

    private CCombo makeComboBox(Composite panel) {
        CCombo box = new CCombo(panel, 8);
        box.add("");
        int i = 0;
        while (i < this.folders.length) {
            box.add(this.folders[i]);
            ++i;
        }
        return box;
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ExplorerView.this.fillContextMenu(manager);
            }
        });
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
    }

    private void fillContextMenu(IMenuManager manager) {
    }

    private void fillLocalToolBar(IToolBarManager manager) {
    }

    public void openDirectory() {
        DirectoryDialog dialog = new DirectoryDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        String path = dialog.open();
        if (path != null) {
            this.openDirectory(path);
        }
    }

    public void setFocus() {
        this.canvas.forceFocus();
    }

    public void startExecute(File[] files) {
        this.getProgressMonitor().beginTask(Messages.getString("converting"), files.length);
        this.convert.setEnabled(false);
        this.enableseek.setEnabled(false);
        this.renameFile.setEnabled(false);
    }

    public void finishExecute() {
        this.ffmpegExecuter = null;
        this.convert.setEnabled(true);
        this.enableseek.setEnabled(true);
        this.renameFile.setEnabled(true);
    }

    public void executingFile(File file, int index) {
        log.info((Object)("executingFile:" + index));
        this.executingIndex = index;
        if (this.convertingDialog != null && this.convertingDialog.isOpened()) {
            log.info((Object)("update:" + this.executingIndex));
            this.convertingDialog.updateSelect(this.executingIndex);
        }
    }

    public IProgressMonitor getProgressMonitor() {
        WorkbenchWindow workbenchWindow = (WorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        return workbenchWindow.getStatusLineManager().getProgressMonitor();
    }

    public void cancel() {
        if (this.ffmpegExecuter != null) {
            this.ffmpegExecuter.cancel();
        }
    }

    public class ImageLoader
    implements Runnable {
        ArrayList list = new ArrayList();

        public void run() {
            Object[] figure_file = this.list.toArray();
            Display display = ExplorerView.this.getSite().getShell().getDisplay();
            boolean ffmpegAvailable = Akj_betasPlugin.getDefault().isFFMpegAvailable();
            int i = 0;
            while (i < figure_file.length) {
                Object[] th_file = (Object[])figure_file[i];
                ThumbnailFigure figure = (ThumbnailFigure)((Object)th_file[0]);
                Image img = null;
                img = ffmpegAvailable ? ThumbnailManager.loadThumbnail((File)th_file[1], noSupportImage) : noFFMpegImage;
                if (ExplorerView.this.getSite() != null && ExplorerView.this.getSite().getShell() != null) {
                    if (ExplorerView.this.getSite().getShell().getDisplay() != null) {
                        display.asyncExec((Runnable)new SetImage(img, figure));
                    } else {
                        log.warn((Object)"display null");
                    }
                }
                ++i;
            }
        }

        public void add(ThumbnailFigure figure, File file) {
            this.list.add(new Object[]{figure, file});
        }
    }

    public class SetImage
    implements Runnable {
        Image img;
        ThumbnailFigure figure;

        public SetImage(Image img, ThumbnailFigure figure) {
            this.img = img;
            this.figure = figure;
        }

        public void run() {
            this.figure.setImage(this.img);
        }
    }

    public class FLVFilter
    implements FilenameFilter {
        public boolean accept(File arg0, String arg1) {
            return arg1.toLowerCase().endsWith(".flv");
        }
    }

    public class MoveAction
    extends Thread {
        public void run() {
            ActionValues[] values = ExplorerView.this.actionValueList.toArray(new ActionValues[0]);
            int i = 0;
            while (i < values.length) {
                values[i].setEnabled(false);
                ++i;
            }
            i = 0;
            while (i < values.length) {
                this.execMove(values[i]);
                ++i;
            }
            ExplorerView.this.openDirectory(ExplorerView.this.currentDir);
        }

        private void execMove(ActionValues values) {
            File parent = values.getFile().getParentFile();
            String path = parent.getAbsolutePath();
            String dir = values.getNewDirectory();
            if (dir.length() > 0) {
                path = String.valueOf(path) + "\\" + dir;
            }
            path = String.valueOf(path) + "\\" + this.trim(values.getNewName());
            path = String.valueOf(path) + ".flv";
            if (!values.getFile().getAbsolutePath().equals(path)) {
                log.info((Object)("rename to:" + path));
                File renameFile = new File(path);
                File emptyName = ExplorerView.getEmptyFileName(renameFile);
                boolean result = values.getFile().renameTo(emptyName);
                if (!result) {
                    log.warn((Object)("rename faild:" + emptyName.getAbsolutePath()));
                }
            }
        }

        private String trim(String name) {
            if (name.toLowerCase().endsWith(".flv")) {
                name = name.substring(0, name.length() - 4);
            }
            return name;
        }
    }

    public class SettingMonitor
    implements Preferences.IPropertyChangeListener {
        public void propertyChange(Preferences.PropertyChangeEvent event) {
            log.info((Object)event.getProperty());
            if (event.getProperty().equals("explorer.paths")) {
                ExplorerView.this.updateExplorerPaths();
            } else if (event.getProperty().equals("ffmpeg_path")) {
                ExplorerView.this.ffmpegEnableChanged(Akj_betasPlugin.getDefault().getFFmpeg(), Akj_betasPlugin.getDefault().getPureFFmpeg());
                ExplorerView.this.reload();
            } else if (event.getProperty().equals("pure_ffmpeg_path")) {
                ExplorerView.this.ffmpegEnableChanged(Akj_betasPlugin.getDefault().getFFmpeg(), Akj_betasPlugin.getDefault().getPureFFmpeg());
                ExplorerView.this.reload();
            } else if (event.getProperty().equals("flvtool2_path")) {
                ExplorerView.this.enableseek.setEnabled(ExplorerView.this.isEnableFLVTool2());
            } else {
                String[] settins = new String[]{"avisetting.audio", "avisetting.video", "mpegsetting.audio", "wmvsetting.audio"};
                int i = 0;
                while (i < settins.length) {
                    if (event.getProperty().equals(settins[i])) {
                        ExplorerView.this.ffmpegEnableChanged(Akj_betasPlugin.getDefault().getFFmpeg(), Akj_betasPlugin.getDefault().getPureFFmpeg());
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    public class ExplorerPathChange
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            String dir = ExplorerView.this.directoryPaths.getItem(ExplorerView.this.directoryPaths.getSelectionIndex());
            ExplorerView.this.openDirectory(dir);
            ExplorerView.this.canvas.forceFocus();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    public class ExecExecuter
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new MoveAction());
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    public class MoveFLVToDir
    implements SelectionListener {
        private String dir;

        public MoveFLVToDir(String path) {
            this.dir = path;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            ExplorerView.this.moveDirectory(this.dir);
        }
    }

    public class DoneProgressMonitor
    implements Runnable {
        IProgressMonitor monitor;

        public DoneProgressMonitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public void run() {
            this.monitor.done();
        }
    }

    public class SetProgressMonitor
    implements Runnable {
        IProgressMonitor monitor;
        String text;
        int step;

        public SetProgressMonitor(IProgressMonitor monitor, String text, int step) {
            this.monitor = monitor;
            this.text = text;
            this.step = step;
        }

        public void run() {
            this.monitor.beginTask(this.text, this.step);
        }
    }

    public class MoveUpPrevNextFigure
    extends Panel {
        Label titleLabel;
        Label imageLabel;

        public void setImage(Image img) {
            if (img != null) {
                this.imageLabel.setIcon(img);
            } else {
                log.info((Object)("setimage:" + this.getLabel()));
            }
        }

        public String getLabel() {
            return this.titleLabel.getText();
        }

        public void setLabel(String text) {
            this.titleLabel.setText(text);
        }

        public MoveUpPrevNextFigure(String label, Image img) {
            this.setLayoutManager((LayoutManager)new FlowLayout(false));
            this.imageLabel = new Label(img);
            this.imageLabel.setToolTip((IFigure)new Label(label));
            this.add((IFigure)this.imageLabel);
            this.titleLabel = new Label(label);
            this.add((IFigure)this.titleLabel);
            this.imageLabel.setToolTip((IFigure)new Label(Messages.getString("moveup_directory")));
            this.setBorder((Border)new MarginBorder(2));
            this.addMouseListener(new MouseListener(){

                public void mousePressed(MouseEvent arg0) {
                }

                public void mouseReleased(MouseEvent arg0) {
                }

                public void mouseDoubleClicked(MouseEvent event) {
                    if (event.y < 60) {
                        String path = new File(ExplorerView.this.currentDir).getParent();
                        log.info((Object)path);
                        ExplorerView.this.openDirectory(path);
                    } else if (event.x < 80) {
                        ExplorerView.this.openPrev();
                    } else {
                        ExplorerView.this.openPrev();
                    }
                }
            });
        }
    }

    public class FolderChecker
    extends Thread {
        private String targetDir;

        public FolderChecker(String dir) {
            this.targetDir = dir;
        }

        public void run() {
            List list = ExplorerView.this.explorerFigure.getChildren();
            ArrayList<String> dirNames = new ArrayList<String>();
            int i = 0;
            while (i < list.size()) {
                if (!this.targetDir.equals(ExplorerView.this.currentDir)) break;
                if (list.get(i) instanceof FolderFigure) {
                    FolderFigure ffigure = (FolderFigure)((Object)list.get(i));
                    String dirName = ffigure.realName;
                    File dir = new File(String.valueOf(this.targetDir) + "\\" + dirName);
                    String[] first = dir.list();
                    int j = 0;
                    while (j < first.length) {
                        if (first[j].toLowerCase().endsWith(".flv") && new File(dir, first[j]).length() > 1024L) {
                            Image img = ThumbnailManager.loadThumbnail(new File(dir, first[j]), noFFMpegImage);
                            Image thumb = ImageUtils.createThumbnail(img, 120, 90);
                            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new SetLabelExec(ffigure.getThumnailLabel(), thumb));
                            dirNames.add(dirName);
                            break;
                        }
                        ++j;
                    }
                }
                ++i;
            }
            PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)new UpdateMoveDirsMenu(dirNames.toArray(new String[0])));
            log.info((Object)("done,folderCheck:" + this.targetDir));
        }
    }

    public class UpdateMoveDirsMenu
    extends Thread {
        private String[] dirs;

        public UpdateMoveDirsMenu(String[] dirs) {
            this.dirs = dirs;
        }

        public void run() {
            ExplorerView.this.updateMoveDirsMenus(this.dirs);
        }
    }

    public class SetLabelExec
    extends Thread {
        private Label label;
        private Image icon;

        public SetLabelExec(Label label, Image icon) {
            this.label = label;
            this.icon = icon;
        }

        public void run() {
            this.label.setIcon(this.icon);
        }
    }

    public class FolderFigure
    extends Panel {
        private String realName;
        Label titleLabel;
        Label imageLabel;
        private Label thumnailLabel;

        public Label getThumnailLabel() {
            return this.thumnailLabel;
        }

        public void setThumnailLabel(Label thumnailLabel) {
            this.thumnailLabel = thumnailLabel;
        }

        public void setSelection(boolean bool) {
        }

        public void setImage(Image img) {
            if (img != null) {
                this.imageLabel.setIcon(img);
            } else {
                log.info((Object)("setimage:" + this.getLabel()));
            }
        }

        public String getLabel() {
            return this.titleLabel.getText();
        }

        public void setLabel(String text) {
            this.titleLabel.setText(text);
        }

        public FolderFigure(String label, Image img) {
            this.realName = label;
            this.setLayoutManager((LayoutManager)new FlowLayout(false));
            this.imageLabel = new Label(img);
            this.imageLabel.setToolTip((IFigure)new Label(label));
            this.add((IFigure)this.imageLabel);
            this.titleLabel = new Label(this.trimTitle(label));
            this.add((IFigure)this.titleLabel);
            this.thumnailLabel = new Label();
            this.thumnailLabel.setBorder((Border)new MarginBorder(1));
            this.imageLabel.setLayoutManager((LayoutManager)new StackLayout());
            this.imageLabel.add((IFigure)this.thumnailLabel);
            this.setBorder((Border)new MarginBorder(2));
            this.addMouseListener(new MouseListener(){

                public void mousePressed(MouseEvent arg0) {
                }

                public void mouseReleased(MouseEvent arg0) {
                    ExplorerView.this.currentFile = new File(ExplorerView.this.currentDir, FolderFigure.this.realName);
                }

                public void mouseDoubleClicked(MouseEvent arg0) {
                    File dir = new File(ExplorerView.this.currentDir, FolderFigure.this.realName);
                    ExplorerView.this.openDirectory(dir.getAbsolutePath());
                }
            });
        }

        public String trimTitle(String name) {
            return name.substring(0, Math.min(16, name.length()));
        }
    }

    public class Explorer
    extends Panel {
        public ThumbnailFigure[] getSelectionThumbnails() {
            ArrayList<Figure> list = new ArrayList<Figure>();
            Figure[] figures = this.getChildren().toArray(new Figure[0]);
            int i = 0;
            while (i < figures.length) {
                if (figures[i] instanceof ThumbnailFigure && ((ThumbnailFigure)figures[i]).isSelection()) {
                    list.add(figures[i]);
                }
                ++i;
            }
            return list.toArray(new ThumbnailFigure[0]);
        }
    }

    public class ThumbnailFigure
    extends Panel {
        Label titleLabel;
        Label imageLabel;
        boolean hasExtension = true;
        boolean selection;
        LineBorder lineBorder;
        MarginBorder marginBorder;
        private String realName;

        public String trimTitle(String name) {
            return name.substring(0, Math.min(16, name.length()));
        }

        public void setSelection(boolean bool) {
            if (this.selection != bool) {
                this.selection = bool;
                if (this.selection) {
                    this.setBorder((Border)this.lineBorder);
                } else {
                    this.setBorder((Border)this.marginBorder);
                }
                this.repaint();
            }
        }

        public boolean isSelection() {
            return this.selection;
        }

        public void turnSelection() {
            this.setSelection(!this.selection);
        }

        public void setImage(Image img) {
            if (img != null) {
                this.imageLabel.setIcon(img);
            } else {
                log.info((Object)("setimage:" + this.getLabel()));
            }
        }

        public String getLabel() {
            return this.titleLabel.getText();
        }

        public void setLabel(String text) {
            this.titleLabel.setText(text);
        }

        public File toFile() {
            if (this.isHasExtension()) {
                return new File(ExplorerView.this.currentDir, String.valueOf(this.realName) + ".flv");
            }
            return new File(ExplorerView.this.currentDir, this.realName);
        }

        public ThumbnailFigure(String label, Image img) {
            this.realName = label;
            this.setLayoutManager((LayoutManager)new FlowLayout(false));
            this.imageLabel = new Label(img);
            this.imageLabel.setToolTip((IFigure)new Label(this.toTooltip(label)));
            this.add((IFigure)this.imageLabel);
            this.titleLabel = new Label(this.trimTitle(label));
            this.add((IFigure)this.titleLabel);
            this.addMouseListener(new MouseListener(){

                public void mousePressed(MouseEvent mouseEvent) {
                    File selectFirst = ExplorerView.this.currentFile;
                    ExplorerView.this.currentFile = ThumbnailFigure.this.toFile();
                    log.trace((Object)("currentFile:" + ExplorerView.this.currentFile));
                    ExplorerView.this.enableseek.setEnabled(ExplorerView.this.isEnableFLVTool2());
                    if (mouseEvent.button == 1) {
                        if ((mouseEvent.getState() & 0x40000) > 0) {
                            ThumbnailFigure.this.turnSelection();
                        } else if ((mouseEvent.getState() & 0x20000) > 0) {
                            ExplorerView.this.selectBetween(selectFirst, ExplorerView.this.currentFile);
                        } else {
                            ThumbnailFigure.this.unselectAll();
                            ThumbnailFigure.this.turnSelection();
                        }
                    } else if (mouseEvent.button == 3) {
                        ThumbnailFigure.this.setSelection(true);
                    }
                }

                public void mouseReleased(MouseEvent arg0) {
                }

                public void mouseDoubleClicked(MouseEvent arg0) {
                    ExplorerView.this.playFile(ThumbnailFigure.this.toFile());
                }
            });
            this.lineBorder = new LineBorder();
            this.lineBorder.setColor(ColorConstants.green);
            this.lineBorder.setWidth(2);
            this.marginBorder = new MarginBorder(2);
            this.setBorder((Border)this.marginBorder);
        }

        public String toTooltip(String path) {
            String ext = "";
            if (this.hasExtension) {
                ext = ".flv";
            }
            File file = new File(ExplorerView.this.currentDir, String.valueOf(path) + ext);
            int kbyte = (int)(file.length() / 1024L);
            String label = path;
            label = String.valueOf(label) + "\n\n" + kbyte + " KBytes\n";
            label = String.valueOf(label) + new Date(file.lastModified()).toLocaleString();
            return label;
        }

        public void unselectAll() {
            Figure[] figures = this.getParent().getChildren().toArray(new Figure[0]);
            int i = 0;
            while (i < figures.length) {
                if (figures[i] instanceof ThumbnailFigure && figures[i] != this) {
                    ((ThumbnailFigure)figures[i]).setSelection(false);
                }
                ++i;
            }
        }

        public void selectAll() {
            Figure[] figures = this.getParent().getChildren().toArray(new Figure[0]);
            int i = 0;
            while (i < figures.length) {
                if (figures[i] instanceof ThumbnailFigure) {
                    ((ThumbnailFigure)figures[i]).setSelection(true);
                }
                ++i;
            }
        }

        public boolean isHasExtension() {
            return this.hasExtension;
        }

        public void setHasExtension(boolean hasExtension) {
            this.hasExtension = hasExtension;
        }
    }

    public class CustomLayout
    implements LayoutManager {
        Figure control;

        public CustomLayout(Figure control) {
            this.control = control;
        }

        public Object getConstraint(IFigure child) {
            return null;
        }

        public Dimension getMinimumSize(IFigure container, int wHint, int hHint) {
            return this.getPreferredSize(container, wHint, hHint);
        }

        public Dimension getPreferredSize(IFigure container, int wHint, int hHint) {
            this.layout(container);
            Figure[] figures = container.getChildren().toArray(new Figure[0]);
            int my = 0;
            int i = 0;
            while (i < figures.length) {
                my = Math.max(my, figures[i].getLocation().y + figures[i].getSize().height);
                ++i;
            }
            return new Dimension(this.control.getClientArea().x, my);
        }

        public void invalidate() {
        }

        public void layout(IFigure container) {
            Figure[] figures = container.getChildren().toArray(new Figure[0]);
            int space = 1;
            int dx = 0;
            int dy = 0;
            int preHeight = 0;
            if (this.control.getSize().width == 0 && this.control.getSize().height == 0) {
                return;
            }
            int i = 0;
            while (i < figures.length) {
                Dimension d = figures[i].getPreferredSize();
                if (dx == 0) {
                    figures[i].setLocation(new Point(dx, dy));
                    figures[i].setSize(d.width, d.height);
                    dx += d.width + space;
                    preHeight = d.height + space;
                } else {
                    int sc = 0;
                    if (!ExplorerView.this.canvas.getVerticalBar().isEnabled()) {
                        sc = 16;
                    }
                    if (dx + d.width > this.control.getClientArea().width - sc) {
                        dx = 0;
                        dy += preHeight;
                    }
                    figures[i].setLocation(new Point(dx, dy));
                    figures[i].setSize(d.width, d.height);
                    dx += d.width + space;
                    preHeight = d.height + space;
                }
                ++i;
            }
            int my = 0;
            int i2 = 0;
            while (i2 < figures.length) {
                my = Math.max(my, figures[i2].getLocation().y + figures[i2].getSize().height);
                ++i2;
            }
        }

        public void remove(IFigure child) {
        }

        public void setConstraint(IFigure child, Object constraint) {
        }
    }

    public class ResizeMonitor
    implements ControlListener {
        Figure figure;

        public ResizeMonitor(Figure figure) {
            this.figure = figure;
        }

        public void controlMoved(ControlEvent e) {
        }

        public void controlResized(ControlEvent e) {
            this.figure.revalidate();
        }
    }

    public class FLVListComparator
    implements Comparator {
        public int compare(Object arg0, Object arg1) {
            File file1 = (File)arg0;
            File file2 = (File)arg1;
            if (ExplorerView.this.sortType == 0) {
                return file1.getName().compareTo(file2.getName());
            }
            if (ExplorerView.this.sortType == 1) {
                return file1.getName().compareTo(file2.getName()) * -1;
            }
            if (ExplorerView.this.sortType == 2) {
                long v = file1.lastModified() - file2.lastModified();
                if (v > 1L) {
                    return -1;
                }
                if (v < 1L) {
                    return 1;
                }
                return 0;
            }
            if (ExplorerView.this.sortType == 3) {
                long v = file1.lastModified() - file2.lastModified();
                if (v > 1L) {
                    return 1;
                }
                if (v < 1L) {
                    return -1;
                }
                return 0;
            }
            if (ExplorerView.this.sortType == 4) {
                long v = file1.length() - file2.length();
                if (v > 1L) {
                    return -1;
                }
                if (v < 1L) {
                    return 1;
                }
                return 0;
            }
            if (ExplorerView.this.sortType == 5) {
                long v = file1.length() - file2.length();
                if (v > 1L) {
                    return 1;
                }
                if (v < 1L) {
                    return -1;
                }
                return 0;
            }
            return 0;
        }
    }

    public class ActionValues
    implements org.eclipse.swt.events.MouseListener {
        private File file;
        private CCombo combo;
        private CCombo text;

        public File getFile() {
            return this.file;
        }

        public String getNewName() {
            return this.text.getText();
        }

        public String getNewDirectory() {
            return this.combo.getText();
        }

        public void setEnabled(boolean bool) {
            this.combo.setEnabled(bool);
            this.text.setEnabled(bool);
        }

        public ActionValues(File file, CCombo combo, CCombo text) {
            this.file = file;
            this.combo = combo;
            this.text = text;
        }

        public void mouseDoubleClick(org.eclipse.swt.events.MouseEvent e) {
            log.warn((Object)"mouse");
        }

        public void mouseDown(org.eclipse.swt.events.MouseEvent e) {
        }

        public void mouseUp(org.eclipse.swt.events.MouseEvent e) {
        }
    }

    public class DropOpen
    implements DropFileListener {
        public void dropFile(String[] path) {
            block2: {
                int i = 0;
                if (i >= path.length) break block2;
                File file = new File(path[i]);
                if (file.isFile()) {
                    ExplorerView.this.openDirectory(file.getParentFile().getAbsolutePath());
                } else {
                    ExplorerView.this.openDirectory(file.getAbsolutePath());
                }
            }
        }
    }

    public class YoutubeDownloaded
    implements YoutubeDLListener {
        public void downloaded(String path) {
            ExplorerView.this.reload();
        }
    }
}

