/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.psp;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import jp.sourceforge.akjrcp.akj_betas.Akj_betasPlugin;
import jp.sourceforge.akjrcp.akj_betas.Messages;
import jp.sourceforge.akjrcp.flvtools.explorer.ThumbnailManager;
import jp.sourceforge.akjrcp.psp.PSPIOCommand;
import jp.sourceforge.akjrcp.psp.PSPUtils;
import jp.sourceforge.akjrcp.psp.commands.AbstractIOCommand;
import jp.sourceforge.akjrcp.psp.commands.PSPCopyCommand;
import jp.sourceforge.akjrcp.psp.commands.PSPDeleteCommand;
import jp.sourceforge.akjrcp.psp.commands.PSPMoveCommand;
import jp.sourceforge.akjrcp.ui.DirectoryList;
import jp.sourceforge.akjrcp.util.FileNameUtils;
import jp.sourceforge.akjrcp.util.ProgressMonitorUtils;
import jp.sourceforge.akjrcp.util.ShowStatusProcessPrinter;
import jp.sourceforge.akjrcp.util.image.ImageUtils;
import org.apache.commons.io.FileSystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class PSPSyncView
extends ViewPart {
    public static Log log = LogFactory.getLog(PSPSyncView.class);
    public static final String ID = PSPSyncView.class.getName();
    protected static Image noImage = new Image((Device)Display.getCurrent(), DirectoryList.class.getClassLoader().getResourceAsStream("jp/sourceforge/akjrcp/psp/resource/" + Messages.getString("pspsync.no_image")));
    private Figure hdFigure;
    private Figure hdListFigure;
    private FigureCanvas hdCanvas;
    private Figure pspFigure;
    private Figure pspListFigure;
    private FigureCanvas pspCanvas;
    private boolean monitorPSPDirectory = true;
    private boolean monitorHDDirectory = true;
    private int pspMonitorSleeptime = 3000;
    private int hdMonitorSleeptime = 5000;
    private File hdDir;
    private File[] hdMP4Files;
    private File pspDir;
    private File[] pspMP4Files;
    private int pspDirectoryStatus;
    private DirectoryInfomation hdInfo;
    private DirectoryInfomation pspInfo;
    private CCombo directoryPaths;
    private Button pspDirPath;
    private String lastPSPDirectoryInfo = "";
    private String lastHDDirectoryInfo = "";
    public static final int PSP_VIDEO_EXIST = 1;
    public static final int PSP_NOTFOUND = 0;
    public static final int PSP_VIDEO_NOTFOUND = 2;
    public static final int ACTION_NONE = 0;
    public static final int ACTION_COPY = 1;
    public static final int ACTION_MOVE = 2;
    public static final int ACTION_COPY_OVERWRITE = 3;
    public static final int ACTION_MOVE_OVERWRITE = 4;
    public static final int ACTION_DELETE = 5;
    public static final String LABEL_ACTION_NONE = "";
    public static final String LABEL_ACTION_COPY = Messages.getString("pspsync.action_copy");
    public static final String LABEL_ACTION_MOVE = Messages.getString("pspsync.action_move");
    public static final String LABEL_ACTION_COPY_OVERWRITE = Messages.getString("pspsync.action_copy_overwrite");
    public static final String LABEL_ACTION_MOVE_OVERWRITE = Messages.getString("pspsync.action_move_overwrite");
    public static final String LABEL_ACTION_DELETE = Messages.getString("pspsync.action_delete");
    public static final String LABEL_ACTION_PLAY = Messages.getString("pspsync.action_play");
    public static final String LABEL_ACTION_OPEN = Messages.getString("pspsync.action_open");
    private MovieActionPopup hdMovieActionPopup;
    private MovieActionPopup pspMovieActionPopup;
    ExplorerPathChange explorerPathChange;
    private Button syncButton;
    boolean executing;
    PSPIOCommand currentCommand;
    IProgressMonitor progressMonitor;

    public boolean makeThumb() {
        return false;
    }

    public void updateSelection() {
        this.updateDirectoryInfo();
        this.updateSyncButton();
    }

    public void updateSyncButton() {
        boolean enabled = false;
        MP4ThumbnailFigure[] hdFigures = this.getHDMP4Figure();
        int i = 0;
        while (i < hdFigures.length) {
            if (hdFigures[i].isSelection() && hdFigures[i].getAction() != 0) {
                enabled = true;
                break;
            }
            ++i;
        }
        MP4ThumbnailFigure[] pspFigures = this.getPSPMP4Figures();
        int i2 = 0;
        while (i2 < pspFigures.length) {
            if (pspFigures[i2].isSelection() && pspFigures[i2].getAction() != 0) {
                enabled = true;
                break;
            }
            ++i2;
        }
        if (this.hdInfo.isOverSize()) {
            enabled = false;
        }
        if (this.pspInfo.isOverSize()) {
            enabled = false;
        }
        if (!this.commandAvailable(this.hdInfo.getFreeSpace() * 1024L, this.pspInfo.getFreeSpace() * 1024L, this.getCommands())) {
            enabled = false;
        }
        if (!this.syncButton.isDisposed()) {
            this.syncButton.setEnabled(enabled);
        }
    }

    public PSPIOCommand[] getCommands() {
        MP4ThumbnailFigure[] hdFigures = this.getHDMP4Figure();
        MP4ThumbnailFigure[] pspFigures = this.getPSPMP4Figures();
        ArrayList<PSPIOCommand> commandList = new ArrayList<PSPIOCommand>();
        int i = 0;
        while (i < hdFigures.length) {
            if (hdFigures[i].isSelection() && hdFigures[i].getAction() != 0) {
                commandList.add(this.toCommand(hdFigures[i]));
            }
            ++i;
        }
        i = 0;
        while (i < pspFigures.length) {
            if (pspFigures[i].isSelection() && pspFigures[i].getAction() != 0) {
                commandList.add(this.toCommand(pspFigures[i]));
            }
            ++i;
        }
        return commandList.toArray(new PSPIOCommand[commandList.size()]);
    }

    public PSPIOCommand toCommand(MP4ThumbnailFigure figure) {
        if (figure.isSelection() && figure.getAction() != 0) {
            File toDir = figure.isOnHD() ? this.pspDir : this.hdDir;
            AbstractIOCommand command = null;
            if (figure.getAction() == 1) {
                command = new PSPCopyCommand(figure.getMp4File(), new File(toDir, figure.getMp4File().getName()), false);
            } else if (figure.getAction() == 2) {
                command = new PSPMoveCommand(figure.getMp4File(), new File(toDir, figure.getMp4File().getName()), false);
            } else if (figure.getAction() == 3) {
                command = new PSPCopyCommand(figure.getMp4File(), new File(toDir, figure.getMp4File().getName()), true);
            } else if (figure.getAction() == 4) {
                command = new PSPMoveCommand(figure.getMp4File(), new File(toDir, figure.getMp4File().getName()), true);
            } else if (figure.getAction() == 5) {
                command = new PSPDeleteCommand(figure.getMp4File());
            }
            if (command != null) {
                if (figure.isOnHD()) {
                    command.setPSPSrc(false);
                } else {
                    command.setPSPSrc(true);
                }
                return command;
            }
            log.warn((Object)(LABEL_ACTION_NONE + figure.getAction()));
            return null;
        }
        return null;
    }

    public boolean commandAvailable(long freeHD, long freePSP, PSPIOCommand[] commands) {
        ArrayList<PSPIOCommand> arrayList = new ArrayList<PSPIOCommand>();
        int i = 0;
        while (i < commands.length) {
            arrayList.add(commands[i]);
            ++i;
        }
        while (arrayList.size() > 0) {
            boolean excused = false;
            int i2 = 0;
            while (i2 < arrayList.size()) {
                PSPIOCommand command;
                long space = (command = (PSPIOCommand)arrayList.get(i2)).isPSPSrc() ? freeHD : freePSP;
                if (this.availableCommand(command, space)) {
                    excused = true;
                    arrayList.remove(command);
                    break;
                }
                ++i2;
            }
            if (excused) continue;
            return false;
        }
        return true;
    }

    private boolean availableCommand(PSPIOCommand command, long destSpace) {
        if (command instanceof PSPDeleteCommand) {
            return true;
        }
        if (((AbstractIOCommand)command).isOverwrite()) {
            return destSpace > command.getSrcFile().length() - command.getDestFile().length();
        }
        return destSpace > command.getSrcFile().length();
    }

    public void unselectPSPFile(String name) {
        MP4ThumbnailFigure[] pspFigures = this.getPSPMP4Figures();
        int i = 0;
        while (i < pspFigures.length) {
            if (pspFigures[i].isSelection() && pspFigures[i].getMp4File().getName().toLowerCase().equals(name.toLowerCase())) {
                pspFigures[i].setSelection(false);
                this.updateDirectoryInfo();
                break;
            }
            ++i;
        }
    }

    public void unselectHdFile(String name) {
        MP4ThumbnailFigure[] hdFigures = this.getHDMP4Figure();
        int i = 0;
        while (i < hdFigures.length) {
            if (hdFigures[i].isSelection() && hdFigures[i].getMp4File().getName().toLowerCase().equals(name.toLowerCase())) {
                hdFigures[i].setSelection(false);
                this.updateDirectoryInfo();
                break;
            }
            ++i;
        }
    }

    public void updateDirectoryInfo() {
        if (this.hdDir == null || this.pspDir == null) {
            return;
        }
        long hdAdd = 0L;
        long pspAdd = 0L;
        MP4ThumbnailFigure[] hdFigures = this.getHDMP4Figure();
        int i = 0;
        while (i < hdFigures.length) {
            if (hdFigures[i].isSelection()) {
                switch (hdFigures[i].getAction()) {
                    case 1: {
                        pspAdd += hdFigures[i].getFileSize();
                        break;
                    }
                    case 2: {
                        pspAdd += hdFigures[i].getFileSize();
                        hdAdd -= hdFigures[i].getFileSize();
                        break;
                    }
                    case 3: {
                        pspAdd += hdFigures[i].getFileSize();
                        pspAdd -= this.getOverwritedFile(hdFigures[i].getMp4File(), this.pspMP4Files).length();
                        break;
                    }
                    case 4: {
                        pspAdd += hdFigures[i].getFileSize();
                        hdAdd -= hdFigures[i].getFileSize();
                        pspAdd -= this.getOverwritedFile(hdFigures[i].getMp4File(), this.pspMP4Files).length();
                        break;
                    }
                    case 5: {
                        hdAdd -= hdFigures[i].getFileSize();
                    }
                }
            }
            ++i;
        }
        MP4ThumbnailFigure[] pspFigures = this.getPSPMP4Figures();
        int i2 = 0;
        while (i2 < pspFigures.length) {
            if (pspFigures[i2].isSelection()) {
                switch (pspFigures[i2].getAction()) {
                    case 1: {
                        hdAdd += pspFigures[i2].getFileSize();
                        break;
                    }
                    case 2: {
                        hdAdd += pspFigures[i2].getFileSize();
                        pspAdd -= pspFigures[i2].getFileSize();
                        break;
                    }
                    case 3: {
                        hdAdd += pspFigures[i2].getFileSize();
                        hdAdd -= this.getOverwritedFile(pspFigures[i2].getMp4File(), this.hdMP4Files).length();
                        break;
                    }
                    case 4: {
                        hdAdd += pspFigures[i2].getFileSize();
                        pspAdd -= pspFigures[i2].getFileSize();
                        hdAdd -= this.getOverwritedFile(pspFigures[i2].getMp4File(), this.hdMP4Files).length();
                        break;
                    }
                    case 5: {
                        pspAdd -= pspFigures[i2].getFileSize();
                    }
                }
            }
            ++i2;
        }
        this.hdInfo.setAdditionalSpace(hdAdd);
        this.pspInfo.setAdditionalSpace(pspAdd);
    }

    public File getOverwritedFile(File file, File[] list) {
        int i = 0;
        while (i < list.length) {
            if (file.getName().toLowerCase().equals(list[i].getName().toLowerCase())) {
                return list[i];
            }
            ++i;
        }
        return null;
    }

    public void openPSPFolder() {
        if (this.pspDir == null) {
            return;
        }
        Runtime r = Runtime.getRuntime();
        try {
            r.exec(new String[]{"explorer", this.pspDir.getAbsolutePath()});
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(2, true));
        this.syncButton = new Button(parent, 0);
        this.syncButton.setText(Messages.getString("pspsync.exec"));
        GridData gd = new GridData();
        gd.heightHint = 40;
        gd.horizontalSpan = 2;
        gd.horizontalAlignment = 0x1000000;
        gd.minimumWidth = 300;
        gd.grabExcessHorizontalSpace = true;
        this.syncButton.setLayoutData((Object)gd);
        this.syncButton.setEnabled(false);
        this.syncButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (PSPSyncView.this.executing) {
                    log.info((Object)"call ancel");
                    PSPSyncView.this.cancel();
                } else {
                    log.info((Object)"call sync");
                    PSPSyncView.this.sync();
                }
            }
        });
        this.directoryPaths = new CCombo(parent, 8);
        this.explorerPathChange = new ExplorerPathChange();
        this.directoryPaths.setLayoutData((Object)new GridData(768));
        this.pspDirPath = new Button(parent, 0);
        this.pspDirPath.setLayoutData((Object)new GridData(768));
        this.pspDirPath.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PSPSyncView.this.openPSPFolder();
            }
        });
        this.hdInfo = new DirectoryInfomation(parent, 2048);
        this.hdInfo.setLayoutData(new GridData(768));
        this.pspInfo = new DirectoryInfomation(parent, 2048);
        this.pspInfo.setLayoutData(new GridData(768));
        Composite hdComposite = new Composite(parent, 2048);
        hdComposite.setLayoutData((Object)new GridData(1808));
        hdComposite.setLayout((Layout)new FillLayout());
        this.hdCanvas = new FigureCanvas(hdComposite);
        this.hdCanvas.addMouseListener(new org.eclipse.swt.events.MouseListener(){

            public void mouseDoubleClick(org.eclipse.swt.events.MouseEvent e) {
            }

            public void mouseDown(org.eclipse.swt.events.MouseEvent e) {
                PSPSyncView.this.hdMovieActionPopup.setCopyEnabled(false);
                PSPSyncView.this.hdMovieActionPopup.setMoveEnabled(false);
                PSPSyncView.this.hdMovieActionPopup.setCopyOverwriteEnabled(false);
                PSPSyncView.this.hdMovieActionPopup.setMoveOverwriteEnabled(false);
                PSPSyncView.this.hdMovieActionPopup.setDeleteEnabled(false);
                PSPSyncView.this.hdMovieActionPopup.setPlayEnabled(false);
                if (PSPSyncView.this.hdDir != null && PSPSyncView.this.hdDir.exists()) {
                    PSPSyncView.this.hdMovieActionPopup.setOpenEnabled(true);
                } else {
                    PSPSyncView.this.hdMovieActionPopup.setOpenEnabled(false);
                }
            }

            public void mouseUp(org.eclipse.swt.events.MouseEvent e) {
            }
        });
        this.hdFigure = new Figure();
        this.hdCanvas.setContents((IFigure)this.hdFigure);
        this.hdFigure.setLayoutManager((LayoutManager)new StackLayout());
        this.hdCanvas.addControlListener((ControlListener)new ResizeMonitor(this.hdFigure));
        this.hdMovieActionPopup = new MovieActionPopup((Control)this.hdCanvas);
        this.hdMovieActionPopup.setHdDirectory(true);
        this.hdCanvas.setMenu(this.hdMovieActionPopup.getRootMenu());
        Composite pspComposite = new Composite(parent, 2048);
        pspComposite.setLayoutData((Object)new GridData(1808));
        pspComposite.setLayout((Layout)new FillLayout());
        this.pspCanvas = new FigureCanvas(pspComposite);
        this.pspCanvas.addMouseListener(new org.eclipse.swt.events.MouseListener(){

            public void mouseDoubleClick(org.eclipse.swt.events.MouseEvent e) {
            }

            public void mouseDown(org.eclipse.swt.events.MouseEvent e) {
                PSPSyncView.this.pspMovieActionPopup.setCopyEnabled(false);
                PSPSyncView.this.pspMovieActionPopup.setMoveEnabled(false);
                PSPSyncView.this.pspMovieActionPopup.setCopyOverwriteEnabled(false);
                PSPSyncView.this.pspMovieActionPopup.setMoveOverwriteEnabled(false);
                PSPSyncView.this.pspMovieActionPopup.setDeleteEnabled(false);
                PSPSyncView.this.pspMovieActionPopup.setPlayEnabled(false);
                if (PSPSyncView.this.pspDir != null && PSPSyncView.this.pspDir.exists()) {
                    PSPSyncView.this.pspMovieActionPopup.setOpenEnabled(true);
                } else {
                    PSPSyncView.this.pspMovieActionPopup.setOpenEnabled(false);
                }
            }

            public void mouseUp(org.eclipse.swt.events.MouseEvent e) {
            }
        });
        this.pspFigure = new Figure();
        this.pspCanvas.setContents((IFigure)this.pspFigure);
        this.pspFigure.setLayoutManager((LayoutManager)new StackLayout());
        this.pspCanvas.addControlListener((ControlListener)new ResizeMonitor(this.pspFigure));
        this.pspMovieActionPopup = new MovieActionPopup((Control)this.pspCanvas);
        this.pspMovieActionPopup.setHdDirectory(false);
        this.pspCanvas.setMenu(this.pspMovieActionPopup.getRootMenu());
        new AutoPSPVideoDirectoryOpener().start();
        this.updateExplorerPaths();
        this.openHDDirectory(new File(this.directoryPaths.getItem(this.directoryPaths.getSelectionIndex())));
        Akj_betasPlugin.getDefault().getPluginPreferences().addPropertyChangeListener((Preferences.IPropertyChangeListener)new SettingMonitor());
        new AutoHDDirectoryOpener().start();
    }

    public boolean isPSPDirectoryAvailable() {
        return this.pspDir != null;
    }

    public boolean isHDDirectoryAvailable() {
        return this.hdDir != null;
    }

    public MP4ThumbnailFigure findPSPFigure(File mp4file) {
        MP4ThumbnailFigure ret = null;
        MP4ThumbnailFigure[] figures = this.getPSPMP4Figures();
        int i = 0;
        while (i < figures.length) {
            if (figures[i].getMp4File().getAbsolutePath().toLowerCase().equals(mp4file.getAbsolutePath().toLowerCase())) {
                ret = figures[i];
                break;
            }
            ++i;
        }
        return ret;
    }

    public MP4ThumbnailFigure findHDFigure(File mp4file) {
        MP4ThumbnailFigure ret = null;
        MP4ThumbnailFigure[] figures = this.getHDMP4Figure();
        int i = 0;
        while (i < figures.length) {
            if (figures[i].getMp4File().getAbsolutePath().toLowerCase().equals(mp4file.getAbsolutePath().toLowerCase())) {
                ret = figures[i];
                break;
            }
            ++i;
        }
        return ret;
    }

    public void updatePSPDir(File dir, boolean keepselect) {
        if (dir == null || !dir.exists()) {
            this.pspDir = null;
            this.pspMP4Files = null;
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new UpdatePSPDir(null));
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new SetFreeSpace(null, this.pspInfo));
        } else {
            File videoDir = new File(dir, "VIDEO");
            if (!videoDir.exists()) {
                this.pspDir = null;
                this.pspMP4Files = null;
                PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new UpdatePSPDir(null));
                PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new SetFreeSpace(null, this.pspInfo));
                return;
            }
            File[] mp4 = this.getMP4Files(videoDir);
            String data = this.toDirectoryInfo(videoDir, mp4);
            if (!this.lastPSPDirectoryInfo.equals(data)) {
                PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new UpdatePSPDir(videoDir));
                this.updatePSPFiles(videoDir, mp4, keepselect);
                this.lastPSPDirectoryInfo = data;
            }
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new SetFreeSpace(videoDir, this.pspInfo));
        }
        PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new UpdateSelection());
    }

    public File[] getMP4Files(File file) {
        ArrayList<File> fileList = new ArrayList<File>();
        String[] list = file.list(new MP4FilenameFilter());
        if (list == null) {
            log.warn((Object)("file.lise()==null:" + file));
            return new File[0];
        }
        int i = 0;
        while (i < list.length) {
            File mp4File = new File(file, list[i]);
            if (mp4File.length() > 0L) {
                fileList.add(mp4File);
            }
            ++i;
        }
        return fileList.toArray(new File[fileList.size()]);
    }

    private String toDirectoryInfo(File dir, File[] files) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(dir.getAbsolutePath());
        int i = 0;
        while (i < files.length) {
            buffer.append(String.valueOf(files[i].getAbsolutePath()) + files[i].length());
            ++i;
        }
        return buffer.toString();
    }

    public void noHDDirectory() {
        this.hdDir = null;
        PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new UpdateHDFigure((Figure)new org.eclipse.draw2d.Label(Messages.getString("pssync.directory_not_found")), false));
    }

    public void openHDDirectory(File file) {
        File[] files;
        if (file != null && file.exists()) {
            this.hdDir = file;
        } else {
            this.noHDDirectory();
        }
        ArrayList<File> fileList = new ArrayList<File>();
        String[] list = file.list(new MP4FilenameFilter());
        if (list == null) {
            log.warn((Object)("file.lise()==null:" + file));
            files = new File[]{};
        } else {
            int i = 0;
            while (i < list.length) {
                File mp4File = new File(file, list[i]);
                if (mp4File.length() > 0L) {
                    fileList.add(mp4File);
                }
                ++i;
            }
            files = fileList.toArray(new File[fileList.size()]);
        }
        this.lastHDDirectoryInfo = this.toDirectoryInfo(file, files);
        this.updateHDFiles(file, files, false);
        PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new SetFreeSpace(file, this.hdInfo));
    }

    public Image loadMP4Image(File mp4) {
        Image img;
        block9: {
            img = noImage;
            try {
                File imgFile = new File(FileNameUtils.getChangedExtensionName(mp4, "jpg", true));
                if (imgFile.exists() && imgFile.length() > 0L) {
                    try {
                        img = new Image(null, imgFile.getAbsolutePath());
                        if (img.getBounds().width != 160 || img.getBounds().height != 120) {
                            img = ImageUtils.createThumbnail(img, 160, 120);
                        }
                        break block9;
                    }
                    catch (Exception exception) {
                        log.warn((Object)("unsupported image:" + imgFile));
                        img = noImage;
                    }
                    break block9;
                }
                ThumbnailManager.makeThumbnail(mp4, 1, imgFile);
                if (imgFile.exists()) {
                    try {
                        img = new Image(null, imgFile.getAbsolutePath());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        log.warn((Object)("unsupported image:" + imgFile));
                        img = noImage;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                log.warn((Object)e.getMessage());
                img = noImage;
            }
        }
        return img;
    }

    private void updatePSPFiles(File parent, File[] files, boolean keepselect) {
        log.trace((Object)(parent + "," + keepselect));
        this.pspDir = parent;
        this.pspMP4Files = files;
        Figure tmpFigure = new Figure();
        tmpFigure.setLayoutManager((LayoutManager)new CustomLayout(this.pspCanvas, this.pspFigure));
        int i = 0;
        while (i < files.length) {
            Image img = this.loadMP4Image(files[i]);
            MP4ThumbnailFigure figure = new MP4ThumbnailFigure(files[i], img);
            tmpFigure.add((IFigure)figure);
            ++i;
        }
        PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new UpdatePSPFigure(tmpFigure, keepselect));
    }

    public MP4ThumbnailFigure[] getPSPMP4Figures() {
        if (this.pspListFigure != null) {
            return this.pspListFigure.getChildren().toArray(new MP4ThumbnailFigure[0]);
        }
        return new MP4ThumbnailFigure[0];
    }

    public MP4ThumbnailFigure[] getHDMP4Figure() {
        if (this.hdListFigure != null) {
            return this.hdListFigure.getChildren().toArray(new MP4ThumbnailFigure[0]);
        }
        return new MP4ThumbnailFigure[0];
    }

    private void updateHDFiles(File parent, File[] files, boolean keepSelection) {
        log.info((Object)("hd updated:" + parent));
        this.hdMP4Files = files;
        Figure tmpFigure = new Figure();
        tmpFigure.setLayoutManager((LayoutManager)new CustomLayout(this.hdCanvas, this.hdFigure));
        int i = 0;
        while (i < files.length) {
            Image img = this.loadMP4Image(files[i]);
            MP4ThumbnailFigure figure = new MP4ThumbnailFigure(files[i], img);
            figure.setOnHD(true);
            tmpFigure.add((IFigure)figure);
            ++i;
        }
        PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new UpdateHDFigure(tmpFigure, keepSelection));
        PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new UpdateSelection());
    }

    public void openPSPVideoDirectory(File file) {
    }

    public void setFocus() {
    }

    public void cancel() {
        if (this.currentCommand != null) {
            this.currentCommand.setCanceld(true);
        }
        this.executing = false;
        this.updatePSPDir(this.pspDir.getParentFile(), false);
        this.openHDDirectory(this.hdDir);
        this.enableWidgets();
    }

    public void sync() {
        this.executing = true;
        this.disableWidgets();
        PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)new ShowStatusProcessPrinter.ShowStatusBar(LABEL_ACTION_NONE));
        this.progressMonitor = ProgressMonitorUtils.getProgressMonitor();
        new Sync(this.getCommands()).start();
    }

    public long getFreeSpace(File dir) throws IOException {
        if (dir == null || !dir.exists()) {
            return 0L;
        }
        return FileSystemUtils.freeSpaceKb((String)dir.getAbsolutePath()) * 1024L;
    }

    public void disableWidgets() {
        this.syncButton.setText(Messages.getString("pspsync.cancel"));
        this.directoryPaths.setEnabled(false);
        this.pspDirPath.setEnabled(false);
    }

    public void enableWidgets() {
        this.syncButton.setText(Messages.getString("pspsync.exec"));
        this.directoryPaths.setEnabled(true);
        this.pspDirPath.setEnabled(true);
    }

    public static boolean existFile(File target, File[] list) {
        int i = 0;
        while (i < list.length) {
            if (target.getName().toLowerCase().equals(list[i].getName().toLowerCase())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void dispose() {
        this.monitorPSPDirectory = false;
        this.monitorHDDirectory = false;
        super.dispose();
    }

    private void updateExplorerPaths() {
        String paths = Akj_betasPlugin.getDefault().getPreferenceStore().getString("explorer.paths");
        String[] path = paths.split(";");
        this.directoryPaths.removeAll();
        int i = 0;
        while (i < path.length) {
            this.directoryPaths.add(path[i]);
            ++i;
        }
        this.directoryPaths.removeSelectionListener((SelectionListener)this.explorerPathChange);
        if (this.hdDir == null) {
            this.directoryPaths.select(0);
        } else {
            boolean find = false;
            int i2 = 0;
            while (i2 < path.length) {
                if (path[i2].equals(this.hdDir.getAbsolutePath())) {
                    this.directoryPaths.select(i2);
                    find = true;
                    break;
                }
                ++i2;
            }
            if (!find && this.hdDir != null) {
                this.directoryPaths.add(this.hdDir.getAbsolutePath());
                this.directoryPaths.select(this.directoryPaths.getItemCount() - 1);
            }
        }
        this.directoryPaths.addSelectionListener((SelectionListener)this.explorerPathChange);
    }

    public class DirectoryInfomation
    extends Composite {
        private long freeSpace;
        private long totalSpace;
        private long additionalSpace;
        private Label label;
        private Color normalColor;
        private Color overColor;

        public DirectoryInfomation(Composite arg0, int arg1) {
            super(arg0, arg1);
            this.normalColor = new Color(null, 0, 0, 0);
            this.overColor = new Color(null, 255, 0, 0);
            this.setLayout((Layout)new FillLayout());
            this.label = new Label((Composite)this, 0);
        }

        public boolean isOverSize() {
            return this.freeSpace * 1024L < this.additionalSpace;
        }

        public void updateLabel() {
            if (!this.label.isDisposed()) {
                if (this.freeSpace > 0L) {
                    if (this.isOverSize()) {
                        this.label.setForeground(this.overColor);
                    } else {
                        this.label.setForeground(this.normalColor);
                    }
                    BigDecimal bd = new BigDecimal((double)this.freeSpace / 1000.0);
                    double free = bd.setScale(1, 4).doubleValue();
                    BigDecimal bd2 = new BigDecimal((double)this.additionalSpace / 1000.0 / 1000.0);
                    double add = bd2.setScale(1, 4).doubleValue();
                    String text = String.valueOf(Messages.getString("pspsync.free_space")) + ":" + free + " MBytes";
                    if (this.additionalSpace != 0L) {
                        text = String.valueOf(text) + Messages.getString("pspsync.add_space") + ":" + add + " MBytes";
                    }
                    this.label.setText(text);
                } else {
                    this.label.setText(PSPSyncView.LABEL_ACTION_NONE);
                }
            }
        }

        public long getAdditionalSpace() {
            return this.additionalSpace;
        }

        public void setAdditionalSpace(long additionalSpace) {
            this.additionalSpace = additionalSpace;
            this.updateLabel();
        }

        public long getFreeSpace() {
            return this.freeSpace;
        }

        public void setFreeSpace(long freeSpace) {
            this.freeSpace = freeSpace;
            this.updateLabel();
        }

        public long getTotalSpace() {
            return this.totalSpace;
        }

        public void setTotalSpace(long totalSpace) {
            this.totalSpace = totalSpace;
            this.updateLabel();
        }
    }

    public class UpdateSelection
    extends Thread {
        public void run() {
            PSPSyncView.this.updateSelection();
        }
    }

    public class UpdatePSPDir
    extends Thread {
        private File file;

        public UpdatePSPDir(File file) {
            this.file = file;
        }

        public void run() {
            if (!PSPSyncView.this.pspDirPath.isDisposed()) {
                if (this.file != null) {
                    PSPSyncView.this.pspDirPath.setText(this.file.getAbsolutePath());
                } else {
                    PSPSyncView.this.pspDirPath.setText(PSPSyncView.LABEL_ACTION_NONE);
                }
            }
        }
    }

    public class SetFreeSpace
    extends Thread {
        private File file;
        private DirectoryInfomation target;

        public SetFreeSpace(File file, DirectoryInfomation target) {
            this.file = file;
            this.target = target;
        }

        public void run() {
            try {
                if (this.file == null || !this.file.exists()) {
                    this.target.setFreeSpace(0L);
                } else {
                    this.target.setFreeSpace(FileSystemUtils.freeSpaceKb((String)this.file.getAbsolutePath()));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public class AutoPSPVideoDirectoryOpener
    extends Thread {
        public void run() {
            while (PSPSyncView.this.monitorPSPDirectory) {
                try {
                    if (!PSPSyncView.this.executing) {
                        File dir = PSPUtils.findPSPDrive();
                        if (dir == null) {
                            PSPSyncView.this.lastPSPDirectoryInfo = PSPSyncView.LABEL_ACTION_NONE;
                            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new UpdatePSPFigure((Figure)new org.eclipse.draw2d.Label(Messages.getString("pssync.psp_not_found")), false));
                            PSPSyncView.this.updatePSPDir(null, false);
                        } else if (PSPUtils.existVideoFolder(dir)) {
                            PSPSyncView.this.updatePSPDir(dir, true);
                        } else {
                            PSPSyncView.this.lastPSPDirectoryInfo = PSPSyncView.LABEL_ACTION_NONE;
                            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new UpdatePSPFigure((Figure)new org.eclipse.draw2d.Label(Messages.getString("pssync.psp_video_folder_not_found")), false));
                            PSPSyncView.this.updatePSPDir(null, false);
                        }
                    }
                    try {
                        Thread.sleep(PSPSyncView.this.pspMonitorSleeptime);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    PSPSyncView pSPSyncView = PSPSyncView.this;
                    pSPSyncView.pspMonitorSleeptime = pSPSyncView.pspMonitorSleeptime + 100;
                }
            }
        }
    }

    public class AutoHDDirectoryOpener
    extends Thread {
        public void run() {
            while (PSPSyncView.this.monitorHDDirectory) {
                try {
                    File[] files;
                    try {
                        Thread.sleep(PSPSyncView.this.hdMonitorSleeptime);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (PSPSyncView.this.executing) continue;
                    File dir = PSPSyncView.this.hdDir;
                    if (dir == null || !dir.exists()) {
                        PSPSyncView.this.lastHDDirectoryInfo = PSPSyncView.LABEL_ACTION_NONE;
                        PSPSyncView.this.noHDDirectory();
                        continue;
                    }
                    ArrayList<File> fileList = new ArrayList<File>();
                    String[] list = dir.list(new MP4FilenameFilter());
                    if (list == null) {
                        log.warn((Object)("file.lise()==null:" + dir));
                        files = new File[]{};
                    } else {
                        int i = 0;
                        while (i < list.length) {
                            File mp4File = new File(dir, list[i]);
                            if (mp4File.length() > 0L) {
                                fileList.add(mp4File);
                            }
                            ++i;
                        }
                        files = fileList.toArray(new File[fileList.size()]);
                    }
                    String info = PSPSyncView.this.toDirectoryInfo(dir, files);
                    if (PSPSyncView.this.lastHDDirectoryInfo.equals(info)) continue;
                    PSPSyncView.this.lastHDDirectoryInfo = info;
                    PSPSyncView.this.updateHDFiles(dir, files, true);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    PSPSyncView pSPSyncView = PSPSyncView.this;
                    pSPSyncView.hdMonitorSleeptime = pSPSyncView.hdMonitorSleeptime + 100;
                }
            }
        }
    }

    public class UpdateHDFigure
    extends Thread {
        Figure replace;
        boolean keepselect;

        public UpdateHDFigure(Figure replace, boolean keepselect) {
            this.keepselect = keepselect;
            this.replace = replace;
        }

        public void run() {
            if (this.keepselect) {
                HashMap<String, String> selectionMap = new HashMap<String, String>();
                MP4ThumbnailFigure[] oldSelection = PSPSyncView.this.getHDMP4Figure();
                int i = 0;
                while (i < oldSelection.length) {
                    File mp4 = oldSelection[i].getMp4File();
                    String key = String.valueOf(mp4.getAbsolutePath()) + mp4.length();
                    String value = String.valueOf(oldSelection[i].isSelection()) + "," + oldSelection[i].getAction();
                    selectionMap.put(key, value);
                    ++i;
                }
                for (MP4ThumbnailFigure figure : this.replace.getChildren()) {
                    File mp4 = figure.getMp4File();
                    String v = (String)selectionMap.get(String.valueOf(mp4.getAbsolutePath()) + mp4.length());
                    if (v == null) continue;
                    String[] boolen_int = v.split(",");
                    figure.setSelection(Boolean.parseBoolean(boolen_int[0]));
                    figure.setAction(Integer.parseInt(boolen_int[1]));
                }
            }
            PSPSyncView.this.hdListFigure = this.replace;
            PSPSyncView.this.hdFigure.removeAll();
            if (this.replace != null) {
                PSPSyncView.this.hdFigure.add((IFigure)this.replace);
            }
            PSPSyncView.this.hdFigure.repaint();
        }
    }

    public class UpdatePSPFigure
    extends Thread {
        boolean keepselect;
        Figure replace;

        public UpdatePSPFigure(Figure replace, boolean keepselect) {
            this.keepselect = keepselect;
            this.replace = replace;
        }

        public void run() {
            if (this.keepselect && this.replace != null) {
                HashMap<String, String> selectionMap = new HashMap<String, String>();
                MP4ThumbnailFigure[] oldSelection = PSPSyncView.this.getPSPMP4Figures();
                int i = 0;
                while (i < oldSelection.length) {
                    File mp4 = oldSelection[i].getMp4File();
                    String key = String.valueOf(mp4.getAbsolutePath()) + mp4.length();
                    String value = String.valueOf(oldSelection[i].isSelection()) + "," + oldSelection[i].getAction();
                    selectionMap.put(key, value);
                    ++i;
                }
                for (MP4ThumbnailFigure figure : this.replace.getChildren()) {
                    File mp4 = figure.getMp4File();
                    String v = (String)selectionMap.get(String.valueOf(mp4.getAbsolutePath()) + mp4.length());
                    if (v == null) continue;
                    String[] boolen_int = v.split(",");
                    figure.setSelection(Boolean.parseBoolean(boolen_int[0]));
                    figure.setAction(Integer.parseInt(boolen_int[1]));
                }
            }
            PSPSyncView.this.pspListFigure = this.replace;
            PSPSyncView.this.pspFigure.removeAll();
            if (this.replace != null) {
                PSPSyncView.this.pspFigure.add((IFigure)this.replace);
            }
            PSPSyncView.this.pspFigure.repaint();
        }
    }

    public class Sync
    extends Thread {
        PSPIOCommand[] commands;

        public Sync(PSPIOCommand[] commands) {
            this.commands = commands;
        }

        public void run() {
            ProgressMonitorUtils.progressMonitorBegin(PSPSyncView.this.progressMonitor, PSPSyncView.LABEL_ACTION_NONE, this.commands.length, false);
            int i = 0;
            while (i < this.commands.length) {
                if (!PSPSyncView.this.executing) {
                    PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new SyncCanceled());
                    return;
                }
                try {
                    if (this.commands[i].isPSPSrc()) {
                        if (!PSPSyncView.this.availableCommand(this.commands[i], PSPSyncView.this.getFreeSpace(PSPSyncView.this.hdDir))) {
                            log.warn((Object)"no space");
                            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new SyncCanceled());
                            return;
                        }
                    } else if (!PSPSyncView.this.availableCommand(this.commands[i], PSPSyncView.this.getFreeSpace(PSPSyncView.this.pspDir))) {
                        log.warn((Object)"no space");
                        PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new SyncCanceled());
                        return;
                    }
                }
                catch (IOException e) {
                    PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new SyncCanceled());
                    e.printStackTrace();
                    return;
                }
                log.info((Object)this.commands[i]);
                PSPSyncView.this.currentCommand = this.commands[i];
                if (!PSPSyncView.this.executing) {
                    PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new SyncCanceled());
                    return;
                }
                int result = this.commands[i].execCommand();
                log.info((Object)"done command");
                if (result != 0) {
                    log.warn((Object)("execute faild:" + result));
                    PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)new ShowStatusProcessPrinter.ShowStatusBar("error:" + result));
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new SyncCanceled());
                    ProgressMonitorUtils.progressMonitorDone(PSPSyncView.this.progressMonitor, false);
                    return;
                }
                ProgressMonitorUtils.progressMonitorWorked(PSPSyncView.this.progressMonitor, 1, false);
                ++i;
            }
            ProgressMonitorUtils.progressMonitorDone(PSPSyncView.this.progressMonitor, false);
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new SyncFinished());
        }
    }

    public class SyncCanceled
    extends Thread {
        public void run() {
            log.info((Object)"canceled");
            PSPSyncView.this.cancel();
        }
    }

    public class SyncFinished
    extends Thread {
        public void run() {
            log.info((Object)"finished");
            if (PSPSyncView.this.pspDir != null && PSPSyncView.this.pspDir.exists()) {
                PSPSyncView.this.updatePSPDir(PSPSyncView.this.pspDir.getParentFile(), false);
            }
            PSPSyncView.this.openHDDirectory(PSPSyncView.this.hdDir);
            PSPSyncView.this.enableWidgets();
            PSPSyncView.this.executing = false;
        }
    }

    public class MP4FilenameFilter
    implements FilenameFilter {
        public boolean accept(File arg0, String arg1) {
            return arg1.toLowerCase().endsWith(".mp4");
        }
    }

    public class MP4ThumbnailFigure
    extends Panel {
        MP4ThumbnailFigure self = this;
        org.eclipse.draw2d.Label titleLabel;
        org.eclipse.draw2d.Label imageLabel;
        boolean selection;
        LineBorder lineBorder;
        MarginBorder marginBorder;
        File mp4File;
        private int action;
        CutomLabel actionLabel;
        boolean onHD;

        public long getFileSize() {
            return this.mp4File.length();
        }

        public String trimTitle(String name) {
            return name.substring(0, Math.min(16, name.length()));
        }

        public void setDefaultAction() {
            if (this.onHD) {
                if (this.action == 0 && PSPSyncView.this.isPSPDirectoryAvailable()) {
                    if (PSPSyncView.existFile(this.self.mp4File, PSPSyncView.this.pspMP4Files)) {
                        this.setAction(3);
                    } else {
                        this.setAction(1);
                    }
                }
            } else if (this.action == 0 && PSPSyncView.this.isHDDirectoryAvailable()) {
                if (PSPSyncView.existFile(this.self.mp4File, PSPSyncView.this.hdMP4Files)) {
                    this.setAction(5);
                } else {
                    this.setAction(2);
                }
            }
        }

        public void setSelection(boolean bool) {
            if (this.selection != bool) {
                this.selection = bool;
                if (this.selection) {
                    this.self.setDefaultAction();
                    this.actionLabel.setVisible(true);
                    this.setBorder((Border)this.lineBorder);
                } else {
                    this.actionLabel.setVisible(false);
                    this.setBorder((Border)this.marginBorder);
                }
                this.repaint();
            }
        }

        public boolean isSelection() {
            return this.selection;
        }

        public void turnSelection() {
            this.setSelection(!this.selection);
        }

        public void setImage(Image img) {
            if (img != null) {
                this.imageLabel.setIcon(img);
            } else {
                log.info((Object)("setimage:" + this.getLabel()));
            }
        }

        public String getLabel() {
            return this.titleLabel.getText();
        }

        public void setLabel(String text) {
            this.titleLabel.setText(text);
        }

        public MP4ThumbnailFigure(File mp4File, Image img) {
            this.mp4File = mp4File;
            this.setLayoutManager((LayoutManager)new FlowLayout(false));
            this.imageLabel = new org.eclipse.draw2d.Label(img);
            this.imageLabel.setToolTip((IFigure)new org.eclipse.draw2d.Label(this.toTooltip()));
            this.imageLabel.setLayoutManager((LayoutManager)new StackLayout());
            this.add((IFigure)this.imageLabel);
            this.actionLabel = new CutomLabel();
            this.actionLabel.setVisible(false);
            this.imageLabel.add((IFigure)this.actionLabel);
            this.titleLabel = new org.eclipse.draw2d.Label(this.trimTitle(mp4File.getName()));
            this.add((IFigure)this.titleLabel);
            this.addMouseListener(new MouseListener(){

                public void mousePressed(MouseEvent mouseEvent) {
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    if (MP4ThumbnailFigure.this.self.isOnHD()) {
                        PSPSyncView.this.hdMovieActionPopup.setTargetFigure(MP4ThumbnailFigure.this.self);
                        if (((MP4ThumbnailFigure)MP4ThumbnailFigure.this).PSPSyncView.this.executing) {
                            PSPSyncView.this.hdMovieActionPopup.setCopyEnabled(false);
                            PSPSyncView.this.hdMovieActionPopup.setMoveEnabled(false);
                            PSPSyncView.this.hdMovieActionPopup.setCopyOverwriteEnabled(false);
                            PSPSyncView.this.hdMovieActionPopup.setMoveOverwriteEnabled(false);
                            PSPSyncView.this.hdMovieActionPopup.setDeleteEnabled(false);
                        } else if (PSPSyncView.this.isPSPDirectoryAvailable()) {
                            if (PSPSyncView.existFile(MP4ThumbnailFigure.this.self.mp4File, PSPSyncView.this.pspMP4Files)) {
                                PSPSyncView.this.hdMovieActionPopup.setCopyEnabled(false);
                                PSPSyncView.this.hdMovieActionPopup.setMoveEnabled(false);
                                PSPSyncView.this.hdMovieActionPopup.setCopyOverwriteEnabled(true);
                                PSPSyncView.this.hdMovieActionPopup.setMoveOverwriteEnabled(true);
                                PSPSyncView.this.hdMovieActionPopup.setDeleteEnabled(true);
                            } else {
                                PSPSyncView.this.hdMovieActionPopup.setCopyEnabled(true);
                                PSPSyncView.this.hdMovieActionPopup.setMoveEnabled(true);
                                PSPSyncView.this.hdMovieActionPopup.setCopyOverwriteEnabled(false);
                                PSPSyncView.this.hdMovieActionPopup.setMoveOverwriteEnabled(false);
                                PSPSyncView.this.hdMovieActionPopup.setDeleteEnabled(true);
                            }
                        } else {
                            PSPSyncView.this.hdMovieActionPopup.setCopyEnabled(false);
                            PSPSyncView.this.hdMovieActionPopup.setMoveEnabled(false);
                            PSPSyncView.this.hdMovieActionPopup.setCopyOverwriteEnabled(false);
                            PSPSyncView.this.hdMovieActionPopup.setMoveOverwriteEnabled(false);
                            PSPSyncView.this.hdMovieActionPopup.setDeleteEnabled(true);
                        }
                    } else {
                        PSPSyncView.this.pspMovieActionPopup.setTargetFigure(MP4ThumbnailFigure.this.self);
                        if (((MP4ThumbnailFigure)MP4ThumbnailFigure.this).PSPSyncView.this.executing) {
                            PSPSyncView.this.pspMovieActionPopup.setCopyEnabled(false);
                            PSPSyncView.this.pspMovieActionPopup.setMoveEnabled(false);
                            PSPSyncView.this.pspMovieActionPopup.setCopyOverwriteEnabled(false);
                            PSPSyncView.this.pspMovieActionPopup.setMoveOverwriteEnabled(false);
                            PSPSyncView.this.pspMovieActionPopup.setDeleteEnabled(false);
                        } else if (PSPSyncView.this.isHDDirectoryAvailable()) {
                            if (PSPSyncView.existFile(MP4ThumbnailFigure.this.self.mp4File, PSPSyncView.this.hdMP4Files)) {
                                PSPSyncView.this.pspMovieActionPopup.setCopyEnabled(false);
                                PSPSyncView.this.pspMovieActionPopup.setMoveEnabled(false);
                                PSPSyncView.this.pspMovieActionPopup.setCopyOverwriteEnabled(true);
                                PSPSyncView.this.pspMovieActionPopup.setMoveOverwriteEnabled(true);
                                PSPSyncView.this.pspMovieActionPopup.setDeleteEnabled(true);
                            } else {
                                PSPSyncView.this.pspMovieActionPopup.setCopyEnabled(true);
                                PSPSyncView.this.pspMovieActionPopup.setMoveEnabled(true);
                                PSPSyncView.this.pspMovieActionPopup.setCopyOverwriteEnabled(false);
                                PSPSyncView.this.pspMovieActionPopup.setMoveOverwriteEnabled(false);
                                PSPSyncView.this.pspMovieActionPopup.setDeleteEnabled(true);
                            }
                        } else {
                            PSPSyncView.this.pspMovieActionPopup.setCopyEnabled(false);
                            PSPSyncView.this.pspMovieActionPopup.setMoveEnabled(false);
                            PSPSyncView.this.pspMovieActionPopup.setCopyOverwriteEnabled(false);
                            PSPSyncView.this.pspMovieActionPopup.setMoveOverwriteEnabled(false);
                            PSPSyncView.this.pspMovieActionPopup.setDeleteEnabled(true);
                        }
                    }
                    if (((MP4ThumbnailFigure)MP4ThumbnailFigure.this).PSPSyncView.this.executing) {
                        return;
                    }
                    if (mouseEvent.button == 1) {
                        if ((mouseEvent.getState() & 0x40000) > 0) {
                            MP4ThumbnailFigure.this.turnSelection();
                        } else if ((mouseEvent.getState() & 0x20000) <= 0) {
                            MP4ThumbnailFigure.this.turnSelection();
                        }
                    } else {
                        int cfr_ignored_0 = mouseEvent.button;
                    }
                    MP4ThumbnailFigure.this.unselectOposite();
                    PSPSyncView.this.updateSelection();
                }

                public void mouseDoubleClicked(MouseEvent arg0) {
                }
            });
            this.lineBorder = new LineBorder();
            this.lineBorder.setColor(ColorConstants.green);
            this.lineBorder.setWidth(2);
            this.marginBorder = new MarginBorder(2);
            this.setBorder((Border)this.marginBorder);
        }

        public String toTooltip() {
            int kbyte = (int)(this.mp4File.length() / 1024L);
            String label = this.mp4File.getAbsolutePath();
            label = String.valueOf(label) + "\n\n" + kbyte + " KBytes\n";
            label = String.valueOf(label) + new Date(this.mp4File.lastModified()).toLocaleString();
            return label;
        }

        public void unselectOposite() {
            if (this.self.isSelection() && this.self.getAction() != 0 && this.self.getAction() != 5) {
                MP4ThumbnailFigure other;
                if (this.self.isOnHD()) {
                    MP4ThumbnailFigure other2;
                    if (PSPSyncView.existFile(this.self.mp4File, PSPSyncView.this.pspMP4Files) && (other2 = PSPSyncView.this.findPSPFigure(new File(PSPSyncView.this.pspDir, this.self.getMp4File().getName()))) != null && other2.isSelection()) {
                        other2.setSelection(false);
                    }
                } else if (PSPSyncView.existFile(this.self.mp4File, PSPSyncView.this.hdMP4Files) && (other = PSPSyncView.this.findHDFigure(new File(PSPSyncView.this.hdDir, this.self.getMp4File().getName()))) != null && other.isSelection()) {
                    other.setSelection(false);
                }
            }
        }

        public String toTooltip(String path) {
            int kbyte = (int)(this.mp4File.length() / 1024L);
            String label = this.mp4File.getName();
            label = String.valueOf(label) + "\n\n" + kbyte + " KBytes\n";
            label = String.valueOf(label) + new Date(this.mp4File.lastModified()).toLocaleString();
            return label;
        }

        public int getAction() {
            return this.action;
        }

        public void setAction(int action) {
            this.action = action;
            this.actionLabel.setForegroundColor(ColorConstants.black);
            switch (action) {
                case 1: {
                    this.actionLabel.setText(LABEL_ACTION_COPY);
                    break;
                }
                case 2: {
                    this.actionLabel.setText(LABEL_ACTION_MOVE);
                    break;
                }
                case 3: {
                    this.actionLabel.setText(LABEL_ACTION_COPY_OVERWRITE);
                    break;
                }
                case 4: {
                    this.actionLabel.setText(LABEL_ACTION_MOVE_OVERWRITE);
                    break;
                }
                case 5: {
                    this.actionLabel.setForegroundColor(ColorConstants.red);
                    this.actionLabel.setText(LABEL_ACTION_DELETE);
                }
            }
            this.unselectOposite();
            PSPSyncView.this.updateSelection();
        }

        public boolean isOnHD() {
            return this.onHD;
        }

        public void setOnHD(boolean onHD) {
            this.onHD = onHD;
        }

        public File getMp4File() {
            return this.mp4File;
        }

        public void setMp4File(File mp4File) {
            this.mp4File = mp4File;
        }
    }

    public class CustomLayout
    implements LayoutManager {
        Figure control;
        FigureCanvas canvas;

        public CustomLayout(FigureCanvas canvas, Figure control) {
            this.canvas = canvas;
            this.control = control;
        }

        public Object getConstraint(IFigure child) {
            return null;
        }

        public Dimension getMinimumSize(IFigure container, int wHint, int hHint) {
            return this.getPreferredSize(container, wHint, hHint);
        }

        public Dimension getPreferredSize(IFigure container, int wHint, int hHint) {
            this.layout(container);
            Figure[] figures = container.getChildren().toArray(new Figure[0]);
            int my = 0;
            int i = 0;
            while (i < figures.length) {
                my = Math.max(my, figures[i].getLocation().y + figures[i].getSize().height);
                ++i;
            }
            return new Dimension(this.control.getClientArea().x, my);
        }

        public void invalidate() {
        }

        public void layout(IFigure container) {
            Figure[] figures = container.getChildren().toArray(new Figure[0]);
            int space = 1;
            int dx = 0;
            int dy = 0;
            int preHeight = 0;
            if (this.control.getSize().width == 0 && this.control.getSize().height == 0) {
                return;
            }
            int i = 0;
            while (i < figures.length) {
                Dimension d = figures[i].getPreferredSize();
                if (dx == 0) {
                    figures[i].setLocation(new Point(dx, dy));
                    figures[i].setSize(d.width, d.height);
                    dx += d.width + space;
                    preHeight = d.height + space;
                } else {
                    int sc = 0;
                    if (!this.canvas.getVerticalBar().isEnabled()) {
                        sc = 16;
                    }
                    if (dx + d.width > this.control.getClientArea().width - sc) {
                        dx = 0;
                        dy += preHeight;
                    }
                    figures[i].setLocation(new Point(dx, dy));
                    figures[i].setSize(d.width, d.height);
                    dx += d.width + space;
                    preHeight = d.height + space;
                }
                ++i;
            }
            int my = 0;
            int i2 = 0;
            while (i2 < figures.length) {
                my = Math.max(my, figures[i2].getLocation().y + figures[i2].getSize().height);
                ++i2;
            }
            if (my > this.control.getClientArea().height) {
                dx = 0;
                dy = 0;
                preHeight = 0;
                i2 = 0;
                while (i2 < figures.length) {
                    Dimension d = figures[i2].getPreferredSize();
                    if (dx == 0) {
                        figures[i2].setLocation(new Point(dx, dy));
                        figures[i2].setSize(d.width, d.height);
                        dx += d.width + space;
                        preHeight = d.height + space;
                    } else {
                        int sc = 16;
                        if (dx + d.width > this.control.getClientArea().width - sc) {
                            dx = 0;
                            dy += preHeight;
                        }
                        figures[i2].setLocation(new Point(dx, dy));
                        figures[i2].setSize(d.width, d.height);
                        dx += d.width + space;
                        preHeight = d.height + space;
                    }
                    ++i2;
                }
            }
        }

        public void remove(IFigure child) {
        }

        public void setConstraint(IFigure child, Object constraint) {
        }
    }

    public class CutomLabel
    extends Figure {
        private String text = "";

        protected void paintFigure(Graphics graphics) {
            if (this.text.length() > 0) {
                Rectangle rect = this.getBounds();
                TextLayout layout = new TextLayout(null);
                layout.setText(this.text);
                int textHeight = 20;
                int cy = rect.height / 2;
                graphics.fillRectangle(rect.x, rect.y + cy - textHeight / 2, rect.width, textHeight);
                layout.setWidth(rect.width);
                layout.setAlignment(0x1000000);
                graphics.drawTextLayout(layout, rect.x, rect.y + cy - 8);
            }
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
            this.repaint();
        }
    }

    public class MovieActionPopup {
        private Menu rootMenu;
        private MP4ThumbnailFigure targetFigure;
        private MenuItem copyItem;
        private MenuItem moveItem;
        private MenuItem copyOverwriteItem;
        private MenuItem moveOverwriteItem;
        private MenuItem deleteItem;
        private MenuItem playItem;
        private boolean hdDirectory;
        private MenuItem openItem;

        public void setCopyEnabled(boolean bool) {
            this.copyItem.setEnabled(bool);
        }

        public void setPlayEnabled(boolean bool) {
            this.playItem.setEnabled(bool);
        }

        public void setOpenEnabled(boolean bool) {
            this.openItem.setEnabled(bool);
        }

        public void setMoveEnabled(boolean bool) {
            this.moveItem.setEnabled(bool);
        }

        public void setCopyOverwriteEnabled(boolean bool) {
            this.copyOverwriteItem.setEnabled(bool);
        }

        public void setMoveOverwriteEnabled(boolean bool) {
            this.moveOverwriteItem.setEnabled(bool);
        }

        public void setDeleteEnabled(boolean bool) {
            this.deleteItem.setEnabled(bool);
        }

        public MovieActionPopup(Control arg0) {
            this.rootMenu = new Menu(arg0);
            this.copyItem = new MenuItem(this.rootMenu, 8);
            this.copyItem.setText(LABEL_ACTION_COPY);
            this.copyItem.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    MovieActionPopup.this.targetFigure.setSelection(true);
                    MovieActionPopup.this.targetFigure.setAction(1);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.moveItem = new MenuItem(this.rootMenu, 8);
            this.moveItem.setText(LABEL_ACTION_MOVE);
            this.moveItem.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    MovieActionPopup.this.targetFigure.setSelection(true);
                    MovieActionPopup.this.targetFigure.setAction(2);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.copyOverwriteItem = new MenuItem(this.rootMenu, 8);
            this.copyOverwriteItem.setText(LABEL_ACTION_COPY_OVERWRITE);
            this.copyOverwriteItem.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    MovieActionPopup.this.targetFigure.setSelection(true);
                    MovieActionPopup.this.targetFigure.setAction(3);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.moveOverwriteItem = new MenuItem(this.rootMenu, 8);
            this.moveOverwriteItem.setText(LABEL_ACTION_MOVE_OVERWRITE);
            this.moveOverwriteItem.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    MovieActionPopup.this.targetFigure.setSelection(true);
                    MovieActionPopup.this.targetFigure.setAction(4);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            new MenuItem(this.rootMenu, 2);
            this.deleteItem = new MenuItem(this.rootMenu, 8);
            this.deleteItem.setText(LABEL_ACTION_DELETE);
            this.deleteItem.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    MovieActionPopup.this.targetFigure.setSelection(true);
                    MovieActionPopup.this.targetFigure.setAction(5);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            new MenuItem(this.rootMenu, 2);
            this.playItem = new MenuItem(this.rootMenu, 8);
            this.playItem.setText(LABEL_ACTION_PLAY);
            this.playItem.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    Program p = Program.findProgram((String)".mp4");
                    if (p != null) {
                        p.execute(MovieActionPopup.this.targetFigure.getMp4File().getAbsolutePath());
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.openItem = new MenuItem(this.rootMenu, 8);
            this.openItem.setText(LABEL_ACTION_OPEN);
            this.openItem.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    File dir = MovieActionPopup.this.isHdDirectory() ? PSPSyncView.this.hdDir : PSPSyncView.this.pspDir;
                    Runtime r = Runtime.getRuntime();
                    try {
                        r.exec(new String[]{"explorer", dir.getAbsolutePath()});
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }

        public Menu getRootMenu() {
            return this.rootMenu;
        }

        public void setRootMenu(Menu rootMenu) {
            this.rootMenu = rootMenu;
        }

        public MP4ThumbnailFigure getTargetFigure() {
            return this.targetFigure;
        }

        public void setTargetFigure(MP4ThumbnailFigure targetFigure) {
            this.targetFigure = targetFigure;
        }

        public boolean isHdDirectory() {
            return this.hdDirectory;
        }

        public void setHdDirectory(boolean hdDirectory) {
            this.hdDirectory = hdDirectory;
        }
    }

    public class ResizeMonitor
    implements ControlListener {
        Figure figure;

        public ResizeMonitor(Figure figure) {
            this.figure = figure;
        }

        public void controlMoved(ControlEvent e) {
        }

        public void controlResized(ControlEvent e) {
            this.figure.revalidate();
        }
    }

    public class ExplorerPathChange
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            String dir = PSPSyncView.this.directoryPaths.getItem(PSPSyncView.this.directoryPaths.getSelectionIndex());
            PSPSyncView.this.openHDDirectory(new File(dir));
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    public class SettingMonitor
    implements Preferences.IPropertyChangeListener {
        public void propertyChange(Preferences.PropertyChangeEvent event) {
            log.info((Object)event.getProperty());
            if (event.getProperty().equals("explorer.paths")) {
                PSPSyncView.this.updateExplorerPaths();
            }
        }
    }
}

