/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.baseadaptor.bundlefile;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.bundlefile.FileBundleEntry;
import org.eclipse.osgi.internal.baseadaptor.AdaptorMsg;
import org.eclipse.osgi.util.NLS;

public class DirBundleFile
extends BundleFile {
    public DirBundleFile(File basefile) throws IOException {
        super(basefile);
        if (!BundleFile.secureAction.exists(basefile) || !BundleFile.secureAction.isDirectory(basefile)) {
            throw new IOException(NLS.bind(AdaptorMsg.ADAPTOR_DIRECTORY_EXCEPTION, basefile));
        }
    }

    public File getFile(String path, boolean nativeCode) {
        File filePath = new File(this.basefile, path);
        if (BundleFile.secureAction.exists(filePath)) {
            return filePath;
        }
        return null;
    }

    public BundleEntry getEntry(String path) {
        File filePath = new File(this.basefile, path);
        if (!BundleFile.secureAction.exists(filePath)) {
            return null;
        }
        return new FileBundleEntry(filePath, path);
    }

    public boolean containsDir(String dir) {
        File dirPath = new File(this.basefile, dir);
        return BundleFile.secureAction.exists(dirPath) && BundleFile.secureAction.isDirectory(dirPath);
    }

    public Enumeration getEntryPaths(final String path) {
        final File pathFile = new File(this.basefile, path);
        if (!BundleFile.secureAction.exists(pathFile)) {
            return null;
        }
        if (BundleFile.secureAction.isDirectory(pathFile)) {
            final String[] fileList = BundleFile.secureAction.list(pathFile);
            if (fileList == null || fileList.length == 0) {
                return null;
            }
            final String dirPath = path.length() == 0 || path.charAt(path.length() - 1) == '/' ? path : String.valueOf(path) + '/';
            return new Enumeration(){
                int cur = 0;

                public boolean hasMoreElements() {
                    return fileList != null && this.cur < fileList.length;
                }

                public Object nextElement() {
                    if (!this.hasMoreElements()) {
                        throw new NoSuchElementException();
                    }
                    File childFile = new File(pathFile, fileList[this.cur]);
                    StringBuffer sb = new StringBuffer(dirPath).append(fileList[this.cur++]);
                    if (BundleFile.secureAction.isDirectory(childFile)) {
                        sb.append("/");
                    }
                    return sb.toString();
                }
            };
        }
        return new Enumeration(){
            int cur = 0;

            public boolean hasMoreElements() {
                return this.cur < 1;
            }

            public Object nextElement() {
                if (this.cur == 0) {
                    this.cur = 1;
                    return path;
                }
                throw new NoSuchElementException();
            }
        };
    }

    public void close() {
    }

    public void open() {
    }
}

