/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.audio;

public class MpegAudioFormatUtil {
    public static final int MPEG_VERSION1 = 0;
    public static final int MPEG_VERSION2 = 1;
    public static final int MPEG_VERSION25 = 2;
    public static final int MPEG_LAYER1 = 1;
    public static final int MPEG_LAYER2 = 2;
    public static final int MPEG_LAYER3 = 0;
    public static final int[] official_mp3_framerate = new int[]{16000, 22050, 24000, 32000, 44100, 48000};
    public static final int[] common_mp3_bitrate = new int[]{32, 40, 48, 56, 64, 80, 96, 112, 128, 160};

    public static final int[] getAvailableFrameRate(int mpegVersion) {
        if (mpegVersion == 0) {
            return new int[]{44100, 48000, 32000};
        }
        if (mpegVersion == 1) {
            return new int[]{22050, 24000, 16000};
        }
        if (mpegVersion == 2) {
            return new int[]{11025, 12000, 8000};
        }
        return new int[0];
    }

    public static final int[] getAvailableBitrate(int MPEG_VERSION, int MPEG_LAYER) {
        if (MPEG_VERSION == 0) {
            if (MPEG_LAYER == 1) {
                return new int[]{32, 64, 96, 128, 160, 192, 224, 256, 288, 320, 352, 384, 416, 448};
            }
            if (MPEG_LAYER == 2) {
                return new int[]{32, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320, 384};
            }
            if (MPEG_LAYER == 0) {
                return new int[]{32, 40, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320};
            }
        } else if (MPEG_VERSION == 1 || MPEG_VERSION == 2) {
            if (MPEG_LAYER == 1) {
                return new int[]{32, 48, 56, 64, 80, 96, 112, 128, 144, 160, 176, 192, 224, 256};
            }
            if (MPEG_LAYER == 2 || MPEG_LAYER == 0) {
                return new int[]{8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160};
            }
        }
        return new int[0];
    }

    public static final int getSimilarValue(int[] values, int value) {
        int[] s = new int[values.length];
        int i = 0;
        while (i < values.length) {
            if (values[i] == value) {
                return value;
            }
            s[i] = values[i] - value;
            ++i;
        }
        int m = values.length - 1;
        int i2 = 0;
        while (i2 < s.length - 1) {
            if (Math.abs(s[i2]) < Math.abs(s[m])) {
                m = i2;
            } else if (Math.abs(s[i2]) == Math.abs(s[m]) && s[i2] > s[m]) {
                m = i2;
            }
            ++i2;
        }
        return values[m];
    }

    public static final int[] getAvailableMP3Bitrate(int framerate) {
        int version = MpegAudioFormatUtil.getMpegVersion(framerate);
        return MpegAudioFormatUtil.getAvailableBitrate(version, 0);
    }

    public static final int getMpegVersion(int framerate) {
        int[] v1 = MpegAudioFormatUtil.getAvailableFrameRate(0);
        int i = 0;
        while (i < v1.length) {
            if (v1[i] == framerate) {
                return 0;
            }
            ++i;
        }
        int[] v2 = MpegAudioFormatUtil.getAvailableFrameRate(1);
        int i2 = 0;
        while (i2 < v2.length) {
            if (v2[i2] == framerate) {
                return 1;
            }
            ++i2;
        }
        int[] v25 = MpegAudioFormatUtil.getAvailableFrameRate(2);
        int i3 = 0;
        while (i3 < v25.length) {
            if (v25[i3] == framerate) {
                return 2;
            }
            ++i3;
        }
        return -1;
    }
}

