/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ffmpeg;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegCommandUtil;
import jp.sourceforge.akjrcp.ffmpeg.JpegPipeWriter;
import jp.sourceforge.akjrcp.ffmpeg.ProcessListener;
import jp.sourceforge.akjrcp.util.DoNothingProcessPrinter;
import jp.sourceforge.akjrcp.util.ProcessMonitor;

public class FFMpegJpegPipeWriter
implements Runnable {
    JpegPipeWriter jpegPipeWriter;
    private String[] command;
    private Process process;
    ProcessListener processListener;

    public FFMpegJpegPipeWriter(String ffmpegPath, boolean overwrite, String[] pipeInputOption, String[] outputOption, String outputPath) {
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < outputOption.length) {
            list.add(outputOption[i]);
            ++i;
        }
        list.add(outputPath);
        String[] options = list.toArray(new String[0]);
        this.command = FFMpegCommandUtil.makeInputPipeCommand(ffmpegPath, overwrite, pipeInputOption, options);
    }

    public void run() {
        Runtime runtime = Runtime.getRuntime();
        try {
            this.process = runtime.exec(this.command);
            DoNothingProcessPrinter printer = new DoNothingProcessPrinter();
            ProcessMonitor monitor = new ProcessMonitor(this.process, printer);
            monitor.startMonitor();
            this.jpegPipeWriter = new JpegPipeWriter(this.process.getOutputStream());
            if (this.processListener != null) {
                this.processListener.started();
            }
            try {
                Thread.sleep(13000L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            try {
                this.process.waitFor();
                if (this.processListener != null) {
                    this.processListener.finished();
                }
                System.out.println("write process finished:" + this.process.exitValue());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public void closeError() {
        InputStream input;
        if (this.process != null && (input = this.process.getErrorStream()) != null) {
            try {
                input.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void closeInput() {
        InputStream input;
        if (this.process != null && (input = this.process.getInputStream()) != null) {
            try {
                input.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void cancel() {
        if (this.process != null) {
            this.process.destroy();
        }
    }

    public void close() throws IOException {
        if (this.jpegPipeWriter != null) {
            this.jpegPipeWriter.close();
        }
    }

    public String[] getCommand() {
        return this.command;
    }

    public void setCommand(String[] command) {
        this.command = command;
    }

    public JpegPipeWriter getJpegPipeWriter() {
        return this.jpegPipeWriter;
    }

    public void setJpegPipeWriter(JpegPipeWriter jpegPipeWriter) {
        this.jpegPipeWriter = jpegPipeWriter;
    }

    public Process getProcess() {
        return this.process;
    }

    public void setProcess(Process process) {
        this.process = process;
    }

    public ProcessListener getProcessListener() {
        return this.processListener;
    }

    public void setProcessListener(ProcessListener processListener) {
        this.processListener = processListener;
    }
}

