/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.psp.commands;

import java.io.File;
import java.io.IOException;
import jp.sourceforge.akjrcp.psp.PSPIOCommand;
import jp.sourceforge.akjrcp.psp.PSPSyncView;
import jp.sourceforge.akjrcp.util.image.ImageUtils;
import org.apache.commons.io.FileUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;

public abstract class AbstractIOCommand
implements PSPIOCommand {
    private File srcFile;
    private File destFile;
    private boolean pSPSrc;
    private boolean canceld;
    private boolean overwrite;

    public boolean isPSPSrc() {
        return this.pSPSrc;
    }

    public void setPSPSrc(boolean src) {
        this.pSPSrc = src;
    }

    public File getDestFile() {
        return this.destFile;
    }

    public void setDestFile(File destFile) {
        this.destFile = destFile;
    }

    public File getSrcFile() {
        return this.srcFile;
    }

    public void setSrcFile(File srcFile) {
        this.srcFile = srcFile;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public boolean isCanceld() {
        return this.canceld;
    }

    public void setCanceld(boolean canceld) {
        this.canceld = canceld;
    }

    public File toPSPThumbnailFile(File imgFile) {
        if (imgFile != null && imgFile.exists()) {
            File thumbFile = imgFile;
            try {
                Image checkImage = new Image(null, imgFile.getAbsolutePath());
                if (checkImage != null) {
                    if (checkImage.getBounds().width > 160 || checkImage.getBounds().height > 120) {
                        File tmp = File.createTempFile("image", ".jpg");
                        tmp.deleteOnExit();
                        Image newthumb = ImageUtils.createThumbnail(checkImage, 160, 120);
                        ImageLoader loader = new ImageLoader();
                        loader.data = new ImageData[]{newthumb.getImageData()};
                        loader.save(tmp.getAbsolutePath(), 4);
                        thumbFile = tmp;
                    }
                } else {
                    PSPSyncView.log.warn((Object)("image is wrong:" + imgFile));
                }
            }
            catch (Exception e) {
                PSPSyncView.log.warn((Object)("image copy faild:" + imgFile));
                e.printStackTrace();
            }
            return thumbFile;
        }
        return null;
    }

    public static boolean canWrite(File file) {
        boolean canwrite = false;
        if (file.exists()) {
            canwrite = file.canWrite();
        } else {
            try {
                FileUtils.touch((File)file);
            }
            catch (IOException iOException) {}
            if (file.exists()) {
                canwrite = file.delete();
            }
        }
        return canwrite;
    }
}

