/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import jp.sourceforge.akjrcp.util.ProcessMonitor;
import jp.sourceforge.akjrcp.util.ProcessPrinter;

public class FFMpegExecuter {
    private String ffmpegPath;
    private File input;
    private File output;
    private ProcessPrinter printer;
    private int videoBitrate;
    private int audioBitrate;
    private int audioSampleRate;
    private int audioChannel;
    private double videoRate;
    private String videoSize;
    private boolean useAvisynth;

    public boolean isUseAvisynth() {
        return this.useAvisynth;
    }

    public void setUseAvisynth(boolean useAvisynth) {
        this.useAvisynth = useAvisynth;
    }

    public FFMpegExecuter(String ffmpegPath, ProcessPrinter printer) {
        this.ffmpegPath = ffmpegPath;
        this.printer = printer;
    }

    public void execute() throws IOException {
        Runtime runtime = Runtime.getRuntime();
        String[] commands = this.toCommands();
        this.printer.printOutput(this.toDebugArray(commands));
        Process process = runtime.exec(commands);
        ProcessMonitor monitor = new ProcessMonitor(process, this.printer);
        monitor.startMonitor();
        try {
            process.waitFor();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public String toDebugArray(String[] array) {
        String v = "";
        int i = 0;
        while (i < array.length) {
            v = String.valueOf(v) + "\"" + array[i] + "\"" + " ";
            ++i;
        }
        return String.valueOf(v) + "\n";
    }

    public String[] toCommands() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.ffmpegPath);
        list.add("-i");
        list.add(this.input.getAbsolutePath());
        if (this.videoBitrate != 0) {
            list.add("-b");
            list.add(this.videoBitrate + "k");
        }
        if (this.videoRate != 0.0) {
            list.add("-r");
            list.add("" + this.videoRate);
        }
        if (this.videoSize != null) {
            list.add("-s");
            list.add(this.videoSize);
        }
        if (this.audioSampleRate != 0) {
            list.add("-ar");
            list.add("" + this.audioSampleRate);
        }
        if (this.audioBitrate != 0) {
            list.add("-ab");
            list.add(this.audioBitrate + "k");
        }
        if (this.audioChannel != 0) {
            list.add("-ac");
            list.add("" + this.audioChannel);
        }
        list.add(this.output.getAbsolutePath());
        return list.toArray(new String[0]);
    }

    public int getAudioBitrate() {
        return this.audioBitrate;
    }

    public void setAudioBitrate(int audioBitrate) {
        this.audioBitrate = audioBitrate;
    }

    public int getAudioChannel() {
        return this.audioChannel;
    }

    public void setAudioChannel(int audioChannel) {
        this.audioChannel = audioChannel;
    }

    public int getAudioSampleRate() {
        return this.audioSampleRate;
    }

    public void setAudioSampleRate(int audioSampleRate) {
        this.audioSampleRate = audioSampleRate;
    }

    public String getFfmpegPath() {
        return this.ffmpegPath;
    }

    public void setFfmpegPath(String ffmpegPath) {
        this.ffmpegPath = ffmpegPath;
    }

    public File getInput() {
        return this.input;
    }

    public void setInput(File input) {
        this.input = input;
    }

    public File getOutput() {
        return this.output;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public int getVideoBitrate() {
        return this.videoBitrate;
    }

    public void setVideoBitrate(int videoBitrate) {
        this.videoBitrate = videoBitrate;
    }

    public double getVideoRate() {
        return this.videoRate;
    }

    public void setVideoRate(double videoRate) {
        this.videoRate = videoRate;
    }

    public String getVideoSize() {
        return this.videoSize;
    }

    public void setVideoSize(String videoSize) {
        this.videoSize = videoSize;
    }

    public int getVideoWidth() {
        if (this.videoSize != null) {
            int sepa = this.videoSize.indexOf("x");
            int w = Integer.parseInt(this.videoSize.substring(0, sepa));
            return w;
        }
        return 0;
    }

    public int getVideoHeight() {
        if (this.videoSize != null) {
            int sepa = this.videoSize.indexOf("x");
            int h = Integer.parseInt(this.videoSize.substring(sepa + 1));
            return h;
        }
        return 0;
    }
}

