/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.events;

import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.framework.Bundle;

class AutoBuildJob
extends Job
implements Preferences.IPropertyChangeListener {
    private boolean avoidBuild = false;
    private boolean buildNeeded = false;
    private boolean forceBuild = false;
    private boolean isAutoBuilding = false;
    private boolean interrupted = false;
    private long lastBuild = 0L;
    private Workspace workspace;
    private final IJobManager jobManager = Platform.getJobManager();
    private final Bundle systemBundle = Platform.getBundle((String)"org.eclipse.osgi");
    private Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();

    AutoBuildJob(Workspace workspace) {
        super(Messages.events_building_0);
        this.setRule(workspace.getRoot());
        this.isAutoBuilding = workspace.isAutoBuilding();
        this.workspace = workspace;
        this.preferences.addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
    }

    synchronized void avoidBuild() {
        this.avoidBuild = true;
    }

    public boolean belongsTo(Object family) {
        return family == ResourcesPlugin.FAMILY_AUTO_BUILD;
    }

    synchronized void build(boolean needsBuild) {
        this.buildNeeded |= needsBuild;
        long delay = Math.max(100L, 1000L + this.lastBuild - System.currentTimeMillis());
        int state = this.getState();
        if (Policy.DEBUG_NEEDS_BUILD) {
            Policy.debug("Build requested, needsBuild: " + needsBuild + " state: " + state + " delay: " + delay);
        }
        if (state != 4) {
            this.interrupted = false;
        }
        switch (state) {
            case 1: {
                this.wakeUp(delay);
                break;
            }
            case 0: {
                this.setSystem(!this.isAutoBuilding);
                this.schedule(delay);
            }
        }
    }

    private synchronized IStatus canceled() {
        this.buildNeeded = true;
        if (this.interrupted) {
            if (Policy.DEBUG_BUILD_INTERRUPT) {
                System.out.println("Scheduling build in AutoBuildJob.cancel()");
            }
            this.interrupted = false;
            this.schedule();
        }
        return Status.CANCEL_STATUS;
    }

    synchronized void interrupt() {
        if (this.interrupted) {
            return;
        }
        switch (this.getState()) {
            case 0: {
                return;
            }
            case 2: {
                this.interrupted = !this.sleep();
                break;
            }
            case 4: {
                boolean bl = this.interrupted = this.jobManager.currentJob() != this;
                if (!this.interrupted || !Policy.DEBUG_BUILD_INTERRUPT) break;
                System.out.println("Autobuild was interrupted:");
                new Exception().fillInStackTrace().printStackTrace();
            }
        }
        if (this.interrupted) {
            this.avoidBuild = false;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doBuild(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        monitor = Policy.monitorFor(monitor);
        try {
            monitor.beginTask(null, Policy.opWork);
            ISchedulingRule rule = this.workspace.getRuleFactory().buildRule();
            try {
                this.workspace.prepareOperation(rule, monitor);
                this.workspace.beginOperation(true);
                this.workspace.broadcastBuildEvent(this.workspace, 8, 9);
                IStatus result = Status.OK_STATUS;
                if (this.shouldBuild()) {
                    result = this.workspace.getBuildManager().build(9, Policy.subMonitorFor(monitor, Policy.opWork));
                }
                this.workspace.broadcastBuildEvent(this.workspace, 16, 9);
                if (!result.isOK()) {
                    throw new ResourceException(result);
                }
                this.buildNeeded = false;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                if (this.workspace.getElementTree().isImmutable()) {
                    this.workspace.newWorkingTree();
                }
                this.workspace.endOperation(rule, false, Policy.subMonitorFor(monitor, Policy.endOpWork));
                throw throwable;
            }
            {
                Object var4_6 = null;
                if (this.workspace.getElementTree().isImmutable()) {
                    this.workspace.newWorkingTree();
                }
                this.workspace.endOperation(rule, false, Policy.subMonitorFor(monitor, Policy.endOpWork));
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var6_9 = null;
        }
        monitor.done();
    }

    public void forceBuild() {
        this.forceBuild = true;
    }

    synchronized boolean isInterrupted() {
        if (this.interrupted) {
            return true;
        }
        if (this.isBlocking()) {
            this.interrupted = true;
        }
        return this.interrupted;
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
        if (!event.getProperty().equals("description.autobuilding")) {
            return;
        }
        boolean wasAutoBuilding = this.isAutoBuilding;
        this.isAutoBuilding = this.preferences.getBoolean("description.autobuilding");
        if (!this.forceBuild && !wasAutoBuilding && this.isAutoBuilding) {
            this.forceBuild = true;
            this.build(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus run(IProgressMonitor monitor) {
        AutoBuildJob autoBuildJob = this;
        synchronized (autoBuildJob) {
            if (monitor.isCanceled()) {
                return this.canceled();
            }
        }
        if (this.systemBundle.getState() == 16) {
            return Status.OK_STATUS;
        }
        try {
            this.doBuild(monitor);
            this.lastBuild = System.currentTimeMillis();
            this.interrupted = false;
            return Status.OK_STATUS;
        }
        catch (OperationCanceledException operationCanceledException) {
            return this.canceled();
        }
        catch (CoreException sig) {
            return sig.getStatus();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized boolean shouldBuild() {
        try {
            block8: {
                block7: {
                    block6: {
                        if (this.workspace.isAutoBuilding()) break block6;
                        break block7;
                    }
                    if (this.forceBuild) {
                        Object var1_2 = null;
                        this.buildNeeded = false;
                        this.avoidBuild = false;
                        this.forceBuild = false;
                        return true;
                    }
                    if (!this.avoidBuild) break block8;
                }
                Object var1_1 = null;
                this.buildNeeded = false;
                this.avoidBuild = false;
                this.forceBuild = false;
                return false;
            }
            boolean bl = this.buildNeeded;
            Object var1_3 = null;
            this.buildNeeded = false;
            this.avoidBuild = false;
            this.forceBuild = false;
            return bl;
        }
        catch (Throwable throwable) {
            Object var1_4 = null;
            this.buildNeeded = false;
            this.avoidBuild = false;
            this.forceBuild = false;
            throw throwable;
        }
    }
}

