/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.dropsomething;

import java.io.File;
import jp.sourceforge.akjrcp.akj_betas.Akj_betasPlugin;
import jp.sourceforge.akjrcp.akj_betas.Messages;
import jp.sourceforge.akjrcp.audio.WavAudioSettingComposite;
import jp.sourceforge.akjrcp.dropsomething.DirectoryBasedDropSomething;
import jp.sourceforge.akjrcp.dropsomething.IDropSomething;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegExecuter;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegUtils;
import jp.sourceforge.akjrcp.ffmpeg.WavFFMpegPreference;
import jp.sourceforge.akjrcp.ui.DirectryBasedExecuterListener;
import jp.sourceforge.akjrcp.ui.FileOverwriteControler;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class WavConvertTabBuilder
implements IDropSomething {
    private FileOverwriteControler fileOverwriteControler;
    private CTabFolder tab;

    public void createTab(ViewPart part, CTabFolder tab) {
        CTabItem tabItem1 = new CTabItem(tab, 0);
        tabItem1.setText(Messages.getString("dropsomething.wavaudio"));
        WavConvertTab dtab = new WavConvertTab((Composite)tab, 0);
        dtab.setViewPart(part);
        tabItem1.setControl((Control)dtab);
        this.tab = tab;
    }

    public class WavConvertTab
    extends DirectoryBasedDropSomething {
        private FFMpegExecuter ffmpegExecuter;
        private CLabel dragHere;
        private Button forceConvert;
        private WavAudioSettingComposite wavSetting;
        private Button useAvisynth;
        private int convertRate;
        private int convertChannel;
        private boolean isForceConvert;
        private Image noFFMpeg;
        private Image canConvert;

        public WavConvertTab(Composite parent, int style) {
            super(parent, style);
        }

        public Composite createControls(Composite parent) {
            this.setPreferenceKey("wavconverttab");
            this.getPreferenceStore().setDefault(String.valueOf(this.getPreferenceKey()) + "." + "forceconvert", false);
            this.getPreferenceStore().setDefault(String.valueOf(this.getPreferenceKey()) + "." + "useAvisynth", false);
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(1, true));
            Group exportDir = new Group(composite, 0);
            exportDir.setToolTipText(Messages.getString("mp3convert.exportDir.tooltip"));
            exportDir.setLayout((Layout)new GridLayout());
            exportDir.setLayoutData((Object)new GridData(768));
            exportDir.setText(Messages.getString("mp3convert.exportDir"));
            this.createDirectoryInfo((Composite)exportDir);
            Group detailSetting = new Group(composite, 0);
            detailSetting.setLayout((Layout)new FillLayout());
            detailSetting.setLayoutData((Object)new GridData(1808));
            detailSetting.setText(Messages.getString("mp3convert.detail"));
            ExpandBar bar = new ExpandBar((Composite)detailSetting, 512);
            Composite advancedSetting = new Composite((Composite)bar, 0);
            advancedSetting.setLayout((Layout)new GridLayout(1, false));
            Composite changebase = new Composite(advancedSetting, 0);
            changebase.setLayout((Layout)new RowLayout());
            this.forceConvert = new Button(changebase, 32);
            this.forceConvert.setText(Messages.getString("mp3convert.forceconvert"));
            this.wavSetting = new WavAudioSettingComposite(changebase, 0, false, this.getPreferenceKey());
            ExpandItem item1 = new ExpandItem(bar, 0, 0);
            item1.setText(Messages.getString("mp3convert.convertsetting"));
            item1.setHeight(advancedSetting.computeSize((int)-1, (int)-1).y);
            item1.setControl((Control)advancedSetting);
            this.forceConvert.addSelectionListener((SelectionListener)new SynchEnabled(this.wavSetting));
            Composite avisynthBase = new Composite((Composite)bar, 0);
            avisynthBase.setLayout((Layout)new RowLayout());
            this.useAvisynth = new Button(avisynthBase, 32);
            this.useAvisynth.setText(Messages.getString("mp3convert.useAvisynth"));
            ExpandItem item3 = new ExpandItem(bar, 0, 1);
            item3.setText(Messages.getString("mp3convert.about_useAvisynth"));
            item3.setHeight(avisynthBase.computeSize((int)-1, (int)-1).y);
            item3.setControl((Control)avisynthBase);
            this.canConvert = AbstractUIPlugin.imageDescriptorFromPlugin((String)"jp.sourceforge.akjrcp.akj_betas", (String)"icons/dandd_wav.png").createImage();
            this.noFFMpeg = AbstractUIPlugin.imageDescriptorFromPlugin((String)"jp.sourceforge.akjrcp.akj_betas", (String)"icons/dandd_noffmpeg.png").createImage();
            this.dragHere = new CLabel(composite, 18432);
            this.dragHere.setBackground(ColorConstants.white);
            this.dragHere.setImage(this.canConvert);
            this.dragHere.setAlignment(0x1000000);
            this.dragHere.setLayoutData((Object)new GridData(768));
            SavePreferenceStore sps = new SavePreferenceStore();
            this.restoreControl((Control)this.forceConvert);
            this.restoreControl((Control)this.useAvisynth);
            this.forceConvert.addSelectionListener((SelectionListener)sps);
            this.useAvisynth.addSelectionListener((SelectionListener)sps);
            this.wavSetting.setEnabled(this.forceConvert.getSelection());
            this.wavSetting.setPreferenceStore(this.getPreferenceStore());
            this.setCanConvert(true);
            this.updateStatus();
            Akj_betasPlugin.getDefault().getPluginPreferences().addPropertyChangeListener((Preferences.IPropertyChangeListener)new SettingMonitor());
            return composite;
        }

        public void restoreControl(Control control) {
            IPreferenceStore store = this.getPreferenceStore();
            if (control == this.forceConvert) {
                this.forceConvert.setSelection(store.getBoolean(String.valueOf(this.getPreferenceKey()) + "." + "forceconvert"));
            } else if (control == this.useAvisynth) {
                this.useAvisynth.setSelection(store.getBoolean(String.valueOf(this.getPreferenceKey()) + "." + "useAvisynth"));
            }
        }

        public IPreferenceStore getPreferenceStore() {
            return Akj_betasPlugin.getDefault().getPreferenceStore();
        }

        public void storeControl(Control control) {
            IPreferenceStore store = this.getPreferenceStore();
            if (control == this.forceConvert) {
                store.setValue(String.valueOf(this.getPreferenceKey()) + "." + "forceconvert", this.forceConvert.getSelection());
            } else if (control == this.useAvisynth) {
                store.setValue(String.valueOf(this.getPreferenceKey()) + "." + "useAvisynth", this.useAvisynth.getSelection());
            }
        }

        public void inconvert(File file) {
            this.ffmpegExecuter.execute(new File[]{file});
        }

        public void beforeConvert() {
            WavConvertTabBuilder.this.fileOverwriteControler = new FileOverwriteControler(WavConvertTabBuilder.this.tab.getShell());
            this.ffmpegExecuter = new FFMpegExecuter();
            this.ffmpegExecuter.setIgnoreAvisynthExtensions(new String[0]);
            this.ffmpegExecuter.setExecuteListener(new FFMpegMonitor());
            String ffmpegPath = Akj_betasPlugin.getDefault().getFFmpegOrPureFFMpeg();
            if (ffmpegPath == null) {
                log.warn((Object)"ffmpegPath is null");
                this.actionCancel();
            }
            WavFFMpegPreference preference = new WavFFMpegPreference();
            this.ffmpegExecuter.setFfmpegPreference(preference);
            Akj_betasPlugin.getDefault().getPreferenceStore().getBoolean("ffmpeg.use_thread");
            preference.setFfmpegPath(ffmpegPath);
            preference.setExtension("wav");
            this.ffmpegExecuter.setSameDirectory(this.samefolder.getSelection());
            this.ffmpegExecuter.setBackup(this.backup.getSelection());
            if (!this.samefolder.getSelection()) {
                this.ffmpegExecuter.setExportDir(this.directoryChooser.getAbsoluteFilePath());
            }
            this.ffmpegExecuter.setUseAvisynth(this.useAvisynth.getSelection());
            preference.setConvertFramerate(this.wavSetting.getFramerate());
            preference.setConvertChannel(this.wavSetting.getChannel());
            preference.setForceConvert(this.forceConvert.getSelection());
        }

        public void afterConvert() {
            WavConvertTabBuilder.this.fileOverwriteControler = null;
        }

        public boolean isCanConvert() {
            String ffmpegPath = Akj_betasPlugin.getDefault().getFFmpegOrPureFFMpeg();
            if (!FFMpegUtils.isFFMpegAvailable(ffmpegPath)) {
                return false;
            }
            return super.isCanConvert();
        }

        public void cancelConvert() {
            if (this.ffmpegExecuter != null) {
                this.ffmpegExecuter.cancel();
            }
        }

        public void updateStatus() {
            String ffmpegPath = Akj_betasPlugin.getDefault().getFFmpegOrPureFFMpeg();
            if (ffmpegPath == null) {
                if (this.noFFMpeg != null) {
                    this.dragHere.setImage(this.noFFMpeg);
                }
                this.setMessage(Messages.getString(""));
                this.setCanConvert(true);
            } else {
                if (this.canConvert != null) {
                    this.dragHere.setImage(this.canConvert);
                }
                if (this.samefolder.getSelection() || this.directoryChooser.getFile() != null) {
                    this.setMessage(Messages.getString("dropsomething.drag_folder"));
                    this.setCanConvert(true);
                } else {
                    this.setErrorMessage(Messages.getString("dropsomething.choose_folder"));
                    this.setCanConvert(false);
                }
            }
        }

        public void setMessage(String text) {
            if (this.dragHere != null) {
                this.dragHere.setForeground(new Color(null, 64, 255, 64));
                this.dragHere.setText(text);
            }
        }

        public void setErrorMessage(String text) {
            if (this.dragHere != null) {
                this.dragHere.setForeground(new Color(null, 255, 0, 0));
                this.dragHere.setText(text);
            }
        }

        public class SynchEnabled
        implements SelectionListener {
            private Composite target;

            public SynchEnabled(Composite target) {
                this.target = target;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.target.setEnabled(((Button)e.getSource()).getSelection());
            }

            public void widgetSelected(SelectionEvent e) {
                this.target.setEnabled(((Button)e.getSource()).getSelection());
            }
        }

        public class SavePreferenceStore
        implements SelectionListener {
            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                WavConvertTab.this.storeControl((Control)e.getSource());
            }
        }

        public class SettingMonitor
        implements Preferences.IPropertyChangeListener {
            public void propertyChange(Preferences.PropertyChangeEvent event) {
                log.info((Object)event.getProperty());
                if (event.getProperty().equals("ffmpeg.pure_ffmpeg_path")) {
                    WavConvertTab.this.updateStatus();
                } else if (event.getProperty().equals("ffmpeg.ffmpeg_path")) {
                    WavConvertTab.this.updateStatus();
                }
            }
        }

        public class FFMpegMonitor
        implements DirectryBasedExecuterListener {
            public void beforeConvert() {
            }

            public void afterConvert() {
                WavConvertTab.this.setProgress(0);
            }

            public void startConvert(File file) {
                WavConvertTab.this.setProgress(0);
                log.info((Object)("set guess:" + WavConvertTab.this.ffmpegExecuter.getGuessSize() + "kB"));
                WavConvertTab.this.setProgressMaxBytes(WavConvertTab.this.ffmpegExecuter.getGuessSize());
            }

            public void endConvert(File file) {
                Akj_betasPlugin.getDefault().getProcessPrinter().printOutput("[complete:mpeg]" + file.getAbsolutePath());
                WavConvertTab.this.setProgress(100);
            }

            public void faildConvert(File file, String message) {
                Akj_betasPlugin.getDefault().getProcessPrinter().printOutput("[faild:mpeg]" + message + "," + file.getAbsolutePath());
            }

            public void printProcess(String line) {
                Akj_betasPlugin.getDefault().getProcessPrinter().printError(line);
                if (FFMpegUtils.isProgressString(line)) {
                    WavConvertTab.this.progressBytes(FFMpegUtils.getProgressSize(line));
                }
            }

            public boolean askOverwrite(File output) {
                return FileOverwriteControler.askOverwrite(WavConvertTabBuilder.this.fileOverwriteControler, output);
            }
        }
    }
}

