/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.flvtools.explorer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import jp.sourceforge.akjrcp.akj_betas.Akj_betasPlugin;
import jp.sourceforge.akjrcp.dropsomething.PSPConvertTabBuilder;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegCommandUtil;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegFLVParser;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegInput;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegPreference;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegUI;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegUtils;
import jp.sourceforge.akjrcp.ffmpeg.SimpleCommandExecuter;
import jp.sourceforge.akjrcp.flvtools.basic.ShareSettingPage;
import jp.sourceforge.akjrcp.flvtools.explorer.ExplorerView;
import jp.sourceforge.akjrcp.flvtools.explorer.FFMpegExecutable;
import jp.sourceforge.akjrcp.psp.PSPMovieSettingTableViewer;
import jp.sourceforge.akjrcp.util.FileNameUtils;
import jp.sourceforge.akjrcp.util.ProcessMonitor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.PlatformUI;

public class FFMpegExplorerExecuter
extends Thread {
    public static Log log = LogFactory.getLog(FFMpegExplorerExecuter.class);
    private String extension;
    private File[] convertingFile;
    private File exportBaseDir;
    private ExplorerView ffmpegExecutable;
    private boolean converting = true;
    private Process currentProcess;

    public FFMpegExplorerExecuter(ExplorerView ffmpegExecutable) {
        this.ffmpegExecutable = ffmpegExecutable;
    }

    public void cancel() {
        if (this.currentProcess != null) {
            this.currentProcess.destroy();
        }
        this.converting = false;
    }

    public void debugArray(String[] array) {
        String v = "";
        int i = 0;
        while (i < array.length) {
            v = String.valueOf(v) + "\"" + array[i] + "\"" + " ";
            ++i;
        }
        Akj_betasPlugin.getDefault().getProcessPrinter().printOutput(String.valueOf(v) + "\n");
    }

    public static boolean isImageExport(String extension) {
        return extension.equals("png") || extension.equals("jpg") || extension.equals("gif");
    }

    public void startExecute() {
        this.ffmpegExecutable.startExecute(this.convertingFile);
        this.start();
    }

    public static boolean canPureFFMpeg(String extension) {
        boolean ret;
        block14: {
            IPreferenceStore store;
            block13: {
                store = Akj_betasPlugin.getDefault().getPreferenceStore();
                ret = false;
                if (FFMpegExplorerExecuter.isImageExport(extension)) {
                    return true;
                }
                if (extension.equals("wav")) {
                    return true;
                }
                if (!extension.equals("avi")) break block13;
                boolean canvideo = false;
                String avicodec = store.getString("avisetting.video");
                String[] canvideos = new String[]{"copy", "huffyuv", "mjpeg", "msmpeg4v1", "msmpeg4v2"};
                int i = 0;
                while (i < canvideos.length) {
                    if (canvideos[i].equals(avicodec)) {
                        canvideo = true;
                        break;
                    }
                    ++i;
                }
                if (!canvideo) break block14;
                String audiocodec = store.getString("avisetting.audio");
                String[] canaudios = new String[]{"copy", "pcm_s16le", "wmav1", "wmav2"};
                int i2 = 0;
                while (i2 < canaudios.length) {
                    if (canaudios[i2].equals(audiocodec)) {
                        return true;
                    }
                    ++i2;
                }
                break block14;
            }
            if (extension.equals("wmv")) {
                String audiocodec = store.getString("wmvsetting.audio");
                String[] canaudios = new String[]{"copy", "pcm_s16le", "wmav1", "wmav2"};
                int i = 0;
                while (i < canaudios.length) {
                    if (canaudios[i].equals(audiocodec)) {
                        return true;
                    }
                    ++i;
                }
            } else if (extension.equals("mpg")) {
                String audiocodec = store.getString("mpegsetting.audio");
                String[] canaudios = new String[]{"mp2"};
                int i = 0;
                while (i < canaudios.length) {
                    if (canaudios[i].equals(audiocodec)) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        tmpAudio = null;
        tmpVideo = null;
        store = Akj_betasPlugin.getDefault().getPreferenceStore();
        if (FFMpegExplorerExecuter.canPureFFMpeg(this.extension)) {
            FFMpegExplorerExecuter.log.info((Object)"can pure ffmpeg.exe");
            ffmpegPath = FFMpegUI.getFFmpegOrPureFFMpeg();
        } else {
            ffmpegPath = FFMpegUI.getFFmpeg();
        }
        FFMpegExplorerExecuter.log.info((Object)ffmpegPath);
        if (ffmpegPath == null) {
            this.cancel();
            return;
        }
        fileDeleted = false;
        generation = FFMpegUtils.getFFMpegGeneration(ffmpegPath);
        FFMpegExplorerExecuter.log.info((Object)("generation:" + generation));
        i = 0;
        while (i < this.convertingFile.length) {
            block56: {
                block57: {
                    if (!this.converting) break;
                    this.ffmpegExecutable.executingFile(this.convertingFile[i], i);
                    ExplorerView.log.info((Object)("converting:" + this.convertingFile[i]));
                    PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new ConvertMonitorStartSubTask(this.convertingFile[i].getName()));
                    monitor = null;
                    runtime = Runtime.getRuntime();
                    param = new ArrayList<String>();
                    param.add(ffmpegPath);
                    flvInfo = new FFMpegFLVParser(ffmpegPath).parseFile(this.convertingFile[i]);
                    if (this.convertingFile[i].getName().toLowerCase().endsWith(".flv") && flvInfo.getVideoCodec().equals("vp6f") && PlatformUI.getPreferenceStore().getBoolean("ffmpeg.demux_dome_video")) {
                        FFMpegExplorerExecuter.log.info((Object)"demux vp6");
                        try {
                            tmpAudio = File.createTempFile("vp6", ".mp3");
                            tmpAudio.deleteOnExit();
                            command = FFMpegCommandUtil.makeCopyAudioCommand(ffmpegPath, this.convertingFile[i].getAbsolutePath(), tmpAudio.getAbsolutePath());
                            executer1 = new SimpleCommandExecuter(command);
                            executer1.execute();
                            FFMpegExplorerExecuter.log.info((Object)"demuxed audio");
                            tmpVideo = File.createTempFile("vp6", ".avi");
                            tmpVideo.deleteOnExit();
                            command2 = FFMpegCommandUtil.makeCopyVideoCommand(ffmpegPath, this.convertingFile[i].getAbsolutePath(), tmpVideo.getAbsolutePath());
                            executer2 = new SimpleCommandExecuter(command2);
                            executer2.execute();
                            FFMpegExplorerExecuter.log.info((Object)"demuxed video");
                            param.add("-f");
                            param.add("mp3");
                            param.add("-i");
                            param.add(tmpAudio.getAbsolutePath());
                            param.add("-i");
                            param.add(tmpVideo.getAbsolutePath());
                        }
                        catch (IOException e) {
                            this.cancel();
                            e.printStackTrace();
                            FFMpegExplorerExecuter.log.warn((Object)"faild vp6 special");
                            return;
                        }
                    } else {
                        param.add("-i");
                        param.add(this.convertingFile[i].getAbsolutePath());
                    }
                    if (FFMpegExplorerExecuter.isImageExport(this.extension)) {
                        param.add("-f");
                        param.add("image2");
                        param.add("-ss");
                        param.add(store.getString("image_time"));
                        param.add("-vframes");
                        param.add("1");
                    } else {
                        param.add("-b");
                        param.add(store.getInt("video_bitrate") + "k");
                        param.add("-ab");
                        param.add(store.getInt("audio_bitrate") + "k");
                        param.add("-ar");
                        param.add("" + store.getInt("export.wave.samplerate"));
                        param.add("-ac");
                        param.add("" + store.getInt("export.wave.channel"));
                        fps = ShareSettingPage.getVideoFps(store);
                        if (fps != null) {
                            param.add("-r");
                            param.add(fps);
                        }
                        if ((size = ShareSettingPage.getVideoSize(store)) != null) {
                            param.add("-s");
                            param.add(size);
                        }
                        optionString = store.getString("ffmpeg_option");
                        if (this.extension.equals("avi")) {
                            vtag = null;
                            param.add("-vcodec");
                            avicodec = store.getString("avisetting.video");
                            if (avicodec.equals("xvid")) {
                                vtag = "XVID";
                                if (size == null && FFMpegUtils.isOdd(flvInfo.getVideoWidth(), flvInfo.getVideoHeight())) {
                                    param.add("-s");
                                    newSize = FFMpegUtils.fixOddSize(flvInfo.getVideoWidth(), flvInfo.getVideoHeight());
                                    param.add(newSize);
                                }
                            } else if (avicodec.equals("copy")) {
                                if (flvInfo.getVideoCodec().equals("xvid")) {
                                    vtag = "XVID";
                                } else if (flvInfo.getVideoCodec().equals("vp6f")) {
                                    vtag = "VP62";
                                }
                            }
                            param.add(FFMpegPreference.toSuiteVideoCodec(avicodec, generation));
                            if (vtag != null) {
                                param.add("-vtag");
                                param.add(vtag);
                            }
                            if ((audioCodec = store.getString("avisetting.audio")).equals("NONE")) {
                                param.add("-an");
                            } else {
                                param.add("-acodec");
                                param.add(FFMpegPreference.toSuiteAudioCodec(store.getString("avisetting.audio"), generation));
                            }
                        } else if (this.extension.equals("wmv")) {
                            param.add("-vcodec");
                            param.add(store.getString("wmvsetting.video"));
                            param.add("-acodec");
                            param.add(store.getString("wmvsetting.audio"));
                            if (FFMpegUtils.isOdd(flvInfo.getVideoWidth(), flvInfo.getVideoHeight())) {
                                param.add("-s");
                                newSize = FFMpegUtils.fixOddSize(flvInfo.getVideoWidth(), flvInfo.getVideoHeight());
                                param.add(newSize);
                            }
                        } else if (this.extension.equals("mp3")) {
                            param.add("-acodec");
                            param.add("mp3");
                        } else if (this.extension.equals("mpg")) {
                            param.add("-vcodec");
                            param.add(store.getString("mpegsetting.video"));
                            param.add("-acodec");
                            param.add(store.getString("mpegsetting.audio"));
                            if (store.getString("mpegsetting.mpeg_type").equals("mpeg_type_cbr")) {
                                param.add("-maxrate");
                                param.add(store.getInt("video_bitrate") + "k");
                                param.add("-minrate");
                                param.add(store.getInt("video_bitrate") + "k");
                                param.add("-bufsize");
                                param.add("128k");
                            }
                        }
                        options = optionString.split(" ");
                        j = 0;
                        while (j < options.length) {
                            param.add(options[j]);
                            ++j;
                        }
                    }
                    currentFile = this.convertingFile[i];
                    if (this.exportBaseDir != null) {
                        currentFile = new File(this.exportBaseDir, this.convertingFile[i].getName());
                    }
                    param.add(FileNameUtils.getChangedExtensionName(currentFile, this.extension));
                    arg = param.toArray(new String[0]);
                    if (!this.extension.equals("psp")) ** GOTO lbl221
                    settings = PSPMovieSettingTableViewer.toPSPMovieSettings(Akj_betasPlugin.getDefault().getPreferenceStore().getString("pspsetting.movie_settings"));
                    if (settings.length != 0) break block56;
                    FFMpegExplorerExecuter.log.warn((Object)"psp setting not found");
                    if (tmpAudio == null) break block57;
                    tmpAudio.delete();
                    tmpAudio = null;
                }
                if (tmpVideo != null) {
                    tmpVideo.delete();
                    tmpVideo = null;
                }
                return;
            }
            try {
                try {
                    preference = PSPConvertTabBuilder.toPreference(settings[0]);
                    preference.setFfmpegPath(ffmpegPath);
                    arg = tmpAudio != null && tmpVideo != null ? preference.toCommand(new FFMpegInput[]{new FFMpegInput(tmpAudio.getAbsolutePath(), "mp3"), new FFMpegInput(tmpVideo.getAbsolutePath())}, FileNameUtils.getChangedExtensionName(currentFile, "mp4")) : preference.toCommand(this.convertingFile[i].getAbsolutePath(), null, FileNameUtils.getChangedExtensionName(currentFile, "mp4"));
lbl221:
                    // 2 sources

                    this.debugArray(arg);
                    this.currentProcess = runtime.exec(arg);
                    monitor = new ProcessMonitor(this.currentProcess, Akj_betasPlugin.getDefault().getProcessPrinter());
                    monitor.startMonitor();
                    try {
                        this.currentProcess.waitFor();
                        exitValue = this.currentProcess.exitValue();
                        if (exitValue == 0) {
                            if (this.extension.equals("psp")) {
                                if (store.getBoolean("explorer.delte_after_conver_mp4")) {
                                    this.convertingFile[i].delete();
                                    fileDeleted = true;
                                }
                            } else if (this.extension.equals("avi")) {
                                if (store.getBoolean("explorer.delte_after_conver_avi")) {
                                    this.convertingFile[i].delete();
                                    fileDeleted = true;
                                }
                            } else if (this.extension.equals("mpg")) {
                                if (store.getBoolean("explorer.delte_after_conver_mpg")) {
                                    this.convertingFile[i].delete();
                                    fileDeleted = true;
                                }
                            } else if (this.extension.equals("wmv") && store.getBoolean("explorer.delte_after_conver_wmv")) {
                                this.convertingFile[i].delete();
                                fileDeleted = true;
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (Throwable var16_22) {
                throw var16_22;
            }
            finally {
                if (tmpAudio != null) {
                    tmpAudio.delete();
                    tmpAudio = null;
                }
                if (tmpVideo != null) {
                    tmpVideo.delete();
                    tmpVideo = null;
                }
            }
            monitor.stop();
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new ConvertMonitorProcess());
            ++i;
        }
        if (fileDeleted) {
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new ReloadView());
        }
        this.ffmpegExecutable.executingFile(null, -1);
        PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new ConvertMonitorDone());
        PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)new FinishAction());
    }

    public File[] getFileList() {
        return this.convertingFile;
    }

    public FFMpegExecutable getFfmpegExecutable() {
        return this.ffmpegExecutable;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public File[] getConvertingFile() {
        return this.convertingFile;
    }

    public void setConvertingFile(File[] convertingFile) {
        this.convertingFile = convertingFile;
    }

    public File getExportBaseDir() {
        return this.exportBaseDir;
    }

    public void setExportBaseDir(File exportBaseDir) {
        this.exportBaseDir = exportBaseDir;
    }

    public class ReloadView
    extends Thread {
        public void run() {
            FFMpegExplorerExecuter.this.ffmpegExecutable.reload();
        }
    }

    public class FinishAction
    extends Thread {
        public void run() {
            FFMpegExplorerExecuter.this.ffmpegExecutable.finishExecute();
        }
    }

    public class ConvertMonitorStartSubTask
    extends Thread {
        String name;

        public ConvertMonitorStartSubTask(String name) {
            this.name = name;
        }

        public void run() {
            if (FFMpegExplorerExecuter.this.ffmpegExecutable.getProgressMonitor() != null) {
                FFMpegExplorerExecuter.this.ffmpegExecutable.getProgressMonitor().subTask(this.name);
            }
        }
    }

    public class ConvertMonitorProcess
    extends Thread {
        public void run() {
            if (FFMpegExplorerExecuter.this.ffmpegExecutable.getProgressMonitor() != null) {
                FFMpegExplorerExecuter.this.ffmpegExecutable.getProgressMonitor().worked(1);
            }
        }
    }

    public class ConvertMonitorDone
    extends Thread {
        public void run() {
            if (FFMpegExplorerExecuter.this.ffmpegExecutable.getProgressMonitor() != null) {
                FFMpegExplorerExecuter.this.ffmpegExecutable.getProgressMonitor().done();
            }
        }
    }
}

