/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import jp.sourceforge.akjrcp.ui.GenericParameters;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class GenericParametersTableViewer
extends TableViewer {
    private List parameterList;

    public GenericParameters getCurrentSelection() {
        int selection = this.getTable().getSelectionIndex();
        if (selection > -1) {
            return (GenericParameters)this.getGenericParameters().get(selection);
        }
        return null;
    }

    public GenericParametersTableViewer(Composite parent) {
        super(parent);
        ArrayList list = new ArrayList();
        this.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.setContentProvider((IContentProvider)new ViewContentProvider());
        this.setGenericParametersList(list);
    }

    public static List loadList(String value) {
        ArrayList<GenericParameters> list = new ArrayList<GenericParameters>();
        GenericParameters[] settings = GenericParametersTableViewer.toGenericParameters(value);
        int i = 0;
        while (i < settings.length) {
            list.add(settings[i]);
            ++i;
        }
        return list;
    }

    public String toLabel(GenericParameters setting) {
        String label = "";
        label = String.valueOf(label) + setting.getName() + " - " + StringUtils.replace((String)setting.getComment(), (String)"\n", (String)" ");
        return label;
    }

    public static GenericParameters[] toGenericParameters(String lines) {
        if (lines.length() == 0) {
            return new GenericParameters[0];
        }
        lines = StringUtils.replace((String)lines, (String)"\r\n", (String)"\n");
        String[] line = lines.split("\n");
        ArrayList<GenericParameters> tmpList = new ArrayList<GenericParameters>();
        int i = 0;
        while (i < line.length) {
            if (!line[i].equals("")) {
                tmpList.add(GenericParametersTableViewer.toGenericParameter(line[i]));
                if (line[i].length() < 10) {
                    System.out.println("'" + line[i] + "'" + line[i].length());
                }
            }
            ++i;
        }
        return tmpList.toArray(new GenericParameters[tmpList.size()]);
    }

    private static GenericParameters toGenericParameter(String text) {
        return GenericParameters.csvToParameters(text);
    }

    public static String toStoreString(GenericParameters setting) {
        return GenericParameters.parametersToCsv(setting);
    }

    public List getGenericParameters() {
        return this.parameterList;
    }

    public void setGenericParametersList(List parameterList) {
        this.parameterList = parameterList;
        this.setInput(parameterList);
    }

    public String copiedName(GenericParameters parameter) {
        HashMap<String, String> nameMap = new HashMap<String, String>();
        int i = 0;
        while (i < this.parameterList.size()) {
            GenericParameters p = (GenericParameters)this.parameterList.get(i);
            nameMap.put(p.getName(), "");
            ++i;
        }
        int index = 1;
        String newName = null;
        while (nameMap.get(newName = String.valueOf(parameter.getName()) + "(" + index + ")") != null) {
            ++index;
        }
        return newName;
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            return GenericParametersTableViewer.this.toLabel((GenericParameters)obj);
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return ((List)parent).toArray();
        }
    }
}

