/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.util.directorybased;

import java.io.File;
import java.io.IOException;
import jp.sourceforge.akjrcp.util.ProcessPrinter;
import jp.sourceforge.akjrcp.util.directorybased.DirectoryBasedCommand;

public class RenameCommand
implements DirectoryBasedCommand {
    private File srcName;
    private File destName;

    public RenameCommand(File srcName, File destName) {
        this.srcName = srcName;
        this.destName = destName;
    }

    public int exec() throws IOException {
        if (this.srcName == null || this.destName == null) {
            return -1;
        }
        boolean result = this.srcName.renameTo(this.destName);
        if (result) {
            return 0;
        }
        return -1;
    }

    public Process getProcess() {
        return null;
    }

    public void setProcessPrinter(ProcessPrinter processPrinter) {
        try {
            processPrinter.printOutput("rename from " + this.srcName + " to " + this.destName + "\r\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

