/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.videotools.spumux;

import java.io.File;
import java.io.IOException;
import jp.sourceforge.akjrcp.akj_betas.Akj_betasPlugin;
import jp.sourceforge.akjrcp.akj_betas.Messages;
import jp.sourceforge.akjrcp.ffmpeg.SimpleCommandExecuter;
import jp.sourceforge.akjrcp.ui.FileDirChoicer;
import jp.sourceforge.akjrcp.ui.ParamCombo;
import jp.sourceforge.akjrcp.util.ExecutingControler;
import jp.sourceforge.akjrcp.util.ExecutingControlerView;
import jp.sourceforge.akjrcp.util.StatusBarUtils;
import jp.sourceforge.akjrcp.videotools.spumux.SpumuxUtils;
import jp.sourceforge.akjrcp.videotools.spumux.TextSub;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.w3c.dom.Document;

public class SpumuxViewer
extends ExecutingControlerView {
    public static Log log = LogFactory.getLog(SpumuxViewer.class);
    public static final String ID = SpumuxViewer.class.getName();
    private ParamCombo fontName;
    private FileDirChoicer tmpDirChooser;
    private FileDirChoicer inputFileChooser;
    private FileDirChoicer outputFileChooser;
    private FileDirChoicer subtitleFileChooser;
    private String fontName_value;
    private String tmpDirChooser_value;
    private String inputFileChooser_value;
    private String outputFileChooser_value;
    private String subtitleFileChooser_value;
    private Process process;
    private SimpleCommandExecuter commandExecuter;

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        this.fontName = new ParamCombo(parent, 0, "font_name", Messages.getString("spumux.font_name"), new String[]{"MSGOTHIC.TTC", "MSMINCHO.TTC"});
        ExecutingControlerView.FileSelected selectedListener = new ExecutingControlerView.FileSelected();
        this.tmpDirChooser = new FileDirChoicer(parent, 2048, 1, Messages.getString("spumux.tmp_dir"));
        this.tmpDirChooser.setLayoutData(new GridData(768));
        this.tmpDirChooser.addFileListChangeListener(selectedListener);
        String tmpPath = System.getProperty("java.io.tmpdir");
        System.out.println(tmpPath);
        if (!SpumuxUtils.isAsciiFileName(tmpPath)) {
            tmpPath = "c:\\tmp\\";
        }
        this.tmpDirChooser.setFilePath(tmpPath);
        this.inputFileChooser = new FileDirChoicer(parent, 2048, 0, Messages.getString("spumux.input_vob"));
        this.inputFileChooser.setLayoutData(new GridData(768));
        this.inputFileChooser.addFileListChangeListener(selectedListener);
        this.inputFileChooser.setFilterExtensions(new String[]{"*.vob;*.mpg"});
        this.subtitleFileChooser = new FileDirChoicer(parent, 2048, 2, Messages.getString("spumux.input_srt"));
        this.subtitleFileChooser.setLayoutData(new GridData(768));
        this.subtitleFileChooser.setFilterExtensions(new String[]{"*.srt"});
        this.subtitleFileChooser.addFileListChangeListener(selectedListener);
        this.outputFileChooser = new FileDirChoicer(parent, 2048, 2, Messages.getString("spumux.output_vob"));
        this.outputFileChooser.setLayoutData(new GridData(768));
        this.outputFileChooser.setFilterExtensions(new String[]{"*.vob;*.mpg"});
        this.outputFileChooser.addFileListChangeListener(selectedListener);
        this.executer.addControl((Control)this.inputFileChooser);
        this.executer.addControl((Control)this.outputFileChooser);
        this.executer.addControl((Control)this.subtitleFileChooser);
        this.executer.addControl((Control)this.tmpDirChooser);
        new ExecutingControler.ExecutingControlButton(parent, 0, this.executer, Messages.getString("spumux.exec"), Messages.getString("cancel"));
    }

    public void setFocus() {
    }

    public void doAfterExecute() {
    }

    public void doBeforeExecute() {
        this.fontName_value = this.fontName.getValue();
        this.tmpDirChooser_value = this.tmpDirChooser.getAbsoluteFilePath();
        this.inputFileChooser_value = this.inputFileChooser.getAbsoluteFilePath();
        this.subtitleFileChooser_value = this.subtitleFileChooser.getAbsoluteFilePath();
        this.outputFileChooser_value = this.outputFileChooser.getAbsoluteFilePath();
    }

    public boolean doCanExecute() {
        String spumuxExePath = Akj_betasPlugin.getDefault().getPreferenceStore().getString("videotools.path_spumux");
        if (spumuxExePath.equals("")) {
            return false;
        }
        if (this.inputFileChooser.getFile() == null) {
            return false;
        }
        if (this.outputFileChooser.getFile() == null) {
            return false;
        }
        if (this.subtitleFileChooser.getFile() == null) {
            return false;
        }
        if (this.tmpDirChooser.getFile() == null) {
            return false;
        }
        return SpumuxUtils.isAsciiFileName(this.tmpDirChooser.getAbsoluteFilePath());
    }

    public void doCancelExecute() {
        if (this.commandExecuter != null) {
            this.commandExecuter.cancel();
        }
    }

    public void doInExecute() {
        String spumuxExePath = Akj_betasPlugin.getDefault().getPreferenceStore().getString("videotools.path_spumux");
        File tmpF = new File(this.tmpDirChooser_value);
        tmpF.mkdir();
        File srt = new File(tmpF, "tmp_spumux.srt");
        try {
            FileUtils.copyFile((File)new File(this.subtitleFileChooser_value), (File)srt);
        }
        catch (IOException e) {
            StatusBarUtils.showStatusBar("srt can't copy");
            e.printStackTrace();
        }
        File spumux = new File(tmpF, "tmp_spumux.xml");
        TextSub textSub = new TextSub(srt.getAbsolutePath());
        if (!this.fontName_value.equals("")) {
            textSub.setFont(this.fontName_value);
        }
        if (spumux.exists()) {
            spumux.delete();
        }
        Document spumuxXml = SpumuxUtils.toDocument(textSub);
        SpumuxUtils.writeXML(spumuxXml, spumux.getAbsolutePath());
        String[] spumuxCommand = SpumuxUtils.toSpumuxCommand(spumuxExePath, this.inputFileChooser_value, this.outputFileChooser_value, 0, spumux.getAbsolutePath());
        Akj_betasPlugin.getDefault().getProcessPrinter().printOutput(String.valueOf(ArrayUtils.toString((Object)spumuxCommand)) + "\r\n");
        this.commandExecuter = new SimpleCommandExecuter(spumuxCommand);
        this.commandExecuter.setPrinter(Akj_betasPlugin.getDefault().getProcessPrinter());
        this.commandExecuter.execute();
    }
}

