/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ffmpeg;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.akjrcp.util.AvisynthUtils;
import jp.sourceforge.akjrcp.util.ProcessMonitor;
import jp.sourceforge.akjrcp.util.SimpleProcessPrinter;

public final class FFMpegUtils {
    public static boolean isAudioOnlyExtension(String formatOrExtension) {
        if (formatOrExtension == null) {
            return false;
        }
        String[] audios = new String[]{"mp2", "mp3", "aac", "wav", "lpcm", "ac3", "wav", "wma", "m2a"};
        int i = 0;
        while (i < audios.length) {
            if (formatOrExtension.equals(audios[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String getDefaultAudioCodec(String format, String extension) {
        String codec;
        if (format != null && (codec = FFMpegUtils.getAudioCodecByFormat(format)) != null) {
            return codec;
        }
        if (extension != null) {
            return FFMpegUtils.getAudioCodecByExtension(extension);
        }
        return null;
    }

    public static String getDefaultVideoCodec(String format, String extension) {
        String codec;
        if (format != null && (codec = FFMpegUtils.getVideoCodecByFormat(format)) != null) {
            return codec;
        }
        if (extension != null) {
            return FFMpegUtils.getVideoCodecByExtension(extension);
        }
        return null;
    }

    public static String getVideoCodecByFormat(String format) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("mp4", "mpeg4");
        map.put("avi", "mpeg4");
        map.put("mpeg", "mpeg1video");
        map.put("vob", "mpeg2video");
        map.put("dvd", "mpeg2video");
        map.put("mov", "mpeg4");
        map.put("3gp", "h263");
        map.put("3g2", "h263");
        return (String)map.get(format);
    }

    public static String getVideoCodecByExtension(String format) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("mp4", "mpeg4");
        map.put("avi", "mpeg4");
        map.put("vob", "mpeg2video");
        map.put("wmv", "msmpeg4");
        map.put("mpg", "mpeg1video");
        map.put("mov", "mpeg4");
        map.put("3gp", "h263");
        map.put("3g2", "h263");
        return (String)map.get(format);
    }

    public static String getAudioCodecByFormat(String format) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("aac", "aac");
        map.put("mp2", "mp2");
        map.put("mp3", "mp3");
        map.put("ac3", "ac3");
        map.put("wav", "pcm_s16le");
        map.put("s16le", "pcm_s16le");
        map.put("dvd", "mp2");
        map.put("mov", "aac");
        map.put("3gp", "aac");
        map.put("3g2", "aac");
        return (String)map.get(format);
    }

    public static String getAudioCodecByExtension(String extension) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("aac", "aac");
        map.put("mp2", "mp2");
        map.put("mp3", "mp3");
        map.put("ac3", "ac3");
        map.put("wav", "pcm_s16le");
        map.put("lpcm", "pcm_s16le");
        map.put("mov", "aac");
        map.put("3gp", "aac");
        map.put("3g2", "aac");
        return (String)map.get(extension);
    }

    public static int[] sizeToWidthHeight(String size) {
        String[] vs = size.split("x");
        if (vs.length == 1) {
            return null;
        }
        return new int[]{Integer.parseInt(vs[0]), Integer.parseInt(vs[1])};
    }

    public static boolean isFFMpegAvailable(String path) {
        return path != null && !path.equals("") && path.toLowerCase().endsWith("ffmpeg.exe") && new File(path).exists();
    }

    public static int getFFMpegGeneration(String path) {
        int ret;
        block7: {
            ret = 1;
            Runtime runtime = Runtime.getRuntime();
            String[] command = new String[]{path, "-formats"};
            try {
                Process process = runtime.exec(command);
                SimpleProcessPrinter printer = new SimpleProcessPrinter();
                ProcessMonitor monitor = new ProcessMonitor(process, printer);
                monitor.startMonitor();
                try {
                    process.waitFor();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                String formats = printer.getLog();
                String[] lines = formats.split("\n");
                String[] checks = new String[]{"libfaac", "libmp3lame", "libxvid", "libx264"};
                int j = 0;
                while (j < lines.length) {
                    int i = 0;
                    while (i < checks.length) {
                        if (lines[j].endsWith(checks[i])) {
                            ret = 2;
                            break block7;
                        }
                        ++i;
                    }
                    ++j;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public static String toAVSScript(String path) {
        System.out.println(AvisynthUtils.getAvisynthScript(path));
        return AvisynthUtils.getAvisynthScript(path);
    }

    public static boolean shouldUseAvisynth(File file) {
        String[] notsupport = new String[]{"flv", "mpg", "mp3"};
        int i = 0;
        while (i < notsupport.length) {
            if (file.getName().endsWith("." + notsupport[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isAvisynthAvailable(File ffmpeg) {
        File tmp = null;
        try {
            tmp = File.createTempFile("avisynth", ".avs");
            FileWriter writer = new FileWriter(tmp);
            writer.write("BlankClip()");
            writer.close();
            Runtime runtime = Runtime.getRuntime();
            Process p = runtime.exec(new String[]{ffmpeg.getAbsolutePath(), "-i", tmp.getAbsolutePath()});
            SimpleProcessPrinter ffmpegMonitor = new SimpleProcessPrinter();
            ProcessMonitor monitor = new ProcessMonitor(p, ffmpegMonitor);
            monitor.startMonitor();
            try {
                p.waitFor();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            tmp.delete();
            String log = ffmpegMonitor.getLog();
            if (log.indexOf("Video: rawvideo") != -1) {
                return true;
            }
        }
        catch (IOException e) {
            tmp.delete();
            e.printStackTrace();
        }
        return false;
    }

    public static boolean isProgressString(String line) {
        return line.startsWith("size=") || line.startsWith("frame=");
    }

    public static int getProgressFrame(String line) {
        int end;
        int r = 0;
        int s = line.indexOf("frame=");
        if (s != -1 && (end = line.indexOf("k", s + 5)) != -1) {
            String tmp = line.substring(s + 5, end);
            r = Integer.parseInt(tmp.replaceAll(" ", ""));
        }
        return r;
    }

    public static int getProgressSize(String line) {
        int end;
        int r = 0;
        int s = line.indexOf("size=");
        if (s != -1 && (end = line.indexOf("k", s + 5)) != -1) {
            String tmp = line.substring(s + 5, end);
            r = Integer.parseInt(tmp.replaceAll(" ", ""));
        }
        return r;
    }

    public static long getProgressTime(String line) {
        int end;
        long r = 0L;
        int s = line.indexOf("time=");
        if (s != -1 && (end = line.indexOf(" ", s + 5)) != -1) {
            String tmp = line.substring(s + 5, end);
            r = (long)(Double.parseDouble(tmp.replaceAll(" ", "")) * 1000.0);
        }
        return r;
    }

    public static double timeToDouble(String duration) {
        if (duration == null) {
            return 0.0;
        }
        Pattern durationPattern = Pattern.compile("(\\d+):(\\d+):(\\d+)\\.(\\d)+$");
        long millisecond = 0L;
        Matcher match = durationPattern.matcher(duration);
        if (match.matches()) {
            int hour = Integer.parseInt(match.group(1));
            int minute = Integer.parseInt(match.group(2));
            int second = Integer.parseInt(match.group(3));
            String msString = match.group(4);
            while (msString.length() < 3) {
                msString = String.valueOf(msString) + "0";
            }
            int millis = Integer.parseInt(msString);
            millisecond = hour * 60 * 60 * 1000;
            millisecond += (long)(minute * 60 * 1000);
            millisecond += (long)(second * 1000);
            return (double)(millisecond += (long)millis) / 1000.0;
        }
        return 0.0;
    }

    public static boolean isMP4FileName(String name) {
        String[] extesntion = new String[]{"mp4", "aac", "m4v", "m4a"};
        int i = 0;
        while (i < extesntion.length) {
            if (name.toLowerCase().endsWith("." + extesntion[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String toPrintCommand(String[] args) {
        String out = "";
        int j = 0;
        while (j < args.length) {
            out = String.valueOf(out) + "\"" + args[j] + "\"" + " ";
            ++j;
        }
        return out;
    }

    public static String audioCodecToExtension(String audioCodec) {
        if (audioCodec.equals("mp2")) {
            return "mp2";
        }
        if (audioCodec.equals("pcm_s16le")) {
            return "wav";
        }
        if (audioCodec.equals("wmav1")) {
            return "wma";
        }
        if (audioCodec.equals("wmav2")) {
            return "wma";
        }
        if (audioCodec.equals("ac3")) {
            return "ac3";
        }
        if (audioCodec.equals("aac")) {
            return "aac";
        }
        return null;
    }

    public static String fixOddSize(int w, int h) {
        String ret = "";
        if (w > 0) {
            ret = w % 2 > 0 ? String.valueOf(ret) + (w - 1) + "x" : String.valueOf(ret) + w + "x";
        } else {
            return null;
        }
        if (h > 0) {
            ret = h % 2 > 0 ? String.valueOf(ret) + (h - 1) : String.valueOf(ret) + h;
        } else {
            return null;
        }
        return ret;
    }

    public static boolean isOdd(int w, int h) {
        boolean ret = false;
        if (w > 0 && w % 2 > 0) {
            return true;
        }
        if (h > 0 && h % 2 > 0) {
            return true;
        }
        return ret;
    }

    public static String toTimeLabel(long millisecond) {
        long hour_millisecond = 3600000L;
        int minute_millisecond = 60000;
        int second_millisecond = 1000;
        int hour = (int)(millisecond / hour_millisecond);
        long remain = millisecond % hour_millisecond;
        int minute = (int)(remain / (long)minute_millisecond);
        int second = (int)((remain %= (long)minute_millisecond) / (long)second_millisecond);
        return String.valueOf(FFMpegUtils.toLabel2(hour)) + ":" + FFMpegUtils.toLabel2(minute) + ":" + FFMpegUtils.toLabel2(second);
    }

    public static String toMillisecondLabel(long millisecond) {
        long hour_millisecond = 3600000L;
        int minute_millisecond = 60000;
        int second_millisecond = 1000;
        int hour = (int)(millisecond / hour_millisecond);
        long remain = millisecond % hour_millisecond;
        int minute = (int)(remain / (long)minute_millisecond);
        int second = (int)((remain %= (long)minute_millisecond) / (long)second_millisecond);
        remain %= (long)second_millisecond;
        if (hour > 0) {
            return String.valueOf(FFMpegUtils.toLabel2(hour)) + ":" + FFMpegUtils.toLabel2(minute) + ":" + FFMpegUtils.toLabel2(second) + "." + remain;
        }
        return String.valueOf(FFMpegUtils.toLabel2(minute)) + ":" + FFMpegUtils.toLabel2(second) + "." + remain;
    }

    private static String toLabel2(int number) {
        String v = "" + number;
        if (v.length() < 2) {
            v = "0" + v;
        }
        return v;
    }
}

