/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.snack;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MetaMessage;
import javax.sound.midi.MidiEvent;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Track;
import jp.sourceforge.akjrcp.snack.ESPS;
import jp.sourceforge.akjrcp.subtitle.StandardSubObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PitchToMIDI {
    public static Log log = LogFactory.getLog(PitchToMIDI.class);
    private int instrument = 55;
    private int shiftNote = 12;
    public static String[] names = new String[]{"C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "B"};
    private boolean setVelocity = true;
    private int defaultVelocity = 64;
    private boolean pitchNoVoice = true;
    private int volumeMin = 500;
    public static double[] note_pitchs = new double[]{13.750000279781856, 14.567617838918553, 15.433853467830245, 16.351598147370062, 17.323914765057356, 18.35404833717995, 19.445436838734228, 20.601722677346945, 21.82676484947196, 23.124651819432007, 24.499715164288165, 25.95654403007546, 27.500000447650976, 29.135235559269688, 30.867706810042687, 32.7031961616527, 34.6478293891135, 36.708096524974316, 38.890873519199936, 41.20344518701423, 43.65352952129351, 46.24930345064996, 48.999430129170484, 51.913087848887784, 55.00000067147646, 58.27047088140453, 61.73541336884975, 65.40639205713052, 69.29565849622452, 73.41619275117742, 77.7817467218628, 82.40689003866913, 87.30705868728619, 92.4986065248718, 97.99885985952928, 103.8261752752493, 110.00000089530192, 116.54094128853936, 123.47082623522826, 130.8127835819113, 138.59131642844417, 146.8323849048125, 155.56349281065155, 164.81377940661966, 174.61411666397075, 184.99721229688743, 195.99771892143522, 207.6523497054461, 220.00000089530195, 233.08188162853938, 246.9416514655141, 261.6255660991232, 277.1826317288786, 293.6647686145403, 311.126984355155, 329.6275574718021, 349.2282319067383, 369.9944230880625, 391.99543624762373, 415.3046977207872, 440.0, 466.16376136, 493.8833009211433, 523.2511300688476, 554.3652612017378, 587.3295348389113, 622.2539661780138, 659.2551122607299, 698.4564609710702, 739.9888431647004, 783.9908693047543, 830.6093920613646, 879.9999964187924, 932.3275189258428, 987.766597822517, 1046.5022558788976, 1108.7305178914366, 1174.6590648974839, 1244.5079272914352, 1318.510219155711, 1396.9129162573277, 1479.9776803065513, 1567.9817322285219, 1661.2187773623093, 1759.9999856751695, 1864.6550302633707, 1975.5331876054945, 2093.0045032402, 2217.4610267587955, 2349.3181202342903, 2489.0158444536855, 2637.0204275799247, 2793.82582114503, 2959.9553485674046, 3135.963451695071, 3322.4375412037793, 3519.9999570255086, 3729.3100453501124, 3951.0663591319108, 4186.008989445209, 4434.922035469435, 4698.636221347226, 4978.0316686490005, 5274.040833696853, 5587.6516195508075, 5919.91067304341, 6271.9268778661935, 6644.875055365877, 7039.999885401354, 7458.620060346964, 7902.132686105661, 8372.017944820036, 8869.844034842557, 9397.27240445174, 9956.06329678126, 10548.081624467713, 11175.303193623111, 11839.821297904024, 12543.853704684494, 13289.750056648398, 14079.999713503388, 14917.240059987414, 15804.265307895013, 16744.035821499314, 17739.687997492496, 18794.544732418064, 19912.126512529045, 21096.163163083453};
    static double per = 78.125;
    private List<NoteData> noVoices;
    private int lastNote;
    private int tempo = 240;
    private int defaultNote = 40;
    private double cal_1000 = 1000.0 / (double)(this.tempo * 4);

    public static int pitchToNoteNumber(double pitch) {
        if (pitch < 12.0 || pitch > 22500.0) {
            return -1;
        }
        int i = 0;
        while (i < 127) {
            double base = PitchToMIDI.noteNumberToPitch(i);
            double base_plus = PitchToMIDI.noteNumberToPitch(i + 1);
            if (pitch < base) {
                return i;
            }
            if (pitch < base_plus) {
                double half = base_plus - base;
                if (pitch > base + half) {
                    return i + 1;
                }
                return i;
            }
            ++i;
        }
        return 127;
    }

    public static void main(String[] argv) {
        int i = 0;
        while (i < 128) {
            System.out.println(String.valueOf(i) + "=" + PitchToMIDI.noteNumberToPitch(i));
            ++i;
        }
    }

    public static int toVelocity(double value) {
        if (value <= 0.0) {
            return 0;
        }
        int v = (int)(value / per);
        return Math.min(v, 127);
    }

    public void makeMIDI(ESPS[] espses, File file) throws IOException {
        log.info((Object)("makeMIDI:" + espses.length + " espses,file=" + file.getAbsolutePath()));
        Sequence seq = null;
        try {
            seq = new Sequence(0.0f, this.tempo);
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
        Track track = this.initializeTrack(seq);
        Note[] notes = this.espsesToNote(espses);
        int i = 0;
        while (i < notes.length) {
            PitchToMIDI.addNote(track, notes[i]);
            ++i;
        }
        if (track.size() == 0) {
            throw new IOException("empty midi");
        }
        MidiSystem.write(seq, 0, file);
    }

    private Note[] espsesToNote(ESPS[] espses) {
        ArrayList noteList = new ArrayList();
        int tick = 15;
        int current = 4;
        int i = 0;
        while (i < espses.length) {
            if (espses[i].getPitch() > 0.0) {
                log.trace((Object)(String.valueOf(PitchToMIDI.pitchToNoteNumber(espses[i].getPitch()) + this.shiftNote) + " " + espses[i].getMeasurements()));
                int note = PitchToMIDI.pitchToNoteNumber(espses[i].getPitch());
                int velocity = this.defaultVelocity;
                if (this.setVelocity) {
                    velocity = PitchToMIDI.toVelocity(espses[i].getMeasurements());
                }
                if (this.noVoices != null) {
                    NoteData[] datas = this.noVoices.toArray(new NoteData[this.noVoices.size()]);
                    int j = 0;
                    while (j < datas.length) {
                        log.trace((Object)"start novoice");
                        PitchToMIDI.addNote(noteList, datas[j].getStart(), datas[j].getEnd(), note + this.shiftNote, datas[j].getVelocity());
                        ++j;
                    }
                    this.noVoices = null;
                }
                log.info((Object)("addNote:" + this.noteToMillisecond(current) + "," + this.noteToMillisecond(current + tick) + "," + (note + this.shiftNote) + "," + velocity));
                PitchToMIDI.addNote(noteList, current, current + tick, note + this.shiftNote, velocity);
                this.lastNote = note;
            } else {
                long startms = this.noteToMillisecond(current);
                long endms = this.noteToMillisecond(current + tick);
                log.trace((Object)("no pitch:" + startms + "," + endms));
                if (espses[i].getMeasurements() > (double)this.volumeMin) {
                    log.trace((Object)("*0:" + espses[i].getMeasurements()));
                    int velocity = this.defaultVelocity;
                    if (this.setVelocity) {
                        velocity = PitchToMIDI.toVelocity(espses[i].getMeasurements());
                    }
                    if (this.lastNote == 0) {
                        if (this.noVoices == null) {
                            this.noVoices = new ArrayList<NoteData>();
                        }
                        NoteData data = new NoteData(current, current + tick, 0, velocity);
                        this.noVoices.add(data);
                    } else {
                        log.trace((Object)"end novoice");
                        PitchToMIDI.addNote(noteList, current, current + tick, this.lastNote + this.shiftNote, velocity);
                    }
                } else {
                    log.trace((Object)("0:" + espses[i].getMeasurements()));
                    if (this.noVoices != null) {
                        log.info((Object)"no voice sounds");
                        NoteData[] datas = this.noVoices.toArray(new NoteData[this.noVoices.size()]);
                        int j = 0;
                        while (j < datas.length) {
                            log.trace((Object)"start novoice");
                            log.info((Object)("addNoVoice:" + datas[j].getVelocity() + "," + this.noteToMillisecond(datas[j].getStart()) + "," + this.noteToMillisecond(datas[j].getEnd())));
                            PitchToMIDI.addNote(noteList, datas[j].getStart(), datas[j].getEnd(), this.defaultNote + this.shiftNote, datas[j].getVelocity());
                            ++j;
                        }
                        this.noVoices = null;
                    }
                    this.noVoices = null;
                    this.lastNote = 0;
                }
            }
            current += tick;
            ++i;
        }
        if (this.noVoices != null) {
            log.info((Object)"no voice sounds");
            NoteData[] datas = this.noVoices.toArray(new NoteData[this.noVoices.size()]);
            int j = 0;
            while (j < datas.length) {
                log.trace((Object)"start novoice");
                log.info((Object)("addNoVoice:" + datas[j].getVelocity() + "," + this.noteToMillisecond(datas[j].getStart()) + "," + this.noteToMillisecond(datas[j].getEnd())));
                PitchToMIDI.addNote(noteList, datas[j].getStart(), datas[j].getEnd(), this.defaultNote + this.shiftNote, datas[j].getVelocity());
                ++j;
            }
            this.noVoices = null;
        }
        log.info((Object)(String.valueOf(current) + " tick, " + this.toSec((double)current / (double)(this.tempo * 4)) + " sec"));
        return noteList.toArray(new Note[noteList.size()]);
    }

    private Track initializeTrack(Sequence seq) {
        Track track = null;
        try {
            track = seq.createTrack();
            MetaMessage tempoMessage = new MetaMessage();
            int l = 60000000 / this.tempo;
            tempoMessage.setMessage(81, new byte[]{(byte)(l / 65536), (byte)(l % 65536 / 256), (byte)(l % 256)}, 3);
            track.add(new MidiEvent(tempoMessage, 0L));
            ShortMessage message = new ShortMessage();
            message.setMessage(192, this.instrument, 0);
            track.add(new MidiEvent(message, 0L));
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
        return track;
    }

    public void makeMIDI(ESPS[] espses, StandardSubObject[] subtitles, File file) throws IOException {
        int i;
        log.info((Object)("makeMIDI:" + espses.length + " espses,file=" + file.getAbsolutePath()));
        Sequence seq = null;
        try {
            seq = new Sequence(0.0f, this.tempo);
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
        Track track = this.initializeTrack(seq);
        Note[] notes = this.espsesToNote(espses);
        List[] subNotes = new List[subtitles.length];
        if (subtitles.length > 0) {
            i = 0;
            while (i < notes.length) {
                int j = 0;
                while (j < subtitles.length) {
                    if (this.inTime(notes[i], subtitles[j])) {
                        log.info((Object)("intime:" + this.noteToMillisecond(notes[i].getStart()) + "-" + this.noteToMillisecond(notes[i].getEnd())));
                        if (subNotes[j] == null) {
                            subNotes[j] = new ArrayList();
                        }
                        subNotes[j].add(notes[i]);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }
        i = 0;
        while (i < subNotes.length) {
            if (subNotes[i] != null) {
                this.addAverageNote(track, subNotes[i]);
            }
            ++i;
        }
        if (track.size() == 0) {
            throw new IOException("empty midi");
        }
        MidiSystem.write(seq, 0, file);
    }

    public double toSec(double v) {
        return new BigDecimal(v).setScale(2, 4).doubleValue();
    }

    private void addAverageNote(Track track, List list) {
        Note[] notes = list.toArray(new Note[list.size()]);
        int start = 0;
        int end = 0;
        long totalNote = 0L;
        long totalVelocity = 0L;
        int i = 0;
        while (i < notes.length) {
            if (i == 0) {
                start = notes[i].start;
                end = notes[i].end;
            } else {
                start = Math.min(notes[i].getStart(), start);
                end = Math.max(notes[i].getEnd(), end);
            }
            totalNote += (long)notes[i].getNote();
            totalVelocity += (long)notes[i].getVelocity();
            ++i;
        }
        int note = (int)(totalNote / (long)notes.length);
        int velocity = (int)(totalVelocity / (long)notes.length);
        System.out.println("start=" + this.noteToMillisecond(start) + " end=" + this.noteToMillisecond(end) + " note=" + note + " velociy=" + velocity);
        PitchToMIDI.addNote(track, start, end, note, velocity);
    }

    public boolean inTime(Note note, StandardSubObject sub) {
        long start = (long)((double)note.getStart() * this.cal_1000);
        long end = (long)((double)note.getEnd() * this.cal_1000);
        return sub.intersect(start, end);
    }

    public static void addNote(List list, int start, int end, int note, int velocity) {
        list.add(new Note(start, end, note, velocity));
    }

    public long noteToMillisecond(int value) {
        return (long)(this.cal_1000 * (double)value);
    }

    public static void addNote(Track track, Note noteData) {
        ShortMessage noteOn1 = new ShortMessage();
        try {
            noteOn1.setMessage(144, noteData.getNote(), noteData.getVelocity());
            track.add(new MidiEvent(noteOn1, noteData.getStart()));
            ShortMessage noteOn2 = new ShortMessage();
            noteOn2.setMessage(128, noteData.getNote(), 0);
            track.add(new MidiEvent(noteOn2, noteData.getEnd()));
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
    }

    public static void addNote(Track track, int start, int end, int note, int velocity) {
        ShortMessage noteOn1 = new ShortMessage();
        try {
            noteOn1.setMessage(144, note, velocity);
            track.add(new MidiEvent(noteOn1, start));
            ShortMessage noteOn2 = new ShortMessage();
            noteOn2.setMessage(128, note, 0);
            track.add(new MidiEvent(noteOn2, end));
        }
        catch (InvalidMidiDataException e) {
            e.printStackTrace();
        }
    }

    public void makeMIDI(Double[] pitchs, File file) throws IOException {
        ESPS[] esps = new ESPS[pitchs.length];
        int i = 0;
        while (i < pitchs.length) {
            esps[i].setPitch(pitchs[i]);
            ++i;
        }
        this.makeMIDI(esps, file);
    }

    public void makeMIDI(double[] pitchs, File file) throws IOException {
        ESPS[] esps = new ESPS[pitchs.length];
        int i = 0;
        while (i < pitchs.length) {
            esps[i].setPitch(pitchs[i]);
            ++i;
        }
        this.makeMIDI(esps, file);
    }

    public static double noteNumberToPitch(int note) {
        if (note >= 0 && note < 128) {
            return note_pitchs[note];
        }
        return 0.0;
    }

    public int getShiftNote() {
        return this.shiftNote;
    }

    public void setShiftNote(int shiftNote) {
        this.shiftNote = shiftNote;
    }

    public int getVolumeMin() {
        return this.volumeMin;
    }

    public void setVolumeMin(int volumeMin) {
        this.volumeMin = volumeMin;
    }

    public class NoteData {
        private int start;
        private int end;
        private int note;
        private int velocity;

        public NoteData(int start, int end, int note, int velocity) {
            this.start = start;
            this.end = end;
            this.note = note;
            this.velocity = velocity;
        }

        public int getEnd() {
            return this.end;
        }

        public void setEnd(int end) {
            this.end = end;
        }

        public int getNote() {
            return this.note;
        }

        public void setNote(int note) {
            this.note = note;
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public int getVelocity() {
            return this.velocity;
        }

        public void setVelocity(int velocity) {
            this.velocity = velocity;
        }
    }

    public static class Note {
        private int start;
        private int end;
        private int note;
        private int velocity;

        public Note(int start, int end, int note, int velocity) {
            this.start = start;
            this.end = end;
            this.note = note;
            this.velocity = velocity;
        }

        public int getEnd() {
            return this.end;
        }

        public void setEnd(int end) {
            this.end = end;
        }

        public int getNote() {
            return this.note;
        }

        public void setNote(int note) {
            this.note = note;
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public int getVelocity() {
            return this.velocity;
        }

        public void setVelocity(int velocity) {
            this.velocity = velocity;
        }
    }
}

