/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ui;

import java.util.ArrayList;
import java.util.List;
import jp.sourceforge.akjrcp.akj_betas.Messages;
import jp.sourceforge.akjrcp.ui.EditableListData;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class EditableList
extends TableViewer {
    public static Log log = LogFactory.getLog(EditableList.class);
    protected List<EditableListData> dataList = new ArrayList<EditableListData>();
    private MenuItem moveTop;
    private MenuItem moveBottom;
    private MenuItem moveUp;
    private MenuItem moveDown;
    private MenuItem removeData;
    private MenuItem addfile;

    public void removeAll() {
        this.dataList.remove(this.dataList);
        this.refresh(true);
    }

    public void removeSelection() {
        log.info((Object)"remove");
        EditableListData[] files = this.getSelectionDatas();
        int i = 0;
        while (i < files.length) {
            this.dataList.remove(files[0]);
            ++i;
        }
    }

    public void moveUp() {
        EditableListData[] files = this.getSelectionDatas();
        if (files.length == 1) {
            int index = this.dataList.indexOf(files[0]);
            this.dataList.remove(files[0]);
            this.dataList.add(Math.max(0, index - 1), files[0]);
        }
    }

    public void moveDown() {
        EditableListData[] files = this.getSelectionDatas();
        if (files.length == 1) {
            int index = this.dataList.indexOf(files[0]);
            this.dataList.remove(files[0]);
            this.dataList.add(Math.min(this.dataList.size(), index + 1), files[0]);
        }
    }

    public void moveTop() {
        EditableListData[] files = this.getSelectionDatas();
        if (files.length == 1) {
            this.dataList.remove(files[0]);
            this.dataList.add(0, files[0]);
        }
    }

    public void moveBottom() {
        EditableListData[] files = this.getSelectionDatas();
        if (files.length == 1) {
            this.dataList.remove(files[0]);
            this.dataList.add(files[0]);
        }
    }

    public EditableList(Composite parent, int style) {
        super(parent, style);
        this.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.setContentProvider((IContentProvider)new ViewContentProvider());
        MenuSelection selection = new MenuSelection();
        Menu menu1 = new Menu((Control)this.getTable());
        this.getTable().setMenu(menu1);
        new MenuItem(menu1, 2);
        this.moveTop = new MenuItem(menu1, 8);
        this.moveTop.setText(Messages.getString("FileListTable.moveTop"));
        this.moveTop.addSelectionListener((SelectionListener)selection);
        this.moveBottom = new MenuItem(menu1, 8);
        this.moveBottom.setText(Messages.getString("FileListTable.moveBottom"));
        this.moveBottom.addSelectionListener((SelectionListener)selection);
        this.moveUp = new MenuItem(menu1, 8);
        this.moveUp.setText(Messages.getString("FileListTable.moveUp"));
        this.moveUp.addSelectionListener((SelectionListener)selection);
        this.moveDown = new MenuItem(menu1, 8);
        this.moveDown.setText(Messages.getString("FileListTable.moveDown"));
        this.moveDown.addSelectionListener((SelectionListener)selection);
        new MenuItem(menu1, 2);
        this.removeData = new MenuItem(menu1, 8);
        this.removeData.setText(Messages.getString("EditableList.remove"));
        this.removeData.addSelectionListener((SelectionListener)selection);
        this.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                if (event.keyCode == 127) {
                    EditableList.this.removeSelection();
                    EditableList.this.refresh(true);
                }
            }
        });
        this.getTable().setLinesVisible(true);
        this.setInput(this.dataList);
    }

    protected void addData(EditableListData data) {
        this.dataList.add(data);
        this.refresh(true);
    }

    public EditableListData[] getDatas() {
        return this.dataList.toArray(new EditableListData[this.dataList.size()]);
    }

    public EditableListData[] getSelectionDatas() {
        ISelection selection = this.getSelection();
        return ((IStructuredSelection)selection).toList().toArray(new EditableListData[0]);
    }

    public void selectData(int index) {
        log.info((Object)("select:" + index));
        this.getTable().setSelection(index);
    }

    public void selectData(Object object) {
        if (object == null) {
            this.getTable().setSelection(-1);
            return;
        }
        EditableListData[] list = this.getDatas();
        int i = 0;
        while (i < list.length) {
            if (list[i].getValue().equals(object)) {
                this.getTable().setSelection(i);
                return;
            }
            ++i;
        }
    }

    public void selectData(EditableListData data) {
        if (data == null) {
            this.getTable().setSelection(-1);
            return;
        }
        EditableListData[] list = this.getDatas();
        int i = 0;
        while (i < list.length) {
            if (list[i].equals(data)) {
                this.getTable().setSelection(i);
                return;
            }
            ++i;
        }
    }

    public int countDatas() {
        return this.dataList.size();
    }

    public EditableListData popData() {
        if (this.dataList.size() > 0) {
            EditableListData obj = this.dataList.get(0);
            this.dataList.remove(obj);
            this.refresh(true);
            return obj;
        }
        return null;
    }

    public class MenuSelection
    implements SelectionListener {
        public void widgetSelected(SelectionEvent e) {
            if (e.getSource() != EditableList.this.addfile) {
                if (e.getSource() == EditableList.this.moveTop) {
                    EditableList.this.moveTop();
                } else if (e.getSource() == EditableList.this.moveBottom) {
                    EditableList.this.moveBottom();
                } else if (e.getSource() == EditableList.this.moveUp) {
                    EditableList.this.moveUp();
                } else if (e.getSource() == EditableList.this.moveDown) {
                    EditableList.this.moveDown();
                } else if (e.getSource() == EditableList.this.removeData) {
                    EditableList.this.removeSelection();
                }
            }
            EditableList.this.refresh(true);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            System.out.println("getElement");
            return EditableList.this.dataList.toArray();
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            System.out.println("getColumnText:" + obj);
            return ((EditableListData)obj).getLabel();
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }
    }
}

