/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.util;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import jp.sourceforge.akjrcp.flvtools.basic.FLVUtil;

public class FLVChecker {
    private int keepSize = 1000;
    private Map fileMap = new HashMap();

    public boolean checkFLV(File file) {
        FLVCheckStatus status = (FLVCheckStatus)this.fileMap.get(file.getAbsolutePath());
        if (status != null && status.getLastmodified() == file.lastModified()) {
            return status.isFlvFile();
        }
        boolean isFLV = FLVUtil.isFLVFileFormat(file);
        status = new FLVCheckStatus();
        status.setFlvFile(isFLV);
        status.setLastmodified(file.lastModified());
        this.fileMap.put(file.getAbsolutePath(), status);
        if (this.fileMap.size() > this.keepSize) {
            this.fileMap.remove(this.fileMap.keySet().iterator().next());
        }
        return isFLV;
    }

    public class FLVCheckStatus {
        private boolean flvFile;
        private long lastmodified;

        public boolean isFlvFile() {
            return this.flvFile;
        }

        public void setFlvFile(boolean flvFile) {
            this.flvFile = flvFile;
        }

        public long getLastmodified() {
            return this.lastmodified;
        }

        public void setLastmodified(long lastmodified) {
            this.lastmodified = lastmodified;
        }
    }
}

