/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.ole.win32.IDataObject;
import org.eclipse.swt.internal.ole.win32.STGMEDIUM;
import org.eclipse.swt.internal.win32.OS;

class URLTransfer
extends ByteArrayTransfer {
    static URLTransfer _instance = new URLTransfer();
    static final String CFSTR_INETURL = "UniformResourceLocator";
    static final int CFSTR_INETURLID = URLTransfer.registerType("UniformResourceLocator");

    private URLTransfer() {
    }

    public static URLTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkURL(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        transferData.result = -2147467259;
        String url = ((String[])object)[0];
        int count = url.length();
        char[] chars = new char[count + 1];
        url.getChars(0, count, chars, 0);
        int codePage = OS.GetACP();
        int cchMultiByte = OS.WideCharToMultiByte(codePage, 0, chars, -1, null, 0, null, null);
        if (cchMultiByte == 0) {
            transferData.stgmedium = new STGMEDIUM();
            transferData.result = -2147221402;
            return;
        }
        int lpMultiByteStr = OS.GlobalAlloc(64, cchMultiByte);
        OS.WideCharToMultiByte(codePage, 0, chars, -1, lpMultiByteStr, cchMultiByte, null, null);
        transferData.stgmedium = new STGMEDIUM();
        transferData.stgmedium.tymed = 1;
        transferData.stgmedium.unionField = lpMultiByteStr;
        transferData.stgmedium.pUnkForRelease = 0;
        transferData.result = 0;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object nativeToJava(TransferData transferData) {
        block14: {
            block13: {
                if (this.isSupportedType(transferData) == false) return null;
                if (transferData.pIDataObject == 0) {
                    return null;
                }
                data = new IDataObject(transferData.pIDataObject);
                data.AddRef();
                stgmedium = new STGMEDIUM();
                formatetc = transferData.formatetc;
                stgmedium.tymed = 1;
                transferData.result = data.GetData(formatetc, stgmedium);
                data.Release();
                if (transferData.result != 0) {
                    return null;
                }
                hMem = stgmedium.unionField;
                try {
                    block12: {
                        lpMultiByteStr = OS.GlobalLock(hMem);
                        if (lpMultiByteStr == 0) {
                        } else {
                            try {
                                codePage = OS.GetACP();
                                cchWideChar = OS.MultiByteToWideChar(codePage, 1, lpMultiByteStr, -1, null, 0);
                                if (cchWideChar == 0) {
                                    var10_12 = null;
                                    break block12;
                                }
                                lpWideCharStr = new char[cchWideChar - 1];
                                OS.MultiByteToWideChar(codePage, 1, lpMultiByteStr, -1, lpWideCharStr, lpWideCharStr.length);
                                var12_16 = new String[]{new String(lpWideCharStr)};
                            }
                            catch (Throwable var11_17) {
                                var10_14 = null;
                                OS.GlobalUnlock(hMem);
                                throw var11_17;
                            }
                        }
lbl40:
                        // 2 sources

                        while (true) {
                            var13_7 = null;
                            break block13;
                            break;
                        }
                    }
                    OS.GlobalUnlock(hMem);
                    ** continue;
                    var10_13 = null;
                    OS.GlobalUnlock(hMem);
                    break block14;
                }
                catch (Throwable var14_18) {
                    var13_9 = null;
                    OS.GlobalFree(hMem);
                    throw var14_18;
                }
            }
            OS.GlobalFree(hMem);
            return null;
        }
        var13_8 = null;
        OS.GlobalFree(hMem);
        return var12_16;
    }

    protected int[] getTypeIds() {
        return new int[]{CFSTR_INETURLID};
    }

    protected String[] getTypeNames() {
        return new String[]{CFSTR_INETURL};
    }

    boolean checkURL(Object object) {
        if (object == null || !(object instanceof String[]) || ((String[])object).length == 0) {
            return false;
        }
        String[] strings = (String[])object;
        if (strings[0] == null || strings[0].length() == 0) {
            return false;
        }
        try {
            new URL(strings[0]);
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        return true;
    }

    protected boolean validate(Object object) {
        return this.checkURL(object);
    }
}

