/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.text_douga;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;

public class BufferedImageFilePathCasher {
    private List<String> paths = new ArrayList<String>();
    private Map<String, BufferedImage> imageMap = new HashMap<String, BufferedImage>();
    private int maxCash = 50;

    public BufferedImage loadImage(String path) {
        BufferedImage img = this.imageMap.get(path);
        if (img == null) {
            try {
                img = ImageIO.read(new File(path));
                this.imageMap.put(path, img);
                this.paths.add(path);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        } else {
            this.paths.remove(path);
            this.paths.add(path);
        }
        if (this.paths.size() >= this.maxCash) {
            String removePath = this.paths.remove(0);
            BufferedImage removeImage = this.imageMap.remove(removePath);
            removeImage.getGraphics().dispose();
            removeImage = null;
        }
        return img;
    }
}

