/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.text_douga.item;

import com.sun.imageio.plugins.gif.GIFImageReader;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import jp.sourceforge.akjrcp.text_douga.DougaPreference;
import jp.sourceforge.akjrcp.text_douga.ImageObject;
import jp.sourceforge.akjrcp.text_douga.item.ImageItem;
import jp.sourceforge.akjrcp.text_douga.utils.GifAnimeUtils;

public class GifAnimeItem
extends ImageItem {
    private GIFImageReader reader;
    private int loop = 1;

    @Override
    public String toString() {
        return "GifAnimeItem:loop=" + this.loop + " " + super.toString();
    }

    private GIFImageReader getGifReader() {
        if (this.reader != null) {
            return this.reader;
        }
        this.reader = GifAnimeUtils.getGifReader(new File(this.inputPath));
        return this.reader;
    }

    @Override
    public boolean writeFrame(DougaPreference preference, ImageObject baseImage, int frame) throws IOException {
        boolean written = false;
        double animationTime = 0.0;
        double frameTime = this.getFrameTime(frame, preference.getFps());
        if (frameTime >= this.getStartTime() && frameTime < this.getStartTime() + GifAnimeUtils.getGifDuration(this.getGifReader()) * (double)this.loop) {
            log.info((Object)("intime:" + frameTime + " start=" + this.getStartTime() + " end=" + (this.getStartTime() + GifAnimeUtils.getGifDuration(this.getGifReader()))));
            written = true;
            animationTime = frameTime - this.getStartTime();
        } else if (frameTime >= this.getStartTime() && this.loop == -1) {
            written = true;
            animationTime = frameTime - this.getStartTime();
        }
        if (written) {
            int f = GifAnimeUtils.findAnimationFrame(this.getGifReader(), animationTime);
            log.warn((Object)("index=" + f + " animationFrame=" + animationTime));
            BufferedImage img = this.getGifReader().read(f);
            Rectangle drawRect = this.getDrawRect(preference, img.getWidth(), img.getHeight());
            log.info((Object)drawRect);
            log.info((Object)(String.valueOf(img.getWidth()) + "x" + img.getHeight()));
            Graphics2D g2 = (Graphics2D)baseImage.getImage().getGraphics();
            g2.setComposite(AlphaComposite.getInstance(3, this.getTransparent()));
            int mx = this.getMovedX(preference, frameTime);
            int my = this.getMovedY(preference, frameTime);
            if (frame == 1) {
                System.out.println("mx:" + mx + ",my=" + my);
            }
            g2.drawImage(img, drawRect.x + mx, drawRect.y + my, drawRect.x + drawRect.width + mx, drawRect.y + drawRect.height + my, 0, 0, img.getWidth(), img.getHeight(), null);
        }
        return written;
    }

    public Rectangle getDrawRect(DougaPreference preference, int w, int h) {
        int dw = this.getWidth();
        int dh = this.getHeight();
        if (dw == 0) {
            dw = w;
        }
        if (dh == 0) {
            dh = h;
        }
        int dx = 0;
        if (this.getAlign() == 0) {
            dx = this.getX();
        } else if (this.getAlign() == 1) {
            dx = 0;
        } else if (this.getAlign() == 3) {
            dx = preference.getWidth() - dw;
        } else if (this.getAlign() == 2) {
            dx = (preference.getWidth() - dw) / 2;
        } else {
            log.warn((Object)("invalid align:" + this.getAlign()));
        }
        int dy = 0;
        if (this.getValign() == 0) {
            dy = this.getY();
        } else if (this.getValign() == 1) {
            dy = 0;
        } else if (this.getValign() == 3) {
            dy = preference.getHeight() - dh;
        } else if (this.getValign() == 2) {
            dy = (preference.getHeight() - dh) / 2;
        } else {
            log.warn((Object)("invalid valign:" + this.getValign()));
        }
        return new Rectangle(dx, dy, dw, dh);
    }

    public int getLoop() {
        return this.loop;
    }

    public void setLoop(int loop) {
        this.loop = loop;
    }

    @Override
    public double getLastTime() {
        if (this.duration != -1.0) {
            return this.getStartTime() + GifAnimeUtils.getGifDuration(this.getGifReader()) * (double)this.loop;
        }
        return 0.0;
    }
}

