/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.text_douga.item;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import jp.sourceforge.akjrcp.text_douga.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TextUtils {
    public static Log log = LogFactory.getLog(TextUtils.class);
    private static BufferedImage bimage = new BufferedImage(1, 1, 1);
    private static char[] splitchars = new char[]{'\n', ' ', ':', ';', '.', ',', Messages.getString("textdouga.splitcharacter1").charAt(0), Messages.getString("textdouga.splitcharacter2").charAt(0)};

    public static String[] wrapText(String line, Font font, int maxwidth) {
        return TextUtils.wrapText(line, font, maxwidth, maxwidth);
    }

    public static String[] wrapText(String line, Font font, int firstMaxWidth, int defaultMaxWidth) {
        int maxwidth = firstMaxWidth;
        line = line.replaceAll("\r\n", "\n");
        line = line.replaceAll("\r", "\n");
        ArrayList<String> textList = new ArrayList<String>();
        Graphics g = bimage.getGraphics();
        g.setFont(font);
        FontMetrics fm = g.getFontMetrics();
        String[] tmpText = TextUtils.splitText(line);
        log.trace((Object)("separeted:" + tmpText.length));
        int i = 0;
        while (i < tmpText.length) {
            log.info((Object)("(" + tmpText[i] + ")"));
            ++i;
        }
        String currentLine = null;
        int i2 = 0;
        while (i2 < tmpText.length) {
            if (tmpText[i2].equals("")) {
                if (currentLine != null) {
                    textList.add(currentLine);
                    maxwidth = defaultMaxWidth;
                    currentLine = null;
                    if (i2 == tmpText.length - 1) {
                        textList.add("");
                        maxwidth = defaultMaxWidth;
                    }
                } else {
                    textList.add("");
                    maxwidth = defaultMaxWidth;
                }
            } else {
                boolean done = false;
                if (currentLine != null) {
                    String tmp = String.valueOf(currentLine) + tmpText[i2];
                    if (TextUtils.stringWidth(fm, tmp) > maxwidth) {
                        textList.add(currentLine);
                        maxwidth = defaultMaxWidth;
                    } else {
                        currentLine = String.valueOf(currentLine) + tmpText[i2];
                        done = true;
                    }
                }
                if (!done) {
                    String text = tmpText[i2];
                    String add = "" + text.charAt(0);
                    if (firstMaxWidth != defaultMaxWidth && maxwidth == firstMaxWidth && TextUtils.stringWidth(fm, add) > maxwidth) {
                        textList.add("");
                        maxwidth = defaultMaxWidth;
                    }
                    int j = 1;
                    while (j < text.length()) {
                        if (TextUtils.stringWidth(fm, String.valueOf(add) + text.charAt(j)) > maxwidth) {
                            textList.add(add);
                            maxwidth = defaultMaxWidth;
                            add = "" + text.charAt(j);
                        } else {
                            add = String.valueOf(add) + text.charAt(j);
                        }
                        ++j;
                    }
                    if (add.length() > 0) {
                        currentLine = add;
                    }
                }
            }
            ++i2;
        }
        if (currentLine != null) {
            textList.add(currentLine);
        }
        g.dispose();
        return textList.toArray(new String[textList.size()]);
    }

    public static int stringWidth(Font font, String text) {
        Graphics g = bimage.getGraphics();
        g.setFont(font);
        FontMetrics fm = g.getFontMetrics();
        int value = fm.stringWidth(text);
        log.trace((Object)(String.valueOf(value) + "px:" + text));
        g.dispose();
        return value;
    }

    private static int stringWidth(FontMetrics fm, String text) {
        int value = fm.stringWidth(text);
        log.trace((Object)(String.valueOf(value) + "px:" + text));
        return value;
    }

    private static String[] splitText(String text) {
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < text.length()) {
            char ch = text.charAt(i);
            boolean isSplit = false;
            int j = 0;
            while (j < splitchars.length) {
                if (ch == splitchars[j]) {
                    isSplit = true;
                    break;
                }
                ++j;
            }
            if (isSplit) {
                if (ch == '\n') {
                    if (buffer.length() > 0) {
                        list.add(buffer.toString());
                    }
                    list.add("");
                } else {
                    list.add(String.valueOf(buffer.toString()) + ch);
                }
                buffer = new StringBuffer();
            } else {
                buffer.append(ch);
            }
            ++i;
        }
        if (buffer.length() > 0) {
            list.add(buffer.toString());
        }
        return list.toArray(new String[list.size()]);
    }
}

