/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.text_douga.parser;

import java.io.File;
import jp.sourceforge.akjrcp.text_douga.parser.ParserUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyUtils {
    public static Log log = LogFactory.getLog(PropertyUtils.class);
    public static final String RESTORE_DEFAULT = "restore_default";
    public static final String DEFAULT = "default";
    public static final String TRASNPARENT = "transparent";
    public static final String START = "start";
    public static final String DURATION = "duration";
    public static final String WAIT = "wait";
    public static final String FADEIN = "fadein";
    public static final String FADEOUT = "fadeout";
    public static final String LOOP = "loop";
    public static final String LOOP_FOREVER = "forever";
    public static final String SHORTEST = "shortest";
    public static final String NO_PROGRESS = "noprogress";
    public static final String PROGRESS = "progress";
    public static final String VIDEO = "video";
    public static final String AUDIO = "audio";
    public static final String SILENCE = "silence";
    public static final String NOVIDEO = "novideo";
    public static final String NOAUDIO = "noaudio";
    public static final String X = "x";
    public static final String Y = "y";
    public static final String Z = "z";
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    public static final String ALIGN = "align";
    public static final String VALIGN = "valign";
    public static final String ALIGN_LEFT = "left";
    public static final String ALIGN_CENTER = "center";
    public static final String ALIGN_RIGHT = "right";
    public static final String VALIGN_TOP = "top";
    public static final String VALIGN_MIDDLE = "middle";
    public static final String VALIGN_CENTER = "center";
    public static final String VALIGN_BOTTOM = "bottom";
    public static final String MOVE_X = "move_x";
    public static final String MOVE_Y = "move_y";
    public static final String MOVE_W = "move_w";
    public static final String MOVE_H = "move_h";
    public static final String LINE_FPS = "line_fps";
    public static final String LINE_DURATION = "line_duration";
    public static final String DEFAULT_TEXT_FADEIN = "default_text_fadein";
    public static final String DEFAULT_TEXT_FADEOUT = "default_text_fadeout";
    public static final String DEFAULT_IMAGE_FADEIN = "default_image_fadein";
    public static final String DEFAULT_IMAGE_FADEOUT = "default_image_fadeout";
    public static final String DEFAULT_COLOR_DURATION = "default_color_duration";
    public static final String DEFAULT_COLOR_TRANSPARENT = "default_color_transparent";
    public static final String KEEP_ASPECT = "keepaspect";
    public static final String EFFECT = "effect";
    public static final String START_EFFECT = "start_effect";
    public static final String END_EFFECT = "end_effect";
    public static final String EFFECT_FULL = "effect_full";
    public static final String EFFECT_BEFORE = "effect_before";
    public static final String EFFECT_AFTER = "effect_after";
    public static final String EFFECT_COLOR = "effect_color";
    public static final String EFFECT_IMAGE = "effect_image";
    public static final String FONT_NAME = "font_name";
    public static final String FONT_STYLE = "font_style";
    public static final String FONT_SIZE = "font_size";
    public static final String TEXT_ANTIALIASE = "text_antialiase";
    public static final String TEXT_LINE_COLOR = "text_line_color";
    public static final String TEXT_BORDER_COLOR = "text_border_color";
    public static final String TEXT_SHADOW_COLOR = "text_shadow_color";
    public static final String TEXT_BORDER_SIZE = "text_border_size";
    public static final String TEXT_SHADOW_X = "text_shadow_x";
    public static final String TEXT_SHADOW_Y = "text_shadow_y";
    public static final String FONT_STYLE_PLAIN = "plain";
    public static final String FONT_STYLE_BOLD = "bold";
    public static final String FONT_STYLE_ITALIC = "italic";
    public static final String FONT_STYLE_BOLD_ITALIC = "bold_italic";
    public static final String TEXT_DRAW_LINE = "text_draw_line";
    public static final String TEXT_DRAW_SHADOW = "text_draw_shadow";
    public static final String TEXT_DRAW_BORDER = "text_draw_border";
    public static final String TEXT_TYPE = "text_type";
    public static final String TEXT_SELECT_COLOR = "text_select_color";
    public static final String TEXT_TIMING = "timing";
    public static final String TEXT_TYPE_NORMAL = "normal";
    public static final String TEXT_TYPE_KARAOKE = "karaoke";
    public static final String OVERWRAP_SUBTITLE = "overwrap_subtitle";
    public static final String EXPORT_SIZE = "export_size";
    public static final String EXPORT_FPS = "export_fps";
    public static final String DRAW_ANTIALIASE = "draw_antialiase";
    public static final String DRAW_TYPE = "draw_type";
    public static final String DRAW_TYPE_RECT = "rect";
    public static final String DRAW_TYPE_OVAL = "oval";
    public static final String DRAW_TYPE_LINE = "line";
    public static final String DRAW_SIZE = "draw_size";
    public static final String DRAW_COLOR = "draw_color";
    public static final String FILL = "fill";
    public static final String DRAW = "draw";
    public static final String SHEAR_X = "shear_x";
    public static final String SHEAR_Y = "shear_y";
    public static final String ROTATE = "rotate";
    public static final String MOVE_ROTATE = "move_rotate";
    public static final String SET = "set";
    public static final String CLASS = "class";

    public static boolean isDefaultAction(String line) {
        return line != null && line.toLowerCase().startsWith("#default");
    }

    public static boolean isSetClassAction(String line) {
        return line != null && line.toLowerCase().startsWith("#set");
    }

    public static boolean isLoadClassAction(String line) {
        return line != null && line.toLowerCase().startsWith("#class");
    }

    public static boolean isRestoreDefaultAction(String line) {
        return line != null && line.toLowerCase().startsWith("#restore_default");
    }

    public static boolean getBooleanValue(String value) {
        return PropertyUtils.getBooleanValue(value, false);
    }

    public static boolean getBooleanValue(String value, boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return value.toLowerCase().equals("true") || value.equals("1");
    }

    public static int getColorValue(String text, int defaultValue) {
        if (text == null) {
            return defaultValue;
        }
        if (ParserUtils.isColorText(text)) {
            return ParserUtils.toColor(text);
        }
        return defaultValue;
    }

    public static File getFileValue(String text, File baseDir, File defaultFile) {
        if (text == null) {
            return defaultFile;
        }
        return new File(ParserUtils.toFilePath(baseDir, text));
    }

    public static String getStringValue(String text, String defaultValue) {
        if (text == null) {
            return defaultValue;
        }
        return text;
    }

    public static int getIntValue(String text, int defaultValue) {
        if (text == null) {
            return defaultValue;
        }
        try {
            int v = Integer.parseInt(text);
            return v;
        }
        catch (Exception e) {
            log.warn((Object)e);
            return defaultValue;
        }
    }

    public static double getPersentDoubleValue(String text, double defaultValue) {
        if (text == null) {
            return defaultValue;
        }
        try {
            int v = Integer.parseInt(text);
            return (double)v / 100.0;
        }
        catch (Exception e) {
            log.warn((Object)e);
            return defaultValue;
        }
    }

    public static float getPersentFloatValue(String text, float defaultValue) {
        if (text == null) {
            return defaultValue;
        }
        try {
            int v = Integer.parseInt(text);
            return (float)v / 100.0f;
        }
        catch (Exception e) {
            log.warn((Object)e);
            return defaultValue;
        }
    }

    public static double getDoubleValue(String text, double defaultValue) {
        if (text == null) {
            return defaultValue;
        }
        try {
            double v = Double.parseDouble(text);
            return v;
        }
        catch (Exception e) {
            log.warn((Object)e);
            return defaultValue;
        }
    }

    public static float getFloatValue(String text, float defaultValue) {
        if (text == null) {
            return defaultValue;
        }
        try {
            float v = Float.parseFloat(text);
            return v;
        }
        catch (Exception e) {
            log.warn((Object)e);
            return defaultValue;
        }
    }

    public static final double[] getTimingValue(String text, double[] defaultValue) {
        if (text == null) {
            return defaultValue;
        }
        String[] values = text.split(":");
        double[] ds = new double[values.length];
        int i = 0;
        while (i < ds.length) {
            try {
                ds[i] = Double.parseDouble(values[i]);
            }
            catch (Exception e) {
                log.warn((Object)e);
            }
            ++i;
        }
        return ds;
    }
}

