/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Iterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.undo.CreateFolderOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.dialogs.CreateLinkedResourceGroup;
import org.eclipse.ui.internal.ide.misc.ResourceAndContainerGroup;

public class WizardNewFolderMainPage
extends WizardPage
implements Listener {
    private static final int SIZING_CONTAINER_GROUP_HEIGHT = 250;
    private IStructuredSelection currentSelection;
    private IFolder newFolder;
    private URI linkTargetPath;
    private ResourceAndContainerGroup resourceGroup;
    private Button advancedButton;
    private CreateLinkedResourceGroup linkedResourceGroup;
    private Composite linkedResourceParent;
    private Composite linkedResourceComposite;
    private int linkedResourceGroupHeight = -1;
    private boolean firstLinkCheck = true;
    static /* synthetic */ Class class$0;

    public WizardNewFolderMainPage(String pageName, IStructuredSelection selection) {
        super("newFolderPage1");
        this.setTitle(pageName);
        this.setDescription(IDEWorkbenchMessages.WizardNewFolderMainPage_description);
        this.currentSelection = selection;
    }

    protected void createAdvancedControls(Composite parent) {
        Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();
        if (!preferences.getBoolean("description.disableLinking")) {
            this.linkedResourceParent = new Composite(parent, 0);
            this.linkedResourceParent.setFont(parent.getFont());
            this.linkedResourceParent.setLayoutData((Object)new GridData(768));
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.linkedResourceParent.setLayout((Layout)layout);
            this.advancedButton = new Button(this.linkedResourceParent, 8);
            this.advancedButton.setFont(this.linkedResourceParent.getFont());
            this.advancedButton.setText(IDEWorkbenchMessages.showAdvanced);
            GridData data = this.setButtonLayoutData(this.advancedButton);
            data.horizontalAlignment = 1;
            this.advancedButton.setLayoutData((Object)data);
            this.advancedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    WizardNewFolderMainPage.this.handleAdvancedButtonSelect();
                }
            });
        }
        this.linkedResourceGroup = new CreateLinkedResourceGroup(2, new Listener(){

            public void handleEvent(Event e) {
                WizardNewFolderMainPage.this.setPageComplete(WizardNewFolderMainPage.this.validatePage());
                WizardNewFolderMainPage.this.firstLinkCheck = false;
            }
        }, new CreateLinkedResourceGroup.IStringValue(){

            public String getValue() {
                return WizardNewFolderMainPage.this.resourceGroup.getResource();
            }

            public void setValue(String string) {
                WizardNewFolderMainPage.this.resourceGroup.setResource(string);
            }
        });
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.ui.ide.new_folder_wizard_page_context");
        this.resourceGroup = new ResourceAndContainerGroup(composite, this, IDEWorkbenchMessages.WizardNewFolderMainPage_folderName, IDEWorkbenchMessages.WizardNewFolderMainPage_folderLabel, false, 250);
        this.resourceGroup.setAllowExistingResources(false);
        this.createAdvancedControls(composite);
        this.initializePage();
        this.validatePage();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
    }

    protected void createFolder(IFolder folderHandle, IProgressMonitor monitor) throws CoreException {
        try {
            if (!folderHandle.exists()) {
                if (this.linkTargetPath != null) {
                    folderHandle.createLink(this.linkTargetPath, 16, monitor);
                } else {
                    IPath path = folderHandle.getFullPath();
                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                    int numSegments = path.segmentCount();
                    if (numSegments > 2 && !root.getFolder(path.removeLastSegments(1)).exists()) {
                        int i = numSegments - 2;
                        while (i > 0) {
                            IFolder folder = root.getFolder(path.removeLastSegments(i));
                            if (!folder.exists()) {
                                folder.create(false, true, monitor);
                            }
                            --i;
                        }
                    }
                    folderHandle.create(false, true, monitor);
                }
            }
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 374) {
                folderHandle.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(monitor, 500));
            }
            throw e;
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected IFolder createFolderHandle(IPath folderPath) {
        return IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getFolder(folderPath);
    }

    protected void createLinkTarget() {
        this.linkTargetPath = this.linkedResourceGroup.getLinkTargetURI();
    }

    public IFolder createNewFolder() {
        if (this.newFolder != null) {
            return this.newFolder;
        }
        IPath containerPath = this.resourceGroup.getContainerFullPath();
        IPath newFolderPath = containerPath.append(this.resourceGroup.getResource());
        final IFolder newFolderHandle = this.createFolderHandle(newFolderPath);
        this.createLinkTarget();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                CreateFolderOperation op = new CreateFolderOperation(newFolderHandle, WizardNewFolderMainPage.this.linkTargetPath, IDEWorkbenchMessages.WizardNewFolderCreationPage_title);
                try {
                    PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute((IUndoableOperation)op, monitor, WorkspaceUndoUtil.getUIInfoAdapter(WizardNewFolderMainPage.this.getShell()));
                }
                catch (ExecutionException e) {
                    WizardNewFolderMainPage.this.getContainer().getShell().getDisplay().syncExec(new Runnable(this, e){
                        final /* synthetic */ 4 this$1;
                        private final /* synthetic */ ExecutionException val$e;
                        {
                            this.this$1 = var1_1;
                            this.val$e = executionException;
                        }

                        public void run() {
                            if (this.val$e.getCause() instanceof CoreException) {
                                ErrorDialog.openError((Shell)WizardNewFolderMainPage.access$3(4.access$0(this.this$1)).getShell(), (String)IDEWorkbenchMessages.WizardNewFolderCreationPage_errorTitle, null, (IStatus)((CoreException)this.val$e.getCause()).getStatus());
                            } else {
                                IDEWorkbenchPlugin.log(this.getClass(), "createNewFolder()", this.val$e.getCause());
                                MessageDialog.openError((Shell)WizardNewFolderMainPage.access$3(4.access$0(this.this$1)).getShell(), (String)IDEWorkbenchMessages.WizardNewFolderCreationPage_internalErrorTitle, (String)NLS.bind((String)IDEWorkbenchMessages.WizardNewFolder_internalError, (Object)this.val$e.getCause().getMessage()));
                            }
                        }
                    });
                }
            }

            static /* synthetic */ WizardNewFolderMainPage access$0(4 var0) {
                return var0.WizardNewFolderMainPage.this;
            }
        };
        try {
            this.getContainer().run(true, true, op);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException e) {
            IDEWorkbenchPlugin.log(((Object)((Object)this)).getClass(), "createNewFolder()", e.getTargetException());
            MessageDialog.openError((Shell)this.getContainer().getShell(), (String)IDEWorkbenchMessages.WizardNewFolderCreationPage_internalErrorTitle, (String)NLS.bind((String)IDEWorkbenchMessages.WizardNewFolder_internalError, (Object)e.getTargetException().getMessage()));
            return null;
        }
        this.newFolder = newFolderHandle;
        return this.newFolder;
    }

    protected void handleAdvancedButtonSelect() {
        Shell shell = this.getShell();
        Point shellSize = shell.getSize();
        Composite composite = (Composite)this.getControl();
        if (this.linkedResourceComposite != null) {
            this.linkedResourceComposite.dispose();
            this.linkedResourceComposite = null;
            composite.layout();
            shell.setSize(shellSize.x, shellSize.y - this.linkedResourceGroupHeight);
            this.advancedButton.setText(IDEWorkbenchMessages.showAdvanced);
        } else {
            this.linkedResourceComposite = this.linkedResourceGroup.createContents(this.linkedResourceParent);
            if (this.linkedResourceGroupHeight == -1) {
                Point groupSize = this.linkedResourceComposite.computeSize(-1, -1, true);
                this.linkedResourceGroupHeight = groupSize.y;
            }
            shell.setSize(shellSize.x, shellSize.y + this.linkedResourceGroupHeight);
            composite.layout();
            this.advancedButton.setText(IDEWorkbenchMessages.hideAdvanced);
        }
    }

    public void handleEvent(Event ev) {
        this.setPageComplete(this.validatePage());
    }

    protected void initializePage() {
        Iterator it = this.currentSelection.iterator();
        if (it.hasNext()) {
            Object next = it.next();
            IResource selectedResource = null;
            if (next instanceof IResource) {
                selectedResource = (IResource)next;
            } else if (next instanceof IAdaptable) {
                IAdaptable iAdaptable = (IAdaptable)next;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                selectedResource = (IResource)iAdaptable.getAdapter((Class)clazz);
            }
            if (selectedResource != null) {
                if (selectedResource.getType() == 1) {
                    selectedResource = selectedResource.getParent();
                }
                if (selectedResource.isAccessible()) {
                    this.resourceGroup.setContainerFullPath(selectedResource.getFullPath());
                }
            }
        }
        this.setPageComplete(false);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.resourceGroup.setFocus();
        }
    }

    protected IStatus validateLinkedResource() {
        IPath containerPath = this.resourceGroup.getContainerFullPath();
        IPath newFolderPath = containerPath.append(this.resourceGroup.getResource());
        IFolder newFolderHandle = this.createFolderHandle(newFolderPath);
        IStatus status = this.linkedResourceGroup.validateLinkLocation((IResource)newFolderHandle);
        if (status.getSeverity() == 4) {
            if (this.firstLinkCheck) {
                this.setMessage(status.getMessage());
            } else {
                this.setErrorMessage(status.getMessage());
            }
        } else if (status.getSeverity() == 2) {
            this.setMessage(status.getMessage(), 2);
            this.setErrorMessage(null);
        }
        return status;
    }

    protected boolean validatePage() {
        boolean valid = true;
        if (!this.resourceGroup.areAllValuesValid()) {
            if (this.resourceGroup.getProblemType() == 1 || this.resourceGroup.getProblemType() == 5) {
                this.setMessage(this.resourceGroup.getProblemMessage());
                this.setErrorMessage(null);
            } else {
                this.setErrorMessage(this.resourceGroup.getProblemMessage());
            }
            valid = false;
        }
        IStatus linkedResourceStatus = null;
        if (valid && (linkedResourceStatus = this.validateLinkedResource()).getSeverity() == 4) {
            valid = false;
        }
        if (valid && (linkedResourceStatus == null || linkedResourceStatus.isOK())) {
            this.setMessage(null);
            this.setErrorMessage(null);
        }
        return valid;
    }
}

