/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.undo;

import java.net.URI;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ui.ide.undo.ResourceDescription;
import org.eclipse.ui.internal.ide.undo.AbstractResourceDescription;
import org.eclipse.ui.internal.ide.undo.FileDescription;
import org.eclipse.ui.internal.ide.undo.FolderDescription;
import org.eclipse.ui.internal.ide.undo.ProjectDescription;
import org.eclipse.ui.internal.ide.undo.UndoMessages;

public abstract class ContainerDescription
extends AbstractResourceDescription {
    String name;
    URI location;
    String defaultCharSet;
    AbstractResourceDescription[] members;

    public static ContainerDescription fromContainer(IContainer container) {
        IPath fullPath = container.getFullPath();
        ContainerDescription firstCreatedParent = null;
        ContainerDescription currentContainerDescription = null;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IContainer currentContainer = (IContainer)root.findMember(fullPath);
        if (currentContainer != null) {
            return (ContainerDescription)ResourceDescription.fromResource((IResource)container);
        }
        currentContainer = root;
        int i = 0;
        while (i < fullPath.segmentCount()) {
            String currentSegment = fullPath.segment(i);
            IResource resource = currentContainer.findMember(currentSegment);
            if (resource != null) {
                currentContainer = (IContainer)resource;
            } else if (i == 0) {
                currentContainerDescription = firstCreatedParent = new ProjectDescription(root.getProject(currentSegment));
            } else {
                IFolder folderHandle = currentContainer.getFolder((IPath)new Path(currentSegment));
                FolderDescription currentFolder = new FolderDescription(folderHandle);
                currentContainer = folderHandle;
                if (currentContainerDescription != null) {
                    currentContainerDescription.addMember(currentFolder);
                }
                currentContainerDescription = currentFolder;
                if (firstCreatedParent == null) {
                    firstCreatedParent = currentFolder;
                }
            }
            ++i;
        }
        return firstCreatedParent;
    }

    public ContainerDescription() {
    }

    public ContainerDescription(IContainer container) {
        super((IResource)container);
        this.name = container.getName();
        if (container.isLinked()) {
            this.location = container.getLocationURI();
        }
        try {
            if (container.isAccessible()) {
                this.defaultCharSet = container.getDefaultCharset(false);
                IResource[] resourceMembers = container.members();
                this.members = new AbstractResourceDescription[resourceMembers.length];
                int i = 0;
                while (i < resourceMembers.length) {
                    this.members[i] = (AbstractResourceDescription)ResourceDescription.fromResource(resourceMembers[i]);
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {}
    }

    protected void createChildResources(IContainer parentHandle, IProgressMonitor monitor, int ticks) throws CoreException {
        if (this.members != null && this.members.length > 0) {
            int i = 0;
            while (i < this.members.length) {
                this.members[i].parent = parentHandle;
                this.members[i].createResource((IProgressMonitor)new SubProgressMonitor(monitor, ticks / this.members.length));
                ++i;
            }
        }
    }

    public void recordStateFromHistory(IResource resource, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(UndoMessages.FolderDescription_SavingUndoInfoProgress, 100);
        if (this.members != null) {
            int i = 0;
            while (i < this.members.length) {
                IPath path;
                if (this.members[i] instanceof FileDescription) {
                    path = resource.getFullPath().append(((FileDescription)this.members[i]).name);
                    IFile fileHandle = resource.getWorkspace().getRoot().getFile(path);
                    this.members[i].recordStateFromHistory((IResource)fileHandle, (IProgressMonitor)new SubProgressMonitor(monitor, 100 / this.members.length));
                } else if (this.members[i] instanceof FolderDescription) {
                    path = resource.getFullPath().append(((FolderDescription)this.members[i]).name);
                    IFolder folderHandle = resource.getWorkspace().getRoot().getFolder(path);
                    this.members[i].recordStateFromHistory((IResource)folderHandle, (IProgressMonitor)new SubProgressMonitor(monitor, 100 / this.members.length));
                }
                ++i;
            }
        }
        monitor.done();
    }

    public String getName() {
        return this.name;
    }

    public ContainerDescription getFirstLeafFolder() {
        if (this.members == null || this.members.length == 0) {
            return this;
        }
        int i = 0;
        while (i < this.members.length) {
            if (this.members[i] instanceof ContainerDescription) {
                return ((ContainerDescription)this.members[i]).getFirstLeafFolder();
            }
            ++i;
        }
        return this;
    }

    public void addMember(AbstractResourceDescription member) {
        if (this.members == null) {
            this.members = new AbstractResourceDescription[]{member};
        } else {
            AbstractResourceDescription[] expandedMembers = new AbstractResourceDescription[this.members.length + 1];
            System.arraycopy(this.members, 0, expandedMembers, 0, this.members.length);
            expandedMembers[this.members.length] = member;
            this.members = expandedMembers;
        }
    }

    protected void restoreResourceAttributes(IResource resource) throws CoreException {
        super.restoreResourceAttributes(resource);
        Assert.isLegal((boolean)(resource instanceof IContainer));
        IContainer container = (IContainer)resource;
        if (this.defaultCharSet != null) {
            container.setDefaultCharset(this.defaultCharSet, null);
        }
    }

    public void setLocation(URI location) {
        this.location = location;
    }

    public boolean verifyExistence(boolean checkMembers) {
        boolean existence = super.verifyExistence(checkMembers);
        if (existence) {
            if (checkMembers && this.members != null && this.members.length > 0) {
                int i = 0;
                while (i < this.members.length) {
                    if (!this.members[i].verifyExistence(checkMembers)) {
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }
        return false;
    }
}

