/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.commons.ui.widget;

import jp.sourceforge.akjrcp.commons.ui.EditableFileList;
import jp.sourceforge.akjrcp.commons.ui.FileDirChoicer2;
import jp.sourceforge.akjrcp.commons.util.FileNameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;

public class WidgetBuilder {
    public static Log log = LogFactory.getLog(WidgetBuilder.class);

    public static Group createGridLayoutGroup(Composite parent, int style) {
        Group group = new Group(parent, style);
        group.setLayout((Layout)new GridLayout());
        return group;
    }

    public static Composite createGridLayoutComposite(Composite parent, int style) {
        Composite composite = new Composite(parent, style);
        composite.setLayout((Layout)new GridLayout());
        return composite;
    }

    public static Composite createTwoGridLayoutComposite(Composite parent, int style) {
        Composite composite = new Composite(parent, style);
        composite.setLayout((Layout)new GridLayout(2, false));
        return composite;
    }

    public static Composite createGridLayoutComposite(Composite parent, int style, int num, boolean same) {
        Composite composite = new Composite(parent, style);
        composite.setLayout((Layout)new GridLayout(num, same));
        return composite;
    }

    public static Button createRadioButton(Composite parent, String label) {
        Button bt = new Button(parent, 16);
        bt.setText(label);
        return bt;
    }

    public static Button createCheckButton(Composite parent, String label) {
        Button bt = new Button(parent, 32);
        bt.setText(label);
        return bt;
    }

    public static Button createButton(Composite parent, String label) {
        Button bt = new Button(parent, 0);
        bt.setText(label);
        return bt;
    }

    public static Label createLabel(Composite parent, RGB rgb, int width, int height) {
        Label bt = new Label(parent, 0);
        Image img = new Image(null, width, height);
        GC gc = new GC((Drawable)img);
        gc.setBackground(new Color(null, rgb));
        gc.fillRectangle(0, 0, width, height);
        bt.setImage(img);
        return bt;
    }

    public static Group createFillLayoutGroup(Composite parent, int style) {
        Group group = new Group(parent, style);
        group.setLayout((Layout)new FillLayout());
        return group;
    }

    public static MenuItem createSeparateMenu(Menu parent) {
        return new MenuItem(parent, 2);
    }

    public static Menu createCascadeMenu(Menu parent, String text) {
        MenuItem item = new MenuItem(parent, 64);
        item.setText(text);
        Menu menu = new Menu(item);
        item.setMenu(menu);
        menu.setData("MenuItem", (Object)item);
        return menu;
    }

    public static MenuItem createPushMenu(Menu parent, String text) {
        MenuItem item = new MenuItem(parent, 8);
        item.setText(text);
        return item;
    }

    public static Text createTextArea(Composite parent, String text) {
        Text t = new Text(parent, 2818);
        if (text != null) {
            t.setText(text);
        }
        return t;
    }

    public static Text createBorderText(Composite parent, String text) {
        Text t = new Text(parent, 2048);
        if (text != null) {
            t.setText(text);
        }
        return t;
    }

    public static Label createLabel(Composite root, String string) {
        Label label = new Label(root, 0);
        label.setText(string);
        return label;
    }

    public static EditableFileList createFileList(Composite root, int style, String extensions) {
        EditableFileList fileList = new EditableFileList(root, style);
        fileList.setFilterExtension(extensions);
        return fileList;
    }

    public static FileDirChoicer2 createDirectoryChoicerWithMyDesktopAndMyDocuments(Composite parent, int style, String label, boolean hasReset) {
        FileDirChoicer2 choicer = new FileDirChoicer2(parent, style, 1, label, hasReset);
        choicer.addSelectableFileName(FileNameUtils.LOCAL_NAME_MY_DOCUMENTS);
        choicer.addSelectableFileName(FileNameUtils.LOCAL_NAME_DESKTOP);
        return choicer;
    }
}

